/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotroborunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties of the worker that are provided by the vendor FMS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VendorProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<VendorProperties.Builder, VendorProperties> {
    private static final SdkField<String> VENDOR_WORKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vendorWorkerId").getter(getter(VendorProperties::vendorWorkerId))
            .setter(setter(Builder::vendorWorkerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorWorkerId").build()).build();

    private static final SdkField<String> VENDOR_WORKER_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vendorWorkerIpAddress").getter(getter(VendorProperties::vendorWorkerIpAddress))
            .setter(setter(Builder::vendorWorkerIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorWorkerIpAddress").build())
            .build();

    private static final SdkField<String> VENDOR_ADDITIONAL_TRANSIENT_PROPERTIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("vendorAdditionalTransientProperties")
            .getter(getter(VendorProperties::vendorAdditionalTransientProperties))
            .setter(setter(Builder::vendorAdditionalTransientProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("vendorAdditionalTransientProperties").build()).build();

    private static final SdkField<String> VENDOR_ADDITIONAL_FIXED_PROPERTIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("vendorAdditionalFixedProperties")
            .getter(getter(VendorProperties::vendorAdditionalFixedProperties))
            .setter(setter(Builder::vendorAdditionalFixedProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorAdditionalFixedProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VENDOR_WORKER_ID_FIELD,
            VENDOR_WORKER_IP_ADDRESS_FIELD, VENDOR_ADDITIONAL_TRANSIENT_PROPERTIES_FIELD,
            VENDOR_ADDITIONAL_FIXED_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vendorWorkerId;

    private final String vendorWorkerIpAddress;

    private final String vendorAdditionalTransientProperties;

    private final String vendorAdditionalFixedProperties;

    private VendorProperties(BuilderImpl builder) {
        this.vendorWorkerId = builder.vendorWorkerId;
        this.vendorWorkerIpAddress = builder.vendorWorkerIpAddress;
        this.vendorAdditionalTransientProperties = builder.vendorAdditionalTransientProperties;
        this.vendorAdditionalFixedProperties = builder.vendorAdditionalFixedProperties;
    }

    /**
     * Returns the value of the VendorWorkerId property for this object.
     * 
     * @return The value of the VendorWorkerId property for this object.
     */
    public final String vendorWorkerId() {
        return vendorWorkerId;
    }

    /**
     * Returns the value of the VendorWorkerIpAddress property for this object.
     * 
     * @return The value of the VendorWorkerIpAddress property for this object.
     */
    public final String vendorWorkerIpAddress() {
        return vendorWorkerIpAddress;
    }

    /**
     * Returns the value of the VendorAdditionalTransientProperties property for this object.
     * 
     * @return The value of the VendorAdditionalTransientProperties property for this object.
     */
    public final String vendorAdditionalTransientProperties() {
        return vendorAdditionalTransientProperties;
    }

    /**
     * Returns the value of the VendorAdditionalFixedProperties property for this object.
     * 
     * @return The value of the VendorAdditionalFixedProperties property for this object.
     */
    public final String vendorAdditionalFixedProperties() {
        return vendorAdditionalFixedProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vendorWorkerId());
        hashCode = 31 * hashCode + Objects.hashCode(vendorWorkerIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(vendorAdditionalTransientProperties());
        hashCode = 31 * hashCode + Objects.hashCode(vendorAdditionalFixedProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VendorProperties)) {
            return false;
        }
        VendorProperties other = (VendorProperties) obj;
        return Objects.equals(vendorWorkerId(), other.vendorWorkerId())
                && Objects.equals(vendorWorkerIpAddress(), other.vendorWorkerIpAddress())
                && Objects.equals(vendorAdditionalTransientProperties(), other.vendorAdditionalTransientProperties())
                && Objects.equals(vendorAdditionalFixedProperties(), other.vendorAdditionalFixedProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VendorProperties").add("VendorWorkerId", vendorWorkerId())
                .add("VendorWorkerIpAddress", vendorWorkerIpAddress())
                .add("VendorAdditionalTransientProperties", vendorAdditionalTransientProperties())
                .add("VendorAdditionalFixedProperties", vendorAdditionalFixedProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vendorWorkerId":
            return Optional.ofNullable(clazz.cast(vendorWorkerId()));
        case "vendorWorkerIpAddress":
            return Optional.ofNullable(clazz.cast(vendorWorkerIpAddress()));
        case "vendorAdditionalTransientProperties":
            return Optional.ofNullable(clazz.cast(vendorAdditionalTransientProperties()));
        case "vendorAdditionalFixedProperties":
            return Optional.ofNullable(clazz.cast(vendorAdditionalFixedProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VendorProperties, T> g) {
        return obj -> g.apply((VendorProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VendorProperties> {
        /**
         * Sets the value of the VendorWorkerId property for this object.
         *
         * @param vendorWorkerId
         *        The new value for the VendorWorkerId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorWorkerId(String vendorWorkerId);

        /**
         * Sets the value of the VendorWorkerIpAddress property for this object.
         *
         * @param vendorWorkerIpAddress
         *        The new value for the VendorWorkerIpAddress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorWorkerIpAddress(String vendorWorkerIpAddress);

        /**
         * Sets the value of the VendorAdditionalTransientProperties property for this object.
         *
         * @param vendorAdditionalTransientProperties
         *        The new value for the VendorAdditionalTransientProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorAdditionalTransientProperties(String vendorAdditionalTransientProperties);

        /**
         * Sets the value of the VendorAdditionalFixedProperties property for this object.
         *
         * @param vendorAdditionalFixedProperties
         *        The new value for the VendorAdditionalFixedProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorAdditionalFixedProperties(String vendorAdditionalFixedProperties);
    }

    static final class BuilderImpl implements Builder {
        private String vendorWorkerId;

        private String vendorWorkerIpAddress;

        private String vendorAdditionalTransientProperties;

        private String vendorAdditionalFixedProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(VendorProperties model) {
            vendorWorkerId(model.vendorWorkerId);
            vendorWorkerIpAddress(model.vendorWorkerIpAddress);
            vendorAdditionalTransientProperties(model.vendorAdditionalTransientProperties);
            vendorAdditionalFixedProperties(model.vendorAdditionalFixedProperties);
        }

        public final String getVendorWorkerId() {
            return vendorWorkerId;
        }

        public final void setVendorWorkerId(String vendorWorkerId) {
            this.vendorWorkerId = vendorWorkerId;
        }

        @Override
        public final Builder vendorWorkerId(String vendorWorkerId) {
            this.vendorWorkerId = vendorWorkerId;
            return this;
        }

        public final String getVendorWorkerIpAddress() {
            return vendorWorkerIpAddress;
        }

        public final void setVendorWorkerIpAddress(String vendorWorkerIpAddress) {
            this.vendorWorkerIpAddress = vendorWorkerIpAddress;
        }

        @Override
        public final Builder vendorWorkerIpAddress(String vendorWorkerIpAddress) {
            this.vendorWorkerIpAddress = vendorWorkerIpAddress;
            return this;
        }

        public final String getVendorAdditionalTransientProperties() {
            return vendorAdditionalTransientProperties;
        }

        public final void setVendorAdditionalTransientProperties(String vendorAdditionalTransientProperties) {
            this.vendorAdditionalTransientProperties = vendorAdditionalTransientProperties;
        }

        @Override
        public final Builder vendorAdditionalTransientProperties(String vendorAdditionalTransientProperties) {
            this.vendorAdditionalTransientProperties = vendorAdditionalTransientProperties;
            return this;
        }

        public final String getVendorAdditionalFixedProperties() {
            return vendorAdditionalFixedProperties;
        }

        public final void setVendorAdditionalFixedProperties(String vendorAdditionalFixedProperties) {
            this.vendorAdditionalFixedProperties = vendorAdditionalFixedProperties;
        }

        @Override
        public final Builder vendorAdditionalFixedProperties(String vendorAdditionalFixedProperties) {
            this.vendorAdditionalFixedProperties = vendorAdditionalFixedProperties;
            return this;
        }

        @Override
        public VendorProperties build() {
            return new VendorProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
