/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotroborunner.IotRoboRunnerAsyncClient;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse;
import software.amazon.awssdk.services.iotroborunner.model.Worker;

public class ListWorkersPublisher
implements SdkPublisher<ListWorkersResponse> {
    private final IotRoboRunnerAsyncClient client;
    private final ListWorkersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkersPublisher(IotRoboRunnerAsyncClient client, ListWorkersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkersPublisher(IotRoboRunnerAsyncClient client, ListWorkersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Worker> workers() {
        Function<ListWorkersResponse, Iterator> getIterator = response -> {
            if (response != null && response.workers() != null) {
                return response.workers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkersResponseFetcher
    implements AsyncPageFetcher<ListWorkersResponse> {
        private ListWorkersResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkersResponse> nextPage(ListWorkersResponse previousPage) {
            if (previousPage == null) {
                return ListWorkersPublisher.this.client.listWorkers(ListWorkersPublisher.this.firstRequest);
            }
            return ListWorkersPublisher.this.client.listWorkers((ListWorkersRequest)((Object)ListWorkersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

