/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotroborunner.model.DestinationState;
import software.amazon.awssdk.services.iotroborunner.model.IotRoboRunnerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDestinationRequest
extends IotRoboRunnerRequest
implements ToCopyableBuilder<Builder, UpdateDestinationRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::id)).setter(UpdateDestinationRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::name)).setter(UpdateDestinationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::stateAsString)).setter(UpdateDestinationRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> ADDITIONAL_FIXED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalFixedProperties").getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::additionalFixedProperties)).setter(UpdateDestinationRequest.setter(Builder::additionalFixedProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalFixedProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, STATE_FIELD, ADDITIONAL_FIXED_PROPERTIES_FIELD));
    private final String id;
    private final String name;
    private final String state;
    private final String additionalFixedProperties;

    private UpdateDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.state = builder.state;
        this.additionalFixedProperties = builder.additionalFixedProperties;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final DestinationState state() {
        return DestinationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String additionalFixedProperties() {
        return this.additionalFixedProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalFixedProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDestinationRequest)) {
            return false;
        }
        UpdateDestinationRequest other = (UpdateDestinationRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.additionalFixedProperties(), other.additionalFixedProperties());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDestinationRequest").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).add("AdditionalFixedProperties", (Object)this.additionalFixedProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "additionalFixedProperties": {
                return Optional.ofNullable(clazz.cast(this.additionalFixedProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDestinationRequest, T> g) {
        return obj -> g.apply((UpdateDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRoboRunnerRequest.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String state;
        private String additionalFixedProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDestinationRequest model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.state(model.state);
            this.additionalFixedProperties(model.additionalFixedProperties);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DestinationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getAdditionalFixedProperties() {
            return this.additionalFixedProperties;
        }

        public final void setAdditionalFixedProperties(String additionalFixedProperties) {
            this.additionalFixedProperties = additionalFixedProperties;
        }

        @Override
        public final Builder additionalFixedProperties(String additionalFixedProperties) {
            this.additionalFixedProperties = additionalFixedProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDestinationRequest build() {
            return new UpdateDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRoboRunnerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDestinationRequest> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(DestinationState var1);

        public Builder additionalFixedProperties(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

