/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseResponse;
import software.amazon.awssdk.services.iotfleetwise.model.VehicleStatus;
import software.amazon.awssdk.services.iotfleetwise.model.VehicleStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVehicleStatusResponse
extends IoTFleetWiseResponse
implements ToCopyableBuilder<Builder, GetVehicleStatusResponse> {
    private static final SdkField<List<VehicleStatus>> CAMPAIGNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("campaigns").getter(GetVehicleStatusResponse.getter(GetVehicleStatusResponse::campaigns)).setter(GetVehicleStatusResponse.setter(Builder::campaigns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaigns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VehicleStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetVehicleStatusResponse.getter(GetVehicleStatusResponse::nextToken)).setter(GetVehicleStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<VehicleStatus> campaigns;
    private final String nextToken;

    private GetVehicleStatusResponse(BuilderImpl builder) {
        super(builder);
        this.campaigns = builder.campaigns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCampaigns() {
        return this.campaigns != null && !(this.campaigns instanceof SdkAutoConstructList);
    }

    public final List<VehicleStatus> campaigns() {
        return this.campaigns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCampaigns() ? this.campaigns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVehicleStatusResponse)) {
            return false;
        }
        GetVehicleStatusResponse other = (GetVehicleStatusResponse)((Object)obj);
        return this.hasCampaigns() == other.hasCampaigns() && Objects.equals(this.campaigns(), other.campaigns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetVehicleStatusResponse").add("Campaigns", this.hasCampaigns() ? this.campaigns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "campaigns": {
                return Optional.ofNullable(clazz.cast(this.campaigns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVehicleStatusResponse, T> g) {
        return obj -> g.apply((GetVehicleStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseResponse.BuilderImpl
    implements Builder {
        private List<VehicleStatus> campaigns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVehicleStatusResponse model) {
            super(model);
            this.campaigns(model.campaigns);
            this.nextToken(model.nextToken);
        }

        public final List<VehicleStatus.Builder> getCampaigns() {
            List<VehicleStatus.Builder> result = VehicleStatusListCopier.copyToBuilder(this.campaigns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCampaigns(Collection<VehicleStatus.BuilderImpl> campaigns) {
            this.campaigns = VehicleStatusListCopier.copyFromBuilder(campaigns);
        }

        @Override
        public final Builder campaigns(Collection<VehicleStatus> campaigns) {
            this.campaigns = VehicleStatusListCopier.copy(campaigns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder campaigns(VehicleStatus ... campaigns) {
            this.campaigns(Arrays.asList(campaigns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder campaigns(Consumer<VehicleStatus.Builder> ... campaigns) {
            this.campaigns(Stream.of(campaigns).map(c -> (VehicleStatus)((VehicleStatus.Builder)VehicleStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetVehicleStatusResponse build() {
            return new GetVehicleStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTFleetWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVehicleStatusResponse> {
        public Builder campaigns(Collection<VehicleStatus> var1);

        public Builder campaigns(VehicleStatus ... var1);

        public Builder campaigns(Consumer<VehicleStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

