/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Timestream table where the Amazon Web Services IoT FleetWise campaign sends data. Timestream stores and
 * organizes data to optimize query processing time and to reduce storage costs. For more information, see <a
 * href="https://docs.aws.amazon.com/timestream/latest/developerguide/data-modeling.html">Data modeling</a> in the
 * <i>Amazon Timestream Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimestreamConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TimestreamConfig.Builder, TimestreamConfig> {
    private static final SdkField<String> TIMESTREAM_TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestreamTableArn").getter(getter(TimestreamConfig::timestreamTableArn))
            .setter(setter(Builder::timestreamTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamTableArn").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(TimestreamConfig::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTREAM_TABLE_ARN_FIELD,
            EXECUTION_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timestreamTableArn;

    private final String executionRoleArn;

    private TimestreamConfig(BuilderImpl builder) {
        this.timestreamTableArn = builder.timestreamTableArn;
        this.executionRoleArn = builder.executionRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Timestream table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Timestream table.
     */
    public final String timestreamTableArn() {
        return timestreamTableArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task execution role that grants Amazon Web Services IoT FleetWise
     * permission to deliver data to the Amazon Timestream table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task execution role that grants Amazon Web Services IoT FleetWise
     *         permission to deliver data to the Amazon Timestream table.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestreamTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestreamConfig)) {
            return false;
        }
        TimestreamConfig other = (TimestreamConfig) obj;
        return Objects.equals(timestreamTableArn(), other.timestreamTableArn())
                && Objects.equals(executionRoleArn(), other.executionRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimestreamConfig").add("TimestreamTableArn", timestreamTableArn())
                .add("ExecutionRoleArn", executionRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timestreamTableArn":
            return Optional.ofNullable(clazz.cast(timestreamTableArn()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimestreamConfig, T> g) {
        return obj -> g.apply((TimestreamConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimestreamConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Timestream table.
         * </p>
         * 
         * @param timestreamTableArn
         *        The Amazon Resource Name (ARN) of the Amazon Timestream table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamTableArn(String timestreamTableArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task execution role that grants Amazon Web Services IoT FleetWise
         * permission to deliver data to the Amazon Timestream table.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the task execution role that grants Amazon Web Services IoT
         *        FleetWise permission to deliver data to the Amazon Timestream table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String timestreamTableArn;

        private String executionRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestreamConfig model) {
            timestreamTableArn(model.timestreamTableArn);
            executionRoleArn(model.executionRoleArn);
        }

        public final String getTimestreamTableArn() {
            return timestreamTableArn;
        }

        public final void setTimestreamTableArn(String timestreamTableArn) {
            this.timestreamTableArn = timestreamTableArn;
        }

        @Override
        public final Builder timestreamTableArn(String timestreamTableArn) {
            this.timestreamTableArn = timestreamTableArn;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        @Override
        public TimestreamConfig build() {
            return new TimestreamConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
