/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iotfleetwise.model.AccessDeniedException;
import software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ConflictException;
import software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DecoderManifestValidationException;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetLoggingOptionsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetLoggingOptionsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.InternalServerException;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidNodeException;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidSignalsException;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseException;
import software.amazon.awssdk.services.iotfleetwise.model.LimitExceededException;
import software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest;
import software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotfleetwise.model.TagResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.TagResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ThrottlingException;
import software.amazon.awssdk.services.iotfleetwise.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ValidationException;
import software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehicleIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetIterable;
import software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesIterable;

/**
 * Service client for accessing AWS IoT FleetWise. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services IoT FleetWise is a fully managed service that you can use to collect, model, and transfer vehicle
 * data to the Amazon Web Services cloud at scale. With Amazon Web Services IoT FleetWise, you can standardize all of
 * your vehicle data models, independent of the in-vehicle communication architecture, and define data collection rules
 * to transfer only high-value data to the cloud.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/">What is Amazon
 * Web Services IoT FleetWise?</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IoTFleetWiseClient extends AwsClient {
    String SERVICE_NAME = "iotfleetwise";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iotfleetwise";

    /**
     * <p>
     * Adds, or associates, a vehicle with a fleet.
     * </p>
     *
     * @param associateVehicleFleetRequest
     * @return Result of the AssociateVehicleFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.AssociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/AssociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateVehicleFleetResponse associateVehicleFleet(AssociateVehicleFleetRequest associateVehicleFleetRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds, or associates, a vehicle with a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateVehicleFleetRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateVehicleFleetRequest#builder()}
     * </p>
     *
     * @param associateVehicleFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateVehicleFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.AssociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/AssociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateVehicleFleetResponse associateVehicleFleet(
            Consumer<AssociateVehicleFleetRequest.Builder> associateVehicleFleetRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return associateVehicleFleet(AssociateVehicleFleetRequest.builder().applyMutation(associateVehicleFleetRequest).build());
    }

    /**
     * <p>
     * Creates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicles-cli.html">Create multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param batchCreateVehicleRequest
     * @return Result of the BatchCreateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.BatchCreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchCreateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateVehicleResponse batchCreateVehicle(BatchCreateVehicleRequest batchCreateVehicleRequest)
            throws InternalServerException, LimitExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicles-cli.html">Create multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateVehicleRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreateVehicleRequest#builder()}
     * </p>
     *
     * @param batchCreateVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest.Builder} to create a
     *        request.
     * @return Result of the BatchCreateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.BatchCreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchCreateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateVehicleResponse batchCreateVehicle(Consumer<BatchCreateVehicleRequest.Builder> batchCreateVehicleRequest)
            throws InternalServerException, LimitExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return batchCreateVehicle(BatchCreateVehicleRequest.builder().applyMutation(batchCreateVehicleRequest).build());
    }

    /**
     * <p>
     * Updates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/update-vehicles-cli.html">Update multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param batchUpdateVehicleRequest
     * @return Result of the BatchUpdateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.BatchUpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchUpdateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateVehicleResponse batchUpdateVehicle(BatchUpdateVehicleRequest batchUpdateVehicleRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/update-vehicles-cli.html">Update multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateVehicleRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateVehicleRequest#builder()}
     * </p>
     *
     * @param batchUpdateVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpdateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.BatchUpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchUpdateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateVehicleResponse batchUpdateVehicle(Consumer<BatchUpdateVehicleRequest.Builder> batchUpdateVehicleRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return batchUpdateVehicle(BatchUpdateVehicleRequest.builder().applyMutation(batchUpdateVehicleRequest).build());
    }

    /**
     * <p>
     * Creates an orchestration of data collection rules. The Amazon Web Services IoT FleetWise Edge Agent software
     * running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns
     * in the cloud. After you or your team approve campaigns, Amazon Web Services IoT FleetWise automatically deploys
     * them to vehicles.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html">Collect and transfer data
     * with campaigns</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createCampaignRequest
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, LimitExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an orchestration of data collection rules. The Amazon Web Services IoT FleetWise Edge Agent software
     * running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns
     * in the cloud. After you or your team approve campaigns, Amazon Web Services IoT FleetWise automatically deploys
     * them to vehicles.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html">Collect and transfer data
     * with campaigns</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCampaignRequest#builder()}
     * </p>
     *
     * @param createCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCampaignResponse createCampaign(Consumer<CreateCampaignRequest.Builder> createCampaignRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, LimitExceededException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return createCampaign(CreateCampaignRequest.builder().applyMutation(createCampaignRequest).build());
    }

    /**
     * <p>
     * Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must
     * be true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Every signal decoder has a unique name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each signal decoder is associated with a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each network interface has a unique ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * The signal decoders are specified in the model manifest.
     * </p>
     * </li>
     * </ul>
     *
     * @param createDecoderManifestRequest
     * @return Result of the CreateDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws DecoderManifestValidationException
     *         The request couldn't be completed because it contains signal decoders with one or more validation errors.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDecoderManifestResponse createDecoderManifest(CreateDecoderManifestRequest createDecoderManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, LimitExceededException,
            DecoderManifestValidationException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must
     * be true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Every signal decoder has a unique name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each signal decoder is associated with a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each network interface has a unique ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * The signal decoders are specified in the model manifest.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDecoderManifestRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDecoderManifestRequest#builder()}
     * </p>
     *
     * @param createDecoderManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest.Builder} to create
     *        a request.
     * @return Result of the CreateDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws DecoderManifestValidationException
     *         The request couldn't be completed because it contains signal decoders with one or more validation errors.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDecoderManifestResponse createDecoderManifest(
            Consumer<CreateDecoderManifestRequest.Builder> createDecoderManifestRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, LimitExceededException, DecoderManifestValidationException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return createDecoderManifest(CreateDecoderManifestRequest.builder().applyMutation(createDecoderManifestRequest).build());
    }

    /**
     * <p>
     * Creates a fleet that represents a group of vehicles.
     * </p>
     * <note>
     * <p>
     * You must create both a signal catalog and vehicles before you can create a fleet.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleets.html">Fleets</a> in the <i>Amazon
     * Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, LimitExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet that represents a group of vehicles.
     * </p>
     * <note>
     * <p>
     * You must create both a signal catalog and vehicles before you can create a fleet.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleets.html">Fleets</a> in the <i>Amazon
     * Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest.Builder} to create a request.
     * @return Result of the CreateFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, LimitExceededException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Creates a vehicle model (model manifest) that specifies signals (attributes, branches, sensors, and actuators).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicle-models.html">Vehicle models</a> in
     * the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createModelManifestRequest
     * @return Result of the CreateModelManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelManifestResponse createModelManifest(CreateModelManifestRequest createModelManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, LimitExceededException,
            ThrottlingException, ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a vehicle model (model manifest) that specifies signals (attributes, branches, sensors, and actuators).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicle-models.html">Vehicle models</a> in
     * the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelManifestRequest.Builder} avoiding the
     * need to create one manually via {@link CreateModelManifestRequest#builder()}
     * </p>
     *
     * @param createModelManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest.Builder} to create a
     *        request.
     * @return Result of the CreateModelManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelManifestResponse createModelManifest(
            Consumer<CreateModelManifestRequest.Builder> createModelManifestRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, LimitExceededException, ThrottlingException, ValidationException,
            InvalidSignalsException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return createModelManifest(CreateModelManifestRequest.builder().applyMutation(createModelManifestRequest).build());
    }

    /**
     * <p>
     * Creates a collection of standardized signals that can be reused to create vehicle models.
     * </p>
     *
     * @param createSignalCatalogRequest
     * @return Result of the CreateSignalCatalog operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws InvalidNodeException
     *         The specified node type doesn't match the expected node type for a node. You can specify the node type as
     *         branch, sensor, actuator, or attribute.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSignalCatalogResponse createSignalCatalog(CreateSignalCatalogRequest createSignalCatalogRequest)
            throws InternalServerException, ConflictException, LimitExceededException, InvalidNodeException, ThrottlingException,
            ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a collection of standardized signals that can be reused to create vehicle models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSignalCatalogRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSignalCatalogRequest#builder()}
     * </p>
     *
     * @param createSignalCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSignalCatalog operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws InvalidNodeException
     *         The specified node type doesn't match the expected node type for a node. You can specify the node type as
     *         branch, sensor, actuator, or attribute.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSignalCatalogResponse createSignalCatalog(
            Consumer<CreateSignalCatalogRequest.Builder> createSignalCatalogRequest) throws InternalServerException,
            ConflictException, LimitExceededException, InvalidNodeException, ThrottlingException, ValidationException,
            InvalidSignalsException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return createSignalCatalog(CreateSignalCatalogRequest.builder().applyMutation(createSignalCatalogRequest).build());
    }

    /**
     * <p>
     * Creates a vehicle, which is an instance of a vehicle model (model manifest). Vehicles created from the same
     * vehicle model consist of the same signals inherited from the vehicle model.
     * </p>
     * <note>
     * <p>
     * If you have an existing Amazon Web Services IoT thing, you can use Amazon Web Services IoT FleetWise to create a
     * vehicle and collect data from your thing.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicle-cli.html">Create a vehicle
     * (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createVehicleRequest
     * @return Result of the CreateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVehicleResponse createVehicle(CreateVehicleRequest createVehicleRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, LimitExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a vehicle, which is an instance of a vehicle model (model manifest). Vehicles created from the same
     * vehicle model consist of the same signals inherited from the vehicle model.
     * </p>
     * <note>
     * <p>
     * If you have an existing Amazon Web Services IoT thing, you can use Amazon Web Services IoT FleetWise to create a
     * vehicle and collect data from your thing.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicle-cli.html">Create a vehicle
     * (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVehicleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVehicleRequest#builder()}
     * </p>
     *
     * @param createVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVehicleResponse createVehicle(Consumer<CreateVehicleRequest.Builder> createVehicleRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, LimitExceededException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return createVehicle(CreateVehicleRequest.builder().applyMutation(createVehicleRequest).build());
    }

    /**
     * <p>
     * Deletes a data collection campaign. Deleting a campaign suspends all data collection and removes it from any
     * vehicles.
     * </p>
     *
     * @param deleteCampaignRequest
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data collection campaign. Deleting a campaign suspends all data collection and removes it from any
     * vehicles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCampaignRequest#builder()}
     * </p>
     *
     * @param deleteCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCampaignResponse deleteCampaign(Consumer<DeleteCampaignRequest.Builder> deleteCampaignRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return deleteCampaign(DeleteCampaignRequest.builder().applyMutation(deleteCampaignRequest).build());
    }

    /**
     * <p>
     * Deletes a decoder manifest. You can't delete a decoder manifest if it has vehicles associated with it.
     * </p>
     * <note>
     * <p>
     * If the decoder manifest is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note>
     *
     * @param deleteDecoderManifestRequest
     * @return Result of the DeleteDecoderManifest operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDecoderManifestResponse deleteDecoderManifest(DeleteDecoderManifestRequest deleteDecoderManifestRequest)
            throws InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a decoder manifest. You can't delete a decoder manifest if it has vehicles associated with it.
     * </p>
     * <note>
     * <p>
     * If the decoder manifest is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDecoderManifestRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDecoderManifestRequest#builder()}
     * </p>
     *
     * @param deleteDecoderManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteDecoderManifestRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteDecoderManifest operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDecoderManifestResponse deleteDecoderManifest(
            Consumer<DeleteDecoderManifestRequest.Builder> deleteDecoderManifestRequest) throws InternalServerException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return deleteDecoderManifest(DeleteDecoderManifestRequest.builder().applyMutation(deleteDecoderManifestRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated from the fleet. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/delete-fleet-cli.html">Delete a fleet (AWS
     * CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note>
     *
     * @param deleteFleetRequest
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated from the fleet. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/delete-fleet-cli.html">Delete a fleet (AWS
     * CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest.Builder} to create a request.
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Deletes a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * If the vehicle model is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note>
     *
     * @param deleteModelManifestRequest
     * @return Result of the DeleteModelManifest operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelManifestResponse deleteModelManifest(DeleteModelManifestRequest deleteModelManifestRequest)
            throws InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * If the vehicle model is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelManifestRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteModelManifestRequest#builder()}
     * </p>
     *
     * @param deleteModelManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteModelManifest operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelManifestResponse deleteModelManifest(
            Consumer<DeleteModelManifestRequest.Builder> deleteModelManifestRequest) throws InternalServerException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return deleteModelManifest(DeleteModelManifestRequest.builder().applyMutation(deleteModelManifestRequest).build());
    }

    /**
     * <p>
     * Deletes a signal catalog.
     * </p>
     * <note>
     * <p>
     * If the signal catalog is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note>
     *
     * @param deleteSignalCatalogRequest
     * @return Result of the DeleteSignalCatalog operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSignalCatalogResponse deleteSignalCatalog(DeleteSignalCatalogRequest deleteSignalCatalogRequest)
            throws InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a signal catalog.
     * </p>
     * <note>
     * <p>
     * If the signal catalog is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSignalCatalogRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSignalCatalogRequest#builder()}
     * </p>
     *
     * @param deleteSignalCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSignalCatalog operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSignalCatalogResponse deleteSignalCatalog(
            Consumer<DeleteSignalCatalogRequest.Builder> deleteSignalCatalogRequest) throws InternalServerException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return deleteSignalCatalog(DeleteSignalCatalogRequest.builder().applyMutation(deleteSignalCatalogRequest).build());
    }

    /**
     * <p>
     * Deletes a vehicle and removes it from any campaigns.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note>
     *
     * @param deleteVehicleRequest
     * @return Result of the DeleteVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVehicleResponse deleteVehicle(DeleteVehicleRequest deleteVehicleRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a vehicle and removes it from any campaigns.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVehicleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVehicleRequest#builder()}
     * </p>
     *
     * @param deleteVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVehicleResponse deleteVehicle(Consumer<DeleteVehicleRequest.Builder> deleteVehicleRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return deleteVehicle(DeleteVehicleRequest.builder().applyMutation(deleteVehicleRequest).build());
    }

    /**
     * <p>
     * Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle from a fleet doesn't delete the
     * vehicle.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully dissociated from a fleet, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note>
     *
     * @param disassociateVehicleFleetRequest
     * @return Result of the DisassociateVehicleFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DisassociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DisassociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateVehicleFleetResponse disassociateVehicleFleet(
            DisassociateVehicleFleetRequest disassociateVehicleFleetRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle from a fleet doesn't delete the
     * vehicle.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully dissociated from a fleet, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateVehicleFleetRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateVehicleFleetRequest#builder()}
     * </p>
     *
     * @param disassociateVehicleFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateVehicleFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DisassociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DisassociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateVehicleFleetResponse disassociateVehicleFleet(
            Consumer<DisassociateVehicleFleetRequest.Builder> disassociateVehicleFleetRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return disassociateVehicleFleet(DisassociateVehicleFleetRequest.builder().applyMutation(disassociateVehicleFleetRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a campaign.
     * </p>
     *
     * @param getCampaignRequest
     * @return Result of the GetCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCampaignResponse getCampaign(GetCampaignRequest getCampaignRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link GetCampaignRequest#builder()}
     * </p>
     *
     * @param getCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest.Builder} to create a request.
     * @return Result of the GetCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCampaignResponse getCampaign(Consumer<GetCampaignRequest.Builder> getCampaignRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return getCampaign(GetCampaignRequest.builder().applyMutation(getCampaignRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a created decoder manifest.
     * </p>
     *
     * @param getDecoderManifestRequest
     * @return Result of the GetDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDecoderManifestResponse getDecoderManifest(GetDecoderManifestRequest getDecoderManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a created decoder manifest.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDecoderManifestRequest.Builder} avoiding the
     * need to create one manually via {@link GetDecoderManifestRequest#builder()}
     * </p>
     *
     * @param getDecoderManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestRequest.Builder} to create a
     *        request.
     * @return Result of the GetDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDecoderManifestResponse getDecoderManifest(Consumer<GetDecoderManifestRequest.Builder> getDecoderManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return getDecoderManifest(GetDecoderManifestRequest.builder().applyMutation(getDecoderManifestRequest).build());
    }

    /**
     * <p>
     * Retrieves the encryption configuration for resources and data in Amazon Web Services IoT FleetWise.
     * </p>
     *
     * @param getEncryptionConfigurationRequest
     * @return Result of the GetEncryptionConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEncryptionConfigurationResponse getEncryptionConfiguration(
            GetEncryptionConfigurationRequest getEncryptionConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the encryption configuration for resources and data in Amazon Web Services IoT FleetWise.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEncryptionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param getEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetEncryptionConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEncryptionConfigurationResponse getEncryptionConfiguration(
            Consumer<GetEncryptionConfigurationRequest.Builder> getEncryptionConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return getEncryptionConfiguration(GetEncryptionConfigurationRequest.builder()
                .applyMutation(getEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a fleet.
     * </p>
     *
     * @param getFleetRequest
     * @return Result of the GetFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFleetResponse getFleet(GetFleetRequest getFleetRequest) throws InternalServerException, ResourceNotFoundException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFleetRequest.Builder} avoiding the need to
     * create one manually via {@link GetFleetRequest#builder()}
     * </p>
     *
     * @param getFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest.Builder} to create a request.
     * @return Result of the GetFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFleetResponse getFleet(Consumer<GetFleetRequest.Builder> getFleetRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return getFleet(GetFleetRequest.builder().applyMutation(getFleetRequest).build());
    }

    /**
     * <p>
     * Retrieves the logging options.
     * </p>
     *
     * @param getLoggingOptionsRequest
     * @return Result of the GetLoggingOptions operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoggingOptionsResponse getLoggingOptions(GetLoggingOptionsRequest getLoggingOptionsRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the logging options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link GetLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param getLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetLoggingOptionsRequest.Builder} to create a
     *        request.
     * @return Result of the GetLoggingOptions operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoggingOptionsResponse getLoggingOptions(Consumer<GetLoggingOptionsRequest.Builder> getLoggingOptionsRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return getLoggingOptions(GetLoggingOptionsRequest.builder().applyMutation(getLoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a vehicle model (model manifest).
     * </p>
     *
     * @param getModelManifestRequest
     * @return Result of the GetModelManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetModelManifest" target="_top">AWS
     *      API Documentation</a>
     */
    default GetModelManifestResponse getModelManifest(GetModelManifestRequest getModelManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a vehicle model (model manifest).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelManifestRequest.Builder} avoiding the need
     * to create one manually via {@link GetModelManifestRequest#builder()}
     * </p>
     *
     * @param getModelManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest.Builder} to create a
     *        request.
     * @return Result of the GetModelManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetModelManifest" target="_top">AWS
     *      API Documentation</a>
     */
    default GetModelManifestResponse getModelManifest(Consumer<GetModelManifestRequest.Builder> getModelManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return getModelManifest(GetModelManifestRequest.builder().applyMutation(getModelManifestRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status of registering your Amazon Web Services account, IAM, and Amazon
     * Timestream resources so that Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web
     * Services Cloud.
     * </p>
     * <p>
     * For more information, including step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html">Setting up Amazon Web
     * Services IoT FleetWise</a>.
     * </p>
     * <note>
     * <p>
     * This API operation doesn't require input parameters.
     * </p>
     * </note>
     *
     * @param getRegisterAccountStatusRequest
     * @return Result of the GetRegisterAccountStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetRegisterAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetRegisterAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRegisterAccountStatusResponse getRegisterAccountStatus(
            GetRegisterAccountStatusRequest getRegisterAccountStatusRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status of registering your Amazon Web Services account, IAM, and Amazon
     * Timestream resources so that Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web
     * Services Cloud.
     * </p>
     * <p>
     * For more information, including step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html">Setting up Amazon Web
     * Services IoT FleetWise</a>.
     * </p>
     * <note>
     * <p>
     * This API operation doesn't require input parameters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegisterAccountStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetRegisterAccountStatusRequest#builder()}
     * </p>
     *
     * @param getRegisterAccountStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusRequest.Builder} to
     *        create a request.
     * @return Result of the GetRegisterAccountStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetRegisterAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetRegisterAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRegisterAccountStatusResponse getRegisterAccountStatus(
            Consumer<GetRegisterAccountStatusRequest.Builder> getRegisterAccountStatusRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return getRegisterAccountStatus(GetRegisterAccountStatusRequest.builder().applyMutation(getRegisterAccountStatusRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a signal catalog.
     * </p>
     *
     * @param getSignalCatalogRequest
     * @return Result of the GetSignalCatalog operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetSignalCatalog" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSignalCatalogResponse getSignalCatalog(GetSignalCatalogRequest getSignalCatalogRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a signal catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSignalCatalogRequest.Builder} avoiding the need
     * to create one manually via {@link GetSignalCatalogRequest#builder()}
     * </p>
     *
     * @param getSignalCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest.Builder} to create a
     *        request.
     * @return Result of the GetSignalCatalog operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetSignalCatalog" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSignalCatalogResponse getSignalCatalog(Consumer<GetSignalCatalogRequest.Builder> getSignalCatalogRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return getSignalCatalog(GetSignalCatalogRequest.builder().applyMutation(getSignalCatalogRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a vehicle.
     * </p>
     *
     * @param getVehicleRequest
     * @return Result of the GetVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicle" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVehicleResponse getVehicle(GetVehicleRequest getVehicleRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a vehicle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVehicleRequest.Builder} avoiding the need to
     * create one manually via {@link GetVehicleRequest#builder()}
     * </p>
     *
     * @param getVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetVehicleRequest.Builder} to create a request.
     * @return Result of the GetVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicle" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVehicleResponse getVehicle(Consumer<GetVehicleRequest.Builder> getVehicleRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return getVehicle(GetVehicleRequest.builder().applyMutation(getVehicleRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status of a vehicle with any associated campaigns.
     * </p>
     *
     * @param getVehicleStatusRequest
     * @return Result of the GetVehicleStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetVehicleStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetVehicleStatusResponse getVehicleStatus(GetVehicleStatusRequest getVehicleStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status of a vehicle with any associated campaigns.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVehicleStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetVehicleStatusRequest#builder()}
     * </p>
     *
     * @param getVehicleStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetVehicleStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetVehicleStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetVehicleStatusResponse getVehicleStatus(Consumer<GetVehicleStatusRequest.Builder> getVehicleStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return getVehicleStatus(GetVehicleStatusRequest.builder().applyMutation(getVehicleStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status of a vehicle with any associated campaigns.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getVehicleStatus(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusIterable responses = client.getVehicleStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusIterable responses = client
     *             .getVehicleStatusPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusIterable responses = client.getVehicleStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVehicleStatus(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getVehicleStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetVehicleStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetVehicleStatusIterable getVehicleStatusPaginator(GetVehicleStatusRequest getVehicleStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return new GetVehicleStatusIterable(this, getVehicleStatusRequest);
    }

    /**
     * <p>
     * Retrieves information about the status of a vehicle with any associated campaigns.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getVehicleStatus(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusIterable responses = client.getVehicleStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusIterable responses = client
     *             .getVehicleStatusPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.GetVehicleStatusIterable responses = client.getVehicleStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVehicleStatus(software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVehicleStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetVehicleStatusRequest#builder()}
     * </p>
     *
     * @param getVehicleStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetVehicleStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetVehicleStatusIterable getVehicleStatusPaginator(Consumer<GetVehicleStatusRequest.Builder> getVehicleStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return getVehicleStatusPaginator(GetVehicleStatusRequest.builder().applyMutation(getVehicleStatusRequest).build());
    }

    /**
     * <p>
     * Creates a decoder manifest using your existing CAN DBC file from your local device.
     * </p>
     *
     * @param importDecoderManifestRequest
     * @return Result of the ImportDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws DecoderManifestValidationException
     *         The request couldn't be completed because it contains signal decoders with one or more validation errors.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ImportDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportDecoderManifestResponse importDecoderManifest(ImportDecoderManifestRequest importDecoderManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, DecoderManifestValidationException,
            ThrottlingException, ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a decoder manifest using your existing CAN DBC file from your local device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportDecoderManifestRequest.Builder} avoiding the
     * need to create one manually via {@link ImportDecoderManifestRequest#builder()}
     * </p>
     *
     * @param importDecoderManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest.Builder} to create
     *        a request.
     * @return Result of the ImportDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws DecoderManifestValidationException
     *         The request couldn't be completed because it contains signal decoders with one or more validation errors.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ImportDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportDecoderManifestResponse importDecoderManifest(
            Consumer<ImportDecoderManifestRequest.Builder> importDecoderManifestRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, DecoderManifestValidationException, ThrottlingException,
            ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return importDecoderManifest(ImportDecoderManifestRequest.builder().applyMutation(importDecoderManifestRequest).build());
    }

    /**
     * <p>
     * Creates a signal catalog using your existing VSS formatted content from your local device.
     * </p>
     *
     * @param importSignalCatalogRequest
     * @return Result of the ImportSignalCatalog operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ImportSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportSignalCatalogResponse importSignalCatalog(ImportSignalCatalogRequest importSignalCatalogRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, LimitExceededException,
            ThrottlingException, ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a signal catalog using your existing VSS formatted content from your local device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportSignalCatalogRequest.Builder} avoiding the
     * need to create one manually via {@link ImportSignalCatalogRequest#builder()}
     * </p>
     *
     * @param importSignalCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest.Builder} to create a
     *        request.
     * @return Result of the ImportSignalCatalog operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ImportSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportSignalCatalogResponse importSignalCatalog(
            Consumer<ImportSignalCatalogRequest.Builder> importSignalCatalogRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, LimitExceededException, ThrottlingException, ValidationException,
            InvalidSignalsException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return importSignalCatalog(ImportSignalCatalogRequest.builder().applyMutation(importSignalCatalogRequest).build());
    }

    /**
     * <p>
     * Lists information about created campaigns.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listCampaignsRequest
     * @return Result of the ListCampaigns operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCampaignsResponse listCampaigns(ListCampaignsRequest listCampaignsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about created campaigns.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCampaigns operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCampaignsResponse listCampaigns(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listCampaigns(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * Lists information about created campaigns.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsIterable responses = client
     *             .listCampaignsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest)} operation.</b>
     * </p>
     *
     * @param listCampaignsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCampaignsIterable listCampaignsPaginator(ListCampaignsRequest listCampaignsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return new ListCampaignsIterable(this, listCampaignsRequest);
    }

    /**
     * <p>
     * Lists information about created campaigns.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsIterable responses = client
     *             .listCampaignsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCampaignsIterable listCampaignsPaginator(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listCampaignsPaginator(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * Lists the network interfaces specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestNetworkInterfacesRequest
     * @return Result of the ListDecoderManifestNetworkInterfaces operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifestNetworkInterfaces
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestNetworkInterfacesResponse listDecoderManifestNetworkInterfaces(
            ListDecoderManifestNetworkInterfacesRequest listDecoderManifestNetworkInterfacesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the network interfaces specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDecoderManifestNetworkInterfacesRequest.Builder} avoiding the need to create one manually via
     * {@link ListDecoderManifestNetworkInterfacesRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestNetworkInterfacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest.Builder}
     *        to create a request.
     * @return Result of the ListDecoderManifestNetworkInterfaces operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifestNetworkInterfaces
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestNetworkInterfacesResponse listDecoderManifestNetworkInterfaces(
            Consumer<ListDecoderManifestNetworkInterfacesRequest.Builder> listDecoderManifestNetworkInterfacesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return listDecoderManifestNetworkInterfaces(ListDecoderManifestNetworkInterfacesRequest.builder()
                .applyMutation(listDecoderManifestNetworkInterfacesRequest).build());
    }

    /**
     * <p>
     * Lists the network interfaces specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDecoderManifestNetworkInterfaces(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesIterable responses = client.listDecoderManifestNetworkInterfacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesIterable responses = client
     *             .listDecoderManifestNetworkInterfacesPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesIterable responses = client.listDecoderManifestNetworkInterfacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifestNetworkInterfaces(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDecoderManifestNetworkInterfacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifestNetworkInterfaces
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestNetworkInterfacesIterable listDecoderManifestNetworkInterfacesPaginator(
            ListDecoderManifestNetworkInterfacesRequest listDecoderManifestNetworkInterfacesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return new ListDecoderManifestNetworkInterfacesIterable(this, listDecoderManifestNetworkInterfacesRequest);
    }

    /**
     * <p>
     * Lists the network interfaces specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDecoderManifestNetworkInterfaces(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesIterable responses = client.listDecoderManifestNetworkInterfacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesIterable responses = client
     *             .listDecoderManifestNetworkInterfacesPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestNetworkInterfacesIterable responses = client.listDecoderManifestNetworkInterfacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifestNetworkInterfaces(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDecoderManifestNetworkInterfacesRequest.Builder} avoiding the need to create one manually via
     * {@link ListDecoderManifestNetworkInterfacesRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestNetworkInterfacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifestNetworkInterfaces
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestNetworkInterfacesIterable listDecoderManifestNetworkInterfacesPaginator(
            Consumer<ListDecoderManifestNetworkInterfacesRequest.Builder> listDecoderManifestNetworkInterfacesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return listDecoderManifestNetworkInterfacesPaginator(ListDecoderManifestNetworkInterfacesRequest.builder()
                .applyMutation(listDecoderManifestNetworkInterfacesRequest).build());
    }

    /**
     * <p>
     * A list of information about signal decoders specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestSignalsRequest
     * @return Result of the ListDecoderManifestSignals operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifestSignals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestSignalsResponse listDecoderManifestSignals(
            ListDecoderManifestSignalsRequest listDecoderManifestSignalsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of information about signal decoders specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDecoderManifestSignalsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDecoderManifestSignalsRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestSignalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDecoderManifestSignals operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifestSignals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestSignalsResponse listDecoderManifestSignals(
            Consumer<ListDecoderManifestSignalsRequest.Builder> listDecoderManifestSignalsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return listDecoderManifestSignals(ListDecoderManifestSignalsRequest.builder()
                .applyMutation(listDecoderManifestSignalsRequest).build());
    }

    /**
     * <p>
     * A list of information about signal decoders specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDecoderManifestSignals(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsIterable responses = client.listDecoderManifestSignalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsIterable responses = client
     *             .listDecoderManifestSignalsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsIterable responses = client.listDecoderManifestSignalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifestSignals(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDecoderManifestSignalsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifestSignals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestSignalsIterable listDecoderManifestSignalsPaginator(
            ListDecoderManifestSignalsRequest listDecoderManifestSignalsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return new ListDecoderManifestSignalsIterable(this, listDecoderManifestSignalsRequest);
    }

    /**
     * <p>
     * A list of information about signal decoders specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDecoderManifestSignals(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsIterable responses = client.listDecoderManifestSignalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsIterable responses = client
     *             .listDecoderManifestSignalsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestSignalsIterable responses = client.listDecoderManifestSignalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifestSignals(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDecoderManifestSignalsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDecoderManifestSignalsRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestSignalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifestSignals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestSignalsIterable listDecoderManifestSignalsPaginator(
            Consumer<ListDecoderManifestSignalsRequest.Builder> listDecoderManifestSignalsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return listDecoderManifestSignalsPaginator(ListDecoderManifestSignalsRequest.builder()
                .applyMutation(listDecoderManifestSignalsRequest).build());
    }

    /**
     * <p>
     * Lists decoder manifests.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestsRequest
     * @return Result of the ListDecoderManifests operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestsResponse listDecoderManifests(ListDecoderManifestsRequest listDecoderManifestsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists decoder manifests.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDecoderManifestsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDecoderManifestsRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDecoderManifests operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestsResponse listDecoderManifests(
            Consumer<ListDecoderManifestsRequest.Builder> listDecoderManifestsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return listDecoderManifests(ListDecoderManifestsRequest.builder().applyMutation(listDecoderManifestsRequest).build());
    }

    /**
     * <p>
     * Lists decoder manifests.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDecoderManifests(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsIterable responses = client.listDecoderManifestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsIterable responses = client
     *             .listDecoderManifestsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsIterable responses = client.listDecoderManifestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifests(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDecoderManifestsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestsIterable listDecoderManifestsPaginator(ListDecoderManifestsRequest listDecoderManifestsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return new ListDecoderManifestsIterable(this, listDecoderManifestsRequest);
    }

    /**
     * <p>
     * Lists decoder manifests.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDecoderManifests(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsIterable responses = client.listDecoderManifestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsIterable responses = client
     *             .listDecoderManifestsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListDecoderManifestsIterable responses = client.listDecoderManifestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDecoderManifests(software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDecoderManifestsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDecoderManifestsRequest#builder()}
     * </p>
     *
     * @param listDecoderManifestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDecoderManifestsIterable listDecoderManifestsPaginator(
            Consumer<ListDecoderManifestsRequest.Builder> listDecoderManifestsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return listDecoderManifestsPaginator(ListDecoderManifestsRequest.builder().applyMutation(listDecoderManifestsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information for each created fleet in an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listFleetsRequest
     * @return Result of the ListFleets operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information for each created fleet in an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest.Builder} to create a request.
     * @return Result of the ListFleets operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets(Consumer<ListFleetsRequest.Builder> listFleetsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listFleets(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Retrieves information for each created fleet in an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator(ListFleetsRequest listFleetsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return new ListFleetsIterable(this, listFleetsRequest);
    }

    /**
     * <p>
     * Retrieves information for each created fleet in an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator(Consumer<ListFleetsRequest.Builder> listFleetsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return listFleetsPaginator(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of IDs for all fleets that the vehicle is associated with.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listFleetsForVehicleRequest
     * @return Result of the ListFleetsForVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListFleetsForVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFleetsForVehicleResponse listFleetsForVehicle(ListFleetsForVehicleRequest listFleetsForVehicleRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of IDs for all fleets that the vehicle is associated with.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsForVehicleRequest.Builder} avoiding the
     * need to create one manually via {@link ListFleetsForVehicleRequest#builder()}
     * </p>
     *
     * @param listFleetsForVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest.Builder} to create a
     *        request.
     * @return Result of the ListFleetsForVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListFleetsForVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFleetsForVehicleResponse listFleetsForVehicle(
            Consumer<ListFleetsForVehicleRequest.Builder> listFleetsForVehicleRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listFleetsForVehicle(ListFleetsForVehicleRequest.builder().applyMutation(listFleetsForVehicleRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of IDs for all fleets that the vehicle is associated with.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listFleetsForVehicle(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehicleIterable responses = client.listFleetsForVehiclePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehicleIterable responses = client
     *             .listFleetsForVehiclePaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehicleIterable responses = client.listFleetsForVehiclePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleetsForVehicle(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFleetsForVehicleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListFleetsForVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFleetsForVehicleIterable listFleetsForVehiclePaginator(ListFleetsForVehicleRequest listFleetsForVehicleRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return new ListFleetsForVehicleIterable(this, listFleetsForVehicleRequest);
    }

    /**
     * <p>
     * Retrieves a list of IDs for all fleets that the vehicle is associated with.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listFleetsForVehicle(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehicleIterable responses = client.listFleetsForVehiclePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehicleIterable responses = client
     *             .listFleetsForVehiclePaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListFleetsForVehicleIterable responses = client.listFleetsForVehiclePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleetsForVehicle(software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsForVehicleRequest.Builder} avoiding the
     * need to create one manually via {@link ListFleetsForVehicleRequest#builder()}
     * </p>
     *
     * @param listFleetsForVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListFleetsForVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFleetsForVehicleIterable listFleetsForVehiclePaginator(
            Consumer<ListFleetsForVehicleRequest.Builder> listFleetsForVehicleRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listFleetsForVehiclePaginator(ListFleetsForVehicleRequest.builder().applyMutation(listFleetsForVehicleRequest)
                .build());
    }

    /**
     * <p>
     * Lists information about nodes specified in a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listModelManifestNodesRequest
     * @return Result of the ListModelManifestNodes operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListModelManifestNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestNodesResponse listModelManifestNodes(ListModelManifestNodesRequest listModelManifestNodesRequest)
            throws InternalServerException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about nodes specified in a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelManifestNodesRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelManifestNodesRequest#builder()}
     * </p>
     *
     * @param listModelManifestNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest.Builder} to create
     *        a request.
     * @return Result of the ListModelManifestNodes operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListModelManifestNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestNodesResponse listModelManifestNodes(
            Consumer<ListModelManifestNodesRequest.Builder> listModelManifestNodesRequest) throws InternalServerException,
            ResourceNotFoundException, LimitExceededException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        return listModelManifestNodes(ListModelManifestNodesRequest.builder().applyMutation(listModelManifestNodesRequest)
                .build());
    }

    /**
     * <p>
     * Lists information about nodes specified in a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listModelManifestNodes(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesIterable responses = client.listModelManifestNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesIterable responses = client
     *             .listModelManifestNodesPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesIterable responses = client.listModelManifestNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelManifestNodes(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelManifestNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListModelManifestNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestNodesIterable listModelManifestNodesPaginator(
            ListModelManifestNodesRequest listModelManifestNodesRequest) throws InternalServerException,
            ResourceNotFoundException, LimitExceededException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        return new ListModelManifestNodesIterable(this, listModelManifestNodesRequest);
    }

    /**
     * <p>
     * Lists information about nodes specified in a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listModelManifestNodes(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesIterable responses = client.listModelManifestNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesIterable responses = client
     *             .listModelManifestNodesPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestNodesIterable responses = client.listModelManifestNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelManifestNodes(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelManifestNodesRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelManifestNodesRequest#builder()}
     * </p>
     *
     * @param listModelManifestNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListModelManifestNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestNodesIterable listModelManifestNodesPaginator(
            Consumer<ListModelManifestNodesRequest.Builder> listModelManifestNodesRequest) throws InternalServerException,
            ResourceNotFoundException, LimitExceededException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        return listModelManifestNodesPaginator(ListModelManifestNodesRequest.builder()
                .applyMutation(listModelManifestNodesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of vehicle models (model manifests).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listModelManifestsRequest
     * @return Result of the ListModelManifests operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListModelManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestsResponse listModelManifests(ListModelManifestsRequest listModelManifestsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of vehicle models (model manifests).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelManifestsRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelManifestsRequest#builder()}
     * </p>
     *
     * @param listModelManifestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest.Builder} to create a
     *        request.
     * @return Result of the ListModelManifests operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListModelManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestsResponse listModelManifests(Consumer<ListModelManifestsRequest.Builder> listModelManifestsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listModelManifests(ListModelManifestsRequest.builder().applyMutation(listModelManifestsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of vehicle models (model manifests).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listModelManifests(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsIterable responses = client.listModelManifestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsIterable responses = client
     *             .listModelManifestsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsIterable responses = client.listModelManifestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelManifests(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listModelManifestsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListModelManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestsIterable listModelManifestsPaginator(ListModelManifestsRequest listModelManifestsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return new ListModelManifestsIterable(this, listModelManifestsRequest);
    }

    /**
     * <p>
     * Retrieves a list of vehicle models (model manifests).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listModelManifests(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsIterable responses = client.listModelManifestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsIterable responses = client
     *             .listModelManifestsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListModelManifestsIterable responses = client.listModelManifestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModelManifests(software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelManifestsRequest.Builder} avoiding the
     * need to create one manually via {@link ListModelManifestsRequest#builder()}
     * </p>
     *
     * @param listModelManifestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListModelManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListModelManifestsIterable listModelManifestsPaginator(
            Consumer<ListModelManifestsRequest.Builder> listModelManifestsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return listModelManifestsPaginator(ListModelManifestsRequest.builder().applyMutation(listModelManifestsRequest).build());
    }

    /**
     * <p>
     * Lists of information about the signals (nodes) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listSignalCatalogNodesRequest
     * @return Result of the ListSignalCatalogNodes operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListSignalCatalogNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogNodesResponse listSignalCatalogNodes(ListSignalCatalogNodesRequest listSignalCatalogNodesRequest)
            throws InternalServerException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists of information about the signals (nodes) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalCatalogNodesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSignalCatalogNodesRequest#builder()}
     * </p>
     *
     * @param listSignalCatalogNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest.Builder} to create
     *        a request.
     * @return Result of the ListSignalCatalogNodes operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListSignalCatalogNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogNodesResponse listSignalCatalogNodes(
            Consumer<ListSignalCatalogNodesRequest.Builder> listSignalCatalogNodesRequest) throws InternalServerException,
            ResourceNotFoundException, LimitExceededException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        return listSignalCatalogNodes(ListSignalCatalogNodesRequest.builder().applyMutation(listSignalCatalogNodesRequest)
                .build());
    }

    /**
     * <p>
     * Lists of information about the signals (nodes) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listSignalCatalogNodes(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesIterable responses = client.listSignalCatalogNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesIterable responses = client
     *             .listSignalCatalogNodesPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesIterable responses = client.listSignalCatalogNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalCatalogNodes(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSignalCatalogNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListSignalCatalogNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogNodesIterable listSignalCatalogNodesPaginator(
            ListSignalCatalogNodesRequest listSignalCatalogNodesRequest) throws InternalServerException,
            ResourceNotFoundException, LimitExceededException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        return new ListSignalCatalogNodesIterable(this, listSignalCatalogNodesRequest);
    }

    /**
     * <p>
     * Lists of information about the signals (nodes) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listSignalCatalogNodes(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesIterable responses = client.listSignalCatalogNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesIterable responses = client
     *             .listSignalCatalogNodesPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogNodesIterable responses = client.listSignalCatalogNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalCatalogNodes(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalCatalogNodesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSignalCatalogNodesRequest#builder()}
     * </p>
     *
     * @param listSignalCatalogNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListSignalCatalogNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogNodesIterable listSignalCatalogNodesPaginator(
            Consumer<ListSignalCatalogNodesRequest.Builder> listSignalCatalogNodesRequest) throws InternalServerException,
            ResourceNotFoundException, LimitExceededException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        return listSignalCatalogNodesPaginator(ListSignalCatalogNodesRequest.builder()
                .applyMutation(listSignalCatalogNodesRequest).build());
    }

    /**
     * <p>
     * Lists all the created signal catalogs in an Amazon Web Services account.
     * </p>
     * <p>
     * You can use to list information about each signal (node) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listSignalCatalogsRequest
     * @return Result of the ListSignalCatalogs operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListSignalCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogsResponse listSignalCatalogs(ListSignalCatalogsRequest listSignalCatalogsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the created signal catalogs in an Amazon Web Services account.
     * </p>
     * <p>
     * You can use to list information about each signal (node) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalCatalogsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSignalCatalogsRequest#builder()}
     * </p>
     *
     * @param listSignalCatalogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSignalCatalogs operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListSignalCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogsResponse listSignalCatalogs(Consumer<ListSignalCatalogsRequest.Builder> listSignalCatalogsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listSignalCatalogs(ListSignalCatalogsRequest.builder().applyMutation(listSignalCatalogsRequest).build());
    }

    /**
     * <p>
     * Lists all the created signal catalogs in an Amazon Web Services account.
     * </p>
     * <p>
     * You can use to list information about each signal (node) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listSignalCatalogs(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsIterable responses = client.listSignalCatalogsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsIterable responses = client
     *             .listSignalCatalogsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsIterable responses = client.listSignalCatalogsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalCatalogs(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSignalCatalogsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListSignalCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogsIterable listSignalCatalogsPaginator(ListSignalCatalogsRequest listSignalCatalogsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return new ListSignalCatalogsIterable(this, listSignalCatalogsRequest);
    }

    /**
     * <p>
     * Lists all the created signal catalogs in an Amazon Web Services account.
     * </p>
     * <p>
     * You can use to list information about each signal (node) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listSignalCatalogs(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsIterable responses = client.listSignalCatalogsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsIterable responses = client
     *             .listSignalCatalogsPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListSignalCatalogsIterable responses = client.listSignalCatalogsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalCatalogs(software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalCatalogsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSignalCatalogsRequest#builder()}
     * </p>
     *
     * @param listSignalCatalogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListSignalCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSignalCatalogsIterable listSignalCatalogsPaginator(
            Consumer<ListSignalCatalogsRequest.Builder> listSignalCatalogsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return listSignalCatalogsPaginator(ListSignalCatalogsRequest.builder().applyMutation(listSignalCatalogsRequest).build());
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of summaries of created vehicles.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listVehiclesRequest
     * @return Result of the ListVehicles operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListVehicles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVehiclesResponse listVehicles(ListVehiclesRequest listVehiclesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of summaries of created vehicles.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVehiclesRequest.Builder} avoiding the need to
     * create one manually via {@link ListVehiclesRequest#builder()}
     * </p>
     *
     * @param listVehiclesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest.Builder} to create a
     *        request.
     * @return Result of the ListVehicles operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListVehicles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVehiclesResponse listVehicles(Consumer<ListVehiclesRequest.Builder> listVehiclesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listVehicles(ListVehiclesRequest.builder().applyMutation(listVehiclesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of summaries of created vehicles.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listVehicles(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesIterable responses = client.listVehiclesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesIterable responses = client
     *             .listVehiclesPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesIterable responses = client.listVehiclesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVehicles(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest)} operation.</b>
     * </p>
     *
     * @param listVehiclesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListVehicles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVehiclesIterable listVehiclesPaginator(ListVehiclesRequest listVehiclesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return new ListVehiclesIterable(this, listVehiclesRequest);
    }

    /**
     * <p>
     * Retrieves a list of summaries of created vehicles.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listVehicles(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesIterable responses = client.listVehiclesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesIterable responses = client
     *             .listVehiclesPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesIterable responses = client.listVehiclesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVehicles(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVehiclesRequest.Builder} avoiding the need to
     * create one manually via {@link ListVehiclesRequest#builder()}
     * </p>
     *
     * @param listVehiclesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListVehicles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVehiclesIterable listVehiclesPaginator(Consumer<ListVehiclesRequest.Builder> listVehiclesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listVehiclesPaginator(ListVehiclesRequest.builder().applyMutation(listVehiclesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of summaries of all vehicles associated with a fleet.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listVehiclesInFleetRequest
     * @return Result of the ListVehiclesInFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListVehiclesInFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVehiclesInFleetResponse listVehiclesInFleet(ListVehiclesInFleetRequest listVehiclesInFleetRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of summaries of all vehicles associated with a fleet.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVehiclesInFleetRequest.Builder} avoiding the
     * need to create one manually via {@link ListVehiclesInFleetRequest#builder()}
     * </p>
     *
     * @param listVehiclesInFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest.Builder} to create a
     *        request.
     * @return Result of the ListVehiclesInFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListVehiclesInFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVehiclesInFleetResponse listVehiclesInFleet(
            Consumer<ListVehiclesInFleetRequest.Builder> listVehiclesInFleetRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listVehiclesInFleet(ListVehiclesInFleetRequest.builder().applyMutation(listVehiclesInFleetRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of summaries of all vehicles associated with a fleet.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listVehiclesInFleet(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetIterable responses = client.listVehiclesInFleetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetIterable responses = client
     *             .listVehiclesInFleetPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetIterable responses = client.listVehiclesInFleetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVehiclesInFleet(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVehiclesInFleetRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListVehiclesInFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVehiclesInFleetIterable listVehiclesInFleetPaginator(ListVehiclesInFleetRequest listVehiclesInFleetRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return new ListVehiclesInFleetIterable(this, listVehiclesInFleetRequest);
    }

    /**
     * <p>
     * Retrieves a list of summaries of all vehicles associated with a fleet.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listVehiclesInFleet(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetIterable responses = client.listVehiclesInFleetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetIterable responses = client
     *             .listVehiclesInFleetPaginator(request);
     *     for (software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotfleetwise.paginators.ListVehiclesInFleetIterable responses = client.listVehiclesInFleetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVehiclesInFleet(software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVehiclesInFleetRequest.Builder} avoiding the
     * need to create one manually via {@link ListVehiclesInFleetRequest#builder()}
     * </p>
     *
     * @param listVehiclesInFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListVehiclesInFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVehiclesInFleetIterable listVehiclesInFleetPaginator(
            Consumer<ListVehiclesInFleetRequest.Builder> listVehiclesInFleetRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        return listVehiclesInFleetPaginator(ListVehiclesInFleetRequest.builder().applyMutation(listVehiclesInFleetRequest)
                .build());
    }

    /**
     * <p>
     * Creates or updates the encryption configuration. Amazon Web Services IoT FleetWise can encrypt your data and
     * resources using an Amazon Web Services managed key. Or, you can use a KMS key that you own and manage. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/data-encryption.html">Data encryption</a>
     * in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param putEncryptionConfigurationRequest
     * @return Result of the PutEncryptionConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.PutEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEncryptionConfigurationResponse putEncryptionConfiguration(
            PutEncryptionConfigurationRequest putEncryptionConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the encryption configuration. Amazon Web Services IoT FleetWise can encrypt your data and
     * resources using an Amazon Web Services managed key. Or, you can use a KMS key that you own and manage. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/data-encryption.html">Data encryption</a>
     * in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEncryptionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param putEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the PutEncryptionConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.PutEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEncryptionConfigurationResponse putEncryptionConfiguration(
            Consumer<PutEncryptionConfigurationRequest.Builder> putEncryptionConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return putEncryptionConfiguration(PutEncryptionConfigurationRequest.builder()
                .applyMutation(putEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates or updates the logging option.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return Result of the PutLoggingOptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutLoggingOptionsResponse putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the logging option.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link PutLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param putLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest.Builder} to create a
     *        request.
     * @return Result of the PutLoggingOptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutLoggingOptionsResponse putLoggingOptions(Consumer<PutLoggingOptionsRequest.Builder> putLoggingOptionsRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return putLoggingOptions(PutLoggingOptionsRequest.builder().applyMutation(putLoggingOptionsRequest).build());
    }

    /**
     * <important>
     * <p>
     * This API operation contains deprecated parameters. Register your account again without the Timestream resources
     * parameter so that Amazon Web Services IoT FleetWise can remove the Timestream metadata stored. You should then
     * pass the data destination into the <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_CreateCampaign.html">CreateCampaign</a>
     * API operation.
     * </p>
     * <p>
     * You must delete any existing campaigns that include an empty data destination before you register your account
     * again. For more information, see the <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_DeleteCampaign.html">DeleteCampaign</a>
     * API operation.
     * </p>
     * <p>
     * If you want to delete the Timestream inline policy from the service-linked role, such as to mitigate an overly
     * permissive policy, you must first delete any existing campaigns. Then delete the service-linked role and register
     * your account again to enable CloudWatch metrics. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html"
     * >DeleteServiceLinkedRole</a> in the <i>Identity and Access Management API Reference</i>.
     * </p>
     * </important>
     * 
     * <pre>
     * <code> &lt;p&gt;Registers your Amazon Web Services account, IAM, and Amazon Timestream resources so Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud. For more information, including step-by-step procedures, see &lt;a href=&quot;https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html&quot;&gt;Setting up Amazon Web Services IoT FleetWise&lt;/a&gt;. &lt;/p&gt; &lt;note&gt; &lt;p&gt;An Amazon Web Services account is &lt;b&gt;not&lt;/b&gt; the same thing as a &quot;user.&quot; An &lt;a href=&quot;https://docs.aws.amazon.com/IAM/latest/UserGuide/introduction_identity-management.html#intro-identity-users&quot;&gt;Amazon Web Services user&lt;/a&gt; is an identity that you create using Identity and Access Management (IAM) and takes the form of either an &lt;a href=&quot;https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html&quot;&gt;IAM user&lt;/a&gt; or an &lt;a href=&quot;https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html&quot;&gt;IAM role, both with credentials&lt;/a&gt;. A single Amazon Web Services account can, and typically does, contain many users and roles.&lt;/p&gt; &lt;/note&gt; </code>
     * </pre>
     *
     * @param registerAccountRequest
     * @return Result of the RegisterAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.RegisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/RegisterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterAccountResponse registerAccount(RegisterAccountRequest registerAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * This API operation contains deprecated parameters. Register your account again without the Timestream resources
     * parameter so that Amazon Web Services IoT FleetWise can remove the Timestream metadata stored. You should then
     * pass the data destination into the <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_CreateCampaign.html">CreateCampaign</a>
     * API operation.
     * </p>
     * <p>
     * You must delete any existing campaigns that include an empty data destination before you register your account
     * again. For more information, see the <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_DeleteCampaign.html">DeleteCampaign</a>
     * API operation.
     * </p>
     * <p>
     * If you want to delete the Timestream inline policy from the service-linked role, such as to mitigate an overly
     * permissive policy, you must first delete any existing campaigns. Then delete the service-linked role and register
     * your account again to enable CloudWatch metrics. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html"
     * >DeleteServiceLinkedRole</a> in the <i>Identity and Access Management API Reference</i>.
     * </p>
     * </important>
     * 
     * <pre>
     * <code> &lt;p&gt;Registers your Amazon Web Services account, IAM, and Amazon Timestream resources so Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud. For more information, including step-by-step procedures, see &lt;a href=&quot;https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html&quot;&gt;Setting up Amazon Web Services IoT FleetWise&lt;/a&gt;. &lt;/p&gt; &lt;note&gt; &lt;p&gt;An Amazon Web Services account is &lt;b&gt;not&lt;/b&gt; the same thing as a &quot;user.&quot; An &lt;a href=&quot;https://docs.aws.amazon.com/IAM/latest/UserGuide/introduction_identity-management.html#intro-identity-users&quot;&gt;Amazon Web Services user&lt;/a&gt; is an identity that you create using Identity and Access Management (IAM) and takes the form of either an &lt;a href=&quot;https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html&quot;&gt;IAM user&lt;/a&gt; or an &lt;a href=&quot;https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html&quot;&gt;IAM role, both with credentials&lt;/a&gt;. A single Amazon Web Services account can, and typically does, contain many users and roles.&lt;/p&gt; &lt;/note&gt; </code>
     * </pre>
     * 
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterAccountRequest#builder()}
     * </p>
     *
     * @param registerAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest.Builder} to create a
     *        request.
     * @return Result of the RegisterAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.RegisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/RegisterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterAccountResponse registerAccount(Consumer<RegisterAccountRequest.Builder> registerAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return registerAccount(RegisterAccountRequest.builder().applyMutation(registerAccountRequest).build());
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a campaign.
     * </p>
     *
     * @param updateCampaignRequest
     * @return Result of the UpdateCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCampaignResponse updateCampaign(UpdateCampaignRequest updateCampaignRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCampaignRequest#builder()}
     * </p>
     *
     * @param updateCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCampaignResponse updateCampaign(Consumer<UpdateCampaignRequest.Builder> updateCampaignRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return updateCampaign(UpdateCampaignRequest.builder().applyMutation(updateCampaignRequest).build());
    }

    /**
     * <p>
     * Updates a decoder manifest.
     * </p>
     * <p>
     * A decoder manifest can only be updated when the status is <code>DRAFT</code>. Only <code>ACTIVE</code> decoder
     * manifests can be associated with vehicles.
     * </p>
     *
     * @param updateDecoderManifestRequest
     * @return Result of the UpdateDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws DecoderManifestValidationException
     *         The request couldn't be completed because it contains signal decoders with one or more validation errors.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDecoderManifestResponse updateDecoderManifest(UpdateDecoderManifestRequest updateDecoderManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, LimitExceededException,
            DecoderManifestValidationException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a decoder manifest.
     * </p>
     * <p>
     * A decoder manifest can only be updated when the status is <code>DRAFT</code>. Only <code>ACTIVE</code> decoder
     * manifests can be associated with vehicles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDecoderManifestRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDecoderManifestRequest#builder()}
     * </p>
     *
     * @param updateDecoderManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws DecoderManifestValidationException
     *         The request couldn't be completed because it contains signal decoders with one or more validation errors.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDecoderManifestResponse updateDecoderManifest(
            Consumer<UpdateDecoderManifestRequest.Builder> updateDecoderManifestRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, LimitExceededException, DecoderManifestValidationException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return updateDecoderManifest(UpdateDecoderManifestRequest.builder().applyMutation(updateDecoderManifestRequest).build());
    }

    /**
     * <p>
     * Updates the description of an existing fleet.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully updated, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty HTTP body.
     * </p>
     * </note>
     *
     * @param updateFleetRequest
     * @return Result of the UpdateFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFleetResponse updateFleet(UpdateFleetRequest updateFleetRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description of an existing fleet.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully updated, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty HTTP body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFleetRequest#builder()}
     * </p>
     *
     * @param updateFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest.Builder} to create a request.
     * @return Result of the UpdateFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFleetResponse updateFleet(Consumer<UpdateFleetRequest.Builder> updateFleetRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return updateFleet(UpdateFleetRequest.builder().applyMutation(updateFleetRequest).build());
    }

    /**
     * <p>
     * Updates a vehicle model (model manifest). If created vehicles are associated with a vehicle model, it can't be
     * updated.
     * </p>
     *
     * @param updateModelManifestRequest
     * @return Result of the UpdateModelManifest operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateModelManifestResponse updateModelManifest(UpdateModelManifestRequest updateModelManifestRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a vehicle model (model manifest). If created vehicles are associated with a vehicle model, it can't be
     * updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelManifestRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateModelManifestRequest#builder()}
     * </p>
     *
     * @param updateModelManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateModelManifest operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateModelManifestResponse updateModelManifest(
            Consumer<UpdateModelManifestRequest.Builder> updateModelManifestRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, InvalidSignalsException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return updateModelManifest(UpdateModelManifestRequest.builder().applyMutation(updateModelManifestRequest).build());
    }

    /**
     * <p>
     * Updates a signal catalog.
     * </p>
     *
     * @param updateSignalCatalogRequest
     * @return Result of the UpdateSignalCatalog operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws InvalidNodeException
     *         The specified node type doesn't match the expected node type for a node. You can specify the node type as
     *         branch, sensor, actuator, or attribute.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSignalCatalogResponse updateSignalCatalog(UpdateSignalCatalogRequest updateSignalCatalogRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, LimitExceededException,
            InvalidNodeException, ThrottlingException, ValidationException, InvalidSignalsException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a signal catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSignalCatalogRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSignalCatalogRequest#builder()}
     * </p>
     *
     * @param updateSignalCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSignalCatalog operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws InvalidNodeException
     *         The specified node type doesn't match the expected node type for a node. You can specify the node type as
     *         branch, sensor, actuator, or attribute.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSignalCatalogResponse updateSignalCatalog(
            Consumer<UpdateSignalCatalogRequest.Builder> updateSignalCatalogRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, LimitExceededException, InvalidNodeException, ThrottlingException,
            ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        return updateSignalCatalog(UpdateSignalCatalogRequest.builder().applyMutation(updateSignalCatalogRequest).build());
    }

    /**
     * <p>
     * Updates a vehicle.
     * </p>
     *
     * @param updateVehicleRequest
     * @return Result of the UpdateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVehicleResponse updateVehicle(UpdateVehicleRequest updateVehicleRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a vehicle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVehicleRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateVehicleRequest#builder()}
     * </p>
     *
     * @param updateVehicleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVehicleResponse updateVehicle(Consumer<UpdateVehicleRequest.Builder> updateVehicleRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        return updateVehicle(UpdateVehicleRequest.builder().applyMutation(updateVehicleRequest).build());
    }

    /**
     * Create a {@link IoTFleetWiseClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IoTFleetWiseClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IoTFleetWiseClient}.
     */
    static IoTFleetWiseClientBuilder builder() {
        return new DefaultIoTFleetWiseClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default IoTFleetWiseServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
