/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotfleetwise.internal.IoTFleetWiseServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.iotfleetwise.model.AccessDeniedException;
import software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ConflictException;
import software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DecoderManifestValidationException;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetLoggingOptionsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetLoggingOptionsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.InternalServerException;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidNodeException;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidSignalsException;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseException;
import software.amazon.awssdk.services.iotfleetwise.model.LimitExceededException;
import software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest;
import software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotfleetwise.model.TagResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.TagResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ThrottlingException;
import software.amazon.awssdk.services.iotfleetwise.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ValidationException;
import software.amazon.awssdk.services.iotfleetwise.transform.AssociateVehicleFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.BatchCreateVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.BatchUpdateVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateDecoderManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateModelManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateSignalCatalogRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.CreateVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteDecoderManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteModelManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteSignalCatalogRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DeleteVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.DisassociateVehicleFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetCampaignRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetDecoderManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetEncryptionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetModelManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetRegisterAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetSignalCatalogRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.GetVehicleStatusRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ImportDecoderManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ImportSignalCatalogRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListCampaignsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListDecoderManifestNetworkInterfacesRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListDecoderManifestSignalsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListDecoderManifestsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListFleetsForVehicleRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListModelManifestNodesRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListModelManifestsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListSignalCatalogNodesRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListSignalCatalogsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListVehiclesInFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.ListVehiclesRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.PutEncryptionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.PutLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.RegisterAccountRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateCampaignRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateDecoderManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateFleetRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateModelManifestRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateSignalCatalogRequestMarshaller;
import software.amazon.awssdk.services.iotfleetwise.transform.UpdateVehicleRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link IoTFleetWiseClient}.
 *
 * @see IoTFleetWiseClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIoTFleetWiseClient implements IoTFleetWiseClient {
    private static final Logger log = Logger.loggerFor(DefaultIoTFleetWiseClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIoTFleetWiseClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds, or associates, a vehicle with a fleet.
     * </p>
     *
     * @param associateVehicleFleetRequest
     * @return Result of the AssociateVehicleFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.AssociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/AssociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateVehicleFleetResponse associateVehicleFleet(AssociateVehicleFleetRequest associateVehicleFleetRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateVehicleFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateVehicleFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateVehicleFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateVehicleFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateVehicleFleet");

            return clientHandler.execute(new ClientExecutionParams<AssociateVehicleFleetRequest, AssociateVehicleFleetResponse>()
                    .withOperationName("AssociateVehicleFleet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateVehicleFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateVehicleFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicles-cli.html">Create multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param batchCreateVehicleRequest
     * @return Result of the BatchCreateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.BatchCreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchCreateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchCreateVehicleResponse batchCreateVehicle(BatchCreateVehicleRequest batchCreateVehicleRequest)
            throws InternalServerException, LimitExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreateVehicleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchCreateVehicleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateVehicleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchCreateVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateVehicle");

            return clientHandler.execute(new ClientExecutionParams<BatchCreateVehicleRequest, BatchCreateVehicleResponse>()
                    .withOperationName("BatchCreateVehicle").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchCreateVehicleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchCreateVehicleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a group, or batch, of vehicles.
     * </p>
     * <note>
     * <p>
     * You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/update-vehicles-cli.html">Update multiple
     * vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param batchUpdateVehicleRequest
     * @return Result of the BatchUpdateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.BatchUpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/BatchUpdateVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchUpdateVehicleResponse batchUpdateVehicle(BatchUpdateVehicleRequest batchUpdateVehicleRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdateVehicleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchUpdateVehicleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateVehicleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchUpdateVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateVehicle");

            return clientHandler.execute(new ClientExecutionParams<BatchUpdateVehicleRequest, BatchUpdateVehicleResponse>()
                    .withOperationName("BatchUpdateVehicle").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchUpdateVehicleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchUpdateVehicleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an orchestration of data collection rules. The Amazon Web Services IoT FleetWise Edge Agent software
     * running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns
     * in the cloud. After you or your team approve campaigns, Amazon Web Services IoT FleetWise automatically deploys
     * them to vehicles.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html">Collect and transfer data
     * with campaigns</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createCampaignRequest
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, LimitExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCampaign");

            return clientHandler.execute(new ClientExecutionParams<CreateCampaignRequest, CreateCampaignResponse>()
                    .withOperationName("CreateCampaign").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCampaignRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must
     * be true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Every signal decoder has a unique name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each signal decoder is associated with a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each network interface has a unique ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * The signal decoders are specified in the model manifest.
     * </p>
     * </li>
     * </ul>
     *
     * @param createDecoderManifestRequest
     * @return Result of the CreateDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws DecoderManifestValidationException
     *         The request couldn't be completed because it contains signal decoders with one or more validation errors.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDecoderManifestResponse createDecoderManifest(CreateDecoderManifestRequest createDecoderManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, LimitExceededException,
            DecoderManifestValidationException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDecoderManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDecoderManifestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDecoderManifestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDecoderManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDecoderManifest");

            return clientHandler.execute(new ClientExecutionParams<CreateDecoderManifestRequest, CreateDecoderManifestResponse>()
                    .withOperationName("CreateDecoderManifest").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDecoderManifestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDecoderManifestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a fleet that represents a group of vehicles.
     * </p>
     * <note>
     * <p>
     * You must create both a signal catalog and vehicles before you can create a fleet.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleets.html">Fleets</a> in the <i>Amazon
     * Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, LimitExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleet");

            return clientHandler.execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                    .withOperationName("CreateFleet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createFleetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a vehicle model (model manifest) that specifies signals (attributes, branches, sensors, and actuators).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicle-models.html">Vehicle models</a> in
     * the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createModelManifestRequest
     * @return Result of the CreateModelManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateModelManifestResponse createModelManifest(CreateModelManifestRequest createModelManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, LimitExceededException,
            ThrottlingException, ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateModelManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateModelManifestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelManifestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelManifest");

            return clientHandler.execute(new ClientExecutionParams<CreateModelManifestRequest, CreateModelManifestResponse>()
                    .withOperationName("CreateModelManifest").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createModelManifestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateModelManifestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a collection of standardized signals that can be reused to create vehicle models.
     * </p>
     *
     * @param createSignalCatalogRequest
     * @return Result of the CreateSignalCatalog operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws InvalidNodeException
     *         The specified node type doesn't match the expected node type for a node. You can specify the node type as
     *         branch, sensor, actuator, or attribute.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSignalCatalogResponse createSignalCatalog(CreateSignalCatalogRequest createSignalCatalogRequest)
            throws InternalServerException, ConflictException, LimitExceededException, InvalidNodeException, ThrottlingException,
            ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSignalCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSignalCatalogResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSignalCatalogRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSignalCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSignalCatalog");

            return clientHandler.execute(new ClientExecutionParams<CreateSignalCatalogRequest, CreateSignalCatalogResponse>()
                    .withOperationName("CreateSignalCatalog").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSignalCatalogRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSignalCatalogRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a vehicle, which is an instance of a vehicle model (model manifest). Vehicles created from the same
     * vehicle model consist of the same signals inherited from the vehicle model.
     * </p>
     * <note>
     * <p>
     * If you have an existing Amazon Web Services IoT thing, you can use Amazon Web Services IoT FleetWise to create a
     * vehicle and collect data from your thing.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicle-cli.html">Create a vehicle
     * (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param createVehicleRequest
     * @return Result of the CreateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.CreateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateVehicleResponse createVehicle(CreateVehicleRequest createVehicleRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, LimitExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVehicleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateVehicleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVehicleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVehicle");

            return clientHandler.execute(new ClientExecutionParams<CreateVehicleRequest, CreateVehicleResponse>()
                    .withOperationName("CreateVehicle").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createVehicleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVehicleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a data collection campaign. Deleting a campaign suspends all data collection and removes it from any
     * vehicles.
     * </p>
     *
     * @param deleteCampaignRequest
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCampaign");

            return clientHandler.execute(new ClientExecutionParams<DeleteCampaignRequest, DeleteCampaignResponse>()
                    .withOperationName("DeleteCampaign").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCampaignRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a decoder manifest. You can't delete a decoder manifest if it has vehicles associated with it.
     * </p>
     * <note>
     * <p>
     * If the decoder manifest is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note>
     *
     * @param deleteDecoderManifestRequest
     * @return Result of the DeleteDecoderManifest operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDecoderManifestResponse deleteDecoderManifest(DeleteDecoderManifestRequest deleteDecoderManifestRequest)
            throws InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDecoderManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDecoderManifestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDecoderManifestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDecoderManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDecoderManifest");

            return clientHandler.execute(new ClientExecutionParams<DeleteDecoderManifestRequest, DeleteDecoderManifestResponse>()
                    .withOperationName("DeleteDecoderManifest").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDecoderManifestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDecoderManifestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated from the fleet. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/delete-fleet-cli.html">Delete a fleet (AWS
     * CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note>
     *
     * @param deleteFleetRequest
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleet");

            return clientHandler.execute(new ClientExecutionParams<DeleteFleetRequest, DeleteFleetResponse>()
                    .withOperationName("DeleteFleet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteFleetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * If the vehicle model is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note>
     *
     * @param deleteModelManifestRequest
     * @return Result of the DeleteModelManifest operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteModelManifestResponse deleteModelManifest(DeleteModelManifestRequest deleteModelManifestRequest)
            throws InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteModelManifestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelManifestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelManifest");

            return clientHandler.execute(new ClientExecutionParams<DeleteModelManifestRequest, DeleteModelManifestResponse>()
                    .withOperationName("DeleteModelManifest").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteModelManifestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteModelManifestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a signal catalog.
     * </p>
     * <note>
     * <p>
     * If the signal catalog is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response
     * with an empty body.
     * </p>
     * </note>
     *
     * @param deleteSignalCatalogRequest
     * @return Result of the DeleteSignalCatalog operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSignalCatalogResponse deleteSignalCatalog(DeleteSignalCatalogRequest deleteSignalCatalogRequest)
            throws InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSignalCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSignalCatalogResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSignalCatalogRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSignalCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSignalCatalog");

            return clientHandler.execute(new ClientExecutionParams<DeleteSignalCatalogRequest, DeleteSignalCatalogResponse>()
                    .withOperationName("DeleteSignalCatalog").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSignalCatalogRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSignalCatalogRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a vehicle and removes it from any campaigns.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty body.
     * </p>
     * </note>
     *
     * @param deleteVehicleRequest
     * @return Result of the DeleteVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DeleteVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DeleteVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteVehicleResponse deleteVehicle(DeleteVehicleRequest deleteVehicleRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVehicleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteVehicleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVehicleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVehicle");

            return clientHandler.execute(new ClientExecutionParams<DeleteVehicleRequest, DeleteVehicleResponse>()
                    .withOperationName("DeleteVehicle").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteVehicleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVehicleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle from a fleet doesn't delete the
     * vehicle.
     * </p>
     * <note>
     * <p>
     * If the vehicle is successfully dissociated from a fleet, Amazon Web Services IoT FleetWise sends back an HTTP 200
     * response with an empty body.
     * </p>
     * </note>
     *
     * @param disassociateVehicleFleetRequest
     * @return Result of the DisassociateVehicleFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.DisassociateVehicleFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/DisassociateVehicleFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateVehicleFleetResponse disassociateVehicleFleet(
            DisassociateVehicleFleetRequest disassociateVehicleFleetRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateVehicleFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateVehicleFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateVehicleFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateVehicleFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateVehicleFleet");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateVehicleFleetRequest, DisassociateVehicleFleetResponse>()
                            .withOperationName("DisassociateVehicleFleet").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateVehicleFleetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateVehicleFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a campaign.
     * </p>
     *
     * @param getCampaignRequest
     * @return Result of the GetCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCampaignResponse getCampaign(GetCampaignRequest getCampaignRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaign");

            return clientHandler.execute(new ClientExecutionParams<GetCampaignRequest, GetCampaignResponse>()
                    .withOperationName("GetCampaign").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getCampaignRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a created decoder manifest.
     * </p>
     *
     * @param getDecoderManifestRequest
     * @return Result of the GetDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDecoderManifestResponse getDecoderManifest(GetDecoderManifestRequest getDecoderManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDecoderManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDecoderManifestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDecoderManifestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDecoderManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDecoderManifest");

            return clientHandler.execute(new ClientExecutionParams<GetDecoderManifestRequest, GetDecoderManifestResponse>()
                    .withOperationName("GetDecoderManifest").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDecoderManifestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDecoderManifestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the encryption configuration for resources and data in Amazon Web Services IoT FleetWise.
     * </p>
     *
     * @param getEncryptionConfigurationRequest
     * @return Result of the GetEncryptionConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEncryptionConfigurationResponse getEncryptionConfiguration(
            GetEncryptionConfigurationRequest getEncryptionConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEncryptionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEncryptionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEncryptionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEncryptionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEncryptionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEncryptionConfigurationRequest, GetEncryptionConfigurationResponse>()
                            .withOperationName("GetEncryptionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getEncryptionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEncryptionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a fleet.
     * </p>
     *
     * @param getFleetRequest
     * @return Result of the GetFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFleetResponse getFleet(GetFleetRequest getFleetRequest) throws InternalServerException, ResourceNotFoundException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFleet");

            return clientHandler.execute(new ClientExecutionParams<GetFleetRequest, GetFleetResponse>()
                    .withOperationName("GetFleet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getFleetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the logging options.
     * </p>
     *
     * @param getLoggingOptionsRequest
     * @return Result of the GetLoggingOptions operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetLoggingOptionsResponse getLoggingOptions(GetLoggingOptionsRequest getLoggingOptionsRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetLoggingOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLoggingOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoggingOptions");

            return clientHandler.execute(new ClientExecutionParams<GetLoggingOptionsRequest, GetLoggingOptionsResponse>()
                    .withOperationName("GetLoggingOptions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getLoggingOptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLoggingOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a vehicle model (model manifest).
     * </p>
     *
     * @param getModelManifestRequest
     * @return Result of the GetModelManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetModelManifest" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetModelManifestResponse getModelManifest(GetModelManifestRequest getModelManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetModelManifestResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetModelManifestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getModelManifestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModelManifest");

            return clientHandler.execute(new ClientExecutionParams<GetModelManifestRequest, GetModelManifestResponse>()
                    .withOperationName("GetModelManifest").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getModelManifestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetModelManifestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status of registering your Amazon Web Services account, IAM, and Amazon
     * Timestream resources so that Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web
     * Services Cloud.
     * </p>
     * <p>
     * For more information, including step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html">Setting up Amazon Web
     * Services IoT FleetWise</a>.
     * </p>
     * <note>
     * <p>
     * This API operation doesn't require input parameters.
     * </p>
     * </note>
     *
     * @param getRegisterAccountStatusRequest
     * @return Result of the GetRegisterAccountStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetRegisterAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetRegisterAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRegisterAccountStatusResponse getRegisterAccountStatus(
            GetRegisterAccountStatusRequest getRegisterAccountStatusRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRegisterAccountStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRegisterAccountStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRegisterAccountStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRegisterAccountStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRegisterAccountStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRegisterAccountStatusRequest, GetRegisterAccountStatusResponse>()
                            .withOperationName("GetRegisterAccountStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getRegisterAccountStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRegisterAccountStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a signal catalog.
     * </p>
     *
     * @param getSignalCatalogRequest
     * @return Result of the GetSignalCatalog operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetSignalCatalog" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSignalCatalogResponse getSignalCatalog(GetSignalCatalogRequest getSignalCatalogRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSignalCatalogResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSignalCatalogResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSignalCatalogRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSignalCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSignalCatalog");

            return clientHandler.execute(new ClientExecutionParams<GetSignalCatalogRequest, GetSignalCatalogResponse>()
                    .withOperationName("GetSignalCatalog").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getSignalCatalogRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSignalCatalogRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a vehicle.
     * </p>
     *
     * @param getVehicleRequest
     * @return Result of the GetVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicle" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetVehicleResponse getVehicle(GetVehicleRequest getVehicleRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVehicleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVehicleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVehicleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVehicle");

            return clientHandler.execute(new ClientExecutionParams<GetVehicleRequest, GetVehicleResponse>()
                    .withOperationName("GetVehicle").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getVehicleRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVehicleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status of a vehicle with any associated campaigns.
     * </p>
     *
     * @param getVehicleStatusRequest
     * @return Result of the GetVehicleStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.GetVehicleStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/GetVehicleStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetVehicleStatusResponse getVehicleStatus(GetVehicleStatusRequest getVehicleStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVehicleStatusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVehicleStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVehicleStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVehicleStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVehicleStatus");

            return clientHandler.execute(new ClientExecutionParams<GetVehicleStatusRequest, GetVehicleStatusResponse>()
                    .withOperationName("GetVehicleStatus").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getVehicleStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVehicleStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a decoder manifest using your existing CAN DBC file from your local device.
     * </p>
     *
     * @param importDecoderManifestRequest
     * @return Result of the ImportDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws DecoderManifestValidationException
     *         The request couldn't be completed because it contains signal decoders with one or more validation errors.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ImportDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportDecoderManifestResponse importDecoderManifest(ImportDecoderManifestRequest importDecoderManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, DecoderManifestValidationException,
            ThrottlingException, ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportDecoderManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportDecoderManifestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importDecoderManifestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importDecoderManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportDecoderManifest");

            return clientHandler.execute(new ClientExecutionParams<ImportDecoderManifestRequest, ImportDecoderManifestResponse>()
                    .withOperationName("ImportDecoderManifest").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importDecoderManifestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportDecoderManifestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a signal catalog using your existing VSS formatted content from your local device.
     * </p>
     *
     * @param importSignalCatalogRequest
     * @return Result of the ImportSignalCatalog operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ImportSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ImportSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportSignalCatalogResponse importSignalCatalog(ImportSignalCatalogRequest importSignalCatalogRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, LimitExceededException,
            ThrottlingException, ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportSignalCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportSignalCatalogResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importSignalCatalogRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importSignalCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportSignalCatalog");

            return clientHandler.execute(new ClientExecutionParams<ImportSignalCatalogRequest, ImportSignalCatalogResponse>()
                    .withOperationName("ImportSignalCatalog").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importSignalCatalogRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportSignalCatalogRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about created campaigns.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listCampaignsRequest
     * @return Result of the ListCampaigns operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListCampaigns" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListCampaignsResponse listCampaigns(ListCampaignsRequest listCampaignsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCampaignsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCampaignsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCampaignsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCampaignsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCampaigns");

            return clientHandler.execute(new ClientExecutionParams<ListCampaignsRequest, ListCampaignsResponse>()
                    .withOperationName("ListCampaigns").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCampaignsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCampaignsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the network interfaces specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestNetworkInterfacesRequest
     * @return Result of the ListDecoderManifestNetworkInterfaces operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifestNetworkInterfaces
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDecoderManifestNetworkInterfacesResponse listDecoderManifestNetworkInterfaces(
            ListDecoderManifestNetworkInterfacesRequest listDecoderManifestNetworkInterfacesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDecoderManifestNetworkInterfacesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListDecoderManifestNetworkInterfacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDecoderManifestNetworkInterfacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDecoderManifestNetworkInterfacesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDecoderManifestNetworkInterfaces");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDecoderManifestNetworkInterfacesRequest, ListDecoderManifestNetworkInterfacesResponse>()
                            .withOperationName("ListDecoderManifestNetworkInterfaces").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listDecoderManifestNetworkInterfacesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDecoderManifestNetworkInterfacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A list of information about signal decoders specified in a decoder manifest.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestSignalsRequest
     * @return Result of the ListDecoderManifestSignals operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifestSignals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifestSignals"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDecoderManifestSignalsResponse listDecoderManifestSignals(
            ListDecoderManifestSignalsRequest listDecoderManifestSignalsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDecoderManifestSignalsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDecoderManifestSignalsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDecoderManifestSignalsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDecoderManifestSignalsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDecoderManifestSignals");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDecoderManifestSignalsRequest, ListDecoderManifestSignalsResponse>()
                            .withOperationName("ListDecoderManifestSignals").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listDecoderManifestSignalsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDecoderManifestSignalsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists decoder manifests.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listDecoderManifestsRequest
     * @return Result of the ListDecoderManifests operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListDecoderManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListDecoderManifests"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDecoderManifestsResponse listDecoderManifests(ListDecoderManifestsRequest listDecoderManifestsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDecoderManifestsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDecoderManifestsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDecoderManifestsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDecoderManifestsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDecoderManifests");

            return clientHandler.execute(new ClientExecutionParams<ListDecoderManifestsRequest, ListDecoderManifestsResponse>()
                    .withOperationName("ListDecoderManifests").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDecoderManifestsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDecoderManifestsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information for each created fleet in an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listFleetsRequest
     * @return Result of the ListFleets operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFleetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFleetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFleetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleets");

            return clientHandler.execute(new ClientExecutionParams<ListFleetsRequest, ListFleetsResponse>()
                    .withOperationName("ListFleets").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listFleetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFleetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of IDs for all fleets that the vehicle is associated with.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listFleetsForVehicleRequest
     * @return Result of the ListFleetsForVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListFleetsForVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleetsForVehicle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFleetsForVehicleResponse listFleetsForVehicle(ListFleetsForVehicleRequest listFleetsForVehicleRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFleetsForVehicleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFleetsForVehicleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFleetsForVehicleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetsForVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleetsForVehicle");

            return clientHandler.execute(new ClientExecutionParams<ListFleetsForVehicleRequest, ListFleetsForVehicleResponse>()
                    .withOperationName("ListFleetsForVehicle").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listFleetsForVehicleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFleetsForVehicleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about nodes specified in a vehicle model (model manifest).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listModelManifestNodesRequest
     * @return Result of the ListModelManifestNodes operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListModelManifestNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifestNodes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListModelManifestNodesResponse listModelManifestNodes(ListModelManifestNodesRequest listModelManifestNodesRequest)
            throws InternalServerException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListModelManifestNodesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListModelManifestNodesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listModelManifestNodesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelManifestNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelManifestNodes");

            return clientHandler
                    .execute(new ClientExecutionParams<ListModelManifestNodesRequest, ListModelManifestNodesResponse>()
                            .withOperationName("ListModelManifestNodes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listModelManifestNodesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListModelManifestNodesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of vehicle models (model manifests).
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listModelManifestsRequest
     * @return Result of the ListModelManifests operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListModelManifests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListModelManifests"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListModelManifestsResponse listModelManifests(ListModelManifestsRequest listModelManifestsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListModelManifestsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListModelManifestsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listModelManifestsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listModelManifestsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListModelManifests");

            return clientHandler.execute(new ClientExecutionParams<ListModelManifestsRequest, ListModelManifestsResponse>()
                    .withOperationName("ListModelManifests").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listModelManifestsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListModelManifestsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists of information about the signals (nodes) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listSignalCatalogNodesRequest
     * @return Result of the ListSignalCatalogNodes operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListSignalCatalogNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogNodes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSignalCatalogNodesResponse listSignalCatalogNodes(ListSignalCatalogNodesRequest listSignalCatalogNodesRequest)
            throws InternalServerException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSignalCatalogNodesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSignalCatalogNodesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSignalCatalogNodesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSignalCatalogNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSignalCatalogNodes");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSignalCatalogNodesRequest, ListSignalCatalogNodesResponse>()
                            .withOperationName("ListSignalCatalogNodes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listSignalCatalogNodesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSignalCatalogNodesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the created signal catalogs in an Amazon Web Services account.
     * </p>
     * <p>
     * You can use to list information about each signal (node) specified in a signal catalog.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listSignalCatalogsRequest
     * @return Result of the ListSignalCatalogs operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListSignalCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListSignalCatalogs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSignalCatalogsResponse listSignalCatalogs(ListSignalCatalogsRequest listSignalCatalogsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSignalCatalogsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSignalCatalogsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSignalCatalogsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSignalCatalogsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSignalCatalogs");

            return clientHandler.execute(new ClientExecutionParams<ListSignalCatalogsRequest, ListSignalCatalogsResponse>()
                    .withOperationName("ListSignalCatalogs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSignalCatalogsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSignalCatalogsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of summaries of created vehicles.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listVehiclesRequest
     * @return Result of the ListVehicles operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListVehicles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehicles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListVehiclesResponse listVehicles(ListVehiclesRequest listVehiclesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVehiclesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListVehiclesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVehiclesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVehiclesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVehicles");

            return clientHandler.execute(new ClientExecutionParams<ListVehiclesRequest, ListVehiclesResponse>()
                    .withOperationName("ListVehicles").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listVehiclesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListVehiclesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of summaries of all vehicles associated with a fleet.
     * </p>
     * <note>
     * <p>
     * This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more
     * results.
     * </p>
     * </note>
     *
     * @param listVehiclesInFleetRequest
     * @return Result of the ListVehiclesInFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.ListVehiclesInFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListVehiclesInFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListVehiclesInFleetResponse listVehiclesInFleet(ListVehiclesInFleetRequest listVehiclesInFleetRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVehiclesInFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListVehiclesInFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVehiclesInFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVehiclesInFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVehiclesInFleet");

            return clientHandler.execute(new ClientExecutionParams<ListVehiclesInFleetRequest, ListVehiclesInFleetResponse>()
                    .withOperationName("ListVehiclesInFleet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listVehiclesInFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListVehiclesInFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates the encryption configuration. Amazon Web Services IoT FleetWise can encrypt your data and
     * resources using an Amazon Web Services managed key. Or, you can use a KMS key that you own and manage. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/data-encryption.html">Data encryption</a>
     * in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     *
     * @param putEncryptionConfigurationRequest
     * @return Result of the PutEncryptionConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.PutEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutEncryptionConfigurationResponse putEncryptionConfiguration(
            PutEncryptionConfigurationRequest putEncryptionConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutEncryptionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutEncryptionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEncryptionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEncryptionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEncryptionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<PutEncryptionConfigurationRequest, PutEncryptionConfigurationResponse>()
                            .withOperationName("PutEncryptionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putEncryptionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutEncryptionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates the logging option.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return Result of the PutLoggingOptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/PutLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutLoggingOptionsResponse putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutLoggingOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putLoggingOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putLoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutLoggingOptions");

            return clientHandler.execute(new ClientExecutionParams<PutLoggingOptionsRequest, PutLoggingOptionsResponse>()
                    .withOperationName("PutLoggingOptions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putLoggingOptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutLoggingOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <important>
     * <p>
     * This API operation contains deprecated parameters. Register your account again without the Timestream resources
     * parameter so that Amazon Web Services IoT FleetWise can remove the Timestream metadata stored. You should then
     * pass the data destination into the <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_CreateCampaign.html">CreateCampaign</a>
     * API operation.
     * </p>
     * <p>
     * You must delete any existing campaigns that include an empty data destination before you register your account
     * again. For more information, see the <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_DeleteCampaign.html">DeleteCampaign</a>
     * API operation.
     * </p>
     * <p>
     * If you want to delete the Timestream inline policy from the service-linked role, such as to mitigate an overly
     * permissive policy, you must first delete any existing campaigns. Then delete the service-linked role and register
     * your account again to enable CloudWatch metrics. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html"
     * >DeleteServiceLinkedRole</a> in the <i>Identity and Access Management API Reference</i>.
     * </p>
     * </important>
     * 
     * <pre>
     * <code> &lt;p&gt;Registers your Amazon Web Services account, IAM, and Amazon Timestream resources so Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud. For more information, including step-by-step procedures, see &lt;a href=&quot;https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html&quot;&gt;Setting up Amazon Web Services IoT FleetWise&lt;/a&gt;. &lt;/p&gt; &lt;note&gt; &lt;p&gt;An Amazon Web Services account is &lt;b&gt;not&lt;/b&gt; the same thing as a &quot;user.&quot; An &lt;a href=&quot;https://docs.aws.amazon.com/IAM/latest/UserGuide/introduction_identity-management.html#intro-identity-users&quot;&gt;Amazon Web Services user&lt;/a&gt; is an identity that you create using Identity and Access Management (IAM) and takes the form of either an &lt;a href=&quot;https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html&quot;&gt;IAM user&lt;/a&gt; or an &lt;a href=&quot;https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html&quot;&gt;IAM role, both with credentials&lt;/a&gt;. A single Amazon Web Services account can, and typically does, contain many users and roles.&lt;/p&gt; &lt;/note&gt; </code>
     * </pre>
     *
     * @param registerAccountRequest
     * @return Result of the RegisterAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.RegisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/RegisterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RegisterAccountResponse registerAccount(RegisterAccountRequest registerAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RegisterAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterAccount");

            return clientHandler.execute(new ClientExecutionParams<RegisterAccountRequest, RegisterAccountResponse>()
                    .withOperationName("RegisterAccount").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(registerAccountRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RegisterAccountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a campaign.
     * </p>
     *
     * @param updateCampaignRequest
     * @return Result of the UpdateCampaign operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateCampaignResponse updateCampaign(UpdateCampaignRequest updateCampaignRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaign");

            return clientHandler.execute(new ClientExecutionParams<UpdateCampaignRequest, UpdateCampaignResponse>()
                    .withOperationName("UpdateCampaign").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateCampaignRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a decoder manifest.
     * </p>
     * <p>
     * A decoder manifest can only be updated when the status is <code>DRAFT</code>. Only <code>ACTIVE</code> decoder
     * manifests can be associated with vehicles.
     * </p>
     *
     * @param updateDecoderManifestRequest
     * @return Result of the UpdateDecoderManifest operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws DecoderManifestValidationException
     *         The request couldn't be completed because it contains signal decoders with one or more validation errors.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateDecoderManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateDecoderManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDecoderManifestResponse updateDecoderManifest(UpdateDecoderManifestRequest updateDecoderManifestRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, LimitExceededException,
            DecoderManifestValidationException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDecoderManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDecoderManifestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDecoderManifestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDecoderManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDecoderManifest");

            return clientHandler.execute(new ClientExecutionParams<UpdateDecoderManifestRequest, UpdateDecoderManifestResponse>()
                    .withOperationName("UpdateDecoderManifest").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDecoderManifestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDecoderManifestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the description of an existing fleet.
     * </p>
     * <note>
     * <p>
     * If the fleet is successfully updated, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an
     * empty HTTP body.
     * </p>
     * </note>
     *
     * @param updateFleetRequest
     * @return Result of the UpdateFleet operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFleetResponse updateFleet(UpdateFleetRequest updateFleetRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFleet");

            return clientHandler.execute(new ClientExecutionParams<UpdateFleetRequest, UpdateFleetResponse>()
                    .withOperationName("UpdateFleet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateFleetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a vehicle model (model manifest). If created vehicles are associated with a vehicle model, it can't be
     * updated.
     * </p>
     *
     * @param updateModelManifestRequest
     * @return Result of the UpdateModelManifest operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateModelManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateModelManifest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateModelManifestResponse updateModelManifest(UpdateModelManifestRequest updateModelManifestRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, InvalidSignalsException, AccessDeniedException, AwsServiceException, SdkClientException,
            IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateModelManifestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateModelManifestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateModelManifestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelManifestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModelManifest");

            return clientHandler.execute(new ClientExecutionParams<UpdateModelManifestRequest, UpdateModelManifestResponse>()
                    .withOperationName("UpdateModelManifest").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateModelManifestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateModelManifestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a signal catalog.
     * </p>
     *
     * @param updateSignalCatalogRequest
     * @return Result of the UpdateSignalCatalog operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         A service quota was exceeded.
     * @throws InvalidNodeException
     *         The specified node type doesn't match the expected node type for a node. You can specify the node type as
     *         branch, sensor, actuator, or attribute.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InvalidSignalsException
     *         The request couldn't be completed because it contains signals that aren't valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateSignalCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateSignalCatalog"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateSignalCatalogResponse updateSignalCatalog(UpdateSignalCatalogRequest updateSignalCatalogRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, LimitExceededException,
            InvalidNodeException, ThrottlingException, ValidationException, InvalidSignalsException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSignalCatalogResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSignalCatalogResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSignalCatalogRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSignalCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSignalCatalog");

            return clientHandler.execute(new ClientExecutionParams<UpdateSignalCatalogRequest, UpdateSignalCatalogResponse>()
                    .withOperationName("UpdateSignalCatalog").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateSignalCatalogRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSignalCatalogRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a vehicle.
     * </p>
     *
     * @param updateVehicleRequest
     * @return Result of the UpdateVehicle operation returned by the service.
     * @throws InternalServerException
     *         The request couldn't be completed because the server temporarily failed.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ConflictException
     *         The request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ThrottlingException
     *         The request couldn't be completed due to throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTFleetWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTFleetWiseClient.UpdateVehicle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateVehicle" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateVehicleResponse updateVehicle(UpdateVehicleRequest updateVehicleRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, IoTFleetWiseException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVehicleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateVehicleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVehicleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVehicleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTFleetWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVehicle");

            return clientHandler.execute(new ClientExecutionParams<UpdateVehicleRequest, UpdateVehicleResponse>()
                    .withOperationName("UpdateVehicle").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateVehicleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateVehicleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        IoTFleetWiseServiceClientConfigurationBuilder serviceConfigBuilder = new IoTFleetWiseServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IoTFleetWiseException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DecoderManifestValidationException")
                                .exceptionBuilderSupplier(DecoderManifestValidationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSignalsException")
                                .exceptionBuilderSupplier(InvalidSignalsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNodeException")
                                .exceptionBuilderSupplier(InvalidNodeException::builder).httpStatusCode(400).build());
    }

    @Override
    public final IoTFleetWiseServiceClientConfiguration serviceClientConfiguration() {
        return new IoTFleetWiseServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
