/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ModelManifestSummary;

public class ListModelManifestsIterable
implements SdkIterable<ListModelManifestsResponse> {
    private final IoTFleetWiseClient client;
    private final ListModelManifestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelManifestsIterable(IoTFleetWiseClient client, ListModelManifestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListModelManifestsResponseFetcher();
    }

    public Iterator<ListModelManifestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelManifestSummary> summaries() {
        Function<ListModelManifestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelManifestsResponseFetcher
    implements SyncPageFetcher<ListModelManifestsResponse> {
        private ListModelManifestsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelManifestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelManifestsResponse nextPage(ListModelManifestsResponse previousPage) {
            if (previousPage == null) {
                return ListModelManifestsIterable.this.client.listModelManifests(ListModelManifestsIterable.this.firstRequest);
            }
            return ListModelManifestsIterable.this.client.listModelManifests((ListModelManifestsRequest)((Object)ListModelManifestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

