/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.Node;

public class ListModelManifestNodesIterable
implements SdkIterable<ListModelManifestNodesResponse> {
    private final IoTFleetWiseClient client;
    private final ListModelManifestNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelManifestNodesIterable(IoTFleetWiseClient client, ListModelManifestNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListModelManifestNodesResponseFetcher();
    }

    public Iterator<ListModelManifestNodesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Node> nodes() {
        Function<ListModelManifestNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodes() != null) {
                return response.nodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelManifestNodesResponseFetcher
    implements SyncPageFetcher<ListModelManifestNodesResponse> {
        private ListModelManifestNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListModelManifestNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelManifestNodesResponse nextPage(ListModelManifestNodesResponse previousPage) {
            if (previousPage == null) {
                return ListModelManifestNodesIterable.this.client.listModelManifestNodes(ListModelManifestNodesIterable.this.firstRequest);
            }
            return ListModelManifestNodesIterable.this.client.listModelManifestNodes((ListModelManifestNodesRequest)((Object)ListModelManifestNodesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

