/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.model.CampaignSummary;
import software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsResponse;

public class ListCampaignsPublisher
implements SdkPublisher<ListCampaignsResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListCampaignsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCampaignsPublisher(IoTFleetWiseAsyncClient client, ListCampaignsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCampaignsPublisher(IoTFleetWiseAsyncClient client, ListCampaignsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCampaignsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCampaignsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CampaignSummary> campaignSummaries() {
        Function<ListCampaignsResponse, Iterator> getIterator = response -> {
            if (response != null && response.campaignSummaries() != null) {
                return response.campaignSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCampaignsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCampaignsResponseFetcher
    implements AsyncPageFetcher<ListCampaignsResponse> {
        private ListCampaignsResponseFetcher() {
        }

        public boolean hasNextPage(ListCampaignsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCampaignsResponse> nextPage(ListCampaignsResponse previousPage) {
            if (previousPage == null) {
                return ListCampaignsPublisher.this.client.listCampaigns(ListCampaignsPublisher.this.firstRequest);
            }
            return ListCampaignsPublisher.this.client.listCampaigns((ListCampaignsRequest)((Object)ListCampaignsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

