/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleethub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleethub.IoTFleetHubAsyncClient;
import software.amazon.awssdk.services.iotfleethub.model.ApplicationSummary;
import software.amazon.awssdk.services.iotfleethub.model.ListApplicationsRequest;
import software.amazon.awssdk.services.iotfleethub.model.ListApplicationsResponse;

public class ListApplicationsPublisher
implements SdkPublisher<ListApplicationsResponse> {
    private final IoTFleetHubAsyncClient client;
    private final ListApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationsPublisher(IoTFleetHubAsyncClient client, ListApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationsPublisher(IoTFleetHubAsyncClient client, ListApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApplicationSummary> applicationSummaries() {
        Function<ListApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationSummaries() != null) {
                return response.applicationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApplicationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationsResponseFetcher
    implements AsyncPageFetcher<ListApplicationsResponse> {
        private ListApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationsResponse> nextPage(ListApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationsPublisher.this.client.listApplications(ListApplicationsPublisher.this.firstRequest);
            }
            return ListApplicationsPublisher.this.client.listApplications((ListApplicationsRequest)((Object)ListApplicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

