/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information of SMS notifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SMSConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SMSConfiguration.Builder, SMSConfiguration> {
    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("senderId").getter(getter(SMSConfiguration::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderId").build()).build();

    private static final SdkField<String> ADDITIONAL_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("additionalMessage").getter(getter(SMSConfiguration::additionalMessage))
            .setter(setter(Builder::additionalMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMessage").build()).build();

    private static final SdkField<List<RecipientDetail>> RECIPIENTS_FIELD = SdkField
            .<List<RecipientDetail>> builder(MarshallingType.LIST)
            .memberName("recipients")
            .getter(getter(SMSConfiguration::recipients))
            .setter(setter(Builder::recipients))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipients").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecipientDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecipientDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENDER_ID_FIELD,
            ADDITIONAL_MESSAGE_FIELD, RECIPIENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String senderId;

    private final String additionalMessage;

    private final List<RecipientDetail> recipients;

    private SMSConfiguration(BuilderImpl builder) {
        this.senderId = builder.senderId;
        this.additionalMessage = builder.additionalMessage;
        this.recipients = builder.recipients;
    }

    /**
     * <p>
     * The sender ID.
     * </p>
     * 
     * @return The sender ID.
     */
    public final String senderId() {
        return senderId;
    }

    /**
     * <p>
     * The message that you want to send. The message can be up to 200 characters.
     * </p>
     * 
     * @return The message that you want to send. The message can be up to 200 characters.
     */
    public final String additionalMessage() {
        return additionalMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Recipients property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecipients() {
        return recipients != null && !(recipients instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies one or more recipients who receive the message.
     * </p>
     * <important>
     * <p>
     * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
     * receive SMS messages to your AWS SSO store</a>.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecipients} method.
     * </p>
     * 
     * @return Specifies one or more recipients who receive the message.</p> <important>
     *         <p>
     *         You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users
     *         that receive SMS messages to your AWS SSO store</a>.
     *         </p>
     */
    public final List<RecipientDetail> recipients() {
        return recipients;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        hashCode = 31 * hashCode + Objects.hashCode(additionalMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecipients() ? recipients() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSConfiguration)) {
            return false;
        }
        SMSConfiguration other = (SMSConfiguration) obj;
        return Objects.equals(senderId(), other.senderId()) && Objects.equals(additionalMessage(), other.additionalMessage())
                && hasRecipients() == other.hasRecipients() && Objects.equals(recipients(), other.recipients());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SMSConfiguration").add("SenderId", senderId()).add("AdditionalMessage", additionalMessage())
                .add("Recipients", hasRecipients() ? recipients() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "senderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        case "additionalMessage":
            return Optional.ofNullable(clazz.cast(additionalMessage()));
        case "recipients":
            return Optional.ofNullable(clazz.cast(recipients()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SMSConfiguration, T> g) {
        return obj -> g.apply((SMSConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SMSConfiguration> {
        /**
         * <p>
         * The sender ID.
         * </p>
         * 
         * @param senderId
         *        The sender ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);

        /**
         * <p>
         * The message that you want to send. The message can be up to 200 characters.
         * </p>
         * 
         * @param additionalMessage
         *        The message that you want to send. The message can be up to 200 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMessage(String additionalMessage);

        /**
         * <p>
         * Specifies one or more recipients who receive the message.
         * </p>
         * <important>
         * <p>
         * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
         * receive SMS messages to your AWS SSO store</a>.
         * </p>
         * </important>
         * 
         * @param recipients
         *        Specifies one or more recipients who receive the message.</p> <important>
         *        <p>
         *        You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the
         *        users that receive SMS messages to your AWS SSO store</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipients(Collection<RecipientDetail> recipients);

        /**
         * <p>
         * Specifies one or more recipients who receive the message.
         * </p>
         * <important>
         * <p>
         * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
         * receive SMS messages to your AWS SSO store</a>.
         * </p>
         * </important>
         * 
         * @param recipients
         *        Specifies one or more recipients who receive the message.</p> <important>
         *        <p>
         *        You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the
         *        users that receive SMS messages to your AWS SSO store</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipients(RecipientDetail... recipients);

        /**
         * <p>
         * Specifies one or more recipients who receive the message.
         * </p>
         * <important>
         * <p>
         * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
         * receive SMS messages to your AWS SSO store</a>.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotevents.model.RecipientDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotevents.model.RecipientDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotevents.model.RecipientDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #recipients(List<RecipientDetail>)}.
         * 
         * @param recipients
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotevents.model.RecipientDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recipients(java.util.Collection<RecipientDetail>)
         */
        Builder recipients(Consumer<RecipientDetail.Builder>... recipients);
    }

    static final class BuilderImpl implements Builder {
        private String senderId;

        private String additionalMessage;

        private List<RecipientDetail> recipients = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SMSConfiguration model) {
            senderId(model.senderId);
            additionalMessage(model.additionalMessage);
            recipients(model.recipients);
        }

        public final String getSenderId() {
            return senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final String getAdditionalMessage() {
            return additionalMessage;
        }

        public final void setAdditionalMessage(String additionalMessage) {
            this.additionalMessage = additionalMessage;
        }

        @Override
        public final Builder additionalMessage(String additionalMessage) {
            this.additionalMessage = additionalMessage;
            return this;
        }

        public final List<RecipientDetail.Builder> getRecipients() {
            List<RecipientDetail.Builder> result = RecipientDetailsCopier.copyToBuilder(this.recipients);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecipients(Collection<RecipientDetail.BuilderImpl> recipients) {
            this.recipients = RecipientDetailsCopier.copyFromBuilder(recipients);
        }

        @Override
        public final Builder recipients(Collection<RecipientDetail> recipients) {
            this.recipients = RecipientDetailsCopier.copy(recipients);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipients(RecipientDetail... recipients) {
            recipients(Arrays.asList(recipients));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipients(Consumer<RecipientDetail.Builder>... recipients) {
            recipients(Stream.of(recipients).map(c -> RecipientDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SMSConfiguration build() {
            return new SMSConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
