/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputStatus {
    CREATING("CREATING"),
    UPDATING("UPDATING"),
    ACTIVE("ACTIVE"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputStatus> VALUE_MAP;
    private final String value;

    private InputStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputStatus> knownValues() {
        EnumSet<InputStatus> knownValues = EnumSet.allOf(InputStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputStatus.class, InputStatus::toString);
    }
}

