/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSuiteDefinitionResponse extends IotDeviceAdvisorResponse implements
        ToCopyableBuilder<CreateSuiteDefinitionResponse.Builder, CreateSuiteDefinitionResponse> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionId").getter(getter(CreateSuiteDefinitionResponse::suiteDefinitionId))
            .setter(setter(Builder::suiteDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionId").build()).build();

    private static final SdkField<String> SUITE_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionArn").getter(getter(CreateSuiteDefinitionResponse::suiteDefinitionArn))
            .setter(setter(Builder::suiteDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionArn").build())
            .build();

    private static final SdkField<String> SUITE_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionName").getter(getter(CreateSuiteDefinitionResponse::suiteDefinitionName))
            .setter(setter(Builder::suiteDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionName").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateSuiteDefinitionResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD,
            SUITE_DEFINITION_ARN_FIELD, SUITE_DEFINITION_NAME_FIELD, CREATED_AT_FIELD));

    private final String suiteDefinitionId;

    private final String suiteDefinitionArn;

    private final String suiteDefinitionName;

    private final Instant createdAt;

    private CreateSuiteDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionArn = builder.suiteDefinitionArn;
        this.suiteDefinitionName = builder.suiteDefinitionName;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The UUID of the test suite created.
     * </p>
     * 
     * @return The UUID of the test suite created.
     */
    public final String suiteDefinitionId() {
        return suiteDefinitionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the test suite.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the test suite.
     */
    public final String suiteDefinitionArn() {
        return suiteDefinitionArn;
    }

    /**
     * <p>
     * The suite definition name of the test suite. This is a required parameter.
     * </p>
     * 
     * @return The suite definition name of the test suite. This is a required parameter.
     */
    public final String suiteDefinitionName() {
        return suiteDefinitionName;
    }

    /**
     * <p>
     * The timestamp of when the test suite was created.
     * </p>
     * 
     * @return The timestamp of when the test suite was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSuiteDefinitionResponse)) {
            return false;
        }
        CreateSuiteDefinitionResponse other = (CreateSuiteDefinitionResponse) obj;
        return Objects.equals(suiteDefinitionId(), other.suiteDefinitionId())
                && Objects.equals(suiteDefinitionArn(), other.suiteDefinitionArn())
                && Objects.equals(suiteDefinitionName(), other.suiteDefinitionName())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSuiteDefinitionResponse").add("SuiteDefinitionId", suiteDefinitionId())
                .add("SuiteDefinitionArn", suiteDefinitionArn()).add("SuiteDefinitionName", suiteDefinitionName())
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionId":
            return Optional.ofNullable(clazz.cast(suiteDefinitionId()));
        case "suiteDefinitionArn":
            return Optional.ofNullable(clazz.cast(suiteDefinitionArn()));
        case "suiteDefinitionName":
            return Optional.ofNullable(clazz.cast(suiteDefinitionName()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSuiteDefinitionResponse, T> g) {
        return obj -> g.apply((CreateSuiteDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSuiteDefinitionResponse> {
        /**
         * <p>
         * The UUID of the test suite created.
         * </p>
         * 
         * @param suiteDefinitionId
         *        The UUID of the test suite created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionId(String suiteDefinitionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the test suite.
         * </p>
         * 
         * @param suiteDefinitionArn
         *        The Amazon Resource Name (ARN) of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionArn(String suiteDefinitionArn);

        /**
         * <p>
         * The suite definition name of the test suite. This is a required parameter.
         * </p>
         * 
         * @param suiteDefinitionName
         *        The suite definition name of the test suite. This is a required parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionName(String suiteDefinitionName);

        /**
         * <p>
         * The timestamp of when the test suite was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the test suite was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends IotDeviceAdvisorResponse.BuilderImpl implements Builder {
        private String suiteDefinitionId;

        private String suiteDefinitionArn;

        private String suiteDefinitionName;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSuiteDefinitionResponse model) {
            super(model);
            suiteDefinitionId(model.suiteDefinitionId);
            suiteDefinitionArn(model.suiteDefinitionArn);
            suiteDefinitionName(model.suiteDefinitionName);
            createdAt(model.createdAt);
        }

        public final String getSuiteDefinitionId() {
            return suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionArn() {
            return suiteDefinitionArn;
        }

        public final void setSuiteDefinitionArn(String suiteDefinitionArn) {
            this.suiteDefinitionArn = suiteDefinitionArn;
        }

        @Override
        public final Builder suiteDefinitionArn(String suiteDefinitionArn) {
            this.suiteDefinitionArn = suiteDefinitionArn;
            return this;
        }

        public final String getSuiteDefinitionName() {
            return suiteDefinitionName;
        }

        public final void setSuiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
        }

        @Override
        public final Builder suiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public CreateSuiteDefinitionResponse build() {
            return new CreateSuiteDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
