/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ConflictException;
import software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.DeleteSuiteDefinitionResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunReportRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunReportResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.InternalServerException;
import software.amazon.awssdk.services.iotdeviceadvisor.model.IotDeviceAdvisorException;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.StopSuiteRunRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.StopSuiteRunResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TagResourceRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TagResourceResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ValidationException;
import software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsIterable;
import software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsIterable;

/**
 * Service client for accessing AWSIoTDeviceAdvisor. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services IoT Core Device Advisor is a cloud-based, fully managed test capability for validating IoT
 * devices during device software development. Device Advisor provides pre-built tests that you can use to validate IoT
 * devices for reliable and secure connectivity with Amazon Web Services IoT Core before deploying devices to
 * production. By using Device Advisor, you can confirm that your devices can connect to Amazon Web Services IoT Core,
 * follow security best practices and, if applicable, receive software updates from IoT Device Management. You can also
 * download signed qualification reports to submit to the Amazon Web Services Partner Network to get your device
 * qualified for the Amazon Web Services Partner Device Catalog without the need to send your device in and wait for it
 * to be tested.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotDeviceAdvisorClient extends AwsClient {
    String SERVICE_NAME = "iotdeviceadvisor";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.iotdeviceadvisor";

    /**
     * <p>
     * Creates a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateSuiteDefinition</a> action.
     * </p>
     *
     * @param createSuiteDefinitionRequest
     * @return Result of the CreateSuiteDefinition operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.CreateSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/CreateSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSuiteDefinitionResponse createSuiteDefinition(CreateSuiteDefinitionRequest createSuiteDefinitionRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateSuiteDefinition</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSuiteDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSuiteDefinitionRequest#builder()}
     * </p>
     *
     * @param createSuiteDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSuiteDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSuiteDefinition operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.CreateSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/CreateSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSuiteDefinitionResponse createSuiteDefinition(
            Consumer<CreateSuiteDefinitionRequest.Builder> createSuiteDefinitionRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, IotDeviceAdvisorException {
        return createSuiteDefinition(CreateSuiteDefinitionRequest.builder().applyMutation(createSuiteDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteSuiteDefinition</a> action.
     * </p>
     *
     * @param deleteSuiteDefinitionRequest
     * @return Result of the DeleteSuiteDefinition operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.DeleteSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/DeleteSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSuiteDefinitionResponse deleteSuiteDefinition(DeleteSuiteDefinitionRequest deleteSuiteDefinitionRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteSuiteDefinition</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSuiteDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSuiteDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteSuiteDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSuiteDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSuiteDefinition operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.DeleteSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/DeleteSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSuiteDefinitionResponse deleteSuiteDefinition(
            Consumer<DeleteSuiteDefinitionRequest.Builder> deleteSuiteDefinitionRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, IotDeviceAdvisorException {
        return deleteSuiteDefinition(DeleteSuiteDefinitionRequest.builder().applyMutation(deleteSuiteDefinitionRequest).build());
    }

    /**
     * <p>
     * Gets information about an Device Advisor endpoint.
     * </p>
     *
     * @param getEndpointRequest
     * @return Result of the GetEndpoint operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.GetEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEndpointResponse getEndpoint(GetEndpointRequest getEndpointRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an Device Advisor endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link GetEndpointRequest#builder()}
     * </p>
     *
     * @param getEndpointRequest
     *        A {@link Consumer} that will call methods on {@link GetEndpointRequest.Builder} to create a request.
     * @return Result of the GetEndpoint operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.GetEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEndpointResponse getEndpoint(Consumer<GetEndpointRequest.Builder> getEndpointRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        return getEndpoint(GetEndpointRequest.builder().applyMutation(getEndpointRequest).build());
    }

    /**
     * <p>
     * Gets information about a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteDefinition</a> action.
     * </p>
     *
     * @param getSuiteDefinitionRequest
     * @return Result of the GetSuiteDefinition operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.GetSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSuiteDefinitionResponse getSuiteDefinition(GetSuiteDefinitionRequest getSuiteDefinitionRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteDefinition</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSuiteDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetSuiteDefinitionRequest#builder()}
     * </p>
     *
     * @param getSuiteDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetSuiteDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the GetSuiteDefinition operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.GetSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSuiteDefinitionResponse getSuiteDefinition(Consumer<GetSuiteDefinitionRequest.Builder> getSuiteDefinitionRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotDeviceAdvisorException {
        return getSuiteDefinition(GetSuiteDefinitionRequest.builder().applyMutation(getSuiteDefinitionRequest).build());
    }

    /**
     * <p>
     * Gets information about a Device Advisor test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteRun</a> action.
     * </p>
     *
     * @param getSuiteRunRequest
     * @return Result of the GetSuiteRun operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.GetSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRun" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSuiteRunResponse getSuiteRun(GetSuiteRunRequest getSuiteRunRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Device Advisor test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteRun</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSuiteRunRequest.Builder} avoiding the need to
     * create one manually via {@link GetSuiteRunRequest#builder()}
     * </p>
     *
     * @param getSuiteRunRequest
     *        A {@link Consumer} that will call methods on {@link GetSuiteRunRequest.Builder} to create a request.
     * @return Result of the GetSuiteRun operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.GetSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRun" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSuiteRunResponse getSuiteRun(Consumer<GetSuiteRunRequest.Builder> getSuiteRunRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        return getSuiteRun(GetSuiteRunRequest.builder().applyMutation(getSuiteRunRequest).build());
    }

    /**
     * <p>
     * Gets a report download link for a successful Device Advisor qualifying test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteRunReport</a> action.
     * </p>
     *
     * @param getSuiteRunReportRequest
     * @return Result of the GetSuiteRunReport operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.GetSuiteRunReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRunReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSuiteRunReportResponse getSuiteRunReport(GetSuiteRunReportRequest getSuiteRunReportRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a report download link for a successful Device Advisor qualifying test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetSuiteRunReport</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSuiteRunReportRequest.Builder} avoiding the need
     * to create one manually via {@link GetSuiteRunReportRequest#builder()}
     * </p>
     *
     * @param getSuiteRunReportRequest
     *        A {@link Consumer} that will call methods on {@link GetSuiteRunReportRequest.Builder} to create a request.
     * @return Result of the GetSuiteRunReport operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.GetSuiteRunReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRunReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSuiteRunReportResponse getSuiteRunReport(Consumer<GetSuiteRunReportRequest.Builder> getSuiteRunReportRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotDeviceAdvisorException {
        return getSuiteRunReport(GetSuiteRunReportRequest.builder().applyMutation(getSuiteRunReportRequest).build());
    }

    /**
     * <p>
     * Lists the Device Advisor test suites you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteDefinitions</a> action.
     * </p>
     *
     * @param listSuiteDefinitionsRequest
     * @return Result of the ListSuiteDefinitions operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.ListSuiteDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteDefinitionsResponse listSuiteDefinitions(ListSuiteDefinitionsRequest listSuiteDefinitionsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Device Advisor test suites you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteDefinitions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuiteDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSuiteDefinitionsRequest#builder()}
     * </p>
     *
     * @param listSuiteDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSuiteDefinitionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSuiteDefinitions operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.ListSuiteDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteDefinitionsResponse listSuiteDefinitions(
            Consumer<ListSuiteDefinitionsRequest.Builder> listSuiteDefinitionsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, IotDeviceAdvisorException {
        return listSuiteDefinitions(ListSuiteDefinitionsRequest.builder().applyMutation(listSuiteDefinitionsRequest).build());
    }

    /**
     * <p>
     * Lists the Device Advisor test suites you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteDefinitions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSuiteDefinitions(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsIterable responses = client.listSuiteDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsIterable responses = client
     *             .listSuiteDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsIterable responses = client.listSuiteDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuiteDefinitions(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSuiteDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.ListSuiteDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteDefinitionsIterable listSuiteDefinitionsPaginator(ListSuiteDefinitionsRequest listSuiteDefinitionsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        return new ListSuiteDefinitionsIterable(this, listSuiteDefinitionsRequest);
    }

    /**
     * <p>
     * Lists the Device Advisor test suites you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteDefinitions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSuiteDefinitions(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsIterable responses = client.listSuiteDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsIterable responses = client
     *             .listSuiteDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteDefinitionsIterable responses = client.listSuiteDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuiteDefinitions(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuiteDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSuiteDefinitionsRequest#builder()}
     * </p>
     *
     * @param listSuiteDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSuiteDefinitionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.ListSuiteDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteDefinitionsIterable listSuiteDefinitionsPaginator(
            Consumer<ListSuiteDefinitionsRequest.Builder> listSuiteDefinitionsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, IotDeviceAdvisorException {
        return listSuiteDefinitionsPaginator(ListSuiteDefinitionsRequest.builder().applyMutation(listSuiteDefinitionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a
     * specific version of the test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteRuns</a> action.
     * </p>
     *
     * @param listSuiteRunsRequest
     * @return Result of the ListSuiteRuns operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.ListSuiteRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteRunsResponse listSuiteRuns(ListSuiteRunsRequest listSuiteRunsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a
     * specific version of the test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteRuns</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuiteRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSuiteRunsRequest#builder()}
     * </p>
     *
     * @param listSuiteRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListSuiteRunsRequest.Builder} to create a request.
     * @return Result of the ListSuiteRuns operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.ListSuiteRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteRunsResponse listSuiteRuns(Consumer<ListSuiteRunsRequest.Builder> listSuiteRunsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        return listSuiteRuns(ListSuiteRunsRequest.builder().applyMutation(listSuiteRunsRequest).build());
    }

    /**
     * <p>
     * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a
     * specific version of the test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteRuns</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSuiteRuns(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsIterable responses = client.listSuiteRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsIterable responses = client
     *             .listSuiteRunsPaginator(request);
     *     for (software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsIterable responses = client.listSuiteRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuiteRuns(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSuiteRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.ListSuiteRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteRunsIterable listSuiteRunsPaginator(ListSuiteRunsRequest listSuiteRunsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, IotDeviceAdvisorException {
        return new ListSuiteRunsIterable(this, listSuiteRunsRequest);
    }

    /**
     * <p>
     * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a
     * specific version of the test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSuiteRuns</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSuiteRuns(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsIterable responses = client.listSuiteRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsIterable responses = client
     *             .listSuiteRunsPaginator(request);
     *     for (software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotdeviceadvisor.paginators.ListSuiteRunsIterable responses = client.listSuiteRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuiteRuns(software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuiteRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSuiteRunsRequest#builder()}
     * </p>
     *
     * @param listSuiteRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListSuiteRunsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.ListSuiteRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuiteRunsIterable listSuiteRunsPaginator(Consumer<ListSuiteRunsRequest.Builder> listSuiteRunsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        return listSuiteRunsPaginator(ListSuiteRunsRequest.builder().applyMutation(listSuiteRunsRequest).build());
    }

    /**
     * <p>
     * Lists the tags attached to an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTagsForResource</a> action.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags attached to an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTagsForResource</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotDeviceAdvisorException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts a Device Advisor test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StartSuiteRun</a> action.
     * </p>
     *
     * @param startSuiteRunRequest
     * @return Result of the StartSuiteRun operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ConflictException
     *         Sends a Conflict Exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.StartSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StartSuiteRun"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSuiteRunResponse startSuiteRun(StartSuiteRunRequest startSuiteRunRequest) throws ValidationException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a Device Advisor test suite run.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StartSuiteRun</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSuiteRunRequest.Builder} avoiding the need to
     * create one manually via {@link StartSuiteRunRequest#builder()}
     * </p>
     *
     * @param startSuiteRunRequest
     *        A {@link Consumer} that will call methods on {@link StartSuiteRunRequest.Builder} to create a request.
     * @return Result of the StartSuiteRun operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ConflictException
     *         Sends a Conflict Exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.StartSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StartSuiteRun"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSuiteRunResponse startSuiteRun(Consumer<StartSuiteRunRequest.Builder> startSuiteRunRequest)
            throws ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        return startSuiteRun(StartSuiteRunRequest.builder().applyMutation(startSuiteRunRequest).build());
    }

    /**
     * <p>
     * Stops a Device Advisor test suite run that is currently running.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StopSuiteRun</a> action.
     * </p>
     *
     * @param stopSuiteRunRequest
     * @return Result of the StopSuiteRun operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.StopSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StopSuiteRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StopSuiteRunResponse stopSuiteRun(StopSuiteRunRequest stopSuiteRunRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a Device Advisor test suite run that is currently running.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StopSuiteRun</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopSuiteRunRequest.Builder} avoiding the need to
     * create one manually via {@link StopSuiteRunRequest#builder()}
     * </p>
     *
     * @param stopSuiteRunRequest
     *        A {@link Consumer} that will call methods on {@link StopSuiteRunRequest.Builder} to create a request.
     * @return Result of the StopSuiteRun operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.StopSuiteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StopSuiteRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StopSuiteRunResponse stopSuiteRun(Consumer<StopSuiteRunRequest.Builder> stopSuiteRunRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, IotDeviceAdvisorException {
        return stopSuiteRun(StopSuiteRunRequest.builder().applyMutation(stopSuiteRunRequest).build());
    }

    /**
     * <p>
     * Adds to and modifies existing tags of an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >TagResource</a> action.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to and modifies existing tags of an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >TagResource</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotDeviceAdvisorException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UntagResource</a> action.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an IoT Device Advisor resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UntagResource</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws ResourceNotFoundException
     *         Sends a Resource Not Found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotDeviceAdvisorException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateSuiteDefinition</a> action.
     * </p>
     *
     * @param updateSuiteDefinitionRequest
     * @return Result of the UpdateSuiteDefinition operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.UpdateSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UpdateSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSuiteDefinitionResponse updateSuiteDefinition(UpdateSuiteDefinitionRequest updateSuiteDefinitionRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            IotDeviceAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Device Advisor test suite.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateSuiteDefinition</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSuiteDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSuiteDefinitionRequest#builder()}
     * </p>
     *
     * @param updateSuiteDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSuiteDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSuiteDefinition operation returned by the service.
     * @throws ValidationException
     *         Sends a validation exception.
     * @throws InternalServerException
     *         Sends an Internal Failure exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotDeviceAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotDeviceAdvisorClient.UpdateSuiteDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UpdateSuiteDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSuiteDefinitionResponse updateSuiteDefinition(
            Consumer<UpdateSuiteDefinitionRequest.Builder> updateSuiteDefinitionRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, IotDeviceAdvisorException {
        return updateSuiteDefinition(UpdateSuiteDefinitionRequest.builder().applyMutation(updateSuiteDefinitionRequest).build());
    }

    /**
     * Create a {@link IotDeviceAdvisorClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotDeviceAdvisorClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotDeviceAdvisorClient}.
     */
    static IotDeviceAdvisorClientBuilder builder() {
        return new DefaultIotDeviceAdvisorClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default IotDeviceAdvisorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
