/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotanalytics.IoTAnalyticsClient;
import software.amazon.awssdk.services.iotanalytics.model.ListPipelinesRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListPipelinesResponse;

public class ListPipelinesIterable
implements SdkIterable<ListPipelinesResponse> {
    private final IoTAnalyticsClient client;
    private final ListPipelinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPipelinesIterable(IoTAnalyticsClient client, ListPipelinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPipelinesResponseFetcher();
    }

    public Iterator<ListPipelinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPipelinesResponseFetcher
    implements SyncPageFetcher<ListPipelinesResponse> {
        private ListPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPipelinesResponse nextPage(ListPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListPipelinesIterable.this.client.listPipelines(ListPipelinesIterable.this.firstRequest);
            }
            return ListPipelinesIterable.this.client.listPipelines((ListPipelinesRequest)((Object)ListPipelinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

