/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to limit data to that which has arrived since the last execution of the action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeltaTime implements SdkPojo, Serializable, ToCopyableBuilder<DeltaTime.Builder, DeltaTime> {
    private static final SdkField<Integer> OFFSET_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("offsetSeconds").getter(getter(DeltaTime::offsetSeconds)).setter(setter(Builder::offsetSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offsetSeconds").build()).build();

    private static final SdkField<String> TIME_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeExpression").getter(getter(DeltaTime::timeExpression)).setter(setter(Builder::timeExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeExpression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFSET_SECONDS_FIELD,
            TIME_EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer offsetSeconds;

    private final String timeExpression;

    private DeltaTime(BuilderImpl builder) {
        this.offsetSeconds = builder.offsetSeconds;
        this.timeExpression = builder.timeExpression;
    }

    /**
     * <p>
     * The number of seconds of estimated in-flight lag time of message data. When you create dataset contents using
     * message data from a specified timeframe, some message data might still be in flight when processing begins, and
     * so do not arrive in time to be processed. Use this field to make allowances for the in flight time of your
     * message data, so that data not processed from a previous timeframe is included with the next timeframe.
     * Otherwise, missed message data would be excluded from processing during the next timeframe too, because its
     * timestamp places it within the previous timeframe.
     * </p>
     * 
     * @return The number of seconds of estimated in-flight lag time of message data. When you create dataset contents
     *         using message data from a specified timeframe, some message data might still be in flight when processing
     *         begins, and so do not arrive in time to be processed. Use this field to make allowances for the in flight
     *         time of your message data, so that data not processed from a previous timeframe is included with the next
     *         timeframe. Otherwise, missed message data would be excluded from processing during the next timeframe
     *         too, because its timestamp places it within the previous timeframe.
     */
    public final Integer offsetSeconds() {
        return offsetSeconds;
    }

    /**
     * <p>
     * An expression by which the time of the message data might be determined. This can be the name of a timestamp
     * field or a SQL expression that is used to derive the time the message data was generated.
     * </p>
     * 
     * @return An expression by which the time of the message data might be determined. This can be the name of a
     *         timestamp field or a SQL expression that is used to derive the time the message data was generated.
     */
    public final String timeExpression() {
        return timeExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offsetSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(timeExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeltaTime)) {
            return false;
        }
        DeltaTime other = (DeltaTime) obj;
        return Objects.equals(offsetSeconds(), other.offsetSeconds()) && Objects.equals(timeExpression(), other.timeExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeltaTime").add("OffsetSeconds", offsetSeconds()).add("TimeExpression", timeExpression())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offsetSeconds":
            return Optional.ofNullable(clazz.cast(offsetSeconds()));
        case "timeExpression":
            return Optional.ofNullable(clazz.cast(timeExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeltaTime, T> g) {
        return obj -> g.apply((DeltaTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeltaTime> {
        /**
         * <p>
         * The number of seconds of estimated in-flight lag time of message data. When you create dataset contents using
         * message data from a specified timeframe, some message data might still be in flight when processing begins,
         * and so do not arrive in time to be processed. Use this field to make allowances for the in flight time of
         * your message data, so that data not processed from a previous timeframe is included with the next timeframe.
         * Otherwise, missed message data would be excluded from processing during the next timeframe too, because its
         * timestamp places it within the previous timeframe.
         * </p>
         * 
         * @param offsetSeconds
         *        The number of seconds of estimated in-flight lag time of message data. When you create dataset
         *        contents using message data from a specified timeframe, some message data might still be in flight
         *        when processing begins, and so do not arrive in time to be processed. Use this field to make
         *        allowances for the in flight time of your message data, so that data not processed from a previous
         *        timeframe is included with the next timeframe. Otherwise, missed message data would be excluded from
         *        processing during the next timeframe too, because its timestamp places it within the previous
         *        timeframe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offsetSeconds(Integer offsetSeconds);

        /**
         * <p>
         * An expression by which the time of the message data might be determined. This can be the name of a timestamp
         * field or a SQL expression that is used to derive the time the message data was generated.
         * </p>
         * 
         * @param timeExpression
         *        An expression by which the time of the message data might be determined. This can be the name of a
         *        timestamp field or a SQL expression that is used to derive the time the message data was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeExpression(String timeExpression);
    }

    static final class BuilderImpl implements Builder {
        private Integer offsetSeconds;

        private String timeExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(DeltaTime model) {
            offsetSeconds(model.offsetSeconds);
            timeExpression(model.timeExpression);
        }

        public final Integer getOffsetSeconds() {
            return offsetSeconds;
        }

        public final void setOffsetSeconds(Integer offsetSeconds) {
            this.offsetSeconds = offsetSeconds;
        }

        @Override
        public final Builder offsetSeconds(Integer offsetSeconds) {
            this.offsetSeconds = offsetSeconds;
            return this;
        }

        public final String getTimeExpression() {
            return timeExpression;
        }

        public final void setTimeExpression(String timeExpression) {
            this.timeExpression = timeExpression;
        }

        @Override
        public final Builder timeExpression(String timeExpression) {
            this.timeExpression = timeExpression;
            return this;
        }

        @Override
        public DeltaTime build() {
            return new DeltaTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
