/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for delivery of dataset contents to IoT Events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotEventsDestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IotEventsDestinationConfiguration.Builder, IotEventsDestinationConfiguration> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputName").getter(getter(IotEventsDestinationConfiguration::inputName))
            .setter(setter(Builder::inputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(IotEventsDestinationConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD,
            ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputName;

    private final String roleArn;

    private IotEventsDestinationConfiguration(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the IoT Events input to which dataset contents are delivered.
     * </p>
     * 
     * @return The name of the IoT Events input to which dataset contents are delivered.
     */
    public final String inputName() {
        return inputName;
    }

    /**
     * <p>
     * The ARN of the role that grants IoT Analytics permission to deliver dataset contents to an IoT Events input.
     * </p>
     * 
     * @return The ARN of the role that grants IoT Analytics permission to deliver dataset contents to an IoT Events
     *         input.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotEventsDestinationConfiguration)) {
            return false;
        }
        IotEventsDestinationConfiguration other = (IotEventsDestinationConfiguration) obj;
        return Objects.equals(inputName(), other.inputName()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IotEventsDestinationConfiguration").add("InputName", inputName()).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputName":
            return Optional.ofNullable(clazz.cast(inputName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotEventsDestinationConfiguration, T> g) {
        return obj -> g.apply((IotEventsDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotEventsDestinationConfiguration> {
        /**
         * <p>
         * The name of the IoT Events input to which dataset contents are delivered.
         * </p>
         * 
         * @param inputName
         *        The name of the IoT Events input to which dataset contents are delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputName(String inputName);

        /**
         * <p>
         * The ARN of the role that grants IoT Analytics permission to deliver dataset contents to an IoT Events input.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants IoT Analytics permission to deliver dataset contents to an IoT Events
         *        input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String inputName;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IotEventsDestinationConfiguration model) {
            inputName(model.inputName);
            roleArn(model.roleArn);
        }

        public final String getInputName() {
            return inputName;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public IotEventsDestinationConfiguration build() {
            return new IotEventsDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
