/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot1clickprojects.Iot1ClickProjectsClient;
import software.amazon.awssdk.services.iot1clickprojects.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.PlacementSummary;

public class ListPlacementsIterable
implements SdkIterable<ListPlacementsResponse> {
    private final Iot1ClickProjectsClient client;
    private final ListPlacementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlacementsIterable(Iot1ClickProjectsClient client, ListPlacementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPlacementsResponseFetcher();
    }

    public Iterator<ListPlacementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PlacementSummary> placements() {
        Function<ListPlacementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.placements() != null) {
                return response.placements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPlacementsResponseFetcher
    implements SyncPageFetcher<ListPlacementsResponse> {
        private ListPlacementsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlacementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlacementsResponse nextPage(ListPlacementsResponse previousPage) {
            if (previousPage == null) {
                return ListPlacementsIterable.this.client.listPlacements(ListPlacementsIterable.this.firstRequest);
            }
            return ListPlacementsIterable.this.client.listPlacements((ListPlacementsRequest)((Object)ListPlacementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

