/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse;

public class ListBillingGroupsIterable
implements SdkIterable<ListBillingGroupsResponse> {
    private final IotClient client;
    private final ListBillingGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBillingGroupsIterable(IotClient client, ListBillingGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBillingGroupsResponseFetcher();
    }

    public Iterator<ListBillingGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupNameAndArn> billingGroups() {
        Function<ListBillingGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.billingGroups() != null) {
                return response.billingGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBillingGroupsResponseFetcher
    implements SyncPageFetcher<ListBillingGroupsResponse> {
        private ListBillingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBillingGroupsResponse nextPage(ListBillingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListBillingGroupsIterable.this.client.listBillingGroups(ListBillingGroupsIterable.this.firstRequest);
            }
            return ListBillingGroupsIterable.this.client.listBillingGroups((ListBillingGroupsRequest)((Object)ListBillingGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

