/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListThingsRequest;
import software.amazon.awssdk.services.iot.model.ListThingsResponse;
import software.amazon.awssdk.services.iot.model.ThingAttribute;

public class ListThingsIterable
implements SdkIterable<ListThingsResponse> {
    private final IotClient client;
    private final ListThingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThingsIterable(IotClient client, ListThingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThingsResponseFetcher();
    }

    public Iterator<ListThingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ThingAttribute> things() {
        Function<ListThingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.things() != null) {
                return response.things().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThingsResponseFetcher
    implements SyncPageFetcher<ListThingsResponse> {
        private ListThingsResponseFetcher() {
        }

        public boolean hasNextPage(ListThingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThingsResponse nextPage(ListThingsResponse previousPage) {
            if (previousPage == null) {
                return ListThingsIterable.this.client.listThings(ListThingsIterable.this.firstRequest);
            }
            return ListThingsIterable.this.client.listThings((ListThingsRequest)((Object)ListThingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

