/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.AuditTaskMetadata;
import software.amazon.awssdk.services.iot.model.ListAuditTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditTasksResponse;

public class ListAuditTasksIterable
implements SdkIterable<ListAuditTasksResponse> {
    private final IotClient client;
    private final ListAuditTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAuditTasksIterable(IotClient client, ListAuditTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAuditTasksResponseFetcher();
    }

    public Iterator<ListAuditTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AuditTaskMetadata> tasks() {
        Function<ListAuditTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAuditTasksResponseFetcher
    implements SyncPageFetcher<ListAuditTasksResponse> {
        private ListAuditTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListAuditTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAuditTasksResponse nextPage(ListAuditTasksResponse previousPage) {
            if (previousPage == null) {
                return ListAuditTasksIterable.this.client.listAuditTasks(ListAuditTasksIterable.this.firstRequest);
            }
            return ListAuditTasksIterable.this.client.listAuditTasks((ListAuditTasksRequest)((Object)ListAuditTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

