/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecurityProfilesResponse extends IotResponse implements
        ToCopyableBuilder<ListSecurityProfilesResponse.Builder, ListSecurityProfilesResponse> {
    private static final SdkField<List<SecurityProfileIdentifier>> SECURITY_PROFILE_IDENTIFIERS_FIELD = SdkField
            .<List<SecurityProfileIdentifier>> builder(MarshallingType.LIST)
            .memberName("securityProfileIdentifiers")
            .getter(getter(ListSecurityProfilesResponse::securityProfileIdentifiers))
            .setter(setter(Builder::securityProfileIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityProfileIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityProfileIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSecurityProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SECURITY_PROFILE_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD));

    private final List<SecurityProfileIdentifier> securityProfileIdentifiers;

    private final String nextToken;

    private ListSecurityProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileIdentifiers = builder.securityProfileIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityProfileIdentifiers property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecurityProfileIdentifiers() {
        return securityProfileIdentifiers != null && !(securityProfileIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security profile identifiers (names and ARNs).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityProfileIdentifiers} method.
     * </p>
     * 
     * @return A list of security profile identifiers (names and ARNs).
     */
    public final List<SecurityProfileIdentifier> securityProfileIdentifiers() {
        return securityProfileIdentifiers;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityProfileIdentifiers() ? securityProfileIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilesResponse)) {
            return false;
        }
        ListSecurityProfilesResponse other = (ListSecurityProfilesResponse) obj;
        return hasSecurityProfileIdentifiers() == other.hasSecurityProfileIdentifiers()
                && Objects.equals(securityProfileIdentifiers(), other.securityProfileIdentifiers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSecurityProfilesResponse")
                .add("SecurityProfileIdentifiers", hasSecurityProfileIdentifiers() ? securityProfileIdentifiers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileIdentifiers":
            return Optional.ofNullable(clazz.cast(securityProfileIdentifiers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityProfilesResponse, T> g) {
        return obj -> g.apply((ListSecurityProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSecurityProfilesResponse> {
        /**
         * <p>
         * A list of security profile identifiers (names and ARNs).
         * </p>
         * 
         * @param securityProfileIdentifiers
         *        A list of security profile identifiers (names and ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileIdentifiers(Collection<SecurityProfileIdentifier> securityProfileIdentifiers);

        /**
         * <p>
         * A list of security profile identifiers (names and ARNs).
         * </p>
         * 
         * @param securityProfileIdentifiers
         *        A list of security profile identifiers (names and ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileIdentifiers(SecurityProfileIdentifier... securityProfileIdentifiers);

        /**
         * <p>
         * A list of security profile identifiers (names and ARNs).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #securityProfileIdentifiers(List<SecurityProfileIdentifier>)}.
         * 
         * @param securityProfileIdentifiers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityProfileIdentifiers(java.util.Collection<SecurityProfileIdentifier>)
         */
        Builder securityProfileIdentifiers(Consumer<SecurityProfileIdentifier.Builder>... securityProfileIdentifiers);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<SecurityProfileIdentifier> securityProfileIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilesResponse model) {
            super(model);
            securityProfileIdentifiers(model.securityProfileIdentifiers);
            nextToken(model.nextToken);
        }

        public final List<SecurityProfileIdentifier.Builder> getSecurityProfileIdentifiers() {
            List<SecurityProfileIdentifier.Builder> result = SecurityProfileIdentifiersCopier
                    .copyToBuilder(this.securityProfileIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityProfileIdentifiers(
                Collection<SecurityProfileIdentifier.BuilderImpl> securityProfileIdentifiers) {
            this.securityProfileIdentifiers = SecurityProfileIdentifiersCopier.copyFromBuilder(securityProfileIdentifiers);
        }

        @Override
        public final Builder securityProfileIdentifiers(Collection<SecurityProfileIdentifier> securityProfileIdentifiers) {
            this.securityProfileIdentifiers = SecurityProfileIdentifiersCopier.copy(securityProfileIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIdentifiers(SecurityProfileIdentifier... securityProfileIdentifiers) {
            securityProfileIdentifiers(Arrays.asList(securityProfileIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIdentifiers(Consumer<SecurityProfileIdentifier.Builder>... securityProfileIdentifiers) {
            securityProfileIdentifiers(Stream.of(securityProfileIdentifiers)
                    .map(c -> SecurityProfileIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSecurityProfilesResponse build() {
            return new ListSecurityProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
