/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDynamicThingGroupResponse extends IotResponse implements
        ToCopyableBuilder<CreateDynamicThingGroupResponse.Builder, CreateDynamicThingGroupResponse> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingGroupName").getter(getter(CreateDynamicThingGroupResponse::thingGroupName))
            .setter(setter(Builder::thingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupName").build()).build();

    private static final SdkField<String> THING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingGroupArn").getter(getter(CreateDynamicThingGroupResponse::thingGroupArn))
            .setter(setter(Builder::thingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupArn").build()).build();

    private static final SdkField<String> THING_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingGroupId").getter(getter(CreateDynamicThingGroupResponse::thingGroupId))
            .setter(setter(Builder::thingGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupId").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(CreateDynamicThingGroupResponse::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(CreateDynamicThingGroupResponse::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryVersion").getter(getter(CreateDynamicThingGroupResponse::queryVersion))
            .setter(setter(Builder::queryVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD,
            THING_GROUP_ARN_FIELD, THING_GROUP_ID_FIELD, INDEX_NAME_FIELD, QUERY_STRING_FIELD, QUERY_VERSION_FIELD));

    private final String thingGroupName;

    private final String thingGroupArn;

    private final String thingGroupId;

    private final String indexName;

    private final String queryString;

    private final String queryVersion;

    private CreateDynamicThingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupArn = builder.thingGroupArn;
        this.thingGroupId = builder.thingGroupId;
        this.indexName = builder.indexName;
        this.queryString = builder.queryString;
        this.queryVersion = builder.queryVersion;
    }

    /**
     * <p>
     * The dynamic thing group name.
     * </p>
     * 
     * @return The dynamic thing group name.
     */
    public final String thingGroupName() {
        return thingGroupName;
    }

    /**
     * <p>
     * The dynamic thing group ARN.
     * </p>
     * 
     * @return The dynamic thing group ARN.
     */
    public final String thingGroupArn() {
        return thingGroupArn;
    }

    /**
     * <p>
     * The dynamic thing group ID.
     * </p>
     * 
     * @return The dynamic thing group ID.
     */
    public final String thingGroupId() {
        return thingGroupId;
    }

    /**
     * <p>
     * The dynamic thing group index name.
     * </p>
     * 
     * @return The dynamic thing group index name.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The dynamic thing group search query string.
     * </p>
     * 
     * @return The dynamic thing group search query string.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The dynamic thing group query version.
     * </p>
     * 
     * @return The dynamic thing group query version.
     */
    public final String queryVersion() {
        return queryVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(queryVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDynamicThingGroupResponse)) {
            return false;
        }
        CreateDynamicThingGroupResponse other = (CreateDynamicThingGroupResponse) obj;
        return Objects.equals(thingGroupName(), other.thingGroupName()) && Objects.equals(thingGroupArn(), other.thingGroupArn())
                && Objects.equals(thingGroupId(), other.thingGroupId()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(queryString(), other.queryString()) && Objects.equals(queryVersion(), other.queryVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDynamicThingGroupResponse").add("ThingGroupName", thingGroupName())
                .add("ThingGroupArn", thingGroupArn()).add("ThingGroupId", thingGroupId()).add("IndexName", indexName())
                .add("QueryString", queryString()).add("QueryVersion", queryVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupName":
            return Optional.ofNullable(clazz.cast(thingGroupName()));
        case "thingGroupArn":
            return Optional.ofNullable(clazz.cast(thingGroupArn()));
        case "thingGroupId":
            return Optional.ofNullable(clazz.cast(thingGroupId()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "queryVersion":
            return Optional.ofNullable(clazz.cast(queryVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDynamicThingGroupResponse, T> g) {
        return obj -> g.apply((CreateDynamicThingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDynamicThingGroupResponse> {
        /**
         * <p>
         * The dynamic thing group name.
         * </p>
         * 
         * @param thingGroupName
         *        The dynamic thing group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupName(String thingGroupName);

        /**
         * <p>
         * The dynamic thing group ARN.
         * </p>
         * 
         * @param thingGroupArn
         *        The dynamic thing group ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupArn(String thingGroupArn);

        /**
         * <p>
         * The dynamic thing group ID.
         * </p>
         * 
         * @param thingGroupId
         *        The dynamic thing group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupId(String thingGroupId);

        /**
         * <p>
         * The dynamic thing group index name.
         * </p>
         * 
         * @param indexName
         *        The dynamic thing group index name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The dynamic thing group search query string.
         * </p>
         * 
         * @param queryString
         *        The dynamic thing group search query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The dynamic thing group query version.
         * </p>
         * 
         * @param queryVersion
         *        The dynamic thing group query version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryVersion(String queryVersion);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String thingGroupName;

        private String thingGroupArn;

        private String thingGroupId;

        private String indexName;

        private String queryString;

        private String queryVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDynamicThingGroupResponse model) {
            super(model);
            thingGroupName(model.thingGroupName);
            thingGroupArn(model.thingGroupArn);
            thingGroupId(model.thingGroupId);
            indexName(model.indexName);
            queryString(model.queryString);
            queryVersion(model.queryVersion);
        }

        public final String getThingGroupName() {
            return thingGroupName;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final String getThingGroupArn() {
            return thingGroupArn;
        }

        public final void setThingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
        }

        @Override
        public final Builder thingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
            return this;
        }

        public final String getThingGroupId() {
            return thingGroupId;
        }

        public final void setThingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
        }

        @Override
        public final Builder thingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getQueryVersion() {
            return queryVersion;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        @Override
        public CreateDynamicThingGroupResponse build() {
            return new CreateDynamicThingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
