/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary;

public class ListProvisioningTemplatesIterable
implements SdkIterable<ListProvisioningTemplatesResponse> {
    private final IotClient client;
    private final ListProvisioningTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProvisioningTemplatesIterable(IotClient client, ListProvisioningTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProvisioningTemplatesResponseFetcher();
    }

    public Iterator<ListProvisioningTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProvisioningTemplateSummary> templates() {
        Function<ListProvisioningTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templates() != null) {
                return response.templates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProvisioningTemplatesResponseFetcher
    implements SyncPageFetcher<ListProvisioningTemplatesResponse> {
        private ListProvisioningTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListProvisioningTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProvisioningTemplatesResponse nextPage(ListProvisioningTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListProvisioningTemplatesIterable.this.client.listProvisioningTemplates(ListProvisioningTemplatesIterable.this.firstRequest);
            }
            return ListProvisioningTemplatesIterable.this.client.listProvisioningTemplates((ListProvisioningTemplatesRequest)((Object)ListProvisioningTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

