/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.EnvironmentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedJobTemplateSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedJobTemplateSummary> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateArn").getter(ManagedJobTemplateSummary.getter(ManagedJobTemplateSummary::templateArn)).setter(ManagedJobTemplateSummary.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(ManagedJobTemplateSummary.getter(ManagedJobTemplateSummary::templateName)).setter(ManagedJobTemplateSummary.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ManagedJobTemplateSummary.getter(ManagedJobTemplateSummary::description)).setter(ManagedJobTemplateSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environments").getter(ManagedJobTemplateSummary.getter(ManagedJobTemplateSummary::environments)).setter(ManagedJobTemplateSummary.setter(Builder::environments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateVersion").getter(ManagedJobTemplateSummary.getter(ManagedJobTemplateSummary::templateVersion)).setter(ManagedJobTemplateSummary.setter(Builder::templateVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD, TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, ENVIRONMENTS_FIELD, TEMPLATE_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String templateArn;
    private final String templateName;
    private final String description;
    private final List<String> environments;
    private final String templateVersion;

    private ManagedJobTemplateSummary(BuilderImpl builder) {
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.environments = builder.environments;
        this.templateVersion = builder.templateVersion;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEnvironments() {
        return this.environments != null && !(this.environments instanceof SdkAutoConstructList);
    }

    public final List<String> environments() {
        return this.environments;
    }

    public final String templateVersion() {
        return this.templateVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironments() ? this.environments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedJobTemplateSummary)) {
            return false;
        }
        ManagedJobTemplateSummary other = (ManagedJobTemplateSummary)obj;
        return Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.description(), other.description()) && this.hasEnvironments() == other.hasEnvironments() && Objects.equals(this.environments(), other.environments()) && Objects.equals(this.templateVersion(), other.templateVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedJobTemplateSummary").add("TemplateArn", (Object)this.templateArn()).add("TemplateName", (Object)this.templateName()).add("Description", (Object)this.description()).add("Environments", this.hasEnvironments() ? this.environments() : null).add("TemplateVersion", (Object)this.templateVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "environments": {
                return Optional.ofNullable(clazz.cast(this.environments()));
            }
            case "templateVersion": {
                return Optional.ofNullable(clazz.cast(this.templateVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedJobTemplateSummary, T> g) {
        return obj -> g.apply((ManagedJobTemplateSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String templateArn;
        private String templateName;
        private String description;
        private List<String> environments = DefaultSdkAutoConstructList.getInstance();
        private String templateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedJobTemplateSummary model) {
            this.templateArn(model.templateArn);
            this.templateName(model.templateName);
            this.description(model.description);
            this.environments(model.environments);
            this.templateVersion(model.templateVersion);
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getEnvironments() {
            if (this.environments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.environments;
        }

        public final void setEnvironments(Collection<String> environments) {
            this.environments = EnvironmentsCopier.copy(environments);
        }

        @Override
        public final Builder environments(Collection<String> environments) {
            this.environments = EnvironmentsCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(String ... environments) {
            this.environments(Arrays.asList(environments));
            return this;
        }

        public final String getTemplateVersion() {
            return this.templateVersion;
        }

        public final void setTemplateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
        }

        @Override
        public final Builder templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        public ManagedJobTemplateSummary build() {
            return new ManagedJobTemplateSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedJobTemplateSummary> {
        public Builder templateArn(String var1);

        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder environments(Collection<String> var1);

        public Builder environments(String ... var1);

        public Builder templateVersion(String var1);
    }
}

