/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource filter criteria for a Software bill of materials (SBOM) report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceFilterCriteria.Builder, ResourceFilterCriteria> {
    private static final SdkField<List<ResourceStringFilter>> ACCOUNT_ID_FIELD = SdkField
            .<List<ResourceStringFilter>> builder(MarshallingType.LIST)
            .memberName("accountId")
            .getter(getter(ResourceFilterCriteria::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceMapFilter>> EC2_INSTANCE_TAGS_FIELD = SdkField
            .<List<ResourceMapFilter>> builder(MarshallingType.LIST)
            .memberName("ec2InstanceTags")
            .getter(getter(ResourceFilterCriteria::ec2InstanceTags))
            .setter(setter(Builder::ec2InstanceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceMapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceMapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceStringFilter>> ECR_IMAGE_TAGS_FIELD = SdkField
            .<List<ResourceStringFilter>> builder(MarshallingType.LIST)
            .memberName("ecrImageTags")
            .getter(getter(ResourceFilterCriteria::ecrImageTags))
            .setter(setter(Builder::ecrImageTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImageTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceStringFilter>> ECR_REPOSITORY_NAME_FIELD = SdkField
            .<List<ResourceStringFilter>> builder(MarshallingType.LIST)
            .memberName("ecrRepositoryName")
            .getter(getter(ResourceFilterCriteria::ecrRepositoryName))
            .setter(setter(Builder::ecrRepositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceStringFilter>> LAMBDA_FUNCTION_NAME_FIELD = SdkField
            .<List<ResourceStringFilter>> builder(MarshallingType.LIST)
            .memberName("lambdaFunctionName")
            .getter(getter(ResourceFilterCriteria::lambdaFunctionName))
            .setter(setter(Builder::lambdaFunctionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceMapFilter>> LAMBDA_FUNCTION_TAGS_FIELD = SdkField
            .<List<ResourceMapFilter>> builder(MarshallingType.LIST)
            .memberName("lambdaFunctionTags")
            .getter(getter(ResourceFilterCriteria::lambdaFunctionTags))
            .setter(setter(Builder::lambdaFunctionTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceMapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceMapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceStringFilter>> RESOURCE_ID_FIELD = SdkField
            .<List<ResourceStringFilter>> builder(MarshallingType.LIST)
            .memberName("resourceId")
            .getter(getter(ResourceFilterCriteria::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceStringFilter>> RESOURCE_TYPE_FIELD = SdkField
            .<List<ResourceStringFilter>> builder(MarshallingType.LIST)
            .memberName("resourceType")
            .getter(getter(ResourceFilterCriteria::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            EC2_INSTANCE_TAGS_FIELD, ECR_IMAGE_TAGS_FIELD, ECR_REPOSITORY_NAME_FIELD, LAMBDA_FUNCTION_NAME_FIELD,
            LAMBDA_FUNCTION_TAGS_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ResourceStringFilter> accountId;

    private final List<ResourceMapFilter> ec2InstanceTags;

    private final List<ResourceStringFilter> ecrImageTags;

    private final List<ResourceStringFilter> ecrRepositoryName;

    private final List<ResourceStringFilter> lambdaFunctionName;

    private final List<ResourceMapFilter> lambdaFunctionTags;

    private final List<ResourceStringFilter> resourceId;

    private final List<ResourceStringFilter> resourceType;

    private ResourceFilterCriteria(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.ec2InstanceTags = builder.ec2InstanceTags;
        this.ecrImageTags = builder.ecrImageTags;
        this.ecrRepositoryName = builder.ecrRepositoryName;
        this.lambdaFunctionName = builder.lambdaFunctionName;
        this.lambdaFunctionTags = builder.lambdaFunctionTags;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountId property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountId() {
        return accountId != null && !(accountId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The account IDs used as resource filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountId} method.
     * </p>
     * 
     * @return The account IDs used as resource filter criteria.
     */
    public final List<ResourceStringFilter> accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2InstanceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2InstanceTags() {
        return ec2InstanceTags != null && !(ec2InstanceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 instance tags used as resource filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2InstanceTags} method.
     * </p>
     * 
     * @return The EC2 instance tags used as resource filter criteria.
     */
    public final List<ResourceMapFilter> ec2InstanceTags() {
        return ec2InstanceTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrImageTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcrImageTags() {
        return ecrImageTags != null && !(ecrImageTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ECR image tags used as resource filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrImageTags} method.
     * </p>
     * 
     * @return The ECR image tags used as resource filter criteria.
     */
    public final List<ResourceStringFilter> ecrImageTags() {
        return ecrImageTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrRepositoryName property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcrRepositoryName() {
        return ecrRepositoryName != null && !(ecrRepositoryName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ECR repository names used as resource filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrRepositoryName} method.
     * </p>
     * 
     * @return The ECR repository names used as resource filter criteria.
     */
    public final List<ResourceStringFilter> ecrRepositoryName() {
        return ecrRepositoryName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LambdaFunctionName property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLambdaFunctionName() {
        return lambdaFunctionName != null && !(lambdaFunctionName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS Lambda function name used as resource filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLambdaFunctionName} method.
     * </p>
     * 
     * @return The AWS Lambda function name used as resource filter criteria.
     */
    public final List<ResourceStringFilter> lambdaFunctionName() {
        return lambdaFunctionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LambdaFunctionTags property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLambdaFunctionTags() {
        return lambdaFunctionTags != null && !(lambdaFunctionTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS Lambda function tags used as resource filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLambdaFunctionTags} method.
     * </p>
     * 
     * @return The AWS Lambda function tags used as resource filter criteria.
     */
    public final List<ResourceMapFilter> lambdaFunctionTags() {
        return lambdaFunctionTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceId property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResourceId() {
        return resourceId != null && !(resourceId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource IDs used as resource filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceId} method.
     * </p>
     * 
     * @return The resource IDs used as resource filter criteria.
     */
    public final List<ResourceStringFilter> resourceId() {
        return resourceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceType() {
        return resourceType != null && !(resourceType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource types used as resource filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceType} method.
     * </p>
     * 
     * @return The resource types used as resource filter criteria.
     */
    public final List<ResourceStringFilter> resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountId() ? accountId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2InstanceTags() ? ec2InstanceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrImageTags() ? ecrImageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrRepositoryName() ? ecrRepositoryName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLambdaFunctionName() ? lambdaFunctionName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLambdaFunctionTags() ? lambdaFunctionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceId() ? resourceId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceType() ? resourceType() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceFilterCriteria)) {
            return false;
        }
        ResourceFilterCriteria other = (ResourceFilterCriteria) obj;
        return hasAccountId() == other.hasAccountId() && Objects.equals(accountId(), other.accountId())
                && hasEc2InstanceTags() == other.hasEc2InstanceTags()
                && Objects.equals(ec2InstanceTags(), other.ec2InstanceTags()) && hasEcrImageTags() == other.hasEcrImageTags()
                && Objects.equals(ecrImageTags(), other.ecrImageTags()) && hasEcrRepositoryName() == other.hasEcrRepositoryName()
                && Objects.equals(ecrRepositoryName(), other.ecrRepositoryName())
                && hasLambdaFunctionName() == other.hasLambdaFunctionName()
                && Objects.equals(lambdaFunctionName(), other.lambdaFunctionName())
                && hasLambdaFunctionTags() == other.hasLambdaFunctionTags()
                && Objects.equals(lambdaFunctionTags(), other.lambdaFunctionTags()) && hasResourceId() == other.hasResourceId()
                && Objects.equals(resourceId(), other.resourceId()) && hasResourceType() == other.hasResourceType()
                && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceFilterCriteria").add("AccountId", hasAccountId() ? accountId() : null)
                .add("Ec2InstanceTags", hasEc2InstanceTags() ? ec2InstanceTags() : null)
                .add("EcrImageTags", hasEcrImageTags() ? ecrImageTags() : null)
                .add("EcrRepositoryName", hasEcrRepositoryName() ? ecrRepositoryName() : null)
                .add("LambdaFunctionName", hasLambdaFunctionName() ? lambdaFunctionName() : null)
                .add("LambdaFunctionTags", hasLambdaFunctionTags() ? lambdaFunctionTags() : null)
                .add("ResourceId", hasResourceId() ? resourceId() : null)
                .add("ResourceType", hasResourceType() ? resourceType() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ec2InstanceTags":
            return Optional.ofNullable(clazz.cast(ec2InstanceTags()));
        case "ecrImageTags":
            return Optional.ofNullable(clazz.cast(ecrImageTags()));
        case "ecrRepositoryName":
            return Optional.ofNullable(clazz.cast(ecrRepositoryName()));
        case "lambdaFunctionName":
            return Optional.ofNullable(clazz.cast(lambdaFunctionName()));
        case "lambdaFunctionTags":
            return Optional.ofNullable(clazz.cast(lambdaFunctionTags()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceFilterCriteria, T> g) {
        return obj -> g.apply((ResourceFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceFilterCriteria> {
        /**
         * <p>
         * The account IDs used as resource filter criteria.
         * </p>
         * 
         * @param accountId
         *        The account IDs used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(Collection<ResourceStringFilter> accountId);

        /**
         * <p>
         * The account IDs used as resource filter criteria.
         * </p>
         * 
         * @param accountId
         *        The account IDs used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(ResourceStringFilter... accountId);

        /**
         * <p>
         * The account IDs used as resource filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #accountId(List<ResourceStringFilter>)}.
         * 
         * @param accountId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountId(java.util.Collection<ResourceStringFilter>)
         */
        Builder accountId(Consumer<ResourceStringFilter.Builder>... accountId);

        /**
         * <p>
         * The EC2 instance tags used as resource filter criteria.
         * </p>
         * 
         * @param ec2InstanceTags
         *        The EC2 instance tags used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceTags(Collection<ResourceMapFilter> ec2InstanceTags);

        /**
         * <p>
         * The EC2 instance tags used as resource filter criteria.
         * </p>
         * 
         * @param ec2InstanceTags
         *        The EC2 instance tags used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceTags(ResourceMapFilter... ec2InstanceTags);

        /**
         * <p>
         * The EC2 instance tags used as resource filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceMapFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.ResourceMapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceMapFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #ec2InstanceTags(List<ResourceMapFilter>)}.
         * 
         * @param ec2InstanceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.ResourceMapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceTags(java.util.Collection<ResourceMapFilter>)
         */
        Builder ec2InstanceTags(Consumer<ResourceMapFilter.Builder>... ec2InstanceTags);

        /**
         * <p>
         * The ECR image tags used as resource filter criteria.
         * </p>
         * 
         * @param ecrImageTags
         *        The ECR image tags used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageTags(Collection<ResourceStringFilter> ecrImageTags);

        /**
         * <p>
         * The ECR image tags used as resource filter criteria.
         * </p>
         * 
         * @param ecrImageTags
         *        The ECR image tags used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageTags(ResourceStringFilter... ecrImageTags);

        /**
         * <p>
         * The ECR image tags used as resource filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #ecrImageTags(List<ResourceStringFilter>)}.
         * 
         * @param ecrImageTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImageTags(java.util.Collection<ResourceStringFilter>)
         */
        Builder ecrImageTags(Consumer<ResourceStringFilter.Builder>... ecrImageTags);

        /**
         * <p>
         * The ECR repository names used as resource filter criteria.
         * </p>
         * 
         * @param ecrRepositoryName
         *        The ECR repository names used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryName(Collection<ResourceStringFilter> ecrRepositoryName);

        /**
         * <p>
         * The ECR repository names used as resource filter criteria.
         * </p>
         * 
         * @param ecrRepositoryName
         *        The ECR repository names used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryName(ResourceStringFilter... ecrRepositoryName);

        /**
         * <p>
         * The ECR repository names used as resource filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #ecrRepositoryName(List<ResourceStringFilter>)}.
         * 
         * @param ecrRepositoryName
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrRepositoryName(java.util.Collection<ResourceStringFilter>)
         */
        Builder ecrRepositoryName(Consumer<ResourceStringFilter.Builder>... ecrRepositoryName);

        /**
         * <p>
         * The AWS Lambda function name used as resource filter criteria.
         * </p>
         * 
         * @param lambdaFunctionName
         *        The AWS Lambda function name used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionName(Collection<ResourceStringFilter> lambdaFunctionName);

        /**
         * <p>
         * The AWS Lambda function name used as resource filter criteria.
         * </p>
         * 
         * @param lambdaFunctionName
         *        The AWS Lambda function name used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionName(ResourceStringFilter... lambdaFunctionName);

        /**
         * <p>
         * The AWS Lambda function name used as resource filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lambdaFunctionName(List<ResourceStringFilter>)}.
         * 
         * @param lambdaFunctionName
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionName(java.util.Collection<ResourceStringFilter>)
         */
        Builder lambdaFunctionName(Consumer<ResourceStringFilter.Builder>... lambdaFunctionName);

        /**
         * <p>
         * The AWS Lambda function tags used as resource filter criteria.
         * </p>
         * 
         * @param lambdaFunctionTags
         *        The AWS Lambda function tags used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionTags(Collection<ResourceMapFilter> lambdaFunctionTags);

        /**
         * <p>
         * The AWS Lambda function tags used as resource filter criteria.
         * </p>
         * 
         * @param lambdaFunctionTags
         *        The AWS Lambda function tags used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionTags(ResourceMapFilter... lambdaFunctionTags);

        /**
         * <p>
         * The AWS Lambda function tags used as resource filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceMapFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.ResourceMapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceMapFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lambdaFunctionTags(List<ResourceMapFilter>)}.
         * 
         * @param lambdaFunctionTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.ResourceMapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionTags(java.util.Collection<ResourceMapFilter>)
         */
        Builder lambdaFunctionTags(Consumer<ResourceMapFilter.Builder>... lambdaFunctionTags);

        /**
         * <p>
         * The resource IDs used as resource filter criteria.
         * </p>
         * 
         * @param resourceId
         *        The resource IDs used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(Collection<ResourceStringFilter> resourceId);

        /**
         * <p>
         * The resource IDs used as resource filter criteria.
         * </p>
         * 
         * @param resourceId
         *        The resource IDs used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(ResourceStringFilter... resourceId);

        /**
         * <p>
         * The resource IDs used as resource filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceId(List<ResourceStringFilter>)}.
         * 
         * @param resourceId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceId(java.util.Collection<ResourceStringFilter>)
         */
        Builder resourceId(Consumer<ResourceStringFilter.Builder>... resourceId);

        /**
         * <p>
         * The resource types used as resource filter criteria.
         * </p>
         * 
         * @param resourceType
         *        The resource types used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(Collection<ResourceStringFilter> resourceType);

        /**
         * <p>
         * The resource types used as resource filter criteria.
         * </p>
         * 
         * @param resourceType
         *        The resource types used as resource filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(ResourceStringFilter... resourceType);

        /**
         * <p>
         * The resource types used as resource filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceType(List<ResourceStringFilter>)}.
         * 
         * @param resourceType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.ResourceStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceType(java.util.Collection<ResourceStringFilter>)
         */
        Builder resourceType(Consumer<ResourceStringFilter.Builder>... resourceType);
    }

    static final class BuilderImpl implements Builder {
        private List<ResourceStringFilter> accountId = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceMapFilter> ec2InstanceTags = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceStringFilter> ecrImageTags = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceStringFilter> ecrRepositoryName = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceStringFilter> lambdaFunctionName = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceMapFilter> lambdaFunctionTags = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceStringFilter> resourceId = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceStringFilter> resourceType = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceFilterCriteria model) {
            accountId(model.accountId);
            ec2InstanceTags(model.ec2InstanceTags);
            ecrImageTags(model.ecrImageTags);
            ecrRepositoryName(model.ecrRepositoryName);
            lambdaFunctionName(model.lambdaFunctionName);
            lambdaFunctionTags(model.lambdaFunctionTags);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
        }

        public final List<ResourceStringFilter.Builder> getAccountId() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.accountId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountId(Collection<ResourceStringFilter.BuilderImpl> accountId) {
            this.accountId = ResourceStringFilterListCopier.copyFromBuilder(accountId);
        }

        @Override
        public final Builder accountId(Collection<ResourceStringFilter> accountId) {
            this.accountId = ResourceStringFilterListCopier.copy(accountId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountId(ResourceStringFilter... accountId) {
            accountId(Arrays.asList(accountId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountId(Consumer<ResourceStringFilter.Builder>... accountId) {
            accountId(Stream.of(accountId).map(c -> ResourceStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceMapFilter.Builder> getEc2InstanceTags() {
            List<ResourceMapFilter.Builder> result = ResourceMapFilterListCopier.copyToBuilder(this.ec2InstanceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InstanceTags(Collection<ResourceMapFilter.BuilderImpl> ec2InstanceTags) {
            this.ec2InstanceTags = ResourceMapFilterListCopier.copyFromBuilder(ec2InstanceTags);
        }

        @Override
        public final Builder ec2InstanceTags(Collection<ResourceMapFilter> ec2InstanceTags) {
            this.ec2InstanceTags = ResourceMapFilterListCopier.copy(ec2InstanceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceTags(ResourceMapFilter... ec2InstanceTags) {
            ec2InstanceTags(Arrays.asList(ec2InstanceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceTags(Consumer<ResourceMapFilter.Builder>... ec2InstanceTags) {
            ec2InstanceTags(Stream.of(ec2InstanceTags).map(c -> ResourceMapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStringFilter.Builder> getEcrImageTags() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.ecrImageTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImageTags(Collection<ResourceStringFilter.BuilderImpl> ecrImageTags) {
            this.ecrImageTags = ResourceStringFilterListCopier.copyFromBuilder(ecrImageTags);
        }

        @Override
        public final Builder ecrImageTags(Collection<ResourceStringFilter> ecrImageTags) {
            this.ecrImageTags = ResourceStringFilterListCopier.copy(ecrImageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageTags(ResourceStringFilter... ecrImageTags) {
            ecrImageTags(Arrays.asList(ecrImageTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageTags(Consumer<ResourceStringFilter.Builder>... ecrImageTags) {
            ecrImageTags(Stream.of(ecrImageTags).map(c -> ResourceStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStringFilter.Builder> getEcrRepositoryName() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.ecrRepositoryName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrRepositoryName(Collection<ResourceStringFilter.BuilderImpl> ecrRepositoryName) {
            this.ecrRepositoryName = ResourceStringFilterListCopier.copyFromBuilder(ecrRepositoryName);
        }

        @Override
        public final Builder ecrRepositoryName(Collection<ResourceStringFilter> ecrRepositoryName) {
            this.ecrRepositoryName = ResourceStringFilterListCopier.copy(ecrRepositoryName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrRepositoryName(ResourceStringFilter... ecrRepositoryName) {
            ecrRepositoryName(Arrays.asList(ecrRepositoryName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrRepositoryName(Consumer<ResourceStringFilter.Builder>... ecrRepositoryName) {
            ecrRepositoryName(Stream.of(ecrRepositoryName).map(c -> ResourceStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStringFilter.Builder> getLambdaFunctionName() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.lambdaFunctionName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaFunctionName(Collection<ResourceStringFilter.BuilderImpl> lambdaFunctionName) {
            this.lambdaFunctionName = ResourceStringFilterListCopier.copyFromBuilder(lambdaFunctionName);
        }

        @Override
        public final Builder lambdaFunctionName(Collection<ResourceStringFilter> lambdaFunctionName) {
            this.lambdaFunctionName = ResourceStringFilterListCopier.copy(lambdaFunctionName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionName(ResourceStringFilter... lambdaFunctionName) {
            lambdaFunctionName(Arrays.asList(lambdaFunctionName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionName(Consumer<ResourceStringFilter.Builder>... lambdaFunctionName) {
            lambdaFunctionName(Stream.of(lambdaFunctionName).map(c -> ResourceStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceMapFilter.Builder> getLambdaFunctionTags() {
            List<ResourceMapFilter.Builder> result = ResourceMapFilterListCopier.copyToBuilder(this.lambdaFunctionTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaFunctionTags(Collection<ResourceMapFilter.BuilderImpl> lambdaFunctionTags) {
            this.lambdaFunctionTags = ResourceMapFilterListCopier.copyFromBuilder(lambdaFunctionTags);
        }

        @Override
        public final Builder lambdaFunctionTags(Collection<ResourceMapFilter> lambdaFunctionTags) {
            this.lambdaFunctionTags = ResourceMapFilterListCopier.copy(lambdaFunctionTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionTags(ResourceMapFilter... lambdaFunctionTags) {
            lambdaFunctionTags(Arrays.asList(lambdaFunctionTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionTags(Consumer<ResourceMapFilter.Builder>... lambdaFunctionTags) {
            lambdaFunctionTags(Stream.of(lambdaFunctionTags).map(c -> ResourceMapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStringFilter.Builder> getResourceId() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.resourceId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceId(Collection<ResourceStringFilter.BuilderImpl> resourceId) {
            this.resourceId = ResourceStringFilterListCopier.copyFromBuilder(resourceId);
        }

        @Override
        public final Builder resourceId(Collection<ResourceStringFilter> resourceId) {
            this.resourceId = ResourceStringFilterListCopier.copy(resourceId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(ResourceStringFilter... resourceId) {
            resourceId(Arrays.asList(resourceId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(Consumer<ResourceStringFilter.Builder>... resourceId) {
            resourceId(Stream.of(resourceId).map(c -> ResourceStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStringFilter.Builder> getResourceType() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.resourceType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceType(Collection<ResourceStringFilter.BuilderImpl> resourceType) {
            this.resourceType = ResourceStringFilterListCopier.copyFromBuilder(resourceType);
        }

        @Override
        public final Builder resourceType(Collection<ResourceStringFilter> resourceType) {
            this.resourceType = ResourceStringFilterListCopier.copy(resourceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(ResourceStringFilter... resourceType) {
            resourceType(Arrays.asList(resourceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(Consumer<ResourceStringFilter.Builder>... resourceType) {
            resourceType(Stream.of(resourceType).map(c -> ResourceStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResourceFilterCriteria build() {
            return new ResourceFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
