/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about the status of Amazon Inspector deep inspection for a member account in your
 * organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberAccountEc2DeepInspectionStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberAccountEc2DeepInspectionStatus.Builder, MemberAccountEc2DeepInspectionStatus> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(MemberAccountEc2DeepInspectionStatus::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Boolean> ACTIVATE_DEEP_INSPECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("activateDeepInspection").getter(getter(MemberAccountEc2DeepInspectionStatus::activateDeepInspection))
            .setter(setter(Builder::activateDeepInspection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activateDeepInspection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ACTIVATE_DEEP_INSPECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Boolean activateDeepInspection;

    private MemberAccountEc2DeepInspectionStatus(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.activateDeepInspection = builder.activateDeepInspection;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Web Services account of the organization member.
     * </p>
     * 
     * @return The unique identifier for the Amazon Web Services account of the organization member.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Whether Amazon Inspector deep inspection is active in the account. If <code>TRUE</code> Amazon Inspector deep
     * inspection is active, if <code>FALSE</code> it is not active.
     * </p>
     * 
     * @return Whether Amazon Inspector deep inspection is active in the account. If <code>TRUE</code> Amazon Inspector
     *         deep inspection is active, if <code>FALSE</code> it is not active.
     */
    public final Boolean activateDeepInspection() {
        return activateDeepInspection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(activateDeepInspection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberAccountEc2DeepInspectionStatus)) {
            return false;
        }
        MemberAccountEc2DeepInspectionStatus other = (MemberAccountEc2DeepInspectionStatus) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(activateDeepInspection(), other.activateDeepInspection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberAccountEc2DeepInspectionStatus").add("AccountId", accountId())
                .add("ActivateDeepInspection", activateDeepInspection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "activateDeepInspection":
            return Optional.ofNullable(clazz.cast(activateDeepInspection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberAccountEc2DeepInspectionStatus, T> g) {
        return obj -> g.apply((MemberAccountEc2DeepInspectionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberAccountEc2DeepInspectionStatus> {
        /**
         * <p>
         * The unique identifier for the Amazon Web Services account of the organization member.
         * </p>
         * 
         * @param accountId
         *        The unique identifier for the Amazon Web Services account of the organization member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Whether Amazon Inspector deep inspection is active in the account. If <code>TRUE</code> Amazon Inspector deep
         * inspection is active, if <code>FALSE</code> it is not active.
         * </p>
         * 
         * @param activateDeepInspection
         *        Whether Amazon Inspector deep inspection is active in the account. If <code>TRUE</code> Amazon
         *        Inspector deep inspection is active, if <code>FALSE</code> it is not active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activateDeepInspection(Boolean activateDeepInspection);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Boolean activateDeepInspection;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberAccountEc2DeepInspectionStatus model) {
            accountId(model.accountId);
            activateDeepInspection(model.activateDeepInspection);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Boolean getActivateDeepInspection() {
            return activateDeepInspection;
        }

        public final void setActivateDeepInspection(Boolean activateDeepInspection) {
            this.activateDeepInspection = activateDeepInspection;
        }

        @Override
        public final Builder activateDeepInspection(Boolean activateDeepInspection) {
            this.activateDeepInspection = activateDeepInspection;
            return this;
        }

        @Override
        public MemberAccountEc2DeepInspectionStatus build() {
            return new MemberAccountEc2DeepInspectionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
