/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details that define an aggregation based on container image layers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageLayerAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageLayerAggregation.Builder, ImageLayerAggregation> {
    private static final SdkField<List<StringFilter>> LAYER_HASHES_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("layerHashes")
            .getter(getter(ImageLayerAggregation::layerHashes))
            .setter(setter(Builder::layerHashes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerHashes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> REPOSITORIES_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("repositories")
            .getter(getter(ImageLayerAggregation::repositories))
            .setter(setter(Builder::repositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_IDS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("resourceIds")
            .getter(getter(ImageLayerAggregation::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ImageLayerAggregation::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ImageLayerAggregation::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_HASHES_FIELD,
            REPOSITORIES_FIELD, RESOURCE_IDS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StringFilter> layerHashes;

    private final List<StringFilter> repositories;

    private final List<StringFilter> resourceIds;

    private final String sortBy;

    private final String sortOrder;

    private ImageLayerAggregation(BuilderImpl builder) {
        this.layerHashes = builder.layerHashes;
        this.repositories = builder.repositories;
        this.resourceIds = builder.resourceIds;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the LayerHashes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLayerHashes() {
        return layerHashes != null && !(layerHashes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The hashes associated with the layers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLayerHashes} method.
     * </p>
     * 
     * @return The hashes associated with the layers.
     */
    public final List<StringFilter> layerHashes() {
        return layerHashes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Repositories property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepositories() {
        return repositories != null && !(repositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The repository associated with the container image hosting the layers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositories} method.
     * </p>
     * 
     * @return The repository associated with the container image hosting the layers.
     */
    public final List<StringFilter> repositories() {
        return repositories;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the container image layer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIds} method.
     * </p>
     * 
     * @return The ID of the container image layer.
     */
    public final List<StringFilter> resourceIds() {
        return resourceIds;
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ImageLayerSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see ImageLayerSortBy
     */
    public final ImageLayerSortBy sortBy() {
        return ImageLayerSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ImageLayerSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see ImageLayerSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLayerHashes() ? layerHashes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositories() ? repositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIds() ? resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageLayerAggregation)) {
            return false;
        }
        ImageLayerAggregation other = (ImageLayerAggregation) obj;
        return hasLayerHashes() == other.hasLayerHashes() && Objects.equals(layerHashes(), other.layerHashes())
                && hasRepositories() == other.hasRepositories() && Objects.equals(repositories(), other.repositories())
                && hasResourceIds() == other.hasResourceIds() && Objects.equals(resourceIds(), other.resourceIds())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageLayerAggregation").add("LayerHashes", hasLayerHashes() ? layerHashes() : null)
                .add("Repositories", hasRepositories() ? repositories() : null)
                .add("ResourceIds", hasResourceIds() ? resourceIds() : null).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "layerHashes":
            return Optional.ofNullable(clazz.cast(layerHashes()));
        case "repositories":
            return Optional.ofNullable(clazz.cast(repositories()));
        case "resourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageLayerAggregation, T> g) {
        return obj -> g.apply((ImageLayerAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageLayerAggregation> {
        /**
         * <p>
         * The hashes associated with the layers.
         * </p>
         * 
         * @param layerHashes
         *        The hashes associated with the layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerHashes(Collection<StringFilter> layerHashes);

        /**
         * <p>
         * The hashes associated with the layers.
         * </p>
         * 
         * @param layerHashes
         *        The hashes associated with the layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerHashes(StringFilter... layerHashes);

        /**
         * <p>
         * The hashes associated with the layers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #layerHashes(List<StringFilter>)}.
         * 
         * @param layerHashes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layerHashes(java.util.Collection<StringFilter>)
         */
        Builder layerHashes(Consumer<StringFilter.Builder>... layerHashes);

        /**
         * <p>
         * The repository associated with the container image hosting the layers.
         * </p>
         * 
         * @param repositories
         *        The repository associated with the container image hosting the layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(Collection<StringFilter> repositories);

        /**
         * <p>
         * The repository associated with the container image hosting the layers.
         * </p>
         * 
         * @param repositories
         *        The repository associated with the container image hosting the layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(StringFilter... repositories);

        /**
         * <p>
         * The repository associated with the container image hosting the layers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #repositories(List<StringFilter>)}.
         * 
         * @param repositories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositories(java.util.Collection<StringFilter>)
         */
        Builder repositories(Consumer<StringFilter.Builder>... repositories);

        /**
         * <p>
         * The ID of the container image layer.
         * </p>
         * 
         * @param resourceIds
         *        The ID of the container image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<StringFilter> resourceIds);

        /**
         * <p>
         * The ID of the container image layer.
         * </p>
         * 
         * @param resourceIds
         *        The ID of the container image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(StringFilter... resourceIds);

        /**
         * <p>
         * The ID of the container image layer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceIds(List<StringFilter>)}.
         * 
         * @param resourceIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIds(java.util.Collection<StringFilter>)
         */
        Builder resourceIds(Consumer<StringFilter.Builder>... resourceIds);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see ImageLayerSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageLayerSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see ImageLayerSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageLayerSortBy
         */
        Builder sortBy(ImageLayerSortBy sortBy);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private List<StringFilter> layerHashes = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> repositories = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageLayerAggregation model) {
            layerHashes(model.layerHashes);
            repositories(model.repositories);
            resourceIds(model.resourceIds);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getLayerHashes() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.layerHashes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayerHashes(Collection<StringFilter.BuilderImpl> layerHashes) {
            this.layerHashes = StringFilterListCopier.copyFromBuilder(layerHashes);
        }

        @Override
        public final Builder layerHashes(Collection<StringFilter> layerHashes) {
            this.layerHashes = StringFilterListCopier.copy(layerHashes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerHashes(StringFilter... layerHashes) {
            layerHashes(Arrays.asList(layerHashes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerHashes(Consumer<StringFilter.Builder>... layerHashes) {
            layerHashes(Stream.of(layerHashes).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getRepositories() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.repositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositories(Collection<StringFilter.BuilderImpl> repositories) {
            this.repositories = StringFilterListCopier.copyFromBuilder(repositories);
        }

        @Override
        public final Builder repositories(Collection<StringFilter> repositories) {
            this.repositories = StringFilterListCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(StringFilter... repositories) {
            repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<StringFilter.Builder>... repositories) {
            repositories(Stream.of(repositories).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIds(Collection<StringFilter.BuilderImpl> resourceIds) {
            this.resourceIds = StringFilterListCopier.copyFromBuilder(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<StringFilter> resourceIds) {
            this.resourceIds = StringFilterListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(StringFilter... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(Consumer<StringFilter.Builder>... resourceIds) {
            resourceIds(Stream.of(resourceIds).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ImageLayerSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public ImageLayerAggregation build() {
            return new ImageLayerAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
