/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetMemberEc2DeepInspectionStatusResponse extends Inspector2Response implements
        ToCopyableBuilder<BatchGetMemberEc2DeepInspectionStatusResponse.Builder, BatchGetMemberEc2DeepInspectionStatusResponse> {
    private static final SdkField<List<MemberAccountEc2DeepInspectionStatusState>> ACCOUNT_IDS_FIELD = SdkField
            .<List<MemberAccountEc2DeepInspectionStatusState>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(BatchGetMemberEc2DeepInspectionStatusResponse::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberAccountEc2DeepInspectionStatusState> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberAccountEc2DeepInspectionStatusState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FailedMemberAccountEc2DeepInspectionStatusState>> FAILED_ACCOUNT_IDS_FIELD = SdkField
            .<List<FailedMemberAccountEc2DeepInspectionStatusState>> builder(MarshallingType.LIST)
            .memberName("failedAccountIds")
            .getter(getter(BatchGetMemberEc2DeepInspectionStatusResponse::failedAccountIds))
            .setter(setter(Builder::failedAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedMemberAccountEc2DeepInspectionStatusState> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedMemberAccountEc2DeepInspectionStatusState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            FAILED_ACCOUNT_IDS_FIELD));

    private final List<MemberAccountEc2DeepInspectionStatusState> accountIds;

    private final List<FailedMemberAccountEc2DeepInspectionStatusState> failedAccountIds;

    private BatchGetMemberEc2DeepInspectionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.failedAccountIds = builder.failedAccountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that provide details on the activation status of Amazon Inspector deep inspection for each of
     * the requested accounts.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return An array of objects that provide details on the activation status of Amazon Inspector deep inspection for
     *         each of the requested accounts.
     * 
     * <pre><code> &lt;/p&gt; </code>
     */
    public final List<MemberAccountEc2DeepInspectionStatusState> accountIds() {
        return accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedAccountIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedAccountIds() {
        return failedAccountIds != null && !(failedAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that provide details on any accounts that failed to activate Amazon Inspector deep inspection
     * and why.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedAccountIds} method.
     * </p>
     * 
     * @return An array of objects that provide details on any accounts that failed to activate Amazon Inspector deep
     *         inspection and why.
     * 
     * <pre><code> &lt;/p&gt; </code>
     */
    public final List<FailedMemberAccountEc2DeepInspectionStatusState> failedAccountIds() {
        return failedAccountIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedAccountIds() ? failedAccountIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMemberEc2DeepInspectionStatusResponse)) {
            return false;
        }
        BatchGetMemberEc2DeepInspectionStatusResponse other = (BatchGetMemberEc2DeepInspectionStatusResponse) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasFailedAccountIds() == other.hasFailedAccountIds()
                && Objects.equals(failedAccountIds(), other.failedAccountIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetMemberEc2DeepInspectionStatusResponse")
                .add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("FailedAccountIds", hasFailedAccountIds() ? failedAccountIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "failedAccountIds":
            return Optional.ofNullable(clazz.cast(failedAccountIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMemberEc2DeepInspectionStatusResponse, T> g) {
        return obj -> g.apply((BatchGetMemberEc2DeepInspectionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetMemberEc2DeepInspectionStatusResponse> {
        /**
         * <p>
         * An array of objects that provide details on the activation status of Amazon Inspector deep inspection for
         * each of the requested accounts.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * @param accountIds
         *        An array of objects that provide details on the activation status of Amazon Inspector deep inspection
         *        for each of the requested accounts.
         * 
         *        <pre>
         * 
         *        <code> &lt;/p&gt; </code> @return Returns a reference to this object so that method calls can be
         *        chained together.
         */
        Builder accountIds(Collection<MemberAccountEc2DeepInspectionStatusState> accountIds);

        /**
         * <p>
         * An array of objects that provide details on the activation status of Amazon Inspector deep inspection for
         * each of the requested accounts.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * @param accountIds
         *        An array of objects that provide details on the activation status of Amazon Inspector deep inspection
         *        for each of the requested accounts.
         * 
         *        <pre>
         * 
         *        <code> &lt;/p&gt; </code> @return Returns a reference to this object so that method calls can be
         *        chained together.
         */
        Builder accountIds(MemberAccountEc2DeepInspectionStatusState... accountIds);

        /**
         * <p>
         * An array of objects that provide details on the activation status of Amazon Inspector deep inspection for
         * each of the requested accounts.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusState.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusState.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #accountIds(List<MemberAccountEc2DeepInspectionStatusState>)}.
         * 
         * @param accountIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatusState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountIds(java.util.Collection<MemberAccountEc2DeepInspectionStatusState>)
         */
        Builder accountIds(Consumer<MemberAccountEc2DeepInspectionStatusState.Builder>... accountIds);

        /**
         * <p>
         * An array of objects that provide details on any accounts that failed to activate Amazon Inspector deep
         * inspection and why.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * @param failedAccountIds
         *        An array of objects that provide details on any accounts that failed to activate Amazon Inspector deep
         *        inspection and why.
         * 
         *        <pre>
         * 
         *        <code> &lt;/p&gt; </code> @return Returns a reference to this object so that method calls can be
         *        chained together.
         */
        Builder failedAccountIds(Collection<FailedMemberAccountEc2DeepInspectionStatusState> failedAccountIds);

        /**
         * <p>
         * An array of objects that provide details on any accounts that failed to activate Amazon Inspector deep
         * inspection and why.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * @param failedAccountIds
         *        An array of objects that provide details on any accounts that failed to activate Amazon Inspector deep
         *        inspection and why.
         * 
         *        <pre>
         * 
         *        <code> &lt;/p&gt; </code> @return Returns a reference to this object so that method calls can be
         *        chained together.
         */
        Builder failedAccountIds(FailedMemberAccountEc2DeepInspectionStatusState... failedAccountIds);

        /**
         * <p>
         * An array of objects that provide details on any accounts that failed to activate Amazon Inspector deep
         * inspection and why.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #failedAccountIds(List<FailedMemberAccountEc2DeepInspectionStatusState>)}.
         * 
         * @param failedAccountIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedAccountIds(java.util.Collection<FailedMemberAccountEc2DeepInspectionStatusState>)
         */
        Builder failedAccountIds(Consumer<FailedMemberAccountEc2DeepInspectionStatusState.Builder>... failedAccountIds);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private List<MemberAccountEc2DeepInspectionStatusState> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<FailedMemberAccountEc2DeepInspectionStatusState> failedAccountIds = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMemberEc2DeepInspectionStatusResponse model) {
            super(model);
            accountIds(model.accountIds);
            failedAccountIds(model.failedAccountIds);
        }

        public final List<MemberAccountEc2DeepInspectionStatusState.Builder> getAccountIds() {
            List<MemberAccountEc2DeepInspectionStatusState.Builder> result = MemberAccountEc2DeepInspectionStatusStateListCopier
                    .copyToBuilder(this.accountIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountIds(Collection<MemberAccountEc2DeepInspectionStatusState.BuilderImpl> accountIds) {
            this.accountIds = MemberAccountEc2DeepInspectionStatusStateListCopier.copyFromBuilder(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<MemberAccountEc2DeepInspectionStatusState> accountIds) {
            this.accountIds = MemberAccountEc2DeepInspectionStatusStateListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(MemberAccountEc2DeepInspectionStatusState... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(Consumer<MemberAccountEc2DeepInspectionStatusState.Builder>... accountIds) {
            accountIds(Stream.of(accountIds)
                    .map(c -> MemberAccountEc2DeepInspectionStatusState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FailedMemberAccountEc2DeepInspectionStatusState.Builder> getFailedAccountIds() {
            List<FailedMemberAccountEc2DeepInspectionStatusState.Builder> result = FailedMemberAccountEc2DeepInspectionStatusStateListCopier
                    .copyToBuilder(this.failedAccountIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAccountIds(
                Collection<FailedMemberAccountEc2DeepInspectionStatusState.BuilderImpl> failedAccountIds) {
            this.failedAccountIds = FailedMemberAccountEc2DeepInspectionStatusStateListCopier.copyFromBuilder(failedAccountIds);
        }

        @Override
        public final Builder failedAccountIds(Collection<FailedMemberAccountEc2DeepInspectionStatusState> failedAccountIds) {
            this.failedAccountIds = FailedMemberAccountEc2DeepInspectionStatusStateListCopier.copy(failedAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAccountIds(FailedMemberAccountEc2DeepInspectionStatusState... failedAccountIds) {
            failedAccountIds(Arrays.asList(failedAccountIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAccountIds(
                Consumer<FailedMemberAccountEc2DeepInspectionStatusState.Builder>... failedAccountIds) {
            failedAccountIds(Stream.of(failedAccountIds)
                    .map(c -> FailedMemberAccountEc2DeepInspectionStatusState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetMemberEc2DeepInspectionStatusResponse build() {
            return new BatchGetMemberEc2DeepInspectionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
