/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an aggregation request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregationRequest.Builder, AggregationRequest> {
    private static final SdkField<AccountAggregation> ACCOUNT_AGGREGATION_FIELD = SdkField
            .<AccountAggregation> builder(MarshallingType.SDK_POJO).memberName("accountAggregation")
            .getter(getter(AggregationRequest::accountAggregation)).setter(setter(Builder::accountAggregation))
            .constructor(AccountAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountAggregation").build())
            .build();

    private static final SdkField<AmiAggregation> AMI_AGGREGATION_FIELD = SdkField
            .<AmiAggregation> builder(MarshallingType.SDK_POJO).memberName("amiAggregation")
            .getter(getter(AggregationRequest::amiAggregation)).setter(setter(Builder::amiAggregation))
            .constructor(AmiAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiAggregation").build()).build();

    private static final SdkField<AwsEcrContainerAggregation> AWS_ECR_CONTAINER_AGGREGATION_FIELD = SdkField
            .<AwsEcrContainerAggregation> builder(MarshallingType.SDK_POJO)
            .memberName("awsEcrContainerAggregation")
            .getter(getter(AggregationRequest::awsEcrContainerAggregation))
            .setter(setter(Builder::awsEcrContainerAggregation))
            .constructor(AwsEcrContainerAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsEcrContainerAggregation").build())
            .build();

    private static final SdkField<Ec2InstanceAggregation> EC2_INSTANCE_AGGREGATION_FIELD = SdkField
            .<Ec2InstanceAggregation> builder(MarshallingType.SDK_POJO).memberName("ec2InstanceAggregation")
            .getter(getter(AggregationRequest::ec2InstanceAggregation)).setter(setter(Builder::ec2InstanceAggregation))
            .constructor(Ec2InstanceAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceAggregation").build())
            .build();

    private static final SdkField<FindingTypeAggregation> FINDING_TYPE_AGGREGATION_FIELD = SdkField
            .<FindingTypeAggregation> builder(MarshallingType.SDK_POJO).memberName("findingTypeAggregation")
            .getter(getter(AggregationRequest::findingTypeAggregation)).setter(setter(Builder::findingTypeAggregation))
            .constructor(FindingTypeAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingTypeAggregation").build())
            .build();

    private static final SdkField<ImageLayerAggregation> IMAGE_LAYER_AGGREGATION_FIELD = SdkField
            .<ImageLayerAggregation> builder(MarshallingType.SDK_POJO).memberName("imageLayerAggregation")
            .getter(getter(AggregationRequest::imageLayerAggregation)).setter(setter(Builder::imageLayerAggregation))
            .constructor(ImageLayerAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageLayerAggregation").build())
            .build();

    private static final SdkField<LambdaFunctionAggregation> LAMBDA_FUNCTION_AGGREGATION_FIELD = SdkField
            .<LambdaFunctionAggregation> builder(MarshallingType.SDK_POJO).memberName("lambdaFunctionAggregation")
            .getter(getter(AggregationRequest::lambdaFunctionAggregation)).setter(setter(Builder::lambdaFunctionAggregation))
            .constructor(LambdaFunctionAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionAggregation").build())
            .build();

    private static final SdkField<LambdaLayerAggregation> LAMBDA_LAYER_AGGREGATION_FIELD = SdkField
            .<LambdaLayerAggregation> builder(MarshallingType.SDK_POJO).memberName("lambdaLayerAggregation")
            .getter(getter(AggregationRequest::lambdaLayerAggregation)).setter(setter(Builder::lambdaLayerAggregation))
            .constructor(LambdaLayerAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaLayerAggregation").build())
            .build();

    private static final SdkField<PackageAggregation> PACKAGE_AGGREGATION_FIELD = SdkField
            .<PackageAggregation> builder(MarshallingType.SDK_POJO).memberName("packageAggregation")
            .getter(getter(AggregationRequest::packageAggregation)).setter(setter(Builder::packageAggregation))
            .constructor(PackageAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageAggregation").build())
            .build();

    private static final SdkField<RepositoryAggregation> REPOSITORY_AGGREGATION_FIELD = SdkField
            .<RepositoryAggregation> builder(MarshallingType.SDK_POJO).memberName("repositoryAggregation")
            .getter(getter(AggregationRequest::repositoryAggregation)).setter(setter(Builder::repositoryAggregation))
            .constructor(RepositoryAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryAggregation").build())
            .build();

    private static final SdkField<TitleAggregation> TITLE_AGGREGATION_FIELD = SdkField
            .<TitleAggregation> builder(MarshallingType.SDK_POJO).memberName("titleAggregation")
            .getter(getter(AggregationRequest::titleAggregation)).setter(setter(Builder::titleAggregation))
            .constructor(TitleAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("titleAggregation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_AGGREGATION_FIELD,
            AMI_AGGREGATION_FIELD, AWS_ECR_CONTAINER_AGGREGATION_FIELD, EC2_INSTANCE_AGGREGATION_FIELD,
            FINDING_TYPE_AGGREGATION_FIELD, IMAGE_LAYER_AGGREGATION_FIELD, LAMBDA_FUNCTION_AGGREGATION_FIELD,
            LAMBDA_LAYER_AGGREGATION_FIELD, PACKAGE_AGGREGATION_FIELD, REPOSITORY_AGGREGATION_FIELD, TITLE_AGGREGATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AccountAggregation accountAggregation;

    private final AmiAggregation amiAggregation;

    private final AwsEcrContainerAggregation awsEcrContainerAggregation;

    private final Ec2InstanceAggregation ec2InstanceAggregation;

    private final FindingTypeAggregation findingTypeAggregation;

    private final ImageLayerAggregation imageLayerAggregation;

    private final LambdaFunctionAggregation lambdaFunctionAggregation;

    private final LambdaLayerAggregation lambdaLayerAggregation;

    private final PackageAggregation packageAggregation;

    private final RepositoryAggregation repositoryAggregation;

    private final TitleAggregation titleAggregation;

    private final Type type;

    private AggregationRequest(BuilderImpl builder) {
        this.accountAggregation = builder.accountAggregation;
        this.amiAggregation = builder.amiAggregation;
        this.awsEcrContainerAggregation = builder.awsEcrContainerAggregation;
        this.ec2InstanceAggregation = builder.ec2InstanceAggregation;
        this.findingTypeAggregation = builder.findingTypeAggregation;
        this.imageLayerAggregation = builder.imageLayerAggregation;
        this.lambdaFunctionAggregation = builder.lambdaFunctionAggregation;
        this.lambdaLayerAggregation = builder.lambdaLayerAggregation;
        this.packageAggregation = builder.packageAggregation;
        this.repositoryAggregation = builder.repositoryAggregation;
        this.titleAggregation = builder.titleAggregation;
        this.type = builder.type;
    }

    /**
     * <p>
     * An object that contains details about an aggregation request based on Amazon Web Services account IDs.
     * </p>
     * 
     * @return An object that contains details about an aggregation request based on Amazon Web Services account IDs.
     */
    public final AccountAggregation accountAggregation() {
        return accountAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).
     * </p>
     * 
     * @return An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).
     */
    public final AmiAggregation amiAggregation() {
        return amiAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation request based on Amazon ECR container images.
     * </p>
     * 
     * @return An object that contains details about an aggregation request based on Amazon ECR container images.
     */
    public final AwsEcrContainerAggregation awsEcrContainerAggregation() {
        return awsEcrContainerAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation request based on Amazon EC2 instances.
     * </p>
     * 
     * @return An object that contains details about an aggregation request based on Amazon EC2 instances.
     */
    public final Ec2InstanceAggregation ec2InstanceAggregation() {
        return ec2InstanceAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation request based on finding types.
     * </p>
     * 
     * @return An object that contains details about an aggregation request based on finding types.
     */
    public final FindingTypeAggregation findingTypeAggregation() {
        return findingTypeAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation request based on container image layers.
     * </p>
     * 
     * @return An object that contains details about an aggregation request based on container image layers.
     */
    public final ImageLayerAggregation imageLayerAggregation() {
        return imageLayerAggregation;
    }

    /**
     * <p>
     * Returns an object with findings aggregated by AWS Lambda function.
     * </p>
     * 
     * @return Returns an object with findings aggregated by AWS Lambda function.
     */
    public final LambdaFunctionAggregation lambdaFunctionAggregation() {
        return lambdaFunctionAggregation;
    }

    /**
     * <p>
     * Returns an object with findings aggregated by AWS Lambda layer.
     * </p>
     * 
     * @return Returns an object with findings aggregated by AWS Lambda layer.
     */
    public final LambdaLayerAggregation lambdaLayerAggregation() {
        return lambdaLayerAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation request based on operating system package type.
     * </p>
     * 
     * @return An object that contains details about an aggregation request based on operating system package type.
     */
    public final PackageAggregation packageAggregation() {
        return packageAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation request based on Amazon ECR repositories.
     * </p>
     * 
     * @return An object that contains details about an aggregation request based on Amazon ECR repositories.
     */
    public final RepositoryAggregation repositoryAggregation() {
        return repositoryAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation request based on finding title.
     * </p>
     * 
     * @return An object that contains details about an aggregation request based on finding title.
     */
    public final TitleAggregation titleAggregation() {
        return titleAggregation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(amiAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(awsEcrContainerAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(findingTypeAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(imageLayerAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaLayerAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(packageAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(titleAggregation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationRequest)) {
            return false;
        }
        AggregationRequest other = (AggregationRequest) obj;
        return Objects.equals(accountAggregation(), other.accountAggregation())
                && Objects.equals(amiAggregation(), other.amiAggregation())
                && Objects.equals(awsEcrContainerAggregation(), other.awsEcrContainerAggregation())
                && Objects.equals(ec2InstanceAggregation(), other.ec2InstanceAggregation())
                && Objects.equals(findingTypeAggregation(), other.findingTypeAggregation())
                && Objects.equals(imageLayerAggregation(), other.imageLayerAggregation())
                && Objects.equals(lambdaFunctionAggregation(), other.lambdaFunctionAggregation())
                && Objects.equals(lambdaLayerAggregation(), other.lambdaLayerAggregation())
                && Objects.equals(packageAggregation(), other.packageAggregation())
                && Objects.equals(repositoryAggregation(), other.repositoryAggregation())
                && Objects.equals(titleAggregation(), other.titleAggregation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregationRequest").add("AccountAggregation", accountAggregation())
                .add("AmiAggregation", amiAggregation()).add("AwsEcrContainerAggregation", awsEcrContainerAggregation())
                .add("Ec2InstanceAggregation", ec2InstanceAggregation()).add("FindingTypeAggregation", findingTypeAggregation())
                .add("ImageLayerAggregation", imageLayerAggregation())
                .add("LambdaFunctionAggregation", lambdaFunctionAggregation())
                .add("LambdaLayerAggregation", lambdaLayerAggregation()).add("PackageAggregation", packageAggregation())
                .add("RepositoryAggregation", repositoryAggregation()).add("TitleAggregation", titleAggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountAggregation":
            return Optional.ofNullable(clazz.cast(accountAggregation()));
        case "amiAggregation":
            return Optional.ofNullable(clazz.cast(amiAggregation()));
        case "awsEcrContainerAggregation":
            return Optional.ofNullable(clazz.cast(awsEcrContainerAggregation()));
        case "ec2InstanceAggregation":
            return Optional.ofNullable(clazz.cast(ec2InstanceAggregation()));
        case "findingTypeAggregation":
            return Optional.ofNullable(clazz.cast(findingTypeAggregation()));
        case "imageLayerAggregation":
            return Optional.ofNullable(clazz.cast(imageLayerAggregation()));
        case "lambdaFunctionAggregation":
            return Optional.ofNullable(clazz.cast(lambdaFunctionAggregation()));
        case "lambdaLayerAggregation":
            return Optional.ofNullable(clazz.cast(lambdaLayerAggregation()));
        case "packageAggregation":
            return Optional.ofNullable(clazz.cast(packageAggregation()));
        case "repositoryAggregation":
            return Optional.ofNullable(clazz.cast(repositoryAggregation()));
        case "titleAggregation":
            return Optional.ofNullable(clazz.cast(titleAggregation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #accountAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on Amazon Web Services account IDs.
     * </p>
     * 
     * @param accountAggregation
     *        An object that contains details about an aggregation request based on Amazon Web Services account IDs.
     */
    public static AggregationRequest fromAccountAggregation(AccountAggregation accountAggregation) {
        return builder().accountAggregation(accountAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #accountAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on Amazon Web Services account IDs.
     * </p>
     * 
     * @param accountAggregation
     *        An object that contains details about an aggregation request based on Amazon Web Services account IDs.
     */
    public static AggregationRequest fromAccountAggregation(Consumer<AccountAggregation.Builder> accountAggregation) {
        AccountAggregation.Builder builder = AccountAggregation.builder();
        accountAggregation.accept(builder);
        return fromAccountAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #amiAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).
     * </p>
     * 
     * @param amiAggregation
     *        An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).
     */
    public static AggregationRequest fromAmiAggregation(AmiAggregation amiAggregation) {
        return builder().amiAggregation(amiAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #amiAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).
     * </p>
     * 
     * @param amiAggregation
     *        An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).
     */
    public static AggregationRequest fromAmiAggregation(Consumer<AmiAggregation.Builder> amiAggregation) {
        AmiAggregation.Builder builder = AmiAggregation.builder();
        amiAggregation.accept(builder);
        return fromAmiAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #awsEcrContainerAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on Amazon ECR container images.
     * </p>
     * 
     * @param awsEcrContainerAggregation
     *        An object that contains details about an aggregation request based on Amazon ECR container images.
     */
    public static AggregationRequest fromAwsEcrContainerAggregation(AwsEcrContainerAggregation awsEcrContainerAggregation) {
        return builder().awsEcrContainerAggregation(awsEcrContainerAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #awsEcrContainerAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on Amazon ECR container images.
     * </p>
     * 
     * @param awsEcrContainerAggregation
     *        An object that contains details about an aggregation request based on Amazon ECR container images.
     */
    public static AggregationRequest fromAwsEcrContainerAggregation(
            Consumer<AwsEcrContainerAggregation.Builder> awsEcrContainerAggregation) {
        AwsEcrContainerAggregation.Builder builder = AwsEcrContainerAggregation.builder();
        awsEcrContainerAggregation.accept(builder);
        return fromAwsEcrContainerAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ec2InstanceAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on Amazon EC2 instances.
     * </p>
     * 
     * @param ec2InstanceAggregation
     *        An object that contains details about an aggregation request based on Amazon EC2 instances.
     */
    public static AggregationRequest fromEc2InstanceAggregation(Ec2InstanceAggregation ec2InstanceAggregation) {
        return builder().ec2InstanceAggregation(ec2InstanceAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #ec2InstanceAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on Amazon EC2 instances.
     * </p>
     * 
     * @param ec2InstanceAggregation
     *        An object that contains details about an aggregation request based on Amazon EC2 instances.
     */
    public static AggregationRequest fromEc2InstanceAggregation(Consumer<Ec2InstanceAggregation.Builder> ec2InstanceAggregation) {
        Ec2InstanceAggregation.Builder builder = Ec2InstanceAggregation.builder();
        ec2InstanceAggregation.accept(builder);
        return fromEc2InstanceAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #findingTypeAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on finding types.
     * </p>
     * 
     * @param findingTypeAggregation
     *        An object that contains details about an aggregation request based on finding types.
     */
    public static AggregationRequest fromFindingTypeAggregation(FindingTypeAggregation findingTypeAggregation) {
        return builder().findingTypeAggregation(findingTypeAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #findingTypeAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on finding types.
     * </p>
     * 
     * @param findingTypeAggregation
     *        An object that contains details about an aggregation request based on finding types.
     */
    public static AggregationRequest fromFindingTypeAggregation(Consumer<FindingTypeAggregation.Builder> findingTypeAggregation) {
        FindingTypeAggregation.Builder builder = FindingTypeAggregation.builder();
        findingTypeAggregation.accept(builder);
        return fromFindingTypeAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #imageLayerAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on container image layers.
     * </p>
     * 
     * @param imageLayerAggregation
     *        An object that contains details about an aggregation request based on container image layers.
     */
    public static AggregationRequest fromImageLayerAggregation(ImageLayerAggregation imageLayerAggregation) {
        return builder().imageLayerAggregation(imageLayerAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #imageLayerAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on container image layers.
     * </p>
     * 
     * @param imageLayerAggregation
     *        An object that contains details about an aggregation request based on container image layers.
     */
    public static AggregationRequest fromImageLayerAggregation(Consumer<ImageLayerAggregation.Builder> imageLayerAggregation) {
        ImageLayerAggregation.Builder builder = ImageLayerAggregation.builder();
        imageLayerAggregation.accept(builder);
        return fromImageLayerAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lambdaFunctionAggregation()} initialized to the given value.
     *
     * <p>
     * Returns an object with findings aggregated by AWS Lambda function.
     * </p>
     * 
     * @param lambdaFunctionAggregation
     *        Returns an object with findings aggregated by AWS Lambda function.
     */
    public static AggregationRequest fromLambdaFunctionAggregation(LambdaFunctionAggregation lambdaFunctionAggregation) {
        return builder().lambdaFunctionAggregation(lambdaFunctionAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #lambdaFunctionAggregation()} initialized to the given value.
     *
     * <p>
     * Returns an object with findings aggregated by AWS Lambda function.
     * </p>
     * 
     * @param lambdaFunctionAggregation
     *        Returns an object with findings aggregated by AWS Lambda function.
     */
    public static AggregationRequest fromLambdaFunctionAggregation(
            Consumer<LambdaFunctionAggregation.Builder> lambdaFunctionAggregation) {
        LambdaFunctionAggregation.Builder builder = LambdaFunctionAggregation.builder();
        lambdaFunctionAggregation.accept(builder);
        return fromLambdaFunctionAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lambdaLayerAggregation()} initialized to the given value.
     *
     * <p>
     * Returns an object with findings aggregated by AWS Lambda layer.
     * </p>
     * 
     * @param lambdaLayerAggregation
     *        Returns an object with findings aggregated by AWS Lambda layer.
     */
    public static AggregationRequest fromLambdaLayerAggregation(LambdaLayerAggregation lambdaLayerAggregation) {
        return builder().lambdaLayerAggregation(lambdaLayerAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #lambdaLayerAggregation()} initialized to the given value.
     *
     * <p>
     * Returns an object with findings aggregated by AWS Lambda layer.
     * </p>
     * 
     * @param lambdaLayerAggregation
     *        Returns an object with findings aggregated by AWS Lambda layer.
     */
    public static AggregationRequest fromLambdaLayerAggregation(Consumer<LambdaLayerAggregation.Builder> lambdaLayerAggregation) {
        LambdaLayerAggregation.Builder builder = LambdaLayerAggregation.builder();
        lambdaLayerAggregation.accept(builder);
        return fromLambdaLayerAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #packageAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on operating system package type.
     * </p>
     * 
     * @param packageAggregation
     *        An object that contains details about an aggregation request based on operating system package type.
     */
    public static AggregationRequest fromPackageAggregation(PackageAggregation packageAggregation) {
        return builder().packageAggregation(packageAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #packageAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on operating system package type.
     * </p>
     * 
     * @param packageAggregation
     *        An object that contains details about an aggregation request based on operating system package type.
     */
    public static AggregationRequest fromPackageAggregation(Consumer<PackageAggregation.Builder> packageAggregation) {
        PackageAggregation.Builder builder = PackageAggregation.builder();
        packageAggregation.accept(builder);
        return fromPackageAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #repositoryAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on Amazon ECR repositories.
     * </p>
     * 
     * @param repositoryAggregation
     *        An object that contains details about an aggregation request based on Amazon ECR repositories.
     */
    public static AggregationRequest fromRepositoryAggregation(RepositoryAggregation repositoryAggregation) {
        return builder().repositoryAggregation(repositoryAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #repositoryAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on Amazon ECR repositories.
     * </p>
     * 
     * @param repositoryAggregation
     *        An object that contains details about an aggregation request based on Amazon ECR repositories.
     */
    public static AggregationRequest fromRepositoryAggregation(Consumer<RepositoryAggregation.Builder> repositoryAggregation) {
        RepositoryAggregation.Builder builder = RepositoryAggregation.builder();
        repositoryAggregation.accept(builder);
        return fromRepositoryAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #titleAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on finding title.
     * </p>
     * 
     * @param titleAggregation
     *        An object that contains details about an aggregation request based on finding title.
     */
    public static AggregationRequest fromTitleAggregation(TitleAggregation titleAggregation) {
        return builder().titleAggregation(titleAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #titleAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation request based on finding title.
     * </p>
     * 
     * @param titleAggregation
     *        An object that contains details about an aggregation request based on finding title.
     */
    public static AggregationRequest fromTitleAggregation(Consumer<TitleAggregation.Builder> titleAggregation) {
        TitleAggregation.Builder builder = TitleAggregation.builder();
        titleAggregation.accept(builder);
        return fromTitleAggregation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregationRequest, T> g) {
        return obj -> g.apply((AggregationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregationRequest> {
        /**
         * <p>
         * An object that contains details about an aggregation request based on Amazon Web Services account IDs.
         * </p>
         * 
         * @param accountAggregation
         *        An object that contains details about an aggregation request based on Amazon Web Services account IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAggregation(AccountAggregation accountAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation request based on Amazon Web Services account IDs.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountAggregation.Builder} avoiding the
         * need to create one manually via {@link AccountAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountAggregation.Builder#build()} is called immediately and its
         * result is passed to {@link #accountAggregation(AccountAggregation)}.
         * 
         * @param accountAggregation
         *        a consumer that will call methods on {@link AccountAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountAggregation(AccountAggregation)
         */
        default Builder accountAggregation(Consumer<AccountAggregation.Builder> accountAggregation) {
            return accountAggregation(AccountAggregation.builder().applyMutation(accountAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).
         * </p>
         * 
         * @param amiAggregation
         *        An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiAggregation(AmiAggregation amiAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).
         * </p>
         * This is a convenience method that creates an instance of the {@link AmiAggregation.Builder} avoiding the need
         * to create one manually via {@link AmiAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmiAggregation.Builder#build()} is called immediately and its
         * result is passed to {@link #amiAggregation(AmiAggregation)}.
         * 
         * @param amiAggregation
         *        a consumer that will call methods on {@link AmiAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amiAggregation(AmiAggregation)
         */
        default Builder amiAggregation(Consumer<AmiAggregation.Builder> amiAggregation) {
            return amiAggregation(AmiAggregation.builder().applyMutation(amiAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation request based on Amazon ECR container images.
         * </p>
         * 
         * @param awsEcrContainerAggregation
         *        An object that contains details about an aggregation request based on Amazon ECR container images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEcrContainerAggregation(AwsEcrContainerAggregation awsEcrContainerAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation request based on Amazon ECR container images.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEcrContainerAggregation.Builder}
         * avoiding the need to create one manually via {@link AwsEcrContainerAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcrContainerAggregation.Builder#build()} is called immediately
         * and its result is passed to {@link #awsEcrContainerAggregation(AwsEcrContainerAggregation)}.
         * 
         * @param awsEcrContainerAggregation
         *        a consumer that will call methods on {@link AwsEcrContainerAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEcrContainerAggregation(AwsEcrContainerAggregation)
         */
        default Builder awsEcrContainerAggregation(Consumer<AwsEcrContainerAggregation.Builder> awsEcrContainerAggregation) {
            return awsEcrContainerAggregation(AwsEcrContainerAggregation.builder().applyMutation(awsEcrContainerAggregation)
                    .build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation request based on Amazon EC2 instances.
         * </p>
         * 
         * @param ec2InstanceAggregation
         *        An object that contains details about an aggregation request based on Amazon EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceAggregation(Ec2InstanceAggregation ec2InstanceAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation request based on Amazon EC2 instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2InstanceAggregation.Builder} avoiding
         * the need to create one manually via {@link Ec2InstanceAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2InstanceAggregation.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2InstanceAggregation(Ec2InstanceAggregation)}.
         * 
         * @param ec2InstanceAggregation
         *        a consumer that will call methods on {@link Ec2InstanceAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceAggregation(Ec2InstanceAggregation)
         */
        default Builder ec2InstanceAggregation(Consumer<Ec2InstanceAggregation.Builder> ec2InstanceAggregation) {
            return ec2InstanceAggregation(Ec2InstanceAggregation.builder().applyMutation(ec2InstanceAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation request based on finding types.
         * </p>
         * 
         * @param findingTypeAggregation
         *        An object that contains details about an aggregation request based on finding types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingTypeAggregation(FindingTypeAggregation findingTypeAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation request based on finding types.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingTypeAggregation.Builder} avoiding
         * the need to create one manually via {@link FindingTypeAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingTypeAggregation.Builder#build()} is called immediately and
         * its result is passed to {@link #findingTypeAggregation(FindingTypeAggregation)}.
         * 
         * @param findingTypeAggregation
         *        a consumer that will call methods on {@link FindingTypeAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingTypeAggregation(FindingTypeAggregation)
         */
        default Builder findingTypeAggregation(Consumer<FindingTypeAggregation.Builder> findingTypeAggregation) {
            return findingTypeAggregation(FindingTypeAggregation.builder().applyMutation(findingTypeAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation request based on container image layers.
         * </p>
         * 
         * @param imageLayerAggregation
         *        An object that contains details about an aggregation request based on container image layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageLayerAggregation(ImageLayerAggregation imageLayerAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation request based on container image layers.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageLayerAggregation.Builder} avoiding
         * the need to create one manually via {@link ImageLayerAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageLayerAggregation.Builder#build()} is called immediately and
         * its result is passed to {@link #imageLayerAggregation(ImageLayerAggregation)}.
         * 
         * @param imageLayerAggregation
         *        a consumer that will call methods on {@link ImageLayerAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageLayerAggregation(ImageLayerAggregation)
         */
        default Builder imageLayerAggregation(Consumer<ImageLayerAggregation.Builder> imageLayerAggregation) {
            return imageLayerAggregation(ImageLayerAggregation.builder().applyMutation(imageLayerAggregation).build());
        }

        /**
         * <p>
         * Returns an object with findings aggregated by AWS Lambda function.
         * </p>
         * 
         * @param lambdaFunctionAggregation
         *        Returns an object with findings aggregated by AWS Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionAggregation(LambdaFunctionAggregation lambdaFunctionAggregation);

        /**
         * <p>
         * Returns an object with findings aggregated by AWS Lambda function.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaFunctionAggregation.Builder}
         * avoiding the need to create one manually via {@link LambdaFunctionAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaFunctionAggregation.Builder#build()} is called immediately
         * and its result is passed to {@link #lambdaFunctionAggregation(LambdaFunctionAggregation)}.
         * 
         * @param lambdaFunctionAggregation
         *        a consumer that will call methods on {@link LambdaFunctionAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionAggregation(LambdaFunctionAggregation)
         */
        default Builder lambdaFunctionAggregation(Consumer<LambdaFunctionAggregation.Builder> lambdaFunctionAggregation) {
            return lambdaFunctionAggregation(LambdaFunctionAggregation.builder().applyMutation(lambdaFunctionAggregation).build());
        }

        /**
         * <p>
         * Returns an object with findings aggregated by AWS Lambda layer.
         * </p>
         * 
         * @param lambdaLayerAggregation
         *        Returns an object with findings aggregated by AWS Lambda layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaLayerAggregation(LambdaLayerAggregation lambdaLayerAggregation);

        /**
         * <p>
         * Returns an object with findings aggregated by AWS Lambda layer.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaLayerAggregation.Builder} avoiding
         * the need to create one manually via {@link LambdaLayerAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaLayerAggregation.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaLayerAggregation(LambdaLayerAggregation)}.
         * 
         * @param lambdaLayerAggregation
         *        a consumer that will call methods on {@link LambdaLayerAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaLayerAggregation(LambdaLayerAggregation)
         */
        default Builder lambdaLayerAggregation(Consumer<LambdaLayerAggregation.Builder> lambdaLayerAggregation) {
            return lambdaLayerAggregation(LambdaLayerAggregation.builder().applyMutation(lambdaLayerAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation request based on operating system package type.
         * </p>
         * 
         * @param packageAggregation
         *        An object that contains details about an aggregation request based on operating system package type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageAggregation(PackageAggregation packageAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation request based on operating system package type.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageAggregation.Builder} avoiding the
         * need to create one manually via {@link PackageAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageAggregation.Builder#build()} is called immediately and its
         * result is passed to {@link #packageAggregation(PackageAggregation)}.
         * 
         * @param packageAggregation
         *        a consumer that will call methods on {@link PackageAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageAggregation(PackageAggregation)
         */
        default Builder packageAggregation(Consumer<PackageAggregation.Builder> packageAggregation) {
            return packageAggregation(PackageAggregation.builder().applyMutation(packageAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation request based on Amazon ECR repositories.
         * </p>
         * 
         * @param repositoryAggregation
         *        An object that contains details about an aggregation request based on Amazon ECR repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryAggregation(RepositoryAggregation repositoryAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation request based on Amazon ECR repositories.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepositoryAggregation.Builder} avoiding
         * the need to create one manually via {@link RepositoryAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RepositoryAggregation.Builder#build()} is called immediately and
         * its result is passed to {@link #repositoryAggregation(RepositoryAggregation)}.
         * 
         * @param repositoryAggregation
         *        a consumer that will call methods on {@link RepositoryAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryAggregation(RepositoryAggregation)
         */
        default Builder repositoryAggregation(Consumer<RepositoryAggregation.Builder> repositoryAggregation) {
            return repositoryAggregation(RepositoryAggregation.builder().applyMutation(repositoryAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation request based on finding title.
         * </p>
         * 
         * @param titleAggregation
         *        An object that contains details about an aggregation request based on finding title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleAggregation(TitleAggregation titleAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation request based on finding title.
         * </p>
         * This is a convenience method that creates an instance of the {@link TitleAggregation.Builder} avoiding the
         * need to create one manually via {@link TitleAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TitleAggregation.Builder#build()} is called immediately and its
         * result is passed to {@link #titleAggregation(TitleAggregation)}.
         * 
         * @param titleAggregation
         *        a consumer that will call methods on {@link TitleAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #titleAggregation(TitleAggregation)
         */
        default Builder titleAggregation(Consumer<TitleAggregation.Builder> titleAggregation) {
            return titleAggregation(TitleAggregation.builder().applyMutation(titleAggregation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccountAggregation accountAggregation;

        private AmiAggregation amiAggregation;

        private AwsEcrContainerAggregation awsEcrContainerAggregation;

        private Ec2InstanceAggregation ec2InstanceAggregation;

        private FindingTypeAggregation findingTypeAggregation;

        private ImageLayerAggregation imageLayerAggregation;

        private LambdaFunctionAggregation lambdaFunctionAggregation;

        private LambdaLayerAggregation lambdaLayerAggregation;

        private PackageAggregation packageAggregation;

        private RepositoryAggregation repositoryAggregation;

        private TitleAggregation titleAggregation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationRequest model) {
            accountAggregation(model.accountAggregation);
            amiAggregation(model.amiAggregation);
            awsEcrContainerAggregation(model.awsEcrContainerAggregation);
            ec2InstanceAggregation(model.ec2InstanceAggregation);
            findingTypeAggregation(model.findingTypeAggregation);
            imageLayerAggregation(model.imageLayerAggregation);
            lambdaFunctionAggregation(model.lambdaFunctionAggregation);
            lambdaLayerAggregation(model.lambdaLayerAggregation);
            packageAggregation(model.packageAggregation);
            repositoryAggregation(model.repositoryAggregation);
            titleAggregation(model.titleAggregation);
        }

        public final AccountAggregation.Builder getAccountAggregation() {
            return accountAggregation != null ? accountAggregation.toBuilder() : null;
        }

        public final void setAccountAggregation(AccountAggregation.BuilderImpl accountAggregation) {
            Object oldValue = this.accountAggregation;
            this.accountAggregation = accountAggregation != null ? accountAggregation.build() : null;
            handleUnionValueChange(Type.ACCOUNT_AGGREGATION, oldValue, this.accountAggregation);
        }

        @Override
        public final Builder accountAggregation(AccountAggregation accountAggregation) {
            Object oldValue = this.accountAggregation;
            this.accountAggregation = accountAggregation;
            handleUnionValueChange(Type.ACCOUNT_AGGREGATION, oldValue, this.accountAggregation);
            return this;
        }

        public final AmiAggregation.Builder getAmiAggregation() {
            return amiAggregation != null ? amiAggregation.toBuilder() : null;
        }

        public final void setAmiAggregation(AmiAggregation.BuilderImpl amiAggregation) {
            Object oldValue = this.amiAggregation;
            this.amiAggregation = amiAggregation != null ? amiAggregation.build() : null;
            handleUnionValueChange(Type.AMI_AGGREGATION, oldValue, this.amiAggregation);
        }

        @Override
        public final Builder amiAggregation(AmiAggregation amiAggregation) {
            Object oldValue = this.amiAggregation;
            this.amiAggregation = amiAggregation;
            handleUnionValueChange(Type.AMI_AGGREGATION, oldValue, this.amiAggregation);
            return this;
        }

        public final AwsEcrContainerAggregation.Builder getAwsEcrContainerAggregation() {
            return awsEcrContainerAggregation != null ? awsEcrContainerAggregation.toBuilder() : null;
        }

        public final void setAwsEcrContainerAggregation(AwsEcrContainerAggregation.BuilderImpl awsEcrContainerAggregation) {
            Object oldValue = this.awsEcrContainerAggregation;
            this.awsEcrContainerAggregation = awsEcrContainerAggregation != null ? awsEcrContainerAggregation.build() : null;
            handleUnionValueChange(Type.AWS_ECR_CONTAINER_AGGREGATION, oldValue, this.awsEcrContainerAggregation);
        }

        @Override
        public final Builder awsEcrContainerAggregation(AwsEcrContainerAggregation awsEcrContainerAggregation) {
            Object oldValue = this.awsEcrContainerAggregation;
            this.awsEcrContainerAggregation = awsEcrContainerAggregation;
            handleUnionValueChange(Type.AWS_ECR_CONTAINER_AGGREGATION, oldValue, this.awsEcrContainerAggregation);
            return this;
        }

        public final Ec2InstanceAggregation.Builder getEc2InstanceAggregation() {
            return ec2InstanceAggregation != null ? ec2InstanceAggregation.toBuilder() : null;
        }

        public final void setEc2InstanceAggregation(Ec2InstanceAggregation.BuilderImpl ec2InstanceAggregation) {
            Object oldValue = this.ec2InstanceAggregation;
            this.ec2InstanceAggregation = ec2InstanceAggregation != null ? ec2InstanceAggregation.build() : null;
            handleUnionValueChange(Type.EC2_INSTANCE_AGGREGATION, oldValue, this.ec2InstanceAggregation);
        }

        @Override
        public final Builder ec2InstanceAggregation(Ec2InstanceAggregation ec2InstanceAggregation) {
            Object oldValue = this.ec2InstanceAggregation;
            this.ec2InstanceAggregation = ec2InstanceAggregation;
            handleUnionValueChange(Type.EC2_INSTANCE_AGGREGATION, oldValue, this.ec2InstanceAggregation);
            return this;
        }

        public final FindingTypeAggregation.Builder getFindingTypeAggregation() {
            return findingTypeAggregation != null ? findingTypeAggregation.toBuilder() : null;
        }

        public final void setFindingTypeAggregation(FindingTypeAggregation.BuilderImpl findingTypeAggregation) {
            Object oldValue = this.findingTypeAggregation;
            this.findingTypeAggregation = findingTypeAggregation != null ? findingTypeAggregation.build() : null;
            handleUnionValueChange(Type.FINDING_TYPE_AGGREGATION, oldValue, this.findingTypeAggregation);
        }

        @Override
        public final Builder findingTypeAggregation(FindingTypeAggregation findingTypeAggregation) {
            Object oldValue = this.findingTypeAggregation;
            this.findingTypeAggregation = findingTypeAggregation;
            handleUnionValueChange(Type.FINDING_TYPE_AGGREGATION, oldValue, this.findingTypeAggregation);
            return this;
        }

        public final ImageLayerAggregation.Builder getImageLayerAggregation() {
            return imageLayerAggregation != null ? imageLayerAggregation.toBuilder() : null;
        }

        public final void setImageLayerAggregation(ImageLayerAggregation.BuilderImpl imageLayerAggregation) {
            Object oldValue = this.imageLayerAggregation;
            this.imageLayerAggregation = imageLayerAggregation != null ? imageLayerAggregation.build() : null;
            handleUnionValueChange(Type.IMAGE_LAYER_AGGREGATION, oldValue, this.imageLayerAggregation);
        }

        @Override
        public final Builder imageLayerAggregation(ImageLayerAggregation imageLayerAggregation) {
            Object oldValue = this.imageLayerAggregation;
            this.imageLayerAggregation = imageLayerAggregation;
            handleUnionValueChange(Type.IMAGE_LAYER_AGGREGATION, oldValue, this.imageLayerAggregation);
            return this;
        }

        public final LambdaFunctionAggregation.Builder getLambdaFunctionAggregation() {
            return lambdaFunctionAggregation != null ? lambdaFunctionAggregation.toBuilder() : null;
        }

        public final void setLambdaFunctionAggregation(LambdaFunctionAggregation.BuilderImpl lambdaFunctionAggregation) {
            Object oldValue = this.lambdaFunctionAggregation;
            this.lambdaFunctionAggregation = lambdaFunctionAggregation != null ? lambdaFunctionAggregation.build() : null;
            handleUnionValueChange(Type.LAMBDA_FUNCTION_AGGREGATION, oldValue, this.lambdaFunctionAggregation);
        }

        @Override
        public final Builder lambdaFunctionAggregation(LambdaFunctionAggregation lambdaFunctionAggregation) {
            Object oldValue = this.lambdaFunctionAggregation;
            this.lambdaFunctionAggregation = lambdaFunctionAggregation;
            handleUnionValueChange(Type.LAMBDA_FUNCTION_AGGREGATION, oldValue, this.lambdaFunctionAggregation);
            return this;
        }

        public final LambdaLayerAggregation.Builder getLambdaLayerAggregation() {
            return lambdaLayerAggregation != null ? lambdaLayerAggregation.toBuilder() : null;
        }

        public final void setLambdaLayerAggregation(LambdaLayerAggregation.BuilderImpl lambdaLayerAggregation) {
            Object oldValue = this.lambdaLayerAggregation;
            this.lambdaLayerAggregation = lambdaLayerAggregation != null ? lambdaLayerAggregation.build() : null;
            handleUnionValueChange(Type.LAMBDA_LAYER_AGGREGATION, oldValue, this.lambdaLayerAggregation);
        }

        @Override
        public final Builder lambdaLayerAggregation(LambdaLayerAggregation lambdaLayerAggregation) {
            Object oldValue = this.lambdaLayerAggregation;
            this.lambdaLayerAggregation = lambdaLayerAggregation;
            handleUnionValueChange(Type.LAMBDA_LAYER_AGGREGATION, oldValue, this.lambdaLayerAggregation);
            return this;
        }

        public final PackageAggregation.Builder getPackageAggregation() {
            return packageAggregation != null ? packageAggregation.toBuilder() : null;
        }

        public final void setPackageAggregation(PackageAggregation.BuilderImpl packageAggregation) {
            Object oldValue = this.packageAggregation;
            this.packageAggregation = packageAggregation != null ? packageAggregation.build() : null;
            handleUnionValueChange(Type.PACKAGE_AGGREGATION, oldValue, this.packageAggregation);
        }

        @Override
        public final Builder packageAggregation(PackageAggregation packageAggregation) {
            Object oldValue = this.packageAggregation;
            this.packageAggregation = packageAggregation;
            handleUnionValueChange(Type.PACKAGE_AGGREGATION, oldValue, this.packageAggregation);
            return this;
        }

        public final RepositoryAggregation.Builder getRepositoryAggregation() {
            return repositoryAggregation != null ? repositoryAggregation.toBuilder() : null;
        }

        public final void setRepositoryAggregation(RepositoryAggregation.BuilderImpl repositoryAggregation) {
            Object oldValue = this.repositoryAggregation;
            this.repositoryAggregation = repositoryAggregation != null ? repositoryAggregation.build() : null;
            handleUnionValueChange(Type.REPOSITORY_AGGREGATION, oldValue, this.repositoryAggregation);
        }

        @Override
        public final Builder repositoryAggregation(RepositoryAggregation repositoryAggregation) {
            Object oldValue = this.repositoryAggregation;
            this.repositoryAggregation = repositoryAggregation;
            handleUnionValueChange(Type.REPOSITORY_AGGREGATION, oldValue, this.repositoryAggregation);
            return this;
        }

        public final TitleAggregation.Builder getTitleAggregation() {
            return titleAggregation != null ? titleAggregation.toBuilder() : null;
        }

        public final void setTitleAggregation(TitleAggregation.BuilderImpl titleAggregation) {
            Object oldValue = this.titleAggregation;
            this.titleAggregation = titleAggregation != null ? titleAggregation.build() : null;
            handleUnionValueChange(Type.TITLE_AGGREGATION, oldValue, this.titleAggregation);
        }

        @Override
        public final Builder titleAggregation(TitleAggregation titleAggregation) {
            Object oldValue = this.titleAggregation;
            this.titleAggregation = titleAggregation;
            handleUnionValueChange(Type.TITLE_AGGREGATION, oldValue, this.titleAggregation);
            return this;
        }

        @Override
        public AggregationRequest build() {
            return new AggregationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AggregationRequest#type()
     */
    public enum Type {
        ACCOUNT_AGGREGATION,

        AMI_AGGREGATION,

        AWS_ECR_CONTAINER_AGGREGATION,

        EC2_INSTANCE_AGGREGATION,

        FINDING_TYPE_AGGREGATION,

        IMAGE_LAYER_AGGREGATION,

        LAMBDA_FUNCTION_AGGREGATION,

        LAMBDA_LAYER_AGGREGATION,

        PACKAGE_AGGREGATION,

        REPOSITORY_AGGREGATION,

        TITLE_AGGREGATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
