/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the criteria used to sort finding results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SortCriteria implements SdkPojo, Serializable, ToCopyableBuilder<SortCriteria.Builder, SortCriteria> {
    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("field")
            .getter(getter(SortCriteria::fieldAsString)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(SortCriteria::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FIELD_FIELD, SORT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String field;

    private final String sortOrder;

    private SortCriteria(BuilderImpl builder) {
        this.field = builder.field;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The finding detail field by which results are sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #field} will return
     * {@link SortField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldAsString}.
     * </p>
     * 
     * @return The finding detail field by which results are sorted.
     * @see SortField
     */
    public final SortField field() {
        return SortField.fromValue(field);
    }

    /**
     * <p>
     * The finding detail field by which results are sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #field} will return
     * {@link SortField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldAsString}.
     * </p>
     * 
     * @return The finding detail field by which results are sorted.
     * @see SortField
     */
    public final String fieldAsString() {
        return field;
    }

    /**
     * <p>
     * The order by which findings are sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order by which findings are sorted.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order by which findings are sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order by which findings are sorted.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SortCriteria)) {
            return false;
        }
        SortCriteria other = (SortCriteria) obj;
        return Objects.equals(fieldAsString(), other.fieldAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SortCriteria").add("Field", fieldAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "field":
            return Optional.ofNullable(clazz.cast(fieldAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SortCriteria, T> g) {
        return obj -> g.apply((SortCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SortCriteria> {
        /**
         * <p>
         * The finding detail field by which results are sorted.
         * </p>
         * 
         * @param field
         *        The finding detail field by which results are sorted.
         * @see SortField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortField
         */
        Builder field(String field);

        /**
         * <p>
         * The finding detail field by which results are sorted.
         * </p>
         * 
         * @param field
         *        The finding detail field by which results are sorted.
         * @see SortField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortField
         */
        Builder field(SortField field);

        /**
         * <p>
         * The order by which findings are sorted.
         * </p>
         * 
         * @param sortOrder
         *        The order by which findings are sorted.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order by which findings are sorted.
         * </p>
         * 
         * @param sortOrder
         *        The order by which findings are sorted.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private String field;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(SortCriteria model) {
            field(model.field);
            sortOrder(model.sortOrder);
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public final Builder field(SortField field) {
            this.field(field == null ? null : field.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public SortCriteria build() {
            return new SortCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
