/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchVulnerabilitiesResponse extends Inspector2Response implements
        ToCopyableBuilder<SearchVulnerabilitiesResponse.Builder, SearchVulnerabilitiesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchVulnerabilitiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Vulnerability>> VULNERABILITIES_FIELD = SdkField
            .<List<Vulnerability>> builder(MarshallingType.LIST)
            .memberName("vulnerabilities")
            .getter(getter(SearchVulnerabilitiesResponse::vulnerabilities))
            .setter(setter(Builder::vulnerabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Vulnerability> builder(MarshallingType.SDK_POJO)
                                            .constructor(Vulnerability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VULNERABILITIES_FIELD));

    private final String nextToken;

    private final List<Vulnerability> vulnerabilities;

    private SearchVulnerabilitiesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vulnerabilities = builder.vulnerabilities;
    }

    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @return The pagination parameter to be used on the next list operation to retrieve more items.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Vulnerabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVulnerabilities() {
        return vulnerabilities != null && !(vulnerabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the listed vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVulnerabilities} method.
     * </p>
     * 
     * @return Details about the listed vulnerability.
     */
    public final List<Vulnerability> vulnerabilities() {
        return vulnerabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVulnerabilities() ? vulnerabilities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchVulnerabilitiesResponse)) {
            return false;
        }
        SearchVulnerabilitiesResponse other = (SearchVulnerabilitiesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVulnerabilities() == other.hasVulnerabilities()
                && Objects.equals(vulnerabilities(), other.vulnerabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchVulnerabilitiesResponse").add("NextToken", nextToken())
                .add("Vulnerabilities", hasVulnerabilities() ? vulnerabilities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "vulnerabilities":
            return Optional.ofNullable(clazz.cast(vulnerabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchVulnerabilitiesResponse, T> g) {
        return obj -> g.apply((SearchVulnerabilitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo, CopyableBuilder<Builder, SearchVulnerabilitiesResponse> {
        /**
         * <p>
         * The pagination parameter to be used on the next list operation to retrieve more items.
         * </p>
         * 
         * @param nextToken
         *        The pagination parameter to be used on the next list operation to retrieve more items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Details about the listed vulnerability.
         * </p>
         * 
         * @param vulnerabilities
         *        Details about the listed vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilities(Collection<Vulnerability> vulnerabilities);

        /**
         * <p>
         * Details about the listed vulnerability.
         * </p>
         * 
         * @param vulnerabilities
         *        Details about the listed vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilities(Vulnerability... vulnerabilities);

        /**
         * <p>
         * Details about the listed vulnerability.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.Vulnerability.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.Vulnerability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.Vulnerability.Builder#build()} is called immediately
         * and its result is passed to {@link #vulnerabilities(List<Vulnerability>)}.
         * 
         * @param vulnerabilities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.Vulnerability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vulnerabilities(java.util.Collection<Vulnerability>)
         */
        Builder vulnerabilities(Consumer<Vulnerability.Builder>... vulnerabilities);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<Vulnerability> vulnerabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchVulnerabilitiesResponse model) {
            super(model);
            nextToken(model.nextToken);
            vulnerabilities(model.vulnerabilities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Vulnerability.Builder> getVulnerabilities() {
            List<Vulnerability.Builder> result = VulnerabilitiesCopier.copyToBuilder(this.vulnerabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerabilities(Collection<Vulnerability.BuilderImpl> vulnerabilities) {
            this.vulnerabilities = VulnerabilitiesCopier.copyFromBuilder(vulnerabilities);
        }

        @Override
        public final Builder vulnerabilities(Collection<Vulnerability> vulnerabilities) {
            this.vulnerabilities = VulnerabilitiesCopier.copy(vulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilities(Vulnerability... vulnerabilities) {
            vulnerabilities(Arrays.asList(vulnerabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilities(Consumer<Vulnerability.Builder>... vulnerabilities) {
            vulnerabilities(Stream.of(vulnerabilities).map(c -> Vulnerability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchVulnerabilitiesResponse build() {
            return new SearchVulnerabilitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
