/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Common Vulnerability Scoring System (CVSS) version 3 details for the vulnerability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cvss3 implements SdkPojo, Serializable, ToCopyableBuilder<Cvss3.Builder, Cvss3> {
    private static final SdkField<Double> BASE_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("baseScore").getter(getter(Cvss3::baseScore)).setter(setter(Builder::baseScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseScore").build()).build();

    private static final SdkField<String> SCORING_VECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scoringVector").getter(getter(Cvss3::scoringVector)).setter(setter(Builder::scoringVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoringVector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_SCORE_FIELD,
            SCORING_VECTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double baseScore;

    private final String scoringVector;

    private Cvss3(BuilderImpl builder) {
        this.baseScore = builder.baseScore;
        this.scoringVector = builder.scoringVector;
    }

    /**
     * <p>
     * The CVSS v3 base score for the vulnerability.
     * </p>
     * 
     * @return The CVSS v3 base score for the vulnerability.
     */
    public final Double baseScore() {
        return baseScore;
    }

    /**
     * <p>
     * The scoring vector associated with the CVSS v3 score.
     * </p>
     * 
     * @return The scoring vector associated with the CVSS v3 score.
     */
    public final String scoringVector() {
        return scoringVector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseScore());
        hashCode = 31 * hashCode + Objects.hashCode(scoringVector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cvss3)) {
            return false;
        }
        Cvss3 other = (Cvss3) obj;
        return Objects.equals(baseScore(), other.baseScore()) && Objects.equals(scoringVector(), other.scoringVector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Cvss3").add("BaseScore", baseScore()).add("ScoringVector", scoringVector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baseScore":
            return Optional.ofNullable(clazz.cast(baseScore()));
        case "scoringVector":
            return Optional.ofNullable(clazz.cast(scoringVector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cvss3, T> g) {
        return obj -> g.apply((Cvss3) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cvss3> {
        /**
         * <p>
         * The CVSS v3 base score for the vulnerability.
         * </p>
         * 
         * @param baseScore
         *        The CVSS v3 base score for the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseScore(Double baseScore);

        /**
         * <p>
         * The scoring vector associated with the CVSS v3 score.
         * </p>
         * 
         * @param scoringVector
         *        The scoring vector associated with the CVSS v3 score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoringVector(String scoringVector);
    }

    static final class BuilderImpl implements Builder {
        private Double baseScore;

        private String scoringVector;

        private BuilderImpl() {
        }

        private BuilderImpl(Cvss3 model) {
            baseScore(model.baseScore);
            scoringVector(model.scoringVector);
        }

        public final Double getBaseScore() {
            return baseScore;
        }

        public final void setBaseScore(Double baseScore) {
            this.baseScore = baseScore;
        }

        @Override
        public final Builder baseScore(Double baseScore) {
            this.baseScore = baseScore;
            return this;
        }

        public final String getScoringVector() {
            return scoringVector;
        }

        public final void setScoringVector(String scoringVector) {
            this.scoringVector = scoringVector;
        }

        @Override
        public final Builder scoringVector(String scoringVector) {
            this.scoringVector = scoringVector;
            return this;
        }

        @Override
        public Cvss3 build() {
            return new Cvss3(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
