/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.inspector2.model.AccessDeniedException;
import software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest;
import software.amazon.awssdk.services.inspector2.model.AssociateMemberResponse;
import software.amazon.awssdk.services.inspector2.model.BadRequestException;
import software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusResponse;
import software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse;
import software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest;
import software.amazon.awssdk.services.inspector2.model.CancelFindingsReportResponse;
import software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.CancelSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.ConflictException;
import software.amazon.awssdk.services.inspector2.model.CreateFilterRequest;
import software.amazon.awssdk.services.inspector2.model.CreateFilterResponse;
import software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest;
import software.amazon.awssdk.services.inspector2.model.CreateFindingsReportResponse;
import software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.CreateSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest;
import software.amazon.awssdk.services.inspector2.model.DeleteFilterResponse;
import software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.DisableRequest;
import software.amazon.awssdk.services.inspector2.model.DisableResponse;
import software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest;
import software.amazon.awssdk.services.inspector2.model.DisassociateMemberResponse;
import software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.EnableRequest;
import software.amazon.awssdk.services.inspector2.model.EnableResponse;
import software.amazon.awssdk.services.inspector2.model.GetConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.GetConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest;
import software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusResponse;
import software.amazon.awssdk.services.inspector2.model.GetMemberRequest;
import software.amazon.awssdk.services.inspector2.model.GetMemberResponse;
import software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.GetSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.Inspector2Exception;
import software.amazon.awssdk.services.inspector2.model.InternalServerException;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse;
import software.amazon.awssdk.services.inspector2.model.ListCoverageRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageResponse;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse;
import software.amazon.awssdk.services.inspector2.model.ListFiltersRequest;
import software.amazon.awssdk.services.inspector2.model.ListFiltersResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingsResponse;
import software.amazon.awssdk.services.inspector2.model.ListMembersRequest;
import software.amazon.awssdk.services.inspector2.model.ListMembersResponse;
import software.amazon.awssdk.services.inspector2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.inspector2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse;
import software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse;
import software.amazon.awssdk.services.inspector2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.inspector2.model.TagResourceRequest;
import software.amazon.awssdk.services.inspector2.model.TagResourceResponse;
import software.amazon.awssdk.services.inspector2.model.ThrottlingException;
import software.amazon.awssdk.services.inspector2.model.UntagResourceRequest;
import software.amazon.awssdk.services.inspector2.model.UntagResourceResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateFilterResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.ValidationException;
import software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable;
import software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable;
import software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable;

/**
 * Service client for accessing Inspector2. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Inspector is a vulnerability discovery service that automates continuous scanning for security vulnerabilities
 * within your Amazon EC2 and Amazon ECR environments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Inspector2Client extends AwsClient {
    String SERVICE_NAME = "inspector2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "inspector2";

    /**
     * <p>
     * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator. An HTTP 200 response
     * indicates the association was successfully started, but doesn’t indicate whether it was completed. You can check
     * if the association completed by using <a
     * href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html">ListMembers</a> for multiple
     * accounts or <a href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html">GetMembers</a> for
     * a single account.
     * </p>
     *
     * @param associateMemberRequest
     * @return Result of the AssociateMember operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.AssociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/AssociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateMemberResponse associateMember(AssociateMemberRequest associateMemberRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator. An HTTP 200 response
     * indicates the association was successfully started, but doesn’t indicate whether it was completed. You can check
     * if the association completed by using <a
     * href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html">ListMembers</a> for multiple
     * accounts or <a href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html">GetMembers</a> for
     * a single account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateMemberRequest#builder()}
     * </p>
     *
     * @param associateMemberRequest
     *        A {@link Consumer} that will call methods on {@link AssociateMemberRequest.Builder} to create a request.
     * @return Result of the AssociateMember operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.AssociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/AssociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateMemberResponse associateMember(Consumer<AssociateMemberRequest.Builder> associateMemberRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return associateMember(AssociateMemberRequest.builder().applyMutation(associateMemberRequest).build());
    }

    /**
     * <p>
     * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
     * </p>
     *
     * @param batchGetAccountStatusRequest
     * @return Result of the BatchGetAccountStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAccountStatusResponse batchGetAccountStatus(BatchGetAccountStatusRequest batchGetAccountStatusRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAccountStatusRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetAccountStatusRequest#builder()}
     * </p>
     *
     * @param batchGetAccountStatusRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetAccountStatusRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetAccountStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAccountStatusResponse batchGetAccountStatus(
            Consumer<BatchGetAccountStatusRequest.Builder> batchGetAccountStatusRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return batchGetAccountStatus(BatchGetAccountStatusRequest.builder().applyMutation(batchGetAccountStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves code snippets from findings that Amazon Inspector detected code vulnerabilities in.
     * </p>
     *
     * @param batchGetCodeSnippetRequest
     * @return Result of the BatchGetCodeSnippet operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetCodeSnippet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetCodeSnippet"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetCodeSnippetResponse batchGetCodeSnippet(BatchGetCodeSnippetRequest batchGetCodeSnippetRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves code snippets from findings that Amazon Inspector detected code vulnerabilities in.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetCodeSnippetRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetCodeSnippetRequest#builder()}
     * </p>
     *
     * @param batchGetCodeSnippetRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetCodeSnippetRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetCodeSnippet operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetCodeSnippet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetCodeSnippet"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetCodeSnippetResponse batchGetCodeSnippet(
            Consumer<BatchGetCodeSnippetRequest.Builder> batchGetCodeSnippetRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return batchGetCodeSnippet(BatchGetCodeSnippetRequest.builder().applyMutation(batchGetCodeSnippetRequest).build());
    }

    /**
     * <p>
     * Gets vulnerability details for findings.
     * </p>
     *
     * @param batchGetFindingDetailsRequest
     * @return Result of the BatchGetFindingDetails operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetFindingDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFindingDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFindingDetailsResponse batchGetFindingDetails(BatchGetFindingDetailsRequest batchGetFindingDetailsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets vulnerability details for findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetFindingDetailsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetFindingDetailsRequest#builder()}
     * </p>
     *
     * @param batchGetFindingDetailsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetFindingDetailsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetFindingDetails operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetFindingDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFindingDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFindingDetailsResponse batchGetFindingDetails(
            Consumer<BatchGetFindingDetailsRequest.Builder> batchGetFindingDetailsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return batchGetFindingDetails(BatchGetFindingDetailsRequest.builder().applyMutation(batchGetFindingDetailsRequest)
                .build());
    }

    /**
     * <p>
     * Gets free trial status for multiple Amazon Web Services accounts.
     * </p>
     *
     * @param batchGetFreeTrialInfoRequest
     * @return Result of the BatchGetFreeTrialInfo operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetFreeTrialInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFreeTrialInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFreeTrialInfoResponse batchGetFreeTrialInfo(BatchGetFreeTrialInfoRequest batchGetFreeTrialInfoRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets free trial status for multiple Amazon Web Services accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetFreeTrialInfoRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetFreeTrialInfoRequest#builder()}
     * </p>
     *
     * @param batchGetFreeTrialInfoRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetFreeTrialInfoRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetFreeTrialInfo operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetFreeTrialInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFreeTrialInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFreeTrialInfoResponse batchGetFreeTrialInfo(
            Consumer<BatchGetFreeTrialInfoRequest.Builder> batchGetFreeTrialInfoRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return batchGetFreeTrialInfo(BatchGetFreeTrialInfoRequest.builder().applyMutation(batchGetFreeTrialInfoRequest).build());
    }

    /**
     * <p>
     * Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your
     * organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     *
     * @param batchGetMemberEc2DeepInspectionStatusRequest
     * @return Result of the BatchGetMemberEc2DeepInspectionStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetMemberEc2DeepInspectionStatusResponse batchGetMemberEc2DeepInspectionStatus(
            BatchGetMemberEc2DeepInspectionStatusRequest batchGetMemberEc2DeepInspectionStatusRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your
     * organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchGetMemberEc2DeepInspectionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link BatchGetMemberEc2DeepInspectionStatusRequest#builder()}
     * </p>
     *
     * @param batchGetMemberEc2DeepInspectionStatusRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetMemberEc2DeepInspectionStatusRequest.Builder}
     *        to create a request.
     * @return Result of the BatchGetMemberEc2DeepInspectionStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchGetMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetMemberEc2DeepInspectionStatusResponse batchGetMemberEc2DeepInspectionStatus(
            Consumer<BatchGetMemberEc2DeepInspectionStatusRequest.Builder> batchGetMemberEc2DeepInspectionStatusRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return batchGetMemberEc2DeepInspectionStatus(BatchGetMemberEc2DeepInspectionStatusRequest.builder()
                .applyMutation(batchGetMemberEc2DeepInspectionStatusRequest).build());
    }

    /**
     * <p>
     * Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization.
     * You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     *
     * @param batchUpdateMemberEc2DeepInspectionStatusRequest
     * @return Result of the BatchUpdateMemberEc2DeepInspectionStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchUpdateMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchUpdateMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateMemberEc2DeepInspectionStatusResponse batchUpdateMemberEc2DeepInspectionStatus(
            BatchUpdateMemberEc2DeepInspectionStatusRequest batchUpdateMemberEc2DeepInspectionStatusRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization.
     * You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link BatchUpdateMemberEc2DeepInspectionStatusRequest#builder()}
     * </p>
     *
     * @param batchUpdateMemberEc2DeepInspectionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder} to create a request.
     * @return Result of the BatchUpdateMemberEc2DeepInspectionStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.BatchUpdateMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchUpdateMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateMemberEc2DeepInspectionStatusResponse batchUpdateMemberEc2DeepInspectionStatus(
            Consumer<BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder> batchUpdateMemberEc2DeepInspectionStatusRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return batchUpdateMemberEc2DeepInspectionStatus(BatchUpdateMemberEc2DeepInspectionStatusRequest.builder()
                .applyMutation(batchUpdateMemberEc2DeepInspectionStatusRequest).build());
    }

    /**
     * <p>
     * Cancels the given findings report.
     * </p>
     *
     * @param cancelFindingsReportRequest
     * @return Result of the CancelFindingsReport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CancelFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelFindingsReportResponse cancelFindingsReport(CancelFindingsReportRequest cancelFindingsReportRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the given findings report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelFindingsReportRequest.Builder} avoiding the
     * need to create one manually via {@link CancelFindingsReportRequest#builder()}
     * </p>
     *
     * @param cancelFindingsReportRequest
     *        A {@link Consumer} that will call methods on {@link CancelFindingsReportRequest.Builder} to create a
     *        request.
     * @return Result of the CancelFindingsReport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CancelFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelFindingsReportResponse cancelFindingsReport(
            Consumer<CancelFindingsReportRequest.Builder> cancelFindingsReportRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return cancelFindingsReport(CancelFindingsReportRequest.builder().applyMutation(cancelFindingsReportRequest).build());
    }

    /**
     * <p>
     * Cancels a software bill of materials (SBOM) report.
     * </p>
     *
     * @param cancelSbomExportRequest
     * @return Result of the CancelSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CancelSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSbomExportResponse cancelSbomExport(CancelSbomExportRequest cancelSbomExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a software bill of materials (SBOM) report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSbomExportRequest.Builder} avoiding the need
     * to create one manually via {@link CancelSbomExportRequest#builder()}
     * </p>
     *
     * @param cancelSbomExportRequest
     *        A {@link Consumer} that will call methods on {@link CancelSbomExportRequest.Builder} to create a request.
     * @return Result of the CancelSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CancelSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSbomExportResponse cancelSbomExport(Consumer<CancelSbomExportRequest.Builder> cancelSbomExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return cancelSbomExport(CancelSbomExportRequest.builder().applyMutation(cancelSbomExportRequest).build());
    }

    /**
     * <p>
     * Creates a filter resource using specified filter criteria.
     * </p>
     *
     * @param createFilterRequest
     * @return Result of the CreateFilter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws BadRequestException
     *         One or more tags submitted as part of the request is not valid.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFilterResponse createFilter(CreateFilterRequest createFilterRequest) throws ServiceQuotaExceededException,
            BadRequestException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a filter resource using specified filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFilterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFilterRequest#builder()}
     * </p>
     *
     * @param createFilterRequest
     *        A {@link Consumer} that will call methods on {@link CreateFilterRequest.Builder} to create a request.
     * @return Result of the CreateFilter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws BadRequestException
     *         One or more tags submitted as part of the request is not valid.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFilterResponse createFilter(Consumer<CreateFilterRequest.Builder> createFilterRequest)
            throws ServiceQuotaExceededException, BadRequestException, ValidationException, AccessDeniedException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return createFilter(CreateFilterRequest.builder().applyMutation(createFilterRequest).build());
    }

    /**
     * <p>
     * Creates a finding report. By default only <code>ACTIVE</code> findings are returned in the report. To see
     * <code>SUPRESSED</code> or <code>CLOSED</code> findings you must specify a value for the
     * <code>findingStatus</code> filter criteria.
     * </p>
     *
     * @param createFindingsReportRequest
     * @return Result of the CreateFindingsReport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFindingsReportResponse createFindingsReport(CreateFindingsReportRequest createFindingsReportRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a finding report. By default only <code>ACTIVE</code> findings are returned in the report. To see
     * <code>SUPRESSED</code> or <code>CLOSED</code> findings you must specify a value for the
     * <code>findingStatus</code> filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFindingsReportRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFindingsReportRequest#builder()}
     * </p>
     *
     * @param createFindingsReportRequest
     *        A {@link Consumer} that will call methods on {@link CreateFindingsReportRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFindingsReport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFindingsReportResponse createFindingsReport(
            Consumer<CreateFindingsReportRequest.Builder> createFindingsReportRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return createFindingsReport(CreateFindingsReportRequest.builder().applyMutation(createFindingsReportRequest).build());
    }

    /**
     * <p>
     * Creates a software bill of materials (SBOM) report.
     * </p>
     *
     * @param createSbomExportRequest
     * @return Result of the CreateSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSbomExportResponse createSbomExport(CreateSbomExportRequest createSbomExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a software bill of materials (SBOM) report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSbomExportRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSbomExportRequest#builder()}
     * </p>
     *
     * @param createSbomExportRequest
     *        A {@link Consumer} that will call methods on {@link CreateSbomExportRequest.Builder} to create a request.
     * @return Result of the CreateSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.CreateSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSbomExportResponse createSbomExport(Consumer<CreateSbomExportRequest.Builder> createSbomExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return createSbomExport(CreateSbomExportRequest.builder().applyMutation(createSbomExportRequest).build());
    }

    /**
     * <p>
     * Deletes a filter resource.
     * </p>
     *
     * @param deleteFilterRequest
     * @return Result of the DeleteFilter operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFilterResponse deleteFilter(DeleteFilterRequest deleteFilterRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a filter resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFilterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFilterRequest#builder()}
     * </p>
     *
     * @param deleteFilterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFilterRequest.Builder} to create a request.
     * @return Result of the DeleteFilter operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFilterResponse deleteFilter(Consumer<DeleteFilterRequest.Builder> deleteFilterRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return deleteFilter(DeleteFilterRequest.builder().applyMutation(deleteFilterRequest).build());
    }

    /**
     * <p>
     * Describe Amazon Inspector configuration settings for an Amazon Web Services organization.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return Result of the DescribeOrganizationConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe Amazon Inspector configuration settings for an Amazon Web Services organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeOrganizationConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(
            Consumer<DescribeOrganizationConfigurationRequest.Builder> describeOrganizationConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.builder()
                .applyMutation(describeOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an
     * account disables the Amazon Inspector service.
     * </p>
     *
     * @param disableRequest
     * @return Result of the Disable operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.Disable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Disable" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableResponse disable(DisableRequest disableRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an
     * account disables the Amazon Inspector service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableRequest.Builder} avoiding the need to create
     * one manually via {@link DisableRequest#builder()}
     * </p>
     *
     * @param disableRequest
     *        A {@link Consumer} that will call methods on {@link DisableRequest.Builder} to create a request.
     * @return Result of the Disable operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.Disable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Disable" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableResponse disable(Consumer<DisableRequest.Builder> disableRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return disable(DisableRequest.builder().applyMutation(disableRequest).build());
    }

    /**
     * <p>
     * Disables the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param disableDelegatedAdminAccountRequest
     * @return Result of the DisableDelegatedAdminAccount operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DisableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableDelegatedAdminAccountResponse disableDelegatedAdminAccount(
            DisableDelegatedAdminAccountRequest disableDelegatedAdminAccountRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the Amazon Inspector delegated administrator for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableDelegatedAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisableDelegatedAdminAccountRequest#builder()}
     * </p>
     *
     * @param disableDelegatedAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisableDelegatedAdminAccountRequest.Builder} to create
     *        a request.
     * @return Result of the DisableDelegatedAdminAccount operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DisableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableDelegatedAdminAccountResponse disableDelegatedAdminAccount(
            Consumer<DisableDelegatedAdminAccountRequest.Builder> disableDelegatedAdminAccountRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return disableDelegatedAdminAccount(DisableDelegatedAdminAccountRequest.builder()
                .applyMutation(disableDelegatedAdminAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates a member account from an Amazon Inspector delegated administrator.
     * </p>
     *
     * @param disassociateMemberRequest
     * @return Result of the DisassociateMember operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DisassociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisassociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateMemberResponse disassociateMember(DisassociateMemberRequest disassociateMemberRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member account from an Amazon Inspector delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateMemberRequest#builder()}
     * </p>
     *
     * @param disassociateMemberRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateMemberRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateMember operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.DisassociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisassociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateMemberResponse disassociateMember(Consumer<DisassociateMemberRequest.Builder> disassociateMemberRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return disassociateMember(DisassociateMemberRequest.builder().applyMutation(disassociateMemberRequest).build());
    }

    /**
     * <p>
     * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
     * </p>
     *
     * @param enableRequest
     * @return Result of the Enable operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.Enable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Enable" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableResponse enable(EnableRequest enableRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableRequest.Builder} avoiding the need to create
     * one manually via {@link EnableRequest#builder()}
     * </p>
     *
     * @param enableRequest
     *        A {@link Consumer} that will call methods on {@link EnableRequest.Builder} to create a request.
     * @return Result of the Enable operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.Enable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Enable" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableResponse enable(Consumer<EnableRequest.Builder> enableRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return enable(EnableRequest.builder().applyMutation(enableRequest).build());
    }

    /**
     * <p>
     * Enables the Amazon Inspector delegated administrator for your Organizations organization.
     * </p>
     *
     * @param enableDelegatedAdminAccountRequest
     * @return Result of the EnableDelegatedAdminAccount operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.EnableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/EnableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableDelegatedAdminAccountResponse enableDelegatedAdminAccount(
            EnableDelegatedAdminAccountRequest enableDelegatedAdminAccountRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the Amazon Inspector delegated administrator for your Organizations organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableDelegatedAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link EnableDelegatedAdminAccountRequest#builder()}
     * </p>
     *
     * @param enableDelegatedAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link EnableDelegatedAdminAccountRequest.Builder} to create
     *        a request.
     * @return Result of the EnableDelegatedAdminAccount operation returned by the service.
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.EnableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/EnableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableDelegatedAdminAccountResponse enableDelegatedAdminAccount(
            Consumer<EnableDelegatedAdminAccountRequest.Builder> enableDelegatedAdminAccountRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return enableDelegatedAdminAccount(EnableDelegatedAdminAccountRequest.builder()
                .applyMutation(enableDelegatedAdminAccountRequest).build());
    }

    /**
     * <p>
     * Retrieves setting configurations for Inspector scans.
     * </p>
     *
     * @param getConfigurationRequest
     * @return Result of the GetConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConfigurationResponse getConfiguration(GetConfigurationRequest getConfigurationRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves setting configurations for Inspector scans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationRequest.Builder} avoiding the need
     * to create one manually via {@link GetConfigurationRequest#builder()}
     * </p>
     *
     * @param getConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetConfigurationRequest.Builder} to create a request.
     * @return Result of the GetConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConfigurationResponse getConfiguration(Consumer<GetConfigurationRequest.Builder> getConfigurationRequest)
            throws ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return getConfiguration(GetConfigurationRequest.builder().applyMutation(getConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param getDelegatedAdminAccountRequest
     * @return Result of the GetDelegatedAdminAccount operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDelegatedAdminAccountResponse getDelegatedAdminAccount(
            GetDelegatedAdminAccountRequest getDelegatedAdminAccountRequest) throws AccessDeniedException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the Amazon Inspector delegated administrator for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDelegatedAdminAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetDelegatedAdminAccountRequest#builder()}
     * </p>
     *
     * @param getDelegatedAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetDelegatedAdminAccountRequest.Builder} to create a
     *        request.
     * @return Result of the GetDelegatedAdminAccount operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDelegatedAdminAccountResponse getDelegatedAdminAccount(
            Consumer<GetDelegatedAdminAccountRequest.Builder> getDelegatedAdminAccountRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return getDelegatedAdminAccount(GetDelegatedAdminAccountRequest.builder().applyMutation(getDelegatedAdminAccountRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your
     * account.
     * </p>
     *
     * @param getEc2DeepInspectionConfigurationRequest
     * @return Result of the GetEc2DeepInspectionConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEc2DeepInspectionConfigurationResponse getEc2DeepInspectionConfiguration(
            GetEc2DeepInspectionConfigurationRequest getEc2DeepInspectionConfigurationRequest) throws AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEc2DeepInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetEc2DeepInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param getEc2DeepInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetEc2DeepInspectionConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetEc2DeepInspectionConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEc2DeepInspectionConfigurationResponse getEc2DeepInspectionConfiguration(
            Consumer<GetEc2DeepInspectionConfigurationRequest.Builder> getEc2DeepInspectionConfigurationRequest)
            throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return getEc2DeepInspectionConfiguration(GetEc2DeepInspectionConfigurationRequest.builder()
                .applyMutation(getEc2DeepInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets an encryption key.
     * </p>
     *
     * @param getEncryptionKeyRequest
     * @return Result of the GetEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEncryptionKeyResponse getEncryptionKey(GetEncryptionKeyRequest getEncryptionKeyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an encryption key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEncryptionKeyRequest.Builder} avoiding the need
     * to create one manually via {@link GetEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param getEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on {@link GetEncryptionKeyRequest.Builder} to create a request.
     * @return Result of the GetEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEncryptionKeyResponse getEncryptionKey(Consumer<GetEncryptionKeyRequest.Builder> getEncryptionKeyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return getEncryptionKey(GetEncryptionKeyRequest.builder().applyMutation(getEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Gets the status of a findings report.
     * </p>
     *
     * @param getFindingsReportStatusRequest
     * @return Result of the GetFindingsReportStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetFindingsReportStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetFindingsReportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsReportStatusResponse getFindingsReportStatus(GetFindingsReportStatusRequest getFindingsReportStatusRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a findings report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsReportStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetFindingsReportStatusRequest#builder()}
     * </p>
     *
     * @param getFindingsReportStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsReportStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetFindingsReportStatus operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetFindingsReportStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetFindingsReportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsReportStatusResponse getFindingsReportStatus(
            Consumer<GetFindingsReportStatusRequest.Builder> getFindingsReportStatusRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return getFindingsReportStatus(GetFindingsReportStatusRequest.builder().applyMutation(getFindingsReportStatusRequest)
                .build());
    }

    /**
     * <p>
     * Gets member information for your organization.
     * </p>
     *
     * @param getMemberRequest
     * @return Result of the GetMember operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetMember" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMemberResponse getMember(GetMemberRequest getMemberRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets member information for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemberRequest.Builder} avoiding the need to
     * create one manually via {@link GetMemberRequest#builder()}
     * </p>
     *
     * @param getMemberRequest
     *        A {@link Consumer} that will call methods on {@link GetMemberRequest.Builder} to create a request.
     * @return Result of the GetMember operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetMember" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMemberResponse getMember(Consumer<GetMemberRequest.Builder> getMemberRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return getMember(GetMemberRequest.builder().applyMutation(getMemberRequest).build());
    }

    /**
     * <p>
     * Gets details of a software bill of materials (SBOM) report.
     * </p>
     *
     * @param getSbomExportRequest
     * @return Result of the GetSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetSbomExport" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSbomExportResponse getSbomExport(GetSbomExportRequest getSbomExportRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details of a software bill of materials (SBOM) report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSbomExportRequest.Builder} avoiding the need to
     * create one manually via {@link GetSbomExportRequest#builder()}
     * </p>
     *
     * @param getSbomExportRequest
     *        A {@link Consumer} that will call methods on {@link GetSbomExportRequest.Builder} to create a request.
     * @return Result of the GetSbomExport operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.GetSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetSbomExport" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSbomExportResponse getSbomExport(Consumer<GetSbomExportRequest.Builder> getSbomExportRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return getSbomExport(GetSbomExportRequest.builder().applyMutation(getSbomExportRequest).build());
    }

    /**
     * <p>
     * Lists the permissions an account has to configure Amazon Inspector.
     * </p>
     *
     * @param listAccountPermissionsRequest
     * @return Result of the ListAccountPermissions operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountPermissionsResponse listAccountPermissions(ListAccountPermissionsRequest listAccountPermissionsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the permissions an account has to configure Amazon Inspector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountPermissionsRequest#builder()}
     * </p>
     *
     * @param listAccountPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAccountPermissions operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountPermissionsResponse listAccountPermissions(
            Consumer<ListAccountPermissionsRequest.Builder> listAccountPermissionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listAccountPermissions(ListAccountPermissionsRequest.builder().applyMutation(listAccountPermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the permissions an account has to configure Amazon Inspector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client.listAccountPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client
     *             .listAccountPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client.listAccountPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountPermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountPermissionsIterable listAccountPermissionsPaginator(
            ListAccountPermissionsRequest listAccountPermissionsRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new ListAccountPermissionsIterable(this, listAccountPermissionsRequest);
    }

    /**
     * <p>
     * Lists the permissions an account has to configure Amazon Inspector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client.listAccountPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client
     *             .listAccountPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListAccountPermissionsIterable responses = client.listAccountPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountPermissions(software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountPermissionsRequest#builder()}
     * </p>
     *
     * @param listAccountPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountPermissionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountPermissionsIterable listAccountPermissionsPaginator(
            Consumer<ListAccountPermissionsRequest.Builder> listAccountPermissionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listAccountPermissionsPaginator(ListAccountPermissionsRequest.builder()
                .applyMutation(listAccountPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists coverage details for you environment.
     * </p>
     *
     * @param listCoverageRequest
     * @return Result of the ListCoverage operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageResponse listCoverage(ListCoverageRequest listCoverageRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists coverage details for you environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageRequest.Builder} avoiding the need to
     * create one manually via {@link ListCoverageRequest#builder()}
     * </p>
     *
     * @param listCoverageRequest
     *        A {@link Consumer} that will call methods on {@link ListCoverageRequest.Builder} to create a request.
     * @return Result of the ListCoverage operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageResponse listCoverage(Consumer<ListCoverageRequest.Builder> listCoverageRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listCoverage(ListCoverageRequest.builder().applyMutation(listCoverageRequest).build());
    }

    /**
     * <p>
     * Lists coverage details for you environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCoverageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)} operation.</b>
     * </p>
     *
     * @param listCoverageRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageIterable listCoveragePaginator(ListCoverageRequest listCoverageRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new ListCoverageIterable(this, listCoverageRequest);
    }

    /**
     * <p>
     * Lists coverage details for you environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCoverageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverage(software.amazon.awssdk.services.inspector2.model.ListCoverageRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageRequest.Builder} avoiding the need to
     * create one manually via {@link ListCoverageRequest#builder()}
     * </p>
     *
     * @param listCoverageRequest
     *        A {@link Consumer} that will call methods on {@link ListCoverageRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageIterable listCoveragePaginator(Consumer<ListCoverageRequest.Builder> listCoverageRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listCoveragePaginator(ListCoverageRequest.builder().applyMutation(listCoverageRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage statistics for your environment.
     * </p>
     *
     * @param listCoverageStatisticsRequest
     * @return Result of the ListCoverageStatistics operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoverageStatisticsResponse listCoverageStatistics(ListCoverageStatisticsRequest listCoverageStatisticsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage statistics for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCoverageStatisticsRequest#builder()}
     * </p>
     *
     * @param listCoverageStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link ListCoverageStatisticsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCoverageStatistics operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoverageStatisticsResponse listCoverageStatistics(
            Consumer<ListCoverageStatisticsRequest.Builder> listCoverageStatisticsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return listCoverageStatistics(ListCoverageStatisticsRequest.builder().applyMutation(listCoverageStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage statistics for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client.listCoverageStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client
     *             .listCoverageStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client.listCoverageStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCoverageStatisticsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoverageStatisticsIterable listCoverageStatisticsPaginator(
            ListCoverageStatisticsRequest listCoverageStatisticsRequest) throws ValidationException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new ListCoverageStatisticsIterable(this, listCoverageStatisticsRequest);
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage statistics for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client.listCoverageStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client
     *             .listCoverageStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListCoverageStatisticsIterable responses = client.listCoverageStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverageStatistics(software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCoverageStatisticsRequest#builder()}
     * </p>
     *
     * @param listCoverageStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link ListCoverageStatisticsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoverageStatisticsIterable listCoverageStatisticsPaginator(
            Consumer<ListCoverageStatisticsRequest.Builder> listCoverageStatisticsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return listCoverageStatisticsPaginator(ListCoverageStatisticsRequest.builder()
                .applyMutation(listCoverageStatisticsRequest).build());
    }

    /**
     * <p>
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     * @return Result of the ListDelegatedAdminAccounts operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDelegatedAdminAccountsResponse listDelegatedAdminAccounts(
            ListDelegatedAdminAccountsRequest listDelegatedAdminAccountsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDelegatedAdminAccountsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDelegatedAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListDelegatedAdminAccountsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDelegatedAdminAccounts operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDelegatedAdminAccountsResponse listDelegatedAdminAccounts(
            Consumer<ListDelegatedAdminAccountsRequest.Builder> listDelegatedAdminAccountsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listDelegatedAdminAccounts(ListDelegatedAdminAccountsRequest.builder()
                .applyMutation(listDelegatedAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client.listDelegatedAdminAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client
     *             .listDelegatedAdminAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client.listDelegatedAdminAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDelegatedAdminAccountsIterable listDelegatedAdminAccountsPaginator(
            ListDelegatedAdminAccountsRequest listDelegatedAdminAccountsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return new ListDelegatedAdminAccountsIterable(this, listDelegatedAdminAccountsRequest);
    }

    /**
     * <p>
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client.listDelegatedAdminAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client
     *             .listDelegatedAdminAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListDelegatedAdminAccountsIterable responses = client.listDelegatedAdminAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDelegatedAdminAccounts(software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDelegatedAdminAccountsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDelegatedAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListDelegatedAdminAccountsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDelegatedAdminAccountsIterable listDelegatedAdminAccountsPaginator(
            Consumer<ListDelegatedAdminAccountsRequest.Builder> listDelegatedAdminAccountsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listDelegatedAdminAccountsPaginator(ListDelegatedAdminAccountsRequest.builder()
                .applyMutation(listDelegatedAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Lists the filters associated with your account.
     * </p>
     *
     * @param listFiltersRequest
     * @return Result of the ListFilters operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersResponse listFilters(ListFiltersRequest listFiltersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the filters associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListFiltersRequest.Builder} to create a request.
     * @return Result of the ListFilters operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersResponse listFilters(Consumer<ListFiltersRequest.Builder> listFiltersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listFilters(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * Lists the filters associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)} operation.</b>
     * </p>
     *
     * @param listFiltersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersIterable listFiltersPaginator(ListFiltersRequest listFiltersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return new ListFiltersIterable(this, listFiltersRequest);
    }

    /**
     * <p>
     * Lists the filters associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.inspector2.model.ListFiltersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListFiltersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersIterable listFiltersPaginator(Consumer<ListFiltersRequest.Builder> listFiltersRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listFiltersPaginator(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * Lists aggregated finding data for your environment based on specific criteria.
     * </p>
     *
     * @param listFindingAggregationsRequest
     * @return Result of the ListFindingAggregations operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregationsResponse listFindingAggregations(ListFindingAggregationsRequest listFindingAggregationsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists aggregated finding data for your environment based on specific criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingAggregationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFindingAggregationsRequest#builder()}
     * </p>
     *
     * @param listFindingAggregationsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingAggregationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListFindingAggregations operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregationsResponse listFindingAggregations(
            Consumer<ListFindingAggregationsRequest.Builder> listFindingAggregationsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return listFindingAggregations(ListFindingAggregationsRequest.builder().applyMutation(listFindingAggregationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists aggregated finding data for your environment based on specific criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client.listFindingAggregationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client
     *             .listFindingAggregationsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client.listFindingAggregationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFindingAggregationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregationsIterable listFindingAggregationsPaginator(
            ListFindingAggregationsRequest listFindingAggregationsRequest) throws ValidationException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new ListFindingAggregationsIterable(this, listFindingAggregationsRequest);
    }

    /**
     * <p>
     * Lists aggregated finding data for your environment based on specific criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client.listFindingAggregationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client
     *             .listFindingAggregationsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingAggregationsIterable responses = client.listFindingAggregationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingAggregations(software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingAggregationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFindingAggregationsRequest#builder()}
     * </p>
     *
     * @param listFindingAggregationsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingAggregationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregationsIterable listFindingAggregationsPaginator(
            Consumer<ListFindingAggregationsRequest.Builder> listFindingAggregationsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return listFindingAggregationsPaginator(ListFindingAggregationsRequest.builder()
                .applyMutation(listFindingAggregationsRequest).build());
    }

    /**
     * <p>
     * Lists findings for your environment.
     * </p>
     *
     * @param listFindingsRequest
     * @return Result of the ListFindings operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsResponse listFindings(ListFindingsRequest listFindingsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists findings for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsRequest.Builder} to create a request.
     * @return Result of the ListFindings operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsResponse listFindings(Consumer<ListFindingsRequest.Builder> listFindingsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listFindings(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Lists findings for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listFindingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsIterable listFindingsPaginator(ListFindingsRequest listFindingsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return new ListFindingsIterable(this, listFindingsRequest);
    }

    /**
     * <p>
     * Lists findings for your environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector2.model.ListFindingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsIterable listFindingsPaginator(Consumer<ListFindingsRequest.Builder> listFindingsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listFindingsPaginator(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param listMembersRequest
     * @return Result of the ListMembers operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersRequest.Builder} to create a request.
     * @return Result of the ListMembers operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return new ListMembersIterable(this, listMembersRequest);
    }

    /**
     * <p>
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.inspector2.model.ListMembersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists all tags attached to a given resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags attached to a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Inspector usage totals over the last 30 days.
     * </p>
     *
     * @param listUsageTotalsRequest
     * @return Result of the ListUsageTotals operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsageTotalsResponse listUsageTotals(ListUsageTotalsRequest listUsageTotalsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Inspector usage totals over the last 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageTotalsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageTotalsRequest#builder()}
     * </p>
     *
     * @param listUsageTotalsRequest
     *        A {@link Consumer} that will call methods on {@link ListUsageTotalsRequest.Builder} to create a request.
     * @return Result of the ListUsageTotals operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsageTotalsResponse listUsageTotals(Consumer<ListUsageTotalsRequest.Builder> listUsageTotalsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listUsageTotals(ListUsageTotalsRequest.builder().applyMutation(listUsageTotalsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Inspector usage totals over the last 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client.listUsageTotalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client
     *             .listUsageTotalsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client.listUsageTotalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation.</b>
     * </p>
     *
     * @param listUsageTotalsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsageTotalsIterable listUsageTotalsPaginator(ListUsageTotalsRequest listUsageTotalsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return new ListUsageTotalsIterable(this, listUsageTotalsRequest);
    }

    /**
     * <p>
     * Lists the Amazon Inspector usage totals over the last 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client.listUsageTotalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client
     *             .listUsageTotalsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.ListUsageTotalsIterable responses = client.listUsageTotalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageTotals(software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageTotalsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageTotalsRequest#builder()}
     * </p>
     *
     * @param listUsageTotalsRequest
     *        A {@link Consumer} that will call methods on {@link ListUsageTotalsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsageTotalsIterable listUsageTotalsPaginator(Consumer<ListUsageTotalsRequest.Builder> listUsageTotalsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return listUsageTotalsPaginator(ListUsageTotalsRequest.builder().applyMutation(listUsageTotalsRequest).build());
    }

    /**
     * <p>
     * Resets an encryption key. After the key is reset your resources will be encrypted by an Amazon Web Services owned
     * key.
     * </p>
     *
     * @param resetEncryptionKeyRequest
     * @return Result of the ResetEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ResetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ResetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default ResetEncryptionKeyResponse resetEncryptionKey(ResetEncryptionKeyRequest resetEncryptionKeyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets an encryption key. After the key is reset your resources will be encrypted by an Amazon Web Services owned
     * key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetEncryptionKeyRequest.Builder} avoiding the
     * need to create one manually via {@link ResetEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param resetEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on {@link ResetEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return Result of the ResetEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.ResetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ResetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default ResetEncryptionKeyResponse resetEncryptionKey(Consumer<ResetEncryptionKeyRequest.Builder> resetEncryptionKeyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return resetEncryptionKey(ResetEncryptionKeyRequest.builder().applyMutation(resetEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage details for a specific vulnerability.
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     * @return Result of the SearchVulnerabilities operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchVulnerabilitiesResponse searchVulnerabilities(SearchVulnerabilitiesRequest searchVulnerabilitiesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage details for a specific vulnerability.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchVulnerabilitiesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchVulnerabilitiesRequest#builder()}
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     *        A {@link Consumer} that will call methods on {@link SearchVulnerabilitiesRequest.Builder} to create a
     *        request.
     * @return Result of the SearchVulnerabilities operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchVulnerabilitiesResponse searchVulnerabilities(
            Consumer<SearchVulnerabilitiesRequest.Builder> searchVulnerabilitiesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return searchVulnerabilities(SearchVulnerabilitiesRequest.builder().applyMutation(searchVulnerabilitiesRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage details for a specific vulnerability.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client.searchVulnerabilitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client
     *             .searchVulnerabilitiesPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client.searchVulnerabilitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchVulnerabilitiesIterable searchVulnerabilitiesPaginator(SearchVulnerabilitiesRequest searchVulnerabilitiesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return new SearchVulnerabilitiesIterable(this, searchVulnerabilitiesRequest);
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage details for a specific vulnerability.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client.searchVulnerabilitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client
     *             .searchVulnerabilitiesPaginator(request);
     *     for (software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector2.paginators.SearchVulnerabilitiesIterable responses = client.searchVulnerabilitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchVulnerabilities(software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchVulnerabilitiesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchVulnerabilitiesRequest#builder()}
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     *        A {@link Consumer} that will call methods on {@link SearchVulnerabilitiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchVulnerabilitiesIterable searchVulnerabilitiesPaginator(
            Consumer<SearchVulnerabilitiesRequest.Builder> searchVulnerabilitiesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return searchVulnerabilitiesPaginator(SearchVulnerabilitiesRequest.builder().applyMutation(searchVulnerabilitiesRequest)
                .build());
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         One or more tags submitted as part of the request is not valid.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         One or more tags submitted as part of the request is not valid.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, Inspector2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector
     * delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization
     * cannot update this setting.
     * </p>
     *
     * @param updateConfigurationRequest
     * @return Result of the UpdateConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest updateConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector
     * delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization
     * cannot update this setting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConfigurationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationResponse updateConfiguration(
            Consumer<UpdateConfigurationRequest.Builder> updateConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        return updateConfiguration(UpdateConfigurationRequest.builder().applyMutation(updateConfigurationRequest).build());
    }

    /**
     * <p>
     * Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account.
     * </p>
     *
     * @param updateEc2DeepInspectionConfigurationRequest
     * @return Result of the UpdateEc2DeepInspectionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEc2DeepInspectionConfigurationResponse updateEc2DeepInspectionConfiguration(
            UpdateEc2DeepInspectionConfigurationRequest updateEc2DeepInspectionConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateEc2DeepInspectionConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateEc2DeepInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateEc2DeepInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEc2DeepInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateEc2DeepInspectionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEc2DeepInspectionConfigurationResponse updateEc2DeepInspectionConfiguration(
            Consumer<UpdateEc2DeepInspectionConfigurationRequest.Builder> updateEc2DeepInspectionConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return updateEc2DeepInspectionConfiguration(UpdateEc2DeepInspectionConfigurationRequest.builder()
                .applyMutation(updateEc2DeepInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an encryption key. A <code>ResourceNotFoundException</code> means that an AWS owned key is being used for
     * encryption.
     * </p>
     *
     * @param updateEncryptionKeyRequest
     * @return Result of the UpdateEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEncryptionKeyResponse updateEncryptionKey(UpdateEncryptionKeyRequest updateEncryptionKeyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an encryption key. A <code>ResourceNotFoundException</code> means that an AWS owned key is being used for
     * encryption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEncryptionKeyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param updateEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEncryptionKeyResponse updateEncryptionKey(
            Consumer<UpdateEncryptionKeyRequest.Builder> updateEncryptionKeyRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return updateEncryptionKey(UpdateEncryptionKeyRequest.builder().applyMutation(updateEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Specifies the action that is to be applied to the findings that match the filter.
     * </p>
     *
     * @param updateFilterRequest
     * @return Result of the UpdateFilter operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFilterResponse updateFilter(UpdateFilterRequest updateFilterRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies the action that is to be applied to the findings that match the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFilterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFilterRequest#builder()}
     * </p>
     *
     * @param updateFilterRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFilterRequest.Builder} to create a request.
     * @return Result of the UpdateFilter operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The operation tried to access an invalid resource. Make sure the resource is specified correctly.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFilterResponse updateFilter(Consumer<UpdateFilterRequest.Builder> updateFilterRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        return updateFilter(UpdateFilterRequest.builder().applyMutation(updateFilterRequest).build());
    }

    /**
     * <p>
     * Updates the Amazon Inspector deep inspection custom paths for your organization. You must be an Amazon Inspector
     * delegated administrator to use this API.
     * </p>
     *
     * @param updateOrgEc2DeepInspectionConfigurationRequest
     * @return Result of the UpdateOrgEc2DeepInspectionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateOrgEc2DeepInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrgEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrgEc2DeepInspectionConfigurationResponse updateOrgEc2DeepInspectionConfiguration(
            UpdateOrgEc2DeepInspectionConfigurationRequest updateOrgEc2DeepInspectionConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Amazon Inspector deep inspection custom paths for your organization. You must be an Amazon Inspector
     * delegated administrator to use this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateOrgEc2DeepInspectionConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateOrgEc2DeepInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrgEc2DeepInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateOrgEc2DeepInspectionConfigurationRequest.Builder} to create a request.
     * @return Result of the UpdateOrgEc2DeepInspectionConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateOrgEc2DeepInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrgEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrgEc2DeepInspectionConfigurationResponse updateOrgEc2DeepInspectionConfiguration(
            Consumer<UpdateOrgEc2DeepInspectionConfigurationRequest.Builder> updateOrgEc2DeepInspectionConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return updateOrgEc2DeepInspectionConfiguration(UpdateOrgEc2DeepInspectionConfigurationRequest.builder()
                .applyMutation(updateOrgEc2DeepInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the configurations for your Amazon Inspector organization.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return Result of the UpdateOrganizationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            Inspector2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configurations for your Amazon Inspector organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateOrganizationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the Amazon Inspector service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Inspector2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Inspector2Client.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(
            Consumer<UpdateOrganizationConfigurationRequest.Builder> updateOrganizationConfigurationRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, Inspector2Exception {
        return updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.builder()
                .applyMutation(updateOrganizationConfigurationRequest).build());
    }

    /**
     * Create a {@link Inspector2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Inspector2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Inspector2Client}.
     */
    static Inspector2ClientBuilder builder() {
        return new DefaultInspector2ClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default Inspector2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
