/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.InspectorServiceClientConfiguration;
import software.amazon.awssdk.services.inspector.internal.InspectorServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.inspector.model.AccessDeniedException;
import software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsRequest;
import software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsResponse;
import software.amazon.awssdk.services.inspector.model.AgentsAlreadyRunningAssessmentException;
import software.amazon.awssdk.services.inspector.model.AssessmentRunInProgressException;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateRequest;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateResponse;
import software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewRequest;
import software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewResponse;
import software.amazon.awssdk.services.inspector.model.CreateResourceGroupRequest;
import software.amazon.awssdk.services.inspector.model.CreateResourceGroupResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesResponse;
import software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleRequest;
import software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleResponse;
import software.amazon.awssdk.services.inspector.model.DescribeExclusionsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeExclusionsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeFindingsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeFindingsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesRequest;
import software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesResponse;
import software.amazon.awssdk.services.inspector.model.GetAssessmentReportRequest;
import software.amazon.awssdk.services.inspector.model.GetAssessmentReportResponse;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse;
import software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataRequest;
import software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataResponse;
import software.amazon.awssdk.services.inspector.model.InspectorException;
import software.amazon.awssdk.services.inspector.model.InternalException;
import software.amazon.awssdk.services.inspector.model.InvalidCrossAccountRoleException;
import software.amazon.awssdk.services.inspector.model.InvalidInputException;
import software.amazon.awssdk.services.inspector.model.LimitExceededException;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse;
import software.amazon.awssdk.services.inspector.model.ListExclusionsRequest;
import software.amazon.awssdk.services.inspector.model.ListExclusionsResponse;
import software.amazon.awssdk.services.inspector.model.ListFindingsRequest;
import software.amazon.awssdk.services.inspector.model.ListFindingsResponse;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse;
import software.amazon.awssdk.services.inspector.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.inspector.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.inspector.model.NoSuchEntityException;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse;
import software.amazon.awssdk.services.inspector.model.PreviewGenerationInProgressException;
import software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleRequest;
import software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleResponse;
import software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsRequest;
import software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsResponse;
import software.amazon.awssdk.services.inspector.model.ServiceTemporarilyUnavailableException;
import software.amazon.awssdk.services.inspector.model.SetTagsForResourceRequest;
import software.amazon.awssdk.services.inspector.model.SetTagsForResourceResponse;
import software.amazon.awssdk.services.inspector.model.StartAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.StartAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.StopAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.StopAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.SubscribeToEventRequest;
import software.amazon.awssdk.services.inspector.model.SubscribeToEventResponse;
import software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventRequest;
import software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventResponse;
import software.amazon.awssdk.services.inspector.model.UnsupportedFeatureException;
import software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.transform.AddAttributesToFindingsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.CreateAssessmentTargetRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.CreateAssessmentTemplateRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.CreateExclusionsPreviewRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.CreateResourceGroupRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DeleteAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DeleteAssessmentTargetRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DeleteAssessmentTemplateRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeAssessmentRunsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeAssessmentTargetsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeAssessmentTemplatesRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeCrossAccountAccessRoleRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeExclusionsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeFindingsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeResourceGroupsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeRulesPackagesRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.GetAssessmentReportRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.GetExclusionsPreviewRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.GetTelemetryMetadataRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListAssessmentRunAgentsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListAssessmentRunsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListAssessmentTargetsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListAssessmentTemplatesRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListExclusionsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListRulesPackagesRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.PreviewAgentsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.RegisterCrossAccountAccessRoleRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.RemoveAttributesFromFindingsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.SetTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.StartAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.StopAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.SubscribeToEventRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.UnsubscribeFromEventRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.UpdateAssessmentTargetRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultInspectorClient
implements InspectorClient {
    private static final Logger log = Logger.loggerFor(DefaultInspectorClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultInspectorClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddAttributesToFindingsResponse addAttributesToFindings(AddAttributesToFindingsRequest addAttributesToFindingsRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddAttributesToFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addAttributesToFindingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, addAttributesToFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddAttributesToFindings");
            AddAttributesToFindingsResponse addAttributesToFindingsResponse = (AddAttributesToFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddAttributesToFindings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addAttributesToFindingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddAttributesToFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addAttributesToFindingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$addAttributesToFindings$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssessmentTargetResponse createAssessmentTarget(CreateAssessmentTargetRequest createAssessmentTargetRequest) throws InternalException, InvalidInputException, LimitExceededException, AccessDeniedException, NoSuchEntityException, InvalidCrossAccountRoleException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAssessmentTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAssessmentTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, createAssessmentTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAssessmentTarget");
            CreateAssessmentTargetResponse createAssessmentTargetResponse = (CreateAssessmentTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAssessmentTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAssessmentTargetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAssessmentTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAssessmentTargetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$createAssessmentTarget$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssessmentTemplateResponse createAssessmentTemplate(CreateAssessmentTemplateRequest createAssessmentTemplateRequest) throws InternalException, InvalidInputException, LimitExceededException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAssessmentTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAssessmentTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, createAssessmentTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAssessmentTemplate");
            CreateAssessmentTemplateResponse createAssessmentTemplateResponse = (CreateAssessmentTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAssessmentTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAssessmentTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAssessmentTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAssessmentTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$createAssessmentTemplate$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateExclusionsPreviewResponse createExclusionsPreview(CreateExclusionsPreviewRequest createExclusionsPreviewRequest) throws InvalidInputException, PreviewGenerationInProgressException, InternalException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateExclusionsPreviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createExclusionsPreviewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, createExclusionsPreviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateExclusionsPreview");
            CreateExclusionsPreviewResponse createExclusionsPreviewResponse = (CreateExclusionsPreviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateExclusionsPreview").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createExclusionsPreviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateExclusionsPreviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createExclusionsPreviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$createExclusionsPreview$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResourceGroupResponse createResourceGroup(CreateResourceGroupRequest createResourceGroupRequest) throws InternalException, InvalidInputException, LimitExceededException, AccessDeniedException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResourceGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createResourceGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, createResourceGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResourceGroup");
            CreateResourceGroupResponse createResourceGroupResponse = (CreateResourceGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResourceGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createResourceGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateResourceGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createResourceGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$createResourceGroup$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssessmentRunResponse deleteAssessmentRun(DeleteAssessmentRunRequest deleteAssessmentRunRequest) throws InternalException, InvalidInputException, AssessmentRunInProgressException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAssessmentRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAssessmentRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, deleteAssessmentRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAssessmentRun");
            DeleteAssessmentRunResponse deleteAssessmentRunResponse = (DeleteAssessmentRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAssessmentRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAssessmentRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAssessmentRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAssessmentRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$deleteAssessmentRun$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssessmentTargetResponse deleteAssessmentTarget(DeleteAssessmentTargetRequest deleteAssessmentTargetRequest) throws InternalException, InvalidInputException, AssessmentRunInProgressException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAssessmentTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAssessmentTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, deleteAssessmentTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAssessmentTarget");
            DeleteAssessmentTargetResponse deleteAssessmentTargetResponse = (DeleteAssessmentTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAssessmentTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAssessmentTargetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAssessmentTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAssessmentTargetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$deleteAssessmentTarget$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssessmentTemplateResponse deleteAssessmentTemplate(DeleteAssessmentTemplateRequest deleteAssessmentTemplateRequest) throws InternalException, InvalidInputException, AssessmentRunInProgressException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAssessmentTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAssessmentTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, deleteAssessmentTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAssessmentTemplate");
            DeleteAssessmentTemplateResponse deleteAssessmentTemplateResponse = (DeleteAssessmentTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAssessmentTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAssessmentTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAssessmentTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAssessmentTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$deleteAssessmentTemplate$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssessmentRunsResponse describeAssessmentRuns(DescribeAssessmentRunsRequest describeAssessmentRunsRequest) throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAssessmentRunsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAssessmentRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, describeAssessmentRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAssessmentRuns");
            DescribeAssessmentRunsResponse describeAssessmentRunsResponse = (DescribeAssessmentRunsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAssessmentRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAssessmentRunsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAssessmentRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAssessmentRunsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$describeAssessmentRuns$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssessmentTargetsResponse describeAssessmentTargets(DescribeAssessmentTargetsRequest describeAssessmentTargetsRequest) throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAssessmentTargetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAssessmentTargetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, describeAssessmentTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAssessmentTargets");
            DescribeAssessmentTargetsResponse describeAssessmentTargetsResponse = (DescribeAssessmentTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAssessmentTargets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAssessmentTargetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAssessmentTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAssessmentTargetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$describeAssessmentTargets$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssessmentTemplatesResponse describeAssessmentTemplates(DescribeAssessmentTemplatesRequest describeAssessmentTemplatesRequest) throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAssessmentTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAssessmentTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, describeAssessmentTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAssessmentTemplates");
            DescribeAssessmentTemplatesResponse describeAssessmentTemplatesResponse = (DescribeAssessmentTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAssessmentTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAssessmentTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAssessmentTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAssessmentTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$describeAssessmentTemplates$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCrossAccountAccessRoleResponse describeCrossAccountAccessRole(DescribeCrossAccountAccessRoleRequest describeCrossAccountAccessRoleRequest) throws InternalException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCrossAccountAccessRoleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCrossAccountAccessRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, describeCrossAccountAccessRoleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCrossAccountAccessRole");
            DescribeCrossAccountAccessRoleResponse describeCrossAccountAccessRoleResponse = (DescribeCrossAccountAccessRoleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCrossAccountAccessRole").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCrossAccountAccessRoleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCrossAccountAccessRoleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCrossAccountAccessRoleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$describeCrossAccountAccessRole$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExclusionsResponse describeExclusions(DescribeExclusionsRequest describeExclusionsRequest) throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExclusionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeExclusionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, describeExclusionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExclusions");
            DescribeExclusionsResponse describeExclusionsResponse = (DescribeExclusionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExclusions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeExclusionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExclusionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeExclusionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$describeExclusions$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFindingsResponse describeFindings(DescribeFindingsRequest describeFindingsRequest) throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFindingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, describeFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFindings");
            DescribeFindingsResponse describeFindingsResponse = (DescribeFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFindings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFindingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFindingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$describeFindings$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourceGroupsResponse describeResourceGroups(DescribeResourceGroupsRequest describeResourceGroupsRequest) throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourceGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeResourceGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, describeResourceGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourceGroups");
            DescribeResourceGroupsResponse describeResourceGroupsResponse = (DescribeResourceGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourceGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeResourceGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeResourceGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeResourceGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$describeResourceGroups$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRulesPackagesResponse describeRulesPackages(DescribeRulesPackagesRequest describeRulesPackagesRequest) throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRulesPackagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRulesPackagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, describeRulesPackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRulesPackages");
            DescribeRulesPackagesResponse describeRulesPackagesResponse = (DescribeRulesPackagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRulesPackages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRulesPackagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRulesPackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRulesPackagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$describeRulesPackages$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAssessmentReportResponse getAssessmentReport(GetAssessmentReportRequest getAssessmentReportRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AssessmentRunInProgressException, UnsupportedFeatureException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssessmentReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAssessmentReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, getAssessmentReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssessmentReport");
            GetAssessmentReportResponse getAssessmentReportResponse = (GetAssessmentReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssessmentReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAssessmentReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAssessmentReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAssessmentReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$getAssessmentReport$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetExclusionsPreviewResponse getExclusionsPreview(GetExclusionsPreviewRequest getExclusionsPreviewRequest) throws InvalidInputException, InternalException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExclusionsPreviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getExclusionsPreviewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, getExclusionsPreviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExclusionsPreview");
            GetExclusionsPreviewResponse getExclusionsPreviewResponse = (GetExclusionsPreviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExclusionsPreview").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getExclusionsPreviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetExclusionsPreviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getExclusionsPreviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$getExclusionsPreview$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTelemetryMetadataResponse getTelemetryMetadata(GetTelemetryMetadataRequest getTelemetryMetadataRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTelemetryMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTelemetryMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, getTelemetryMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTelemetryMetadata");
            GetTelemetryMetadataResponse getTelemetryMetadataResponse = (GetTelemetryMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTelemetryMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTelemetryMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTelemetryMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTelemetryMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$getTelemetryMetadata$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentRunAgentsResponse listAssessmentRunAgents(ListAssessmentRunAgentsRequest listAssessmentRunAgentsRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssessmentRunAgentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssessmentRunAgentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, listAssessmentRunAgentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssessmentRunAgents");
            ListAssessmentRunAgentsResponse listAssessmentRunAgentsResponse = (ListAssessmentRunAgentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssessmentRunAgents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAssessmentRunAgentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssessmentRunAgentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssessmentRunAgentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$listAssessmentRunAgents$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentRunsResponse listAssessmentRuns(ListAssessmentRunsRequest listAssessmentRunsRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssessmentRunsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssessmentRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, listAssessmentRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssessmentRuns");
            ListAssessmentRunsResponse listAssessmentRunsResponse = (ListAssessmentRunsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssessmentRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAssessmentRunsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssessmentRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssessmentRunsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$listAssessmentRuns$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentTargetsResponse listAssessmentTargets(ListAssessmentTargetsRequest listAssessmentTargetsRequest) throws InternalException, InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssessmentTargetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssessmentTargetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, listAssessmentTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssessmentTargets");
            ListAssessmentTargetsResponse listAssessmentTargetsResponse = (ListAssessmentTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssessmentTargets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAssessmentTargetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssessmentTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssessmentTargetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$listAssessmentTargets$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentTemplatesResponse listAssessmentTemplates(ListAssessmentTemplatesRequest listAssessmentTemplatesRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssessmentTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssessmentTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, listAssessmentTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssessmentTemplates");
            ListAssessmentTemplatesResponse listAssessmentTemplatesResponse = (ListAssessmentTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssessmentTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAssessmentTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssessmentTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssessmentTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$listAssessmentTemplates$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventSubscriptionsResponse listEventSubscriptions(ListEventSubscriptionsRequest listEventSubscriptionsRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventSubscriptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventSubscriptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, listEventSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventSubscriptions");
            ListEventSubscriptionsResponse listEventSubscriptionsResponse = (ListEventSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventSubscriptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEventSubscriptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventSubscriptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$listEventSubscriptions$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExclusionsResponse listExclusions(ListExclusionsRequest listExclusionsRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExclusionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listExclusionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, listExclusionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExclusions");
            ListExclusionsResponse listExclusionsResponse = (ListExclusionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExclusions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listExclusionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExclusionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExclusionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$listExclusions$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFindingsResponse listFindings(ListFindingsRequest listFindingsRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFindingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, listFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFindings");
            ListFindingsResponse listFindingsResponse = (ListFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFindings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFindingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFindingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$listFindings$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRulesPackagesResponse listRulesPackages(ListRulesPackagesRequest listRulesPackagesRequest) throws InternalException, InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRulesPackagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRulesPackagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, listRulesPackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRulesPackages");
            ListRulesPackagesResponse listRulesPackagesResponse = (ListRulesPackagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRulesPackages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRulesPackagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRulesPackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRulesPackagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$listRulesPackages$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$listTagsForResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreviewAgentsResponse previewAgents(PreviewAgentsRequest previewAgentsRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, InvalidCrossAccountRoleException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PreviewAgentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)previewAgentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, previewAgentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PreviewAgents");
            PreviewAgentsResponse previewAgentsResponse = (PreviewAgentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PreviewAgents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)previewAgentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PreviewAgentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return previewAgentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$previewAgents$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterCrossAccountAccessRoleResponse registerCrossAccountAccessRole(RegisterCrossAccountAccessRoleRequest registerCrossAccountAccessRoleRequest) throws InternalException, InvalidInputException, AccessDeniedException, InvalidCrossAccountRoleException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterCrossAccountAccessRoleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerCrossAccountAccessRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, registerCrossAccountAccessRoleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterCrossAccountAccessRole");
            RegisterCrossAccountAccessRoleResponse registerCrossAccountAccessRoleResponse = (RegisterCrossAccountAccessRoleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterCrossAccountAccessRole").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerCrossAccountAccessRoleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterCrossAccountAccessRoleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerCrossAccountAccessRoleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$registerCrossAccountAccessRole$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveAttributesFromFindingsResponse removeAttributesFromFindings(RemoveAttributesFromFindingsRequest removeAttributesFromFindingsRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveAttributesFromFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeAttributesFromFindingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, removeAttributesFromFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveAttributesFromFindings");
            RemoveAttributesFromFindingsResponse removeAttributesFromFindingsResponse = (RemoveAttributesFromFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveAttributesFromFindings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeAttributesFromFindingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveAttributesFromFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeAttributesFromFindingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$removeAttributesFromFindings$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetTagsForResourceResponse setTagsForResource(SetTagsForResourceRequest setTagsForResourceRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, setTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetTagsForResource");
            SetTagsForResourceResponse setTagsForResourceResponse = (SetTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$setTagsForResource$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartAssessmentRunResponse startAssessmentRun(StartAssessmentRunRequest startAssessmentRunRequest) throws InternalException, InvalidInputException, LimitExceededException, AccessDeniedException, NoSuchEntityException, InvalidCrossAccountRoleException, AgentsAlreadyRunningAssessmentException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartAssessmentRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startAssessmentRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, startAssessmentRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartAssessmentRun");
            StartAssessmentRunResponse startAssessmentRunResponse = (StartAssessmentRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartAssessmentRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startAssessmentRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartAssessmentRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startAssessmentRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$startAssessmentRun$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopAssessmentRunResponse stopAssessmentRun(StopAssessmentRunRequest stopAssessmentRunRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopAssessmentRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopAssessmentRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, stopAssessmentRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopAssessmentRun");
            StopAssessmentRunResponse stopAssessmentRunResponse = (StopAssessmentRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopAssessmentRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopAssessmentRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopAssessmentRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopAssessmentRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$stopAssessmentRun$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscribeToEventResponse subscribeToEvent(SubscribeToEventRequest subscribeToEventRequest) throws InternalException, InvalidInputException, LimitExceededException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubscribeToEventResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)subscribeToEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, subscribeToEventRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubscribeToEvent");
            SubscribeToEventResponse subscribeToEventResponse = (SubscribeToEventResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubscribeToEvent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)subscribeToEventRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SubscribeToEventRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return subscribeToEventResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$subscribeToEvent$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnsubscribeFromEventResponse unsubscribeFromEvent(UnsubscribeFromEventRequest unsubscribeFromEventRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnsubscribeFromEventResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)unsubscribeFromEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, unsubscribeFromEventRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnsubscribeFromEvent");
            UnsubscribeFromEventResponse unsubscribeFromEventResponse = (UnsubscribeFromEventResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnsubscribeFromEvent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)unsubscribeFromEventRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnsubscribeFromEventRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unsubscribeFromEventResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$unsubscribeFromEvent$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAssessmentTargetResponse updateAssessmentTarget(UpdateAssessmentTargetRequest updateAssessmentTargetRequest) throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAssessmentTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAssessmentTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorClient.resolveMetricPublishers(clientConfiguration, updateAssessmentTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAssessmentTarget");
            UpdateAssessmentTargetResponse updateAssessmentTargetResponse = (UpdateAssessmentTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAssessmentTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAssessmentTargetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAssessmentTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAssessmentTargetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspectorClient.lambda$updateAssessmentTarget$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "inspector";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        InspectorServiceClientConfigurationBuilder serviceConfigBuilder = new InspectorServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(InspectorException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").exceptionBuilderSupplier(AssessmentRunInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").exceptionBuilderSupplier(UnsupportedFeatureException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchEntityException").exceptionBuilderSupplier(NoSuchEntityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final InspectorServiceClientConfiguration serviceClientConfiguration() {
        return new InspectorServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateAssessmentTarget$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unsubscribeFromEvent$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$subscribeToEvent$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopAssessmentRun$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startAssessmentRun$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setTagsForResource$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeAttributesFromFindings$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerCrossAccountAccessRole$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$previewAgents$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRulesPackages$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFindings$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExclusions$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventSubscriptions$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssessmentTemplates$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssessmentTargets$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssessmentRuns$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssessmentRunAgents$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTelemetryMetadata$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExclusionsPreview$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAssessmentReport$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRulesPackages$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourceGroups$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFindings$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExclusions$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCrossAccountAccessRole$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAssessmentTemplates$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAssessmentTargets$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAssessmentRuns$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAssessmentTemplate$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAssessmentTarget$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAssessmentRun$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createResourceGroup$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createExclusionsPreview$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAssessmentTemplate$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAssessmentTarget$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addAttributesToFindings$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

