/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteComponentResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, DeleteComponentResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(DeleteComponentResponse.getter(DeleteComponentResponse::requestId)).setter(DeleteComponentResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> COMPONENT_BUILD_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentBuildVersionArn").getter(DeleteComponentResponse.getter(DeleteComponentResponse::componentBuildVersionArn)).setter(DeleteComponentResponse.setter(Builder::componentBuildVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentBuildVersionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, COMPONENT_BUILD_VERSION_ARN_FIELD));
    private final String requestIdValue;
    private final String componentBuildVersionArn;

    private DeleteComponentResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.componentBuildVersionArn = builder.componentBuildVersionArn;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final String componentBuildVersionArn() {
        return this.componentBuildVersionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentBuildVersionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteComponentResponse)) {
            return false;
        }
        DeleteComponentResponse other = (DeleteComponentResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.componentBuildVersionArn(), other.componentBuildVersionArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteComponentResponse").add("RequestId", (Object)this.requestId()).add("ComponentBuildVersionArn", (Object)this.componentBuildVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "componentBuildVersionArn": {
                return Optional.ofNullable(clazz.cast(this.componentBuildVersionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteComponentResponse, T> g) {
        return obj -> g.apply((DeleteComponentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String componentBuildVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteComponentResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.componentBuildVersionArn(model.componentBuildVersionArn);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getComponentBuildVersionArn() {
            return this.componentBuildVersionArn;
        }

        public final void setComponentBuildVersionArn(String componentBuildVersionArn) {
            this.componentBuildVersionArn = componentBuildVersionArn;
        }

        @Override
        public final Builder componentBuildVersionArn(String componentBuildVersionArn) {
            this.componentBuildVersionArn = componentBuildVersionArn;
            return this;
        }

        @Override
        public DeleteComponentResponse build() {
            return new DeleteComponentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteComponentResponse> {
        public Builder requestId(String var1);

        public Builder componentBuildVersionArn(String var1);
    }
}

