/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the launch template that the associated Windows AMI uses for launching an instance when faster launching
 * is enabled.
 * </p>
 * <note>
 * <p>
 * You can specify either the <code>launchTemplateName</code> or the <code>launchTemplateId</code>, but not both.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FastLaunchLaunchTemplateSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<FastLaunchLaunchTemplateSpecification.Builder, FastLaunchLaunchTemplateSpecification> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchTemplateId").getter(getter(FastLaunchLaunchTemplateSpecification::launchTemplateId))
            .setter(setter(Builder::launchTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplateId").build()).build();

    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchTemplateName").getter(getter(FastLaunchLaunchTemplateSpecification::launchTemplateName))
            .setter(setter(Builder::launchTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplateName").build())
            .build();

    private static final SdkField<String> LAUNCH_TEMPLATE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchTemplateVersion").getter(getter(FastLaunchLaunchTemplateSpecification::launchTemplateVersion))
            .setter(setter(Builder::launchTemplateVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplateVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD,
            LAUNCH_TEMPLATE_NAME_FIELD, LAUNCH_TEMPLATE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchTemplateId;

    private final String launchTemplateName;

    private final String launchTemplateVersion;

    private FastLaunchLaunchTemplateSpecification(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.launchTemplateVersion = builder.launchTemplateVersion;
    }

    /**
     * <p>
     * The ID of the launch template to use for faster launching for a Windows AMI.
     * </p>
     * 
     * @return The ID of the launch template to use for faster launching for a Windows AMI.
     */
    public final String launchTemplateId() {
        return launchTemplateId;
    }

    /**
     * <p>
     * The name of the launch template to use for faster launching for a Windows AMI.
     * </p>
     * 
     * @return The name of the launch template to use for faster launching for a Windows AMI.
     */
    public final String launchTemplateName() {
        return launchTemplateName;
    }

    /**
     * <p>
     * The version of the launch template to use for faster launching for a Windows AMI.
     * </p>
     * 
     * @return The version of the launch template to use for faster launching for a Windows AMI.
     */
    public final String launchTemplateVersion() {
        return launchTemplateVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FastLaunchLaunchTemplateSpecification)) {
            return false;
        }
        FastLaunchLaunchTemplateSpecification other = (FastLaunchLaunchTemplateSpecification) obj;
        return Objects.equals(launchTemplateId(), other.launchTemplateId())
                && Objects.equals(launchTemplateName(), other.launchTemplateName())
                && Objects.equals(launchTemplateVersion(), other.launchTemplateVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FastLaunchLaunchTemplateSpecification").add("LaunchTemplateId", launchTemplateId())
                .add("LaunchTemplateName", launchTemplateName()).add("LaunchTemplateVersion", launchTemplateVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchTemplateId":
            return Optional.ofNullable(clazz.cast(launchTemplateId()));
        case "launchTemplateName":
            return Optional.ofNullable(clazz.cast(launchTemplateName()));
        case "launchTemplateVersion":
            return Optional.ofNullable(clazz.cast(launchTemplateVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FastLaunchLaunchTemplateSpecification, T> g) {
        return obj -> g.apply((FastLaunchLaunchTemplateSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FastLaunchLaunchTemplateSpecification> {
        /**
         * <p>
         * The ID of the launch template to use for faster launching for a Windows AMI.
         * </p>
         * 
         * @param launchTemplateId
         *        The ID of the launch template to use for faster launching for a Windows AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateId(String launchTemplateId);

        /**
         * <p>
         * The name of the launch template to use for faster launching for a Windows AMI.
         * </p>
         * 
         * @param launchTemplateName
         *        The name of the launch template to use for faster launching for a Windows AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateName(String launchTemplateName);

        /**
         * <p>
         * The version of the launch template to use for faster launching for a Windows AMI.
         * </p>
         * 
         * @param launchTemplateVersion
         *        The version of the launch template to use for faster launching for a Windows AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateVersion(String launchTemplateVersion);
    }

    static final class BuilderImpl implements Builder {
        private String launchTemplateId;

        private String launchTemplateName;

        private String launchTemplateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(FastLaunchLaunchTemplateSpecification model) {
            launchTemplateId(model.launchTemplateId);
            launchTemplateName(model.launchTemplateName);
            launchTemplateVersion(model.launchTemplateVersion);
        }

        public final String getLaunchTemplateId() {
            return launchTemplateId;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final String getLaunchTemplateName() {
            return launchTemplateName;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final String getLaunchTemplateVersion() {
            return launchTemplateVersion;
        }

        public final void setLaunchTemplateVersion(String launchTemplateVersion) {
            this.launchTemplateVersion = launchTemplateVersion;
        }

        @Override
        public final Builder launchTemplateVersion(String launchTemplateVersion) {
            this.launchTemplateVersion = launchTemplateVersion;
            return this;
        }

        @Override
        public FastLaunchLaunchTemplateSpecification build() {
            return new FastLaunchLaunchTemplateSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
