/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about package vulnerability findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageVulnerabilityDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageVulnerabilityDetails.Builder, PackageVulnerabilityDetails> {
    private static final SdkField<String> VULNERABILITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vulnerabilityId").getter(getter(PackageVulnerabilityDetails::vulnerabilityId))
            .setter(setter(Builder::vulnerabilityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityId").build()).build();

    private static final SdkField<List<VulnerablePackage>> VULNERABLE_PACKAGES_FIELD = SdkField
            .<List<VulnerablePackage>> builder(MarshallingType.LIST)
            .memberName("vulnerablePackages")
            .getter(getter(PackageVulnerabilityDetails::vulnerablePackages))
            .setter(setter(Builder::vulnerablePackages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerablePackages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VulnerablePackage> builder(MarshallingType.SDK_POJO)
                                            .constructor(VulnerablePackage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(PackageVulnerabilityDetails::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<List<CvssScore>> CVSS_FIELD = SdkField
            .<List<CvssScore>> builder(MarshallingType.LIST)
            .memberName("cvss")
            .getter(getter(PackageVulnerabilityDetails::cvss))
            .setter(setter(Builder::cvss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cvss").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CvssScore> builder(MarshallingType.SDK_POJO)
                                            .constructor(CvssScore::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RELATED_VULNERABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("relatedVulnerabilities")
            .getter(getter(PackageVulnerabilityDetails::relatedVulnerabilities))
            .setter(setter(Builder::relatedVulnerabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedVulnerabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceUrl").getter(getter(PackageVulnerabilityDetails::sourceUrl)).setter(setter(Builder::sourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceUrl").build()).build();

    private static final SdkField<String> VENDOR_SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vendorSeverity").getter(getter(PackageVulnerabilityDetails::vendorSeverity))
            .setter(setter(Builder::vendorSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorSeverity").build()).build();

    private static final SdkField<Instant> VENDOR_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("vendorCreatedAt").getter(getter(PackageVulnerabilityDetails::vendorCreatedAt))
            .setter(setter(Builder::vendorCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorCreatedAt").build()).build();

    private static final SdkField<Instant> VENDOR_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("vendorUpdatedAt").getter(getter(PackageVulnerabilityDetails::vendorUpdatedAt))
            .setter(setter(Builder::vendorUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorUpdatedAt").build()).build();

    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("referenceUrls")
            .getter(getter(PackageVulnerabilityDetails::referenceUrls))
            .setter(setter(Builder::referenceUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VULNERABILITY_ID_FIELD,
            VULNERABLE_PACKAGES_FIELD, SOURCE_FIELD, CVSS_FIELD, RELATED_VULNERABILITIES_FIELD, SOURCE_URL_FIELD,
            VENDOR_SEVERITY_FIELD, VENDOR_CREATED_AT_FIELD, VENDOR_UPDATED_AT_FIELD, REFERENCE_URLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vulnerabilityId;

    private final List<VulnerablePackage> vulnerablePackages;

    private final String source;

    private final List<CvssScore> cvss;

    private final List<String> relatedVulnerabilities;

    private final String sourceUrl;

    private final String vendorSeverity;

    private final Instant vendorCreatedAt;

    private final Instant vendorUpdatedAt;

    private final List<String> referenceUrls;

    private PackageVulnerabilityDetails(BuilderImpl builder) {
        this.vulnerabilityId = builder.vulnerabilityId;
        this.vulnerablePackages = builder.vulnerablePackages;
        this.source = builder.source;
        this.cvss = builder.cvss;
        this.relatedVulnerabilities = builder.relatedVulnerabilities;
        this.sourceUrl = builder.sourceUrl;
        this.vendorSeverity = builder.vendorSeverity;
        this.vendorCreatedAt = builder.vendorCreatedAt;
        this.vendorUpdatedAt = builder.vendorUpdatedAt;
        this.referenceUrls = builder.referenceUrls;
    }

    /**
     * <p>
     * A unique identifier for this vulnerability.
     * </p>
     * 
     * @return A unique identifier for this vulnerability.
     */
    public final String vulnerabilityId() {
        return vulnerabilityId;
    }

    /**
     * For responses, this returns true if the service returned a value for the VulnerablePackages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVulnerablePackages() {
        return vulnerablePackages != null && !(vulnerablePackages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The packages that this vulnerability impacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVulnerablePackages} method.
     * </p>
     * 
     * @return The packages that this vulnerability impacts.
     */
    public final List<VulnerablePackage> vulnerablePackages() {
        return vulnerablePackages;
    }

    /**
     * <p>
     * The source of the vulnerability information.
     * </p>
     * 
     * @return The source of the vulnerability information.
     */
    public final String source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cvss property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCvss() {
        return cvss != null && !(cvss instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * CVSS scores for one or more vulnerabilities that Amazon Inspector identified for a package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCvss} method.
     * </p>
     * 
     * @return CVSS scores for one or more vulnerabilities that Amazon Inspector identified for a package.
     */
    public final List<CvssScore> cvss() {
        return cvss;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelatedVulnerabilities property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRelatedVulnerabilities() {
        return relatedVulnerabilities != null && !(relatedVulnerabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Vulnerabilities that are often related to the findings for the package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelatedVulnerabilities} method.
     * </p>
     * 
     * @return Vulnerabilities that are often related to the findings for the package.
     */
    public final List<String> relatedVulnerabilities() {
        return relatedVulnerabilities;
    }

    /**
     * <p>
     * A link to the source of the vulnerability information.
     * </p>
     * 
     * @return A link to the source of the vulnerability information.
     */
    public final String sourceUrl() {
        return sourceUrl;
    }

    /**
     * <p>
     * The severity that the vendor assigned to this vulnerability type.
     * </p>
     * 
     * @return The severity that the vendor assigned to this vulnerability type.
     */
    public final String vendorSeverity() {
        return vendorSeverity;
    }

    /**
     * <p>
     * The date and time when this vulnerability was first added to the vendor's database.
     * </p>
     * 
     * @return The date and time when this vulnerability was first added to the vendor's database.
     */
    public final Instant vendorCreatedAt() {
        return vendorCreatedAt;
    }

    /**
     * <p>
     * The date and time when the vendor last updated this vulnerability in their database.
     * </p>
     * 
     * @return The date and time when the vendor last updated this vulnerability in their database.
     */
    public final Instant vendorUpdatedAt() {
        return vendorUpdatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceUrls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceUrls() {
        return referenceUrls != null && !(referenceUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Links to web pages that contain details about the vulnerabilities that Amazon Inspector identified for the
     * package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceUrls} method.
     * </p>
     * 
     * @return Links to web pages that contain details about the vulnerabilities that Amazon Inspector identified for
     *         the package.
     */
    public final List<String> referenceUrls() {
        return referenceUrls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vulnerabilityId());
        hashCode = 31 * hashCode + Objects.hashCode(hasVulnerablePackages() ? vulnerablePackages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasCvss() ? cvss() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedVulnerabilities() ? relatedVulnerabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(vendorSeverity());
        hashCode = 31 * hashCode + Objects.hashCode(vendorCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(vendorUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceUrls() ? referenceUrls() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVulnerabilityDetails)) {
            return false;
        }
        PackageVulnerabilityDetails other = (PackageVulnerabilityDetails) obj;
        return Objects.equals(vulnerabilityId(), other.vulnerabilityId())
                && hasVulnerablePackages() == other.hasVulnerablePackages()
                && Objects.equals(vulnerablePackages(), other.vulnerablePackages()) && Objects.equals(source(), other.source())
                && hasCvss() == other.hasCvss() && Objects.equals(cvss(), other.cvss())
                && hasRelatedVulnerabilities() == other.hasRelatedVulnerabilities()
                && Objects.equals(relatedVulnerabilities(), other.relatedVulnerabilities())
                && Objects.equals(sourceUrl(), other.sourceUrl()) && Objects.equals(vendorSeverity(), other.vendorSeverity())
                && Objects.equals(vendorCreatedAt(), other.vendorCreatedAt())
                && Objects.equals(vendorUpdatedAt(), other.vendorUpdatedAt()) && hasReferenceUrls() == other.hasReferenceUrls()
                && Objects.equals(referenceUrls(), other.referenceUrls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageVulnerabilityDetails").add("VulnerabilityId", vulnerabilityId())
                .add("VulnerablePackages", hasVulnerablePackages() ? vulnerablePackages() : null).add("Source", source())
                .add("Cvss", hasCvss() ? cvss() : null)
                .add("RelatedVulnerabilities", hasRelatedVulnerabilities() ? relatedVulnerabilities() : null)
                .add("SourceUrl", sourceUrl()).add("VendorSeverity", vendorSeverity()).add("VendorCreatedAt", vendorCreatedAt())
                .add("VendorUpdatedAt", vendorUpdatedAt()).add("ReferenceUrls", hasReferenceUrls() ? referenceUrls() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vulnerabilityId":
            return Optional.ofNullable(clazz.cast(vulnerabilityId()));
        case "vulnerablePackages":
            return Optional.ofNullable(clazz.cast(vulnerablePackages()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "cvss":
            return Optional.ofNullable(clazz.cast(cvss()));
        case "relatedVulnerabilities":
            return Optional.ofNullable(clazz.cast(relatedVulnerabilities()));
        case "sourceUrl":
            return Optional.ofNullable(clazz.cast(sourceUrl()));
        case "vendorSeverity":
            return Optional.ofNullable(clazz.cast(vendorSeverity()));
        case "vendorCreatedAt":
            return Optional.ofNullable(clazz.cast(vendorCreatedAt()));
        case "vendorUpdatedAt":
            return Optional.ofNullable(clazz.cast(vendorUpdatedAt()));
        case "referenceUrls":
            return Optional.ofNullable(clazz.cast(referenceUrls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageVulnerabilityDetails, T> g) {
        return obj -> g.apply((PackageVulnerabilityDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageVulnerabilityDetails> {
        /**
         * <p>
         * A unique identifier for this vulnerability.
         * </p>
         * 
         * @param vulnerabilityId
         *        A unique identifier for this vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilityId(String vulnerabilityId);

        /**
         * <p>
         * The packages that this vulnerability impacts.
         * </p>
         * 
         * @param vulnerablePackages
         *        The packages that this vulnerability impacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerablePackages(Collection<VulnerablePackage> vulnerablePackages);

        /**
         * <p>
         * The packages that this vulnerability impacts.
         * </p>
         * 
         * @param vulnerablePackages
         *        The packages that this vulnerability impacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerablePackages(VulnerablePackage... vulnerablePackages);

        /**
         * <p>
         * The packages that this vulnerability impacts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.VulnerablePackage.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.VulnerablePackage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.VulnerablePackage.Builder#build()} is called
         * immediately and its result is passed to {@link #vulnerablePackages(List<VulnerablePackage>)}.
         * 
         * @param vulnerablePackages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.VulnerablePackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vulnerablePackages(java.util.Collection<VulnerablePackage>)
         */
        Builder vulnerablePackages(Consumer<VulnerablePackage.Builder>... vulnerablePackages);

        /**
         * <p>
         * The source of the vulnerability information.
         * </p>
         * 
         * @param source
         *        The source of the vulnerability information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * CVSS scores for one or more vulnerabilities that Amazon Inspector identified for a package.
         * </p>
         * 
         * @param cvss
         *        CVSS scores for one or more vulnerabilities that Amazon Inspector identified for a package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cvss(Collection<CvssScore> cvss);

        /**
         * <p>
         * CVSS scores for one or more vulnerabilities that Amazon Inspector identified for a package.
         * </p>
         * 
         * @param cvss
         *        CVSS scores for one or more vulnerabilities that Amazon Inspector identified for a package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cvss(CvssScore... cvss);

        /**
         * <p>
         * CVSS scores for one or more vulnerabilities that Amazon Inspector identified for a package.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.CvssScore.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.imagebuilder.model.CvssScore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.CvssScore.Builder#build()} is called immediately
         * and its result is passed to {@link #cvss(List<CvssScore>)}.
         * 
         * @param cvss
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.CvssScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cvss(java.util.Collection<CvssScore>)
         */
        Builder cvss(Consumer<CvssScore.Builder>... cvss);

        /**
         * <p>
         * Vulnerabilities that are often related to the findings for the package.
         * </p>
         * 
         * @param relatedVulnerabilities
         *        Vulnerabilities that are often related to the findings for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities);

        /**
         * <p>
         * Vulnerabilities that are often related to the findings for the package.
         * </p>
         * 
         * @param relatedVulnerabilities
         *        Vulnerabilities that are often related to the findings for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedVulnerabilities(String... relatedVulnerabilities);

        /**
         * <p>
         * A link to the source of the vulnerability information.
         * </p>
         * 
         * @param sourceUrl
         *        A link to the source of the vulnerability information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(String sourceUrl);

        /**
         * <p>
         * The severity that the vendor assigned to this vulnerability type.
         * </p>
         * 
         * @param vendorSeverity
         *        The severity that the vendor assigned to this vulnerability type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorSeverity(String vendorSeverity);

        /**
         * <p>
         * The date and time when this vulnerability was first added to the vendor's database.
         * </p>
         * 
         * @param vendorCreatedAt
         *        The date and time when this vulnerability was first added to the vendor's database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorCreatedAt(Instant vendorCreatedAt);

        /**
         * <p>
         * The date and time when the vendor last updated this vulnerability in their database.
         * </p>
         * 
         * @param vendorUpdatedAt
         *        The date and time when the vendor last updated this vulnerability in their database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorUpdatedAt(Instant vendorUpdatedAt);

        /**
         * <p>
         * Links to web pages that contain details about the vulnerabilities that Amazon Inspector identified for the
         * package.
         * </p>
         * 
         * @param referenceUrls
         *        Links to web pages that contain details about the vulnerabilities that Amazon Inspector identified for
         *        the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(Collection<String> referenceUrls);

        /**
         * <p>
         * Links to web pages that contain details about the vulnerabilities that Amazon Inspector identified for the
         * package.
         * </p>
         * 
         * @param referenceUrls
         *        Links to web pages that contain details about the vulnerabilities that Amazon Inspector identified for
         *        the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(String... referenceUrls);
    }

    static final class BuilderImpl implements Builder {
        private String vulnerabilityId;

        private List<VulnerablePackage> vulnerablePackages = DefaultSdkAutoConstructList.getInstance();

        private String source;

        private List<CvssScore> cvss = DefaultSdkAutoConstructList.getInstance();

        private List<String> relatedVulnerabilities = DefaultSdkAutoConstructList.getInstance();

        private String sourceUrl;

        private String vendorSeverity;

        private Instant vendorCreatedAt;

        private Instant vendorUpdatedAt;

        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVulnerabilityDetails model) {
            vulnerabilityId(model.vulnerabilityId);
            vulnerablePackages(model.vulnerablePackages);
            source(model.source);
            cvss(model.cvss);
            relatedVulnerabilities(model.relatedVulnerabilities);
            sourceUrl(model.sourceUrl);
            vendorSeverity(model.vendorSeverity);
            vendorCreatedAt(model.vendorCreatedAt);
            vendorUpdatedAt(model.vendorUpdatedAt);
            referenceUrls(model.referenceUrls);
        }

        public final String getVulnerabilityId() {
            return vulnerabilityId;
        }

        public final void setVulnerabilityId(String vulnerabilityId) {
            this.vulnerabilityId = vulnerabilityId;
        }

        @Override
        public final Builder vulnerabilityId(String vulnerabilityId) {
            this.vulnerabilityId = vulnerabilityId;
            return this;
        }

        public final List<VulnerablePackage.Builder> getVulnerablePackages() {
            List<VulnerablePackage.Builder> result = VulnerablePackageListCopier.copyToBuilder(this.vulnerablePackages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerablePackages(Collection<VulnerablePackage.BuilderImpl> vulnerablePackages) {
            this.vulnerablePackages = VulnerablePackageListCopier.copyFromBuilder(vulnerablePackages);
        }

        @Override
        public final Builder vulnerablePackages(Collection<VulnerablePackage> vulnerablePackages) {
            this.vulnerablePackages = VulnerablePackageListCopier.copy(vulnerablePackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(VulnerablePackage... vulnerablePackages) {
            vulnerablePackages(Arrays.asList(vulnerablePackages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(Consumer<VulnerablePackage.Builder>... vulnerablePackages) {
            vulnerablePackages(Stream.of(vulnerablePackages).map(c -> VulnerablePackage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final List<CvssScore.Builder> getCvss() {
            List<CvssScore.Builder> result = CvssScoreListCopier.copyToBuilder(this.cvss);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCvss(Collection<CvssScore.BuilderImpl> cvss) {
            this.cvss = CvssScoreListCopier.copyFromBuilder(cvss);
        }

        @Override
        public final Builder cvss(Collection<CvssScore> cvss) {
            this.cvss = CvssScoreListCopier.copy(cvss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(CvssScore... cvss) {
            cvss(Arrays.asList(cvss));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(Consumer<CvssScore.Builder>... cvss) {
            cvss(Stream.of(cvss).map(c -> CvssScore.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRelatedVulnerabilities() {
            if (relatedVulnerabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return relatedVulnerabilities;
        }

        public final void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = VulnerabilityIdListCopier.copy(relatedVulnerabilities);
        }

        @Override
        public final Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = VulnerabilityIdListCopier.copy(relatedVulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedVulnerabilities(String... relatedVulnerabilities) {
            relatedVulnerabilities(Arrays.asList(relatedVulnerabilities));
            return this;
        }

        public final String getSourceUrl() {
            return sourceUrl;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final String getVendorSeverity() {
            return vendorSeverity;
        }

        public final void setVendorSeverity(String vendorSeverity) {
            this.vendorSeverity = vendorSeverity;
        }

        @Override
        public final Builder vendorSeverity(String vendorSeverity) {
            this.vendorSeverity = vendorSeverity;
            return this;
        }

        public final Instant getVendorCreatedAt() {
            return vendorCreatedAt;
        }

        public final void setVendorCreatedAt(Instant vendorCreatedAt) {
            this.vendorCreatedAt = vendorCreatedAt;
        }

        @Override
        public final Builder vendorCreatedAt(Instant vendorCreatedAt) {
            this.vendorCreatedAt = vendorCreatedAt;
            return this;
        }

        public final Instant getVendorUpdatedAt() {
            return vendorUpdatedAt;
        }

        public final void setVendorUpdatedAt(Instant vendorUpdatedAt) {
            this.vendorUpdatedAt = vendorUpdatedAt;
        }

        @Override
        public final Builder vendorUpdatedAt(Instant vendorUpdatedAt) {
            this.vendorUpdatedAt = vendorUpdatedAt;
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = NonEmptyStringListCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = NonEmptyStringListCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String... referenceUrls) {
            referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        @Override
        public PackageVulnerabilityDetails build() {
            return new PackageVulnerabilityDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
