/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.identitystore.model.Address;
import software.amazon.awssdk.services.identitystore.model.AddressesCopier;
import software.amazon.awssdk.services.identitystore.model.Email;
import software.amazon.awssdk.services.identitystore.model.EmailsCopier;
import software.amazon.awssdk.services.identitystore.model.ExternalId;
import software.amazon.awssdk.services.identitystore.model.ExternalIdsCopier;
import software.amazon.awssdk.services.identitystore.model.IdentitystoreResponse;
import software.amazon.awssdk.services.identitystore.model.Name;
import software.amazon.awssdk.services.identitystore.model.PhoneNumber;
import software.amazon.awssdk.services.identitystore.model.PhoneNumbersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserResponse
extends IdentitystoreResponse
implements ToCopyableBuilder<Builder, DescribeUserResponse> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(DescribeUserResponse.getter(DescribeUserResponse::userName)).setter(DescribeUserResponse.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(DescribeUserResponse.getter(DescribeUserResponse::userId)).setter(DescribeUserResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<List<ExternalId>> EXTERNAL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExternalIds").getter(DescribeUserResponse.getter(DescribeUserResponse::externalIds)).setter(DescribeUserResponse.setter(Builder::externalIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExternalId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Name> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Name").getter(DescribeUserResponse.getter(DescribeUserResponse::name)).setter(DescribeUserResponse.setter(Builder::name)).constructor(Name::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(DescribeUserResponse.getter(DescribeUserResponse::displayName)).setter(DescribeUserResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> NICK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NickName").getter(DescribeUserResponse.getter(DescribeUserResponse::nickName)).setter(DescribeUserResponse.setter(Builder::nickName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NickName").build()}).build();
    private static final SdkField<String> PROFILE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileUrl").getter(DescribeUserResponse.getter(DescribeUserResponse::profileUrl)).setter(DescribeUserResponse.setter(Builder::profileUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileUrl").build()}).build();
    private static final SdkField<List<Email>> EMAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Emails").getter(DescribeUserResponse.getter(DescribeUserResponse::emails)).setter(DescribeUserResponse.setter(Builder::emails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Email::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Address>> ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Addresses").getter(DescribeUserResponse.getter(DescribeUserResponse::addresses)).setter(DescribeUserResponse.setter(Builder::addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PhoneNumber>> PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumbers").getter(DescribeUserResponse.getter(DescribeUserResponse::phoneNumbers)).setter(DescribeUserResponse.setter(Builder::phoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserType").getter(DescribeUserResponse.getter(DescribeUserResponse::userType)).setter(DescribeUserResponse.setter(Builder::userType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserType").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(DescribeUserResponse.getter(DescribeUserResponse::title)).setter(DescribeUserResponse.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> PREFERRED_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredLanguage").getter(DescribeUserResponse.getter(DescribeUserResponse::preferredLanguage)).setter(DescribeUserResponse.setter(Builder::preferredLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredLanguage").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locale").getter(DescribeUserResponse.getter(DescribeUserResponse::locale)).setter(DescribeUserResponse.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(DescribeUserResponse.getter(DescribeUserResponse::timezone)).setter(DescribeUserResponse.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityStoreId").getter(DescribeUserResponse.getter(DescribeUserResponse::identityStoreId)).setter(DescribeUserResponse.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, USER_ID_FIELD, EXTERNAL_IDS_FIELD, NAME_FIELD, DISPLAY_NAME_FIELD, NICK_NAME_FIELD, PROFILE_URL_FIELD, EMAILS_FIELD, ADDRESSES_FIELD, PHONE_NUMBERS_FIELD, USER_TYPE_FIELD, TITLE_FIELD, PREFERRED_LANGUAGE_FIELD, LOCALE_FIELD, TIMEZONE_FIELD, IDENTITY_STORE_ID_FIELD));
    private final String userName;
    private final String userId;
    private final List<ExternalId> externalIds;
    private final Name name;
    private final String displayName;
    private final String nickName;
    private final String profileUrl;
    private final List<Email> emails;
    private final List<Address> addresses;
    private final List<PhoneNumber> phoneNumbers;
    private final String userType;
    private final String title;
    private final String preferredLanguage;
    private final String locale;
    private final String timezone;
    private final String identityStoreId;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.userId = builder.userId;
        this.externalIds = builder.externalIds;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.nickName = builder.nickName;
        this.profileUrl = builder.profileUrl;
        this.emails = builder.emails;
        this.addresses = builder.addresses;
        this.phoneNumbers = builder.phoneNumbers;
        this.userType = builder.userType;
        this.title = builder.title;
        this.preferredLanguage = builder.preferredLanguage;
        this.locale = builder.locale;
        this.timezone = builder.timezone;
        this.identityStoreId = builder.identityStoreId;
    }

    public final String userName() {
        return this.userName;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasExternalIds() {
        return this.externalIds != null && !(this.externalIds instanceof SdkAutoConstructList);
    }

    public final List<ExternalId> externalIds() {
        return this.externalIds;
    }

    public final Name name() {
        return this.name;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String nickName() {
        return this.nickName;
    }

    public final String profileUrl() {
        return this.profileUrl;
    }

    public final boolean hasEmails() {
        return this.emails != null && !(this.emails instanceof SdkAutoConstructList);
    }

    public final List<Email> emails() {
        return this.emails;
    }

    public final boolean hasAddresses() {
        return this.addresses != null && !(this.addresses instanceof SdkAutoConstructList);
    }

    public final List<Address> addresses() {
        return this.addresses;
    }

    public final boolean hasPhoneNumbers() {
        return this.phoneNumbers != null && !(this.phoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<PhoneNumber> phoneNumbers() {
        return this.phoneNumbers;
    }

    public final String userType() {
        return this.userType;
    }

    public final String title() {
        return this.title;
    }

    public final String preferredLanguage() {
        return this.preferredLanguage;
    }

    public final String locale() {
        return this.locale;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalIds() ? this.externalIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nickName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmails() ? this.emails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddresses() ? this.addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumbers() ? this.phoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userType());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.userId(), other.userId()) && this.hasExternalIds() == other.hasExternalIds() && Objects.equals(this.externalIds(), other.externalIds()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.nickName(), other.nickName()) && Objects.equals(this.profileUrl(), other.profileUrl()) && this.hasEmails() == other.hasEmails() && Objects.equals(this.emails(), other.emails()) && this.hasAddresses() == other.hasAddresses() && Objects.equals(this.addresses(), other.addresses()) && this.hasPhoneNumbers() == other.hasPhoneNumbers() && Objects.equals(this.phoneNumbers(), other.phoneNumbers()) && Objects.equals(this.userType(), other.userType()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.preferredLanguage(), other.preferredLanguage()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.identityStoreId(), other.identityStoreId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeUserResponse").add("UserName", (Object)(this.userName() == null ? null : "*** Sensitive Data Redacted ***")).add("UserId", (Object)this.userId()).add("ExternalIds", this.hasExternalIds() ? this.externalIds() : null).add("Name", (Object)this.name()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("NickName", (Object)(this.nickName() == null ? null : "*** Sensitive Data Redacted ***")).add("ProfileUrl", (Object)(this.profileUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("Emails", this.hasEmails() ? this.emails() : null).add("Addresses", this.hasAddresses() ? this.addresses() : null).add("PhoneNumbers", this.hasPhoneNumbers() ? this.phoneNumbers() : null).add("UserType", (Object)(this.userType() == null ? null : "*** Sensitive Data Redacted ***")).add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).add("PreferredLanguage", (Object)(this.preferredLanguage() == null ? null : "*** Sensitive Data Redacted ***")).add("Locale", (Object)(this.locale() == null ? null : "*** Sensitive Data Redacted ***")).add("Timezone", (Object)(this.timezone() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentityStoreId", (Object)this.identityStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "ExternalIds": {
                return Optional.ofNullable(clazz.cast(this.externalIds()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "NickName": {
                return Optional.ofNullable(clazz.cast(this.nickName()));
            }
            case "ProfileUrl": {
                return Optional.ofNullable(clazz.cast(this.profileUrl()));
            }
            case "Emails": {
                return Optional.ofNullable(clazz.cast(this.emails()));
            }
            case "Addresses": {
                return Optional.ofNullable(clazz.cast(this.addresses()));
            }
            case "PhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.phoneNumbers()));
            }
            case "UserType": {
                return Optional.ofNullable(clazz.cast(this.userType()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "PreferredLanguage": {
                return Optional.ofNullable(clazz.cast(this.preferredLanguage()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "IdentityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserResponse, T> g) {
        return obj -> g.apply((DescribeUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IdentitystoreResponse.BuilderImpl
    implements Builder {
        private String userName;
        private String userId;
        private List<ExternalId> externalIds = DefaultSdkAutoConstructList.getInstance();
        private Name name;
        private String displayName;
        private String nickName;
        private String profileUrl;
        private List<Email> emails = DefaultSdkAutoConstructList.getInstance();
        private List<Address> addresses = DefaultSdkAutoConstructList.getInstance();
        private List<PhoneNumber> phoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private String userType;
        private String title;
        private String preferredLanguage;
        private String locale;
        private String timezone;
        private String identityStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            super(model);
            this.userName(model.userName);
            this.userId(model.userId);
            this.externalIds(model.externalIds);
            this.name(model.name);
            this.displayName(model.displayName);
            this.nickName(model.nickName);
            this.profileUrl(model.profileUrl);
            this.emails(model.emails);
            this.addresses(model.addresses);
            this.phoneNumbers(model.phoneNumbers);
            this.userType(model.userType);
            this.title(model.title);
            this.preferredLanguage(model.preferredLanguage);
            this.locale(model.locale);
            this.timezone(model.timezone);
            this.identityStoreId(model.identityStoreId);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final List<ExternalId.Builder> getExternalIds() {
            List<ExternalId.Builder> result = ExternalIdsCopier.copyToBuilder(this.externalIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExternalIds(Collection<ExternalId.BuilderImpl> externalIds) {
            this.externalIds = ExternalIdsCopier.copyFromBuilder(externalIds);
        }

        @Override
        public final Builder externalIds(Collection<ExternalId> externalIds) {
            this.externalIds = ExternalIdsCopier.copy(externalIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalIds(ExternalId ... externalIds) {
            this.externalIds(Arrays.asList(externalIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalIds(Consumer<ExternalId.Builder> ... externalIds) {
            this.externalIds(Stream.of(externalIds).map(c -> (ExternalId)((ExternalId.Builder)ExternalId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Name.Builder getName() {
            return this.name != null ? this.name.toBuilder() : null;
        }

        public final void setName(Name.BuilderImpl name) {
            this.name = name != null ? name.build() : null;
        }

        @Override
        public final Builder name(Name name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getNickName() {
            return this.nickName;
        }

        public final void setNickName(String nickName) {
            this.nickName = nickName;
        }

        @Override
        public final Builder nickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public final String getProfileUrl() {
            return this.profileUrl;
        }

        public final void setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
        }

        @Override
        public final Builder profileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
            return this;
        }

        public final List<Email.Builder> getEmails() {
            List<Email.Builder> result = EmailsCopier.copyToBuilder(this.emails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmails(Collection<Email.BuilderImpl> emails) {
            this.emails = EmailsCopier.copyFromBuilder(emails);
        }

        @Override
        public final Builder emails(Collection<Email> emails) {
            this.emails = EmailsCopier.copy(emails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emails(Email ... emails) {
            this.emails(Arrays.asList(emails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emails(Consumer<Email.Builder> ... emails) {
            this.emails(Stream.of(emails).map(c -> (Email)((Email.Builder)Email.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Address.Builder> getAddresses() {
            List<Address.Builder> result = AddressesCopier.copyToBuilder(this.addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddresses(Collection<Address.BuilderImpl> addresses) {
            this.addresses = AddressesCopier.copyFromBuilder(addresses);
        }

        @Override
        public final Builder addresses(Collection<Address> addresses) {
            this.addresses = AddressesCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Address ... addresses) {
            this.addresses(Arrays.asList(addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Consumer<Address.Builder> ... addresses) {
            this.addresses(Stream.of(addresses).map(c -> (Address)((Address.Builder)Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PhoneNumber.Builder> getPhoneNumbers() {
            List<PhoneNumber.Builder> result = PhoneNumbersCopier.copyToBuilder(this.phoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumbers(Collection<PhoneNumber.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = PhoneNumbersCopier.copyFromBuilder(phoneNumbers);
        }

        @Override
        public final Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = PhoneNumbersCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(PhoneNumber ... phoneNumbers) {
            this.phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<PhoneNumber.Builder> ... phoneNumbers) {
            this.phoneNumbers(Stream.of(phoneNumbers).map(c -> (PhoneNumber)((PhoneNumber.Builder)PhoneNumber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserType() {
            return this.userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getPreferredLanguage() {
            return this.preferredLanguage;
        }

        public final void setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
        }

        @Override
        public final Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IdentitystoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserResponse> {
        public Builder userName(String var1);

        public Builder userId(String var1);

        public Builder externalIds(Collection<ExternalId> var1);

        public Builder externalIds(ExternalId ... var1);

        public Builder externalIds(Consumer<ExternalId.Builder> ... var1);

        public Builder name(Name var1);

        default public Builder name(Consumer<Name.Builder> name) {
            return this.name((Name)((Name.Builder)Name.builder().applyMutation(name)).build());
        }

        public Builder displayName(String var1);

        public Builder nickName(String var1);

        public Builder profileUrl(String var1);

        public Builder emails(Collection<Email> var1);

        public Builder emails(Email ... var1);

        public Builder emails(Consumer<Email.Builder> ... var1);

        public Builder addresses(Collection<Address> var1);

        public Builder addresses(Address ... var1);

        public Builder addresses(Consumer<Address.Builder> ... var1);

        public Builder phoneNumbers(Collection<PhoneNumber> var1);

        public Builder phoneNumbers(PhoneNumber ... var1);

        public Builder phoneNumbers(Consumer<PhoneNumber.Builder> ... var1);

        public Builder userType(String var1);

        public Builder title(String var1);

        public Builder preferredLanguage(String var1);

        public Builder locale(String var1);

        public Builder timezone(String var1);

        public Builder identityStoreId(String var1);
    }
}

