/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserRequest extends IdentitystoreRequest implements
        ToCopyableBuilder<CreateUserRequest.Builder, CreateUserRequest> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStoreId").getter(getter(CreateUserRequest::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(CreateUserRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<Name> NAME_FIELD = SdkField.<Name> builder(MarshallingType.SDK_POJO).memberName("Name")
            .getter(getter(CreateUserRequest::name)).setter(setter(Builder::name)).constructor(Name::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateUserRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> NICK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NickName").getter(getter(CreateUserRequest::nickName)).setter(setter(Builder::nickName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NickName").build()).build();

    private static final SdkField<String> PROFILE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileUrl").getter(getter(CreateUserRequest::profileUrl)).setter(setter(Builder::profileUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileUrl").build()).build();

    private static final SdkField<List<Email>> EMAILS_FIELD = SdkField
            .<List<Email>> builder(MarshallingType.LIST)
            .memberName("Emails")
            .getter(getter(CreateUserRequest::emails))
            .setter(setter(Builder::emails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Email> builder(MarshallingType.SDK_POJO)
                                            .constructor(Email::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Address>> ADDRESSES_FIELD = SdkField
            .<List<Address>> builder(MarshallingType.LIST)
            .memberName("Addresses")
            .getter(getter(CreateUserRequest::addresses))
            .setter(setter(Builder::addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PhoneNumber>> PHONE_NUMBERS_FIELD = SdkField
            .<List<PhoneNumber>> builder(MarshallingType.LIST)
            .memberName("PhoneNumbers")
            .getter(getter(CreateUserRequest::phoneNumbers))
            .setter(setter(Builder::phoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumber> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserType").getter(getter(CreateUserRequest::userType)).setter(setter(Builder::userType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserType").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(CreateUserRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> PREFERRED_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredLanguage").getter(getter(CreateUserRequest::preferredLanguage))
            .setter(setter(Builder::preferredLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredLanguage").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Locale")
            .getter(getter(CreateUserRequest::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(CreateUserRequest::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD,
            USER_NAME_FIELD, NAME_FIELD, DISPLAY_NAME_FIELD, NICK_NAME_FIELD, PROFILE_URL_FIELD, EMAILS_FIELD, ADDRESSES_FIELD,
            PHONE_NUMBERS_FIELD, USER_TYPE_FIELD, TITLE_FIELD, PREFERRED_LANGUAGE_FIELD, LOCALE_FIELD, TIMEZONE_FIELD));

    private final String identityStoreId;

    private final String userName;

    private final Name name;

    private final String displayName;

    private final String nickName;

    private final String profileUrl;

    private final List<Email> emails;

    private final List<Address> addresses;

    private final List<PhoneNumber> phoneNumbers;

    private final String userType;

    private final String title;

    private final String preferredLanguage;

    private final String locale;

    private final String timezone;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.userName = builder.userName;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.nickName = builder.nickName;
        this.profileUrl = builder.profileUrl;
        this.emails = builder.emails;
        this.addresses = builder.addresses;
        this.phoneNumbers = builder.phoneNumbers;
        this.userType = builder.userType;
        this.title = builder.title;
        this.preferredLanguage = builder.preferredLanguage;
        this.locale = builder.locale;
        this.timezone = builder.timezone;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store.
     * </p>
     * 
     * @return The globally unique identifier for the identity store.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    /**
     * <p>
     * A unique string used to identify the user. The length limit is 128 characters. This value can consist of letters,
     * accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created
     * and stored as an attribute of the user object in the identity store. "Administrator" and "AWSAdministrators" are
     * reserved names and can't be used for users or groups.
     * </p>
     * 
     * @return A unique string used to identify the user. The length limit is 128 characters. This value can consist of
     *         letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the
     *         user is created and stored as an attribute of the user object in the identity store. "Administrator" and
     *         "AWSAdministrators" are reserved names and can't be used for users or groups.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * An object containing the name of the user.
     * </p>
     * 
     * @return An object containing the name of the user.
     */
    public final Name name() {
        return name;
    }

    /**
     * <p>
     * A string containing the name of the user. This value is typically formatted for display when the user is
     * referenced. For example, "John Doe."
     * </p>
     * 
     * @return A string containing the name of the user. This value is typically formatted for display when the user is
     *         referenced. For example, "John Doe."
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A string containing an alternate name for the user.
     * </p>
     * 
     * @return A string containing an alternate name for the user.
     */
    public final String nickName() {
        return nickName;
    }

    /**
     * <p>
     * A string containing a URL that might be associated with the user.
     * </p>
     * 
     * @return A string containing a URL that might be associated with the user.
     */
    public final String profileUrl() {
        return profileUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the Emails property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEmails() {
        return emails != null && !(emails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>Email</code> objects containing email addresses associated with the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmails} method.
     * </p>
     * 
     * @return A list of <code>Email</code> objects containing email addresses associated with the user.
     */
    public final List<Email> emails() {
        return emails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Addresses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddresses() {
        return addresses != null && !(addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>Address</code> objects containing addresses associated with the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddresses} method.
     * </p>
     * 
     * @return A list of <code>Address</code> objects containing addresses associated with the user.
     */
    public final List<Address> addresses() {
        return addresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhoneNumbers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhoneNumbers() {
        return phoneNumbers != null && !(phoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>PhoneNumber</code> objects containing phone numbers associated with the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhoneNumbers} method.
     * </p>
     * 
     * @return A list of <code>PhoneNumber</code> objects containing phone numbers associated with the user.
     */
    public final List<PhoneNumber> phoneNumbers() {
        return phoneNumbers;
    }

    /**
     * <p>
     * A string indicating the type of user. Possible values are left unspecified. The value can vary based on your
     * specific use case.
     * </p>
     * 
     * @return A string indicating the type of user. Possible values are left unspecified. The value can vary based on
     *         your specific use case.
     */
    public final String userType() {
        return userType;
    }

    /**
     * <p>
     * A string containing the title of the user. Possible values are left unspecified. The value can vary based on your
     * specific use case.
     * </p>
     * 
     * @return A string containing the title of the user. Possible values are left unspecified. The value can vary based
     *         on your specific use case.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * A string containing the preferred language of the user. For example, "American English" or "en-us."
     * </p>
     * 
     * @return A string containing the preferred language of the user. For example, "American English" or "en-us."
     */
    public final String preferredLanguage() {
        return preferredLanguage;
    }

    /**
     * <p>
     * A string containing the geographical region or location of the user.
     * </p>
     * 
     * @return A string containing the geographical region or location of the user.
     */
    public final String locale() {
        return locale;
    }

    /**
     * <p>
     * A string containing the time zone of the user.
     * </p>
     * 
     * @return A string containing the time zone of the user.
     */
    public final String timezone() {
        return timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(nickName());
        hashCode = 31 * hashCode + Objects.hashCode(profileUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasEmails() ? emails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddresses() ? addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumbers() ? phoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userType());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(preferredLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest) obj;
        return Objects.equals(identityStoreId(), other.identityStoreId()) && Objects.equals(userName(), other.userName())
                && Objects.equals(name(), other.name()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(nickName(), other.nickName()) && Objects.equals(profileUrl(), other.profileUrl())
                && hasEmails() == other.hasEmails() && Objects.equals(emails(), other.emails())
                && hasAddresses() == other.hasAddresses() && Objects.equals(addresses(), other.addresses())
                && hasPhoneNumbers() == other.hasPhoneNumbers() && Objects.equals(phoneNumbers(), other.phoneNumbers())
                && Objects.equals(userType(), other.userType()) && Objects.equals(title(), other.title())
                && Objects.equals(preferredLanguage(), other.preferredLanguage()) && Objects.equals(locale(), other.locale())
                && Objects.equals(timezone(), other.timezone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserRequest").add("IdentityStoreId", identityStoreId())
                .add("UserName", userName() == null ? null : "*** Sensitive Data Redacted ***").add("Name", name())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NickName", nickName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProfileUrl", profileUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Emails", hasEmails() ? emails() : null).add("Addresses", hasAddresses() ? addresses() : null)
                .add("PhoneNumbers", hasPhoneNumbers() ? phoneNumbers() : null)
                .add("UserType", userType() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PreferredLanguage", preferredLanguage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Locale", locale() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Timezone", timezone() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "NickName":
            return Optional.ofNullable(clazz.cast(nickName()));
        case "ProfileUrl":
            return Optional.ofNullable(clazz.cast(profileUrl()));
        case "Emails":
            return Optional.ofNullable(clazz.cast(emails()));
        case "Addresses":
            return Optional.ofNullable(clazz.cast(addresses()));
        case "PhoneNumbers":
            return Optional.ofNullable(clazz.cast(phoneNumbers()));
        case "UserType":
            return Optional.ofNullable(clazz.cast(userType()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "PreferredLanguage":
            return Optional.ofNullable(clazz.cast(preferredLanguage()));
        case "Locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IdentitystoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserRequest> {
        /**
         * <p>
         * The globally unique identifier for the identity store.
         * </p>
         * 
         * @param identityStoreId
         *        The globally unique identifier for the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * A unique string used to identify the user. The length limit is 128 characters. This value can consist of
         * letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user
         * is created and stored as an attribute of the user object in the identity store. "Administrator" and
         * "AWSAdministrators" are reserved names and can't be used for users or groups.
         * </p>
         * 
         * @param userName
         *        A unique string used to identify the user. The length limit is 128 characters. This value can consist
         *        of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the
         *        time the user is created and stored as an attribute of the user object in the identity store.
         *        "Administrator" and "AWSAdministrators" are reserved names and can't be used for users or groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * An object containing the name of the user.
         * </p>
         * 
         * @param name
         *        An object containing the name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(Name name);

        /**
         * <p>
         * An object containing the name of the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link Name.Builder} avoiding the need to create
         * one manually via {@link Name#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Name.Builder#build()} is called immediately and its result is
         * passed to {@link #name(Name)}.
         * 
         * @param name
         *        a consumer that will call methods on {@link Name.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #name(Name)
         */
        default Builder name(Consumer<Name.Builder> name) {
            return name(Name.builder().applyMutation(name).build());
        }

        /**
         * <p>
         * A string containing the name of the user. This value is typically formatted for display when the user is
         * referenced. For example, "John Doe."
         * </p>
         * 
         * @param displayName
         *        A string containing the name of the user. This value is typically formatted for display when the user
         *        is referenced. For example, "John Doe."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A string containing an alternate name for the user.
         * </p>
         * 
         * @param nickName
         *        A string containing an alternate name for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nickName(String nickName);

        /**
         * <p>
         * A string containing a URL that might be associated with the user.
         * </p>
         * 
         * @param profileUrl
         *        A string containing a URL that might be associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileUrl(String profileUrl);

        /**
         * <p>
         * A list of <code>Email</code> objects containing email addresses associated with the user.
         * </p>
         * 
         * @param emails
         *        A list of <code>Email</code> objects containing email addresses associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emails(Collection<Email> emails);

        /**
         * <p>
         * A list of <code>Email</code> objects containing email addresses associated with the user.
         * </p>
         * 
         * @param emails
         *        A list of <code>Email</code> objects containing email addresses associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emails(Email... emails);

        /**
         * <p>
         * A list of <code>Email</code> objects containing email addresses associated with the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.identitystore.model.Email.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.identitystore.model.Email#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.identitystore.model.Email.Builder#build()} is called immediately and
         * its result is passed to {@link #emails(List<Email>)}.
         * 
         * @param emails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.identitystore.model.Email.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emails(java.util.Collection<Email>)
         */
        Builder emails(Consumer<Email.Builder>... emails);

        /**
         * <p>
         * A list of <code>Address</code> objects containing addresses associated with the user.
         * </p>
         * 
         * @param addresses
         *        A list of <code>Address</code> objects containing addresses associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Collection<Address> addresses);

        /**
         * <p>
         * A list of <code>Address</code> objects containing addresses associated with the user.
         * </p>
         * 
         * @param addresses
         *        A list of <code>Address</code> objects containing addresses associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Address... addresses);

        /**
         * <p>
         * A list of <code>Address</code> objects containing addresses associated with the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.identitystore.model.Address.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.identitystore.model.Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.identitystore.model.Address.Builder#build()} is called immediately and
         * its result is passed to {@link #addresses(List<Address>)}.
         * 
         * @param addresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.identitystore.model.Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addresses(java.util.Collection<Address>)
         */
        Builder addresses(Consumer<Address.Builder>... addresses);

        /**
         * <p>
         * A list of <code>PhoneNumber</code> objects containing phone numbers associated with the user.
         * </p>
         * 
         * @param phoneNumbers
         *        A list of <code>PhoneNumber</code> objects containing phone numbers associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers);

        /**
         * <p>
         * A list of <code>PhoneNumber</code> objects containing phone numbers associated with the user.
         * </p>
         * 
         * @param phoneNumbers
         *        A list of <code>PhoneNumber</code> objects containing phone numbers associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(PhoneNumber... phoneNumbers);

        /**
         * <p>
         * A list of <code>PhoneNumber</code> objects containing phone numbers associated with the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.identitystore.model.PhoneNumber.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.identitystore.model.PhoneNumber#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.identitystore.model.PhoneNumber.Builder#build()} is called immediately
         * and its result is passed to {@link #phoneNumbers(List<PhoneNumber>)}.
         * 
         * @param phoneNumbers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.identitystore.model.PhoneNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumbers(java.util.Collection<PhoneNumber>)
         */
        Builder phoneNumbers(Consumer<PhoneNumber.Builder>... phoneNumbers);

        /**
         * <p>
         * A string indicating the type of user. Possible values are left unspecified. The value can vary based on your
         * specific use case.
         * </p>
         * 
         * @param userType
         *        A string indicating the type of user. Possible values are left unspecified. The value can vary based
         *        on your specific use case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userType(String userType);

        /**
         * <p>
         * A string containing the title of the user. Possible values are left unspecified. The value can vary based on
         * your specific use case.
         * </p>
         * 
         * @param title
         *        A string containing the title of the user. Possible values are left unspecified. The value can vary
         *        based on your specific use case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A string containing the preferred language of the user. For example, "American English" or "en-us."
         * </p>
         * 
         * @param preferredLanguage
         *        A string containing the preferred language of the user. For example, "American English" or "en-us."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredLanguage(String preferredLanguage);

        /**
         * <p>
         * A string containing the geographical region or location of the user.
         * </p>
         * 
         * @param locale
         *        A string containing the geographical region or location of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * A string containing the time zone of the user.
         * </p>
         * 
         * @param timezone
         *        A string containing the time zone of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IdentitystoreRequest.BuilderImpl implements Builder {
        private String identityStoreId;

        private String userName;

        private Name name;

        private String displayName;

        private String nickName;

        private String profileUrl;

        private List<Email> emails = DefaultSdkAutoConstructList.getInstance();

        private List<Address> addresses = DefaultSdkAutoConstructList.getInstance();

        private List<PhoneNumber> phoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private String userType;

        private String title;

        private String preferredLanguage;

        private String locale;

        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            identityStoreId(model.identityStoreId);
            userName(model.userName);
            name(model.name);
            displayName(model.displayName);
            nickName(model.nickName);
            profileUrl(model.profileUrl);
            emails(model.emails);
            addresses(model.addresses);
            phoneNumbers(model.phoneNumbers);
            userType(model.userType);
            title(model.title);
            preferredLanguage(model.preferredLanguage);
            locale(model.locale);
            timezone(model.timezone);
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final Name.Builder getName() {
            return name != null ? name.toBuilder() : null;
        }

        public final void setName(Name.BuilderImpl name) {
            this.name = name != null ? name.build() : null;
        }

        @Override
        public final Builder name(Name name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getNickName() {
            return nickName;
        }

        public final void setNickName(String nickName) {
            this.nickName = nickName;
        }

        @Override
        public final Builder nickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public final String getProfileUrl() {
            return profileUrl;
        }

        public final void setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
        }

        @Override
        public final Builder profileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
            return this;
        }

        public final List<Email.Builder> getEmails() {
            List<Email.Builder> result = EmailsCopier.copyToBuilder(this.emails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmails(Collection<Email.BuilderImpl> emails) {
            this.emails = EmailsCopier.copyFromBuilder(emails);
        }

        @Override
        public final Builder emails(Collection<Email> emails) {
            this.emails = EmailsCopier.copy(emails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emails(Email... emails) {
            emails(Arrays.asList(emails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emails(Consumer<Email.Builder>... emails) {
            emails(Stream.of(emails).map(c -> Email.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Address.Builder> getAddresses() {
            List<Address.Builder> result = AddressesCopier.copyToBuilder(this.addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddresses(Collection<Address.BuilderImpl> addresses) {
            this.addresses = AddressesCopier.copyFromBuilder(addresses);
        }

        @Override
        public final Builder addresses(Collection<Address> addresses) {
            this.addresses = AddressesCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Address... addresses) {
            addresses(Arrays.asList(addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Consumer<Address.Builder>... addresses) {
            addresses(Stream.of(addresses).map(c -> Address.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PhoneNumber.Builder> getPhoneNumbers() {
            List<PhoneNumber.Builder> result = PhoneNumbersCopier.copyToBuilder(this.phoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumbers(Collection<PhoneNumber.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = PhoneNumbersCopier.copyFromBuilder(phoneNumbers);
        }

        @Override
        public final Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = PhoneNumbersCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(PhoneNumber... phoneNumbers) {
            phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<PhoneNumber.Builder>... phoneNumbers) {
            phoneNumbers(Stream.of(phoneNumbers).map(c -> PhoneNumber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUserType() {
            return userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getPreferredLanguage() {
            return preferredLanguage;
        }

        public final void setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
        }

        @Override
        public final Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
