/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstanceProfileTagsRequest
extends IamRequest
implements ToCopyableBuilder<Builder, ListInstanceProfileTagsRequest> {
    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileName").getter(ListInstanceProfileTagsRequest.getter(ListInstanceProfileTagsRequest::instanceProfileName)).setter(ListInstanceProfileTagsRequest.setter(Builder::instanceProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileName").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListInstanceProfileTagsRequest.getter(ListInstanceProfileTagsRequest::marker)).setter(ListInstanceProfileTagsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListInstanceProfileTagsRequest.getter(ListInstanceProfileTagsRequest::maxItems)).setter(ListInstanceProfileTagsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PROFILE_NAME_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));
    private final String instanceProfileName;
    private final String marker;
    private final Integer maxItems;

    private ListInstanceProfileTagsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceProfileName = builder.instanceProfileName;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public final String instanceProfileName() {
        return this.instanceProfileName;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceProfileTagsRequest)) {
            return false;
        }
        ListInstanceProfileTagsRequest other = (ListInstanceProfileTagsRequest)((Object)obj);
        return Objects.equals(this.instanceProfileName(), other.instanceProfileName()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListInstanceProfileTagsRequest").add("InstanceProfileName", (Object)this.instanceProfileName()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceProfileName": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileName()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceProfileTagsRequest, T> g) {
        return obj -> g.apply((ListInstanceProfileTagsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String instanceProfileName;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceProfileTagsRequest model) {
            super(model);
            this.instanceProfileName(model.instanceProfileName);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInstanceProfileTagsRequest build() {
            return new ListInstanceProfileTagsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInstanceProfileTagsRequest> {
        public Builder instanceProfileName(String var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

