/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFhirDatastoreRequest extends HealthLakeRequest implements
        ToCopyableBuilder<CreateFhirDatastoreRequest.Builder, CreateFhirDatastoreRequest> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreName").getter(getter(CreateFhirDatastoreRequest::datastoreName))
            .setter(setter(Builder::datastoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreName").build()).build();

    private static final SdkField<String> DATASTORE_TYPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreTypeVersion").getter(getter(CreateFhirDatastoreRequest::datastoreTypeVersionAsString))
            .setter(setter(Builder::datastoreTypeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreTypeVersion").build())
            .build();

    private static final SdkField<PreloadDataConfig> PRELOAD_DATA_CONFIG_FIELD = SdkField
            .<PreloadDataConfig> builder(MarshallingType.SDK_POJO).memberName("PreloadDataConfig")
            .getter(getter(CreateFhirDatastoreRequest::preloadDataConfig)).setter(setter(Builder::preloadDataConfig))
            .constructor(PreloadDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreloadDataConfig").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateFhirDatastoreRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD,
            DATASTORE_TYPE_VERSION_FIELD, PRELOAD_DATA_CONFIG_FIELD, CLIENT_TOKEN_FIELD));

    private final String datastoreName;

    private final String datastoreTypeVersion;

    private final PreloadDataConfig preloadDataConfig;

    private final String clientToken;

    private CreateFhirDatastoreRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreName = builder.datastoreName;
        this.datastoreTypeVersion = builder.datastoreTypeVersion;
        this.preloadDataConfig = builder.preloadDataConfig;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The user generated name for the Data Store.
     * </p>
     * 
     * @return The user generated name for the Data Store.
     */
    public final String datastoreName() {
        return datastoreName;
    }

    /**
     * <p>
     * The FHIR version of the Data Store. The only supported version is R4.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datastoreTypeVersion} will return {@link FHIRVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #datastoreTypeVersionAsString}.
     * </p>
     * 
     * @return The FHIR version of the Data Store. The only supported version is R4.
     * @see FHIRVersion
     */
    public final FHIRVersion datastoreTypeVersion() {
        return FHIRVersion.fromValue(datastoreTypeVersion);
    }

    /**
     * <p>
     * The FHIR version of the Data Store. The only supported version is R4.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datastoreTypeVersion} will return {@link FHIRVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #datastoreTypeVersionAsString}.
     * </p>
     * 
     * @return The FHIR version of the Data Store. The only supported version is R4.
     * @see FHIRVersion
     */
    public final String datastoreTypeVersionAsString() {
        return datastoreTypeVersion;
    }

    /**
     * <p>
     * Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded data
     * is synthetic data generated from Synthea.
     * </p>
     * 
     * @return Optional parameter to preload data upon creation of the Data Store. Currently, the only supported
     *         preloaded data is synthetic data generated from Synthea.
     */
    public final PreloadDataConfig preloadDataConfig() {
        return preloadDataConfig;
    }

    /**
     * <p>
     * Optional user provided token used for ensuring idempotency.
     * </p>
     * 
     * @return Optional user provided token used for ensuring idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreTypeVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(preloadDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFhirDatastoreRequest)) {
            return false;
        }
        CreateFhirDatastoreRequest other = (CreateFhirDatastoreRequest) obj;
        return Objects.equals(datastoreName(), other.datastoreName())
                && Objects.equals(datastoreTypeVersionAsString(), other.datastoreTypeVersionAsString())
                && Objects.equals(preloadDataConfig(), other.preloadDataConfig())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFhirDatastoreRequest").add("DatastoreName", datastoreName())
                .add("DatastoreTypeVersion", datastoreTypeVersionAsString()).add("PreloadDataConfig", preloadDataConfig())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatastoreName":
            return Optional.ofNullable(clazz.cast(datastoreName()));
        case "DatastoreTypeVersion":
            return Optional.ofNullable(clazz.cast(datastoreTypeVersionAsString()));
        case "PreloadDataConfig":
            return Optional.ofNullable(clazz.cast(preloadDataConfig()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFhirDatastoreRequest, T> g) {
        return obj -> g.apply((CreateFhirDatastoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFhirDatastoreRequest> {
        /**
         * <p>
         * The user generated name for the Data Store.
         * </p>
         * 
         * @param datastoreName
         *        The user generated name for the Data Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreName(String datastoreName);

        /**
         * <p>
         * The FHIR version of the Data Store. The only supported version is R4.
         * </p>
         * 
         * @param datastoreTypeVersion
         *        The FHIR version of the Data Store. The only supported version is R4.
         * @see FHIRVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FHIRVersion
         */
        Builder datastoreTypeVersion(String datastoreTypeVersion);

        /**
         * <p>
         * The FHIR version of the Data Store. The only supported version is R4.
         * </p>
         * 
         * @param datastoreTypeVersion
         *        The FHIR version of the Data Store. The only supported version is R4.
         * @see FHIRVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FHIRVersion
         */
        Builder datastoreTypeVersion(FHIRVersion datastoreTypeVersion);

        /**
         * <p>
         * Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded
         * data is synthetic data generated from Synthea.
         * </p>
         * 
         * @param preloadDataConfig
         *        Optional parameter to preload data upon creation of the Data Store. Currently, the only supported
         *        preloaded data is synthetic data generated from Synthea.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preloadDataConfig(PreloadDataConfig preloadDataConfig);

        /**
         * <p>
         * Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded
         * data is synthetic data generated from Synthea.
         * </p>
         * This is a convenience that creates an instance of the {@link PreloadDataConfig.Builder} avoiding the need to
         * create one manually via {@link PreloadDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PreloadDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #preloadDataConfig(PreloadDataConfig)}.
         * 
         * @param preloadDataConfig
         *        a consumer that will call methods on {@link PreloadDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preloadDataConfig(PreloadDataConfig)
         */
        default Builder preloadDataConfig(Consumer<PreloadDataConfig.Builder> preloadDataConfig) {
            return preloadDataConfig(PreloadDataConfig.builder().applyMutation(preloadDataConfig).build());
        }

        /**
         * <p>
         * Optional user provided token used for ensuring idempotency.
         * </p>
         * 
         * @param clientToken
         *        Optional user provided token used for ensuring idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HealthLakeRequest.BuilderImpl implements Builder {
        private String datastoreName;

        private String datastoreTypeVersion;

        private PreloadDataConfig preloadDataConfig;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFhirDatastoreRequest model) {
            super(model);
            datastoreName(model.datastoreName);
            datastoreTypeVersion(model.datastoreTypeVersion);
            preloadDataConfig(model.preloadDataConfig);
            clientToken(model.clientToken);
        }

        public final String getDatastoreName() {
            return datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        public final String getDatastoreTypeVersion() {
            return datastoreTypeVersion;
        }

        @Override
        public final Builder datastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
            return this;
        }

        @Override
        public final Builder datastoreTypeVersion(FHIRVersion datastoreTypeVersion) {
            this.datastoreTypeVersion(datastoreTypeVersion == null ? null : datastoreTypeVersion.toString());
            return this;
        }

        public final void setDatastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
        }

        public final PreloadDataConfig.Builder getPreloadDataConfig() {
            return preloadDataConfig != null ? preloadDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder preloadDataConfig(PreloadDataConfig preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig;
            return this;
        }

        public final void setPreloadDataConfig(PreloadDataConfig.BuilderImpl preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig != null ? preloadDataConfig.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFhirDatastoreRequest build() {
            return new CreateFhirDatastoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
