/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.healthlake.model.CreateFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.CreateFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DeleteFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.DeleteFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobResponse;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse;
import software.amazon.awssdk.services.healthlake.model.StartFhirExportJobRequest;
import software.amazon.awssdk.services.healthlake.model.StartFhirExportJobResponse;
import software.amazon.awssdk.services.healthlake.model.StartFhirImportJobRequest;
import software.amazon.awssdk.services.healthlake.model.StartFhirImportJobResponse;
import software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresPublisher;

/**
 * Service client for accessing HealthLake asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon HealthLake is a HIPAA eligibile service that allows customers to store, transform, query, and analyze their
 * FHIR-formatted data in a consistent fashion in the cloud.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface HealthLakeAsyncClient extends SdkClient {
    String SERVICE_NAME = "healthlake";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "healthlake";

    /**
     * Create a {@link HealthLakeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static HealthLakeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link HealthLakeAsyncClient}.
     */
    static HealthLakeAsyncClientBuilder builder() {
        return new DefaultHealthLakeAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a Data Store that can ingest and export FHIR formatted data.
     * </p>
     *
     * @param createFhirDatastoreRequest
     * @return A Java Future containing the result of the CreateFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.CreateFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/CreateFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFhirDatastoreResponse> createFHIRDatastore(
            CreateFhirDatastoreRequest createFhirDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Data Store that can ingest and export FHIR formatted data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFhirDatastoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFhirDatastoreRequest#builder()}
     * </p>
     *
     * @param createFhirDatastoreRequest
     *        A {@link Consumer} that will call methods on {@link CreateFHIRDatastoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.CreateFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/CreateFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFhirDatastoreResponse> createFHIRDatastore(
            Consumer<CreateFhirDatastoreRequest.Builder> createFhirDatastoreRequest) {
        return createFHIRDatastore(CreateFhirDatastoreRequest.builder().applyMutation(createFhirDatastoreRequest).build());
    }

    /**
     * <p>
     * Deletes a Data Store.
     * </p>
     *
     * @param deleteFhirDatastoreRequest
     * @return A Java Future containing the result of the DeleteFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ConflictException The Data Store is in a transition state and the user requested action can not be
     *         performed.</li>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DeleteFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DeleteFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFhirDatastoreResponse> deleteFHIRDatastore(
            DeleteFhirDatastoreRequest deleteFhirDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Data Store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFhirDatastoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFhirDatastoreRequest#builder()}
     * </p>
     *
     * @param deleteFhirDatastoreRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFHIRDatastoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ConflictException The Data Store is in a transition state and the user requested action can not be
     *         performed.</li>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DeleteFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DeleteFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFhirDatastoreResponse> deleteFHIRDatastore(
            Consumer<DeleteFhirDatastoreRequest.Builder> deleteFhirDatastoreRequest) {
        return deleteFHIRDatastore(DeleteFhirDatastoreRequest.builder().applyMutation(deleteFhirDatastoreRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with the FHIR Data Store, including the Data Store ID, Data Store ARN, Data Store
     * name, Data Store status, created at, Data Store type version, and Data Store endpoint.
     * </p>
     *
     * @param describeFhirDatastoreRequest
     * @return A Java Future containing the result of the DescribeFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirDatastoreResponse> describeFHIRDatastore(
            DescribeFhirDatastoreRequest describeFhirDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with the FHIR Data Store, including the Data Store ID, Data Store ARN, Data Store
     * name, Data Store status, created at, Data Store type version, and Data Store endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFhirDatastoreRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFhirDatastoreRequest#builder()}
     * </p>
     *
     * @param describeFhirDatastoreRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFHIRDatastoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirDatastoreResponse> describeFHIRDatastore(
            Consumer<DescribeFhirDatastoreRequest.Builder> describeFhirDatastoreRequest) {
        return describeFHIRDatastore(DescribeFhirDatastoreRequest.builder().applyMutation(describeFhirDatastoreRequest).build());
    }

    /**
     * <p>
     * Displays the properties of a FHIR export job, including the ID, ARN, name, and the status of the job.
     * </p>
     *
     * @param describeFhirExportJobRequest
     * @return A Java Future containing the result of the DescribeFHIRExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirExportJobResponse> describeFHIRExportJob(
            DescribeFhirExportJobRequest describeFhirExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the properties of a FHIR export job, including the ID, ARN, name, and the status of the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFhirExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFhirExportJobRequest#builder()}
     * </p>
     *
     * @param describeFhirExportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFHIRExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFHIRExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirExportJobResponse> describeFHIRExportJob(
            Consumer<DescribeFhirExportJobRequest.Builder> describeFhirExportJobRequest) {
        return describeFHIRExportJob(DescribeFhirExportJobRequest.builder().applyMutation(describeFhirExportJobRequest).build());
    }

    /**
     * <p>
     * Displays the properties of a FHIR import job, including the ID, ARN, name, and the status of the job.
     * </p>
     *
     * @param describeFhirImportJobRequest
     * @return A Java Future containing the result of the DescribeFHIRImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirImportJobResponse> describeFHIRImportJob(
            DescribeFhirImportJobRequest describeFhirImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the properties of a FHIR import job, including the ID, ARN, name, and the status of the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFhirImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFhirImportJobRequest#builder()}
     * </p>
     *
     * @param describeFhirImportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFHIRImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFHIRImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirImportJobResponse> describeFHIRImportJob(
            Consumer<DescribeFhirImportJobRequest.Builder> describeFhirImportJobRequest) {
        return describeFHIRImportJob(DescribeFhirImportJobRequest.builder().applyMutation(describeFhirImportJobRequest).build());
    }

    /**
     * <p>
     * Lists all FHIR Data Stores that are in the user’s account, regardless of Data Store status.
     * </p>
     *
     * @param listFhirDatastoresRequest
     * @return A Java Future containing the result of the ListFHIRDatastores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFhirDatastoresResponse> listFHIRDatastores(ListFhirDatastoresRequest listFhirDatastoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all FHIR Data Stores that are in the user’s account, regardless of Data Store status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFhirDatastoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListFhirDatastoresRequest#builder()}
     * </p>
     *
     * @param listFhirDatastoresRequest
     *        A {@link Consumer} that will call methods on {@link ListFHIRDatastoresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFHIRDatastores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFhirDatastoresResponse> listFHIRDatastores(
            Consumer<ListFhirDatastoresRequest.Builder> listFhirDatastoresRequest) {
        return listFHIRDatastores(ListFhirDatastoresRequest.builder().applyMutation(listFhirDatastoresRequest).build());
    }

    /**
     * <p>
     * Lists all FHIR Data Stores that are in the user’s account, regardless of Data Store status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFHIRDatastores(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresPublisher publisher = client.listFHIRDatastoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresPublisher publisher = client.listFHIRDatastoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFHIRDatastores(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFhirDatastoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFHIRDatastoresPublisher listFHIRDatastoresPaginator(ListFhirDatastoresRequest listFhirDatastoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all FHIR Data Stores that are in the user’s account, regardless of Data Store status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFHIRDatastores(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresPublisher publisher = client.listFHIRDatastoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresPublisher publisher = client.listFHIRDatastoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFHIRDatastores(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFhirDatastoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListFhirDatastoresRequest#builder()}
     * </p>
     *
     * @param listFhirDatastoresRequest
     *        A {@link Consumer} that will call methods on {@link ListFHIRDatastoresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFHIRDatastoresPublisher listFHIRDatastoresPaginator(
            Consumer<ListFhirDatastoresRequest.Builder> listFhirDatastoresRequest) {
        return listFHIRDatastoresPaginator(ListFhirDatastoresRequest.builder().applyMutation(listFhirDatastoresRequest).build());
    }

    /**
     * <p>
     * Begins a FHIR export job.
     * </p>
     *
     * @param startFhirExportJobRequest
     * @return A Java Future containing the result of the StartFHIRExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.StartFHIRExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFhirExportJobResponse> startFHIRExportJob(StartFhirExportJobRequest startFhirExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Begins a FHIR export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFhirExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartFhirExportJobRequest#builder()}
     * </p>
     *
     * @param startFhirExportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartFHIRExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartFHIRExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.StartFHIRExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFhirExportJobResponse> startFHIRExportJob(
            Consumer<StartFhirExportJobRequest.Builder> startFhirExportJobRequest) {
        return startFHIRExportJob(StartFhirExportJobRequest.builder().applyMutation(startFhirExportJobRequest).build());
    }

    /**
     * <p>
     * Begins a FHIR Import job.
     * </p>
     *
     * @param startFhirImportJobRequest
     * @return A Java Future containing the result of the StartFHIRImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.StartFHIRImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFhirImportJobResponse> startFHIRImportJob(StartFhirImportJobRequest startFhirImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Begins a FHIR Import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFhirImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartFhirImportJobRequest#builder()}
     * </p>
     *
     * @param startFhirImportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartFHIRImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartFHIRImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ResourceNotFoundException The requested Data Store was not found.</li>
     *         <li>InternalServerException Unknown error occurs in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.StartFHIRImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFhirImportJobResponse> startFHIRImportJob(
            Consumer<StartFhirImportJobRequest.Builder> startFhirImportJobRequest) {
        return startFHIRImportJob(StartFhirImportJobRequest.builder().applyMutation(startFhirImportJobRequest).build());
    }
}
