/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.PermissionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublicAccess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PublicAccess> {
    private static final SdkField<PermissionConfiguration> PERMISSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PermissionConfiguration").getter(PublicAccess.getter(PublicAccess::permissionConfiguration)).setter(PublicAccess.setter(Builder::permissionConfiguration)).constructor(PermissionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionConfiguration").build()}).build();
    private static final SdkField<String> EFFECTIVE_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectivePermission").getter(PublicAccess.getter(PublicAccess::effectivePermission)).setter(PublicAccess.setter(Builder::effectivePermission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectivePermission").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_CONFIGURATION_FIELD, EFFECTIVE_PERMISSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final PermissionConfiguration permissionConfiguration;
    private final String effectivePermission;

    private PublicAccess(BuilderImpl builder) {
        this.permissionConfiguration = builder.permissionConfiguration;
        this.effectivePermission = builder.effectivePermission;
    }

    public final PermissionConfiguration permissionConfiguration() {
        return this.permissionConfiguration;
    }

    public final String effectivePermission() {
        return this.effectivePermission;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectivePermission());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicAccess)) {
            return false;
        }
        PublicAccess other = (PublicAccess)obj;
        return Objects.equals(this.permissionConfiguration(), other.permissionConfiguration()) && Objects.equals(this.effectivePermission(), other.effectivePermission());
    }

    public final String toString() {
        return ToString.builder((String)"PublicAccess").add("PermissionConfiguration", (Object)this.permissionConfiguration()).add("EffectivePermission", (Object)this.effectivePermission()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PermissionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.permissionConfiguration()));
            }
            case "EffectivePermission": {
                return Optional.ofNullable(clazz.cast(this.effectivePermission()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicAccess, T> g) {
        return obj -> g.apply((PublicAccess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PermissionConfiguration permissionConfiguration;
        private String effectivePermission;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicAccess model) {
            this.permissionConfiguration(model.permissionConfiguration);
            this.effectivePermission(model.effectivePermission);
        }

        public final PermissionConfiguration.Builder getPermissionConfiguration() {
            return this.permissionConfiguration != null ? this.permissionConfiguration.toBuilder() : null;
        }

        public final void setPermissionConfiguration(PermissionConfiguration.BuilderImpl permissionConfiguration) {
            this.permissionConfiguration = permissionConfiguration != null ? permissionConfiguration.build() : null;
        }

        @Override
        public final Builder permissionConfiguration(PermissionConfiguration permissionConfiguration) {
            this.permissionConfiguration = permissionConfiguration;
            return this;
        }

        public final String getEffectivePermission() {
            return this.effectivePermission;
        }

        public final void setEffectivePermission(String effectivePermission) {
            this.effectivePermission = effectivePermission;
        }

        @Override
        public final Builder effectivePermission(String effectivePermission) {
            this.effectivePermission = effectivePermission;
            return this;
        }

        public PublicAccess build() {
            return new PublicAccess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PublicAccess> {
        public Builder permissionConfiguration(PermissionConfiguration var1);

        default public Builder permissionConfiguration(Consumer<PermissionConfiguration.Builder> permissionConfiguration) {
            return this.permissionConfiguration((PermissionConfiguration)((PermissionConfiguration.Builder)PermissionConfiguration.builder().applyMutation(permissionConfiguration)).build());
        }

        public Builder effectivePermission(String var1);
    }
}

