/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the reason that the finding was generated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Evidence implements SdkPojo, Serializable, ToCopyableBuilder<Evidence.Builder, Evidence> {
    private static final SdkField<List<ThreatIntelligenceDetail>> THREAT_INTELLIGENCE_DETAILS_FIELD = SdkField
            .<List<ThreatIntelligenceDetail>> builder(MarshallingType.LIST)
            .memberName("ThreatIntelligenceDetails")
            .getter(getter(Evidence::threatIntelligenceDetails))
            .setter(setter(Builder::threatIntelligenceDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatIntelligenceDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThreatIntelligenceDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThreatIntelligenceDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(THREAT_INTELLIGENCE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ThreatIntelligenceDetail> threatIntelligenceDetails;

    private Evidence(BuilderImpl builder) {
        this.threatIntelligenceDetails = builder.threatIntelligenceDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThreatIntelligenceDetails property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasThreatIntelligenceDetails() {
        return threatIntelligenceDetails != null && !(threatIntelligenceDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of threat intelligence details related to the evidence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThreatIntelligenceDetails} method.
     * </p>
     * 
     * @return A list of threat intelligence details related to the evidence.
     */
    public final List<ThreatIntelligenceDetail> threatIntelligenceDetails() {
        return threatIntelligenceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasThreatIntelligenceDetails() ? threatIntelligenceDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evidence)) {
            return false;
        }
        Evidence other = (Evidence) obj;
        return hasThreatIntelligenceDetails() == other.hasThreatIntelligenceDetails()
                && Objects.equals(threatIntelligenceDetails(), other.threatIntelligenceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Evidence")
                .add("ThreatIntelligenceDetails", hasThreatIntelligenceDetails() ? threatIntelligenceDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThreatIntelligenceDetails":
            return Optional.ofNullable(clazz.cast(threatIntelligenceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Evidence, T> g) {
        return obj -> g.apply((Evidence) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Evidence> {
        /**
         * <p>
         * A list of threat intelligence details related to the evidence.
         * </p>
         * 
         * @param threatIntelligenceDetails
         *        A list of threat intelligence details related to the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelligenceDetails(Collection<ThreatIntelligenceDetail> threatIntelligenceDetails);

        /**
         * <p>
         * A list of threat intelligence details related to the evidence.
         * </p>
         * 
         * @param threatIntelligenceDetails
         *        A list of threat intelligence details related to the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelligenceDetails(ThreatIntelligenceDetail... threatIntelligenceDetails);

        /**
         * <p>
         * A list of threat intelligence details related to the evidence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.ThreatIntelligenceDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.ThreatIntelligenceDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.ThreatIntelligenceDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #threatIntelligenceDetails(List<ThreatIntelligenceDetail>)}.
         * 
         * @param threatIntelligenceDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.ThreatIntelligenceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatIntelligenceDetails(java.util.Collection<ThreatIntelligenceDetail>)
         */
        Builder threatIntelligenceDetails(Consumer<ThreatIntelligenceDetail.Builder>... threatIntelligenceDetails);
    }

    static final class BuilderImpl implements Builder {
        private List<ThreatIntelligenceDetail> threatIntelligenceDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Evidence model) {
            threatIntelligenceDetails(model.threatIntelligenceDetails);
        }

        public final List<ThreatIntelligenceDetail.Builder> getThreatIntelligenceDetails() {
            List<ThreatIntelligenceDetail.Builder> result = ThreatIntelligenceDetailsCopier
                    .copyToBuilder(this.threatIntelligenceDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatIntelligenceDetails(Collection<ThreatIntelligenceDetail.BuilderImpl> threatIntelligenceDetails) {
            this.threatIntelligenceDetails = ThreatIntelligenceDetailsCopier.copyFromBuilder(threatIntelligenceDetails);
        }

        @Override
        public final Builder threatIntelligenceDetails(Collection<ThreatIntelligenceDetail> threatIntelligenceDetails) {
            this.threatIntelligenceDetails = ThreatIntelligenceDetailsCopier.copy(threatIntelligenceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelligenceDetails(ThreatIntelligenceDetail... threatIntelligenceDetails) {
            threatIntelligenceDetails(Arrays.asList(threatIntelligenceDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelligenceDetails(Consumer<ThreatIntelligenceDetail.Builder>... threatIntelligenceDetails) {
            threatIntelligenceDetails(Stream.of(threatIntelligenceDetails)
                    .map(c -> ThreatIntelligenceDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Evidence build() {
            return new Evidence(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
