/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the resource for each individual EKS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageResourceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageResourceDetails.Builder, CoverageResourceDetails> {
    private static final SdkField<CoverageEksClusterDetails> EKS_CLUSTER_DETAILS_FIELD = SdkField
            .<CoverageEksClusterDetails> builder(MarshallingType.SDK_POJO).memberName("EksClusterDetails")
            .getter(getter(CoverageResourceDetails::eksClusterDetails)).setter(setter(Builder::eksClusterDetails))
            .constructor(CoverageEksClusterDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusterDetails").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(CoverageResourceDetails::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CLUSTER_DETAILS_FIELD,
            RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final CoverageEksClusterDetails eksClusterDetails;

    private final String resourceType;

    private CoverageResourceDetails(BuilderImpl builder) {
        this.eksClusterDetails = builder.eksClusterDetails;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * EKS cluster details involved in the coverage statistics.
     * </p>
     * 
     * @return EKS cluster details involved in the coverage statistics.
     */
    public final CoverageEksClusterDetails eksClusterDetails() {
        return eksClusterDetails;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of Amazon Web Services resource.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of Amazon Web Services resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of Amazon Web Services resource.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eksClusterDetails());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageResourceDetails)) {
            return false;
        }
        CoverageResourceDetails other = (CoverageResourceDetails) obj;
        return Objects.equals(eksClusterDetails(), other.eksClusterDetails())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageResourceDetails").add("EksClusterDetails", eksClusterDetails())
                .add("ResourceType", resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EksClusterDetails":
            return Optional.ofNullable(clazz.cast(eksClusterDetails()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoverageResourceDetails, T> g) {
        return obj -> g.apply((CoverageResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageResourceDetails> {
        /**
         * <p>
         * EKS cluster details involved in the coverage statistics.
         * </p>
         * 
         * @param eksClusterDetails
         *        EKS cluster details involved in the coverage statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksClusterDetails(CoverageEksClusterDetails eksClusterDetails);

        /**
         * <p>
         * EKS cluster details involved in the coverage statistics.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoverageEksClusterDetails.Builder}
         * avoiding the need to create one manually via {@link CoverageEksClusterDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoverageEksClusterDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #eksClusterDetails(CoverageEksClusterDetails)}.
         * 
         * @param eksClusterDetails
         *        a consumer that will call methods on {@link CoverageEksClusterDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksClusterDetails(CoverageEksClusterDetails)
         */
        default Builder eksClusterDetails(Consumer<CoverageEksClusterDetails.Builder> eksClusterDetails) {
            return eksClusterDetails(CoverageEksClusterDetails.builder().applyMutation(eksClusterDetails).build());
        }

        /**
         * <p>
         * The type of Amazon Web Services resource.
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of Amazon Web Services resource.
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);
    }

    static final class BuilderImpl implements Builder {
        private CoverageEksClusterDetails eksClusterDetails;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageResourceDetails model) {
            eksClusterDetails(model.eksClusterDetails);
            resourceType(model.resourceType);
        }

        public final CoverageEksClusterDetails.Builder getEksClusterDetails() {
            return eksClusterDetails != null ? eksClusterDetails.toBuilder() : null;
        }

        public final void setEksClusterDetails(CoverageEksClusterDetails.BuilderImpl eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails != null ? eksClusterDetails.build() : null;
        }

        @Override
        public final Builder eksClusterDetails(CoverageEksClusterDetails eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        @Override
        public CoverageResourceDetails build() {
            return new CoverageResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
