/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason;
import software.amazon.awssdk.services.groundstation.model.EphemerisStatus;
import software.amazon.awssdk.services.groundstation.model.EphemerisTypeDescription;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEphemerisResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, DescribeEphemerisResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::creationTime)).setter(DescribeEphemerisResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::enabled)).setter(DescribeEphemerisResponse.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> EPHEMERIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ephemerisId").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::ephemerisId)).setter(DescribeEphemerisResponse.setter(Builder::ephemerisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisId").build()}).build();
    private static final SdkField<String> INVALID_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invalidReason").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::invalidReasonAsString)).setter(DescribeEphemerisResponse.setter(Builder::invalidReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidReason").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::name)).setter(DescribeEphemerisResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::priority)).setter(DescribeEphemerisResponse.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteId").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::satelliteId)).setter(DescribeEphemerisResponse.setter(Builder::satelliteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::statusAsString)).setter(DescribeEphemerisResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<EphemerisTypeDescription> SUPPLIED_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("suppliedData").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::suppliedData)).setter(DescribeEphemerisResponse.setter(Builder::suppliedData)).constructor(EphemerisTypeDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppliedData").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeEphemerisResponse.getter(DescribeEphemerisResponse::tags)).setter(DescribeEphemerisResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, ENABLED_FIELD, EPHEMERIS_ID_FIELD, INVALID_REASON_FIELD, NAME_FIELD, PRIORITY_FIELD, SATELLITE_ID_FIELD, STATUS_FIELD, SUPPLIED_DATA_FIELD, TAGS_FIELD));
    private final Instant creationTime;
    private final Boolean enabled;
    private final String ephemerisId;
    private final String invalidReason;
    private final String name;
    private final Integer priority;
    private final String satelliteId;
    private final String status;
    private final EphemerisTypeDescription suppliedData;
    private final Map<String, String> tags;

    private DescribeEphemerisResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.enabled = builder.enabled;
        this.ephemerisId = builder.ephemerisId;
        this.invalidReason = builder.invalidReason;
        this.name = builder.name;
        this.priority = builder.priority;
        this.satelliteId = builder.satelliteId;
        this.status = builder.status;
        this.suppliedData = builder.suppliedData;
        this.tags = builder.tags;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String ephemerisId() {
        return this.ephemerisId;
    }

    public final EphemerisInvalidReason invalidReason() {
        return EphemerisInvalidReason.fromValue(this.invalidReason);
    }

    public final String invalidReasonAsString() {
        return this.invalidReason;
    }

    public final String name() {
        return this.name;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final String satelliteId() {
        return this.satelliteId;
    }

    public final EphemerisStatus status() {
        return EphemerisStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final EphemerisTypeDescription suppliedData() {
        return this.suppliedData;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemerisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppliedData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEphemerisResponse)) {
            return false;
        }
        DescribeEphemerisResponse other = (DescribeEphemerisResponse)((Object)obj);
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.ephemerisId(), other.ephemerisId()) && Objects.equals(this.invalidReasonAsString(), other.invalidReasonAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.satelliteId(), other.satelliteId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.suppliedData(), other.suppliedData()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEphemerisResponse").add("CreationTime", (Object)this.creationTime()).add("Enabled", (Object)this.enabled()).add("EphemerisId", (Object)this.ephemerisId()).add("InvalidReason", (Object)this.invalidReasonAsString()).add("Name", (Object)this.name()).add("Priority", (Object)this.priority()).add("SatelliteId", (Object)this.satelliteId()).add("Status", (Object)this.statusAsString()).add("SuppliedData", (Object)this.suppliedData()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "ephemerisId": {
                return Optional.ofNullable(clazz.cast(this.ephemerisId()));
            }
            case "invalidReason": {
                return Optional.ofNullable(clazz.cast(this.invalidReasonAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "satelliteId": {
                return Optional.ofNullable(clazz.cast(this.satelliteId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "suppliedData": {
                return Optional.ofNullable(clazz.cast(this.suppliedData()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEphemerisResponse, T> g) {
        return obj -> g.apply((DescribeEphemerisResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private Instant creationTime;
        private Boolean enabled;
        private String ephemerisId;
        private String invalidReason;
        private String name;
        private Integer priority;
        private String satelliteId;
        private String status;
        private EphemerisTypeDescription suppliedData;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEphemerisResponse model) {
            super(model);
            this.creationTime(model.creationTime);
            this.enabled(model.enabled);
            this.ephemerisId(model.ephemerisId);
            this.invalidReason(model.invalidReason);
            this.name(model.name);
            this.priority(model.priority);
            this.satelliteId(model.satelliteId);
            this.status(model.status);
            this.suppliedData(model.suppliedData);
            this.tags(model.tags);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getEphemerisId() {
            return this.ephemerisId;
        }

        public final void setEphemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
        }

        @Override
        public final Builder ephemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
            return this;
        }

        public final String getInvalidReason() {
            return this.invalidReason;
        }

        public final void setInvalidReason(String invalidReason) {
            this.invalidReason = invalidReason;
        }

        @Override
        public final Builder invalidReason(String invalidReason) {
            this.invalidReason = invalidReason;
            return this;
        }

        @Override
        public final Builder invalidReason(EphemerisInvalidReason invalidReason) {
            this.invalidReason(invalidReason == null ? null : invalidReason.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getSatelliteId() {
            return this.satelliteId;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EphemerisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final EphemerisTypeDescription.Builder getSuppliedData() {
            return this.suppliedData != null ? this.suppliedData.toBuilder() : null;
        }

        public final void setSuppliedData(EphemerisTypeDescription.BuilderImpl suppliedData) {
            this.suppliedData = suppliedData != null ? suppliedData.build() : null;
        }

        @Override
        public final Builder suppliedData(EphemerisTypeDescription suppliedData) {
            this.suppliedData = suppliedData;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeEphemerisResponse build() {
            return new DescribeEphemerisResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEphemerisResponse> {
        public Builder creationTime(Instant var1);

        public Builder enabled(Boolean var1);

        public Builder ephemerisId(String var1);

        public Builder invalidReason(String var1);

        public Builder invalidReason(EphemerisInvalidReason var1);

        public Builder name(String var1);

        public Builder priority(Integer var1);

        public Builder satelliteId(String var1);

        public Builder status(String var1);

        public Builder status(EphemerisStatus var1);

        public Builder suppliedData(EphemerisTypeDescription var1);

        default public Builder suppliedData(Consumer<EphemerisTypeDescription.Builder> suppliedData) {
            return this.suppliedData((EphemerisTypeDescription)((EphemerisTypeDescription.Builder)EphemerisTypeDescription.builder().applyMutation(suppliedData)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

