/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.groundstation.DefaultGroundStationAsyncClient;
import software.amazon.awssdk.services.groundstation.DefaultGroundStationBaseClientBuilder;
import software.amazon.awssdk.services.groundstation.GroundStationAsyncClient;
import software.amazon.awssdk.services.groundstation.GroundStationAsyncClientBuilder;
import software.amazon.awssdk.services.groundstation.GroundStationServiceClientConfiguration;
import software.amazon.awssdk.services.groundstation.endpoints.GroundStationEndpointProvider;

@SdkInternalApi
final class DefaultGroundStationAsyncClientBuilder
extends DefaultGroundStationBaseClientBuilder<GroundStationAsyncClientBuilder, GroundStationAsyncClient>
implements GroundStationAsyncClientBuilder {
    DefaultGroundStationAsyncClientBuilder() {
    }

    @Override
    public DefaultGroundStationAsyncClientBuilder endpointProvider(GroundStationEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GroundStationAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultGroundStationAsyncClientBuilder.validateClientOptions(clientConfiguration);
        GroundStationServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGroundStationAsyncClient client = new DefaultGroundStationAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GroundStationServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GroundStationServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

