/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.DataflowEdgeListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.services.groundstation.model.KmsKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMissionProfileRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, UpdateMissionProfileRequest> {
    private static final SdkField<Integer> CONTACT_POST_PASS_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("contactPostPassDurationSeconds").getter(UpdateMissionProfileRequest.getter(UpdateMissionProfileRequest::contactPostPassDurationSeconds)).setter(UpdateMissionProfileRequest.setter(Builder::contactPostPassDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPostPassDurationSeconds").build()}).build();
    private static final SdkField<Integer> CONTACT_PRE_PASS_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("contactPrePassDurationSeconds").getter(UpdateMissionProfileRequest.getter(UpdateMissionProfileRequest::contactPrePassDurationSeconds)).setter(UpdateMissionProfileRequest.setter(Builder::contactPrePassDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPrePassDurationSeconds").build()}).build();
    private static final SdkField<List<List<String>>> DATAFLOW_EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataflowEdges").getter(UpdateMissionProfileRequest.getter(UpdateMissionProfileRequest::dataflowEdges)).setter(UpdateMissionProfileRequest.setter(Builder::dataflowEdges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEdges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Integer> MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minimumViableContactDurationSeconds").getter(UpdateMissionProfileRequest.getter(UpdateMissionProfileRequest::minimumViableContactDurationSeconds)).setter(UpdateMissionProfileRequest.setter(Builder::minimumViableContactDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumViableContactDurationSeconds").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("missionProfileId").getter(UpdateMissionProfileRequest.getter(UpdateMissionProfileRequest::missionProfileId)).setter(UpdateMissionProfileRequest.setter(Builder::missionProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("missionProfileId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateMissionProfileRequest.getter(UpdateMissionProfileRequest::name)).setter(UpdateMissionProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<KmsKey> STREAMS_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streamsKmsKey").getter(UpdateMissionProfileRequest.getter(UpdateMissionProfileRequest::streamsKmsKey)).setter(UpdateMissionProfileRequest.setter(Builder::streamsKmsKey)).constructor(KmsKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamsKmsKey").build()}).build();
    private static final SdkField<String> STREAMS_KMS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamsKmsRole").getter(UpdateMissionProfileRequest.getter(UpdateMissionProfileRequest::streamsKmsRole)).setter(UpdateMissionProfileRequest.setter(Builder::streamsKmsRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamsKmsRole").build()}).build();
    private static final SdkField<String> TRACKING_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trackingConfigArn").getter(UpdateMissionProfileRequest.getter(UpdateMissionProfileRequest::trackingConfigArn)).setter(UpdateMissionProfileRequest.setter(Builder::trackingConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingConfigArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_POST_PASS_DURATION_SECONDS_FIELD, CONTACT_PRE_PASS_DURATION_SECONDS_FIELD, DATAFLOW_EDGES_FIELD, MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD, MISSION_PROFILE_ID_FIELD, NAME_FIELD, STREAMS_KMS_KEY_FIELD, STREAMS_KMS_ROLE_FIELD, TRACKING_CONFIG_ARN_FIELD));
    private final Integer contactPostPassDurationSeconds;
    private final Integer contactPrePassDurationSeconds;
    private final List<List<String>> dataflowEdges;
    private final Integer minimumViableContactDurationSeconds;
    private final String missionProfileId;
    private final String name;
    private final KmsKey streamsKmsKey;
    private final String streamsKmsRole;
    private final String trackingConfigArn;

    private UpdateMissionProfileRequest(BuilderImpl builder) {
        super(builder);
        this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
        this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
        this.dataflowEdges = builder.dataflowEdges;
        this.minimumViableContactDurationSeconds = builder.minimumViableContactDurationSeconds;
        this.missionProfileId = builder.missionProfileId;
        this.name = builder.name;
        this.streamsKmsKey = builder.streamsKmsKey;
        this.streamsKmsRole = builder.streamsKmsRole;
        this.trackingConfigArn = builder.trackingConfigArn;
    }

    public final Integer contactPostPassDurationSeconds() {
        return this.contactPostPassDurationSeconds;
    }

    public final Integer contactPrePassDurationSeconds() {
        return this.contactPrePassDurationSeconds;
    }

    public final boolean hasDataflowEdges() {
        return this.dataflowEdges != null && !(this.dataflowEdges instanceof SdkAutoConstructList);
    }

    public final List<List<String>> dataflowEdges() {
        return this.dataflowEdges;
    }

    public final Integer minimumViableContactDurationSeconds() {
        return this.minimumViableContactDurationSeconds;
    }

    public final String missionProfileId() {
        return this.missionProfileId;
    }

    public final String name() {
        return this.name;
    }

    public final KmsKey streamsKmsKey() {
        return this.streamsKmsKey;
    }

    public final String streamsKmsRole() {
        return this.streamsKmsRole;
    }

    public final String trackingConfigArn() {
        return this.trackingConfigArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactPostPassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactPrePassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataflowEdges() ? this.dataflowEdges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumViableContactDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamsKmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamsKmsRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingConfigArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMissionProfileRequest)) {
            return false;
        }
        UpdateMissionProfileRequest other = (UpdateMissionProfileRequest)((Object)obj);
        return Objects.equals(this.contactPostPassDurationSeconds(), other.contactPostPassDurationSeconds()) && Objects.equals(this.contactPrePassDurationSeconds(), other.contactPrePassDurationSeconds()) && this.hasDataflowEdges() == other.hasDataflowEdges() && Objects.equals(this.dataflowEdges(), other.dataflowEdges()) && Objects.equals(this.minimumViableContactDurationSeconds(), other.minimumViableContactDurationSeconds()) && Objects.equals(this.missionProfileId(), other.missionProfileId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.streamsKmsKey(), other.streamsKmsKey()) && Objects.equals(this.streamsKmsRole(), other.streamsKmsRole()) && Objects.equals(this.trackingConfigArn(), other.trackingConfigArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMissionProfileRequest").add("ContactPostPassDurationSeconds", (Object)this.contactPostPassDurationSeconds()).add("ContactPrePassDurationSeconds", (Object)this.contactPrePassDurationSeconds()).add("DataflowEdges", this.hasDataflowEdges() ? this.dataflowEdges() : null).add("MinimumViableContactDurationSeconds", (Object)this.minimumViableContactDurationSeconds()).add("MissionProfileId", (Object)this.missionProfileId()).add("Name", (Object)this.name()).add("StreamsKmsKey", (Object)this.streamsKmsKey()).add("StreamsKmsRole", (Object)this.streamsKmsRole()).add("TrackingConfigArn", (Object)this.trackingConfigArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contactPostPassDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.contactPostPassDurationSeconds()));
            }
            case "contactPrePassDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.contactPrePassDurationSeconds()));
            }
            case "dataflowEdges": {
                return Optional.ofNullable(clazz.cast(this.dataflowEdges()));
            }
            case "minimumViableContactDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.minimumViableContactDurationSeconds()));
            }
            case "missionProfileId": {
                return Optional.ofNullable(clazz.cast(this.missionProfileId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "streamsKmsKey": {
                return Optional.ofNullable(clazz.cast(this.streamsKmsKey()));
            }
            case "streamsKmsRole": {
                return Optional.ofNullable(clazz.cast(this.streamsKmsRole()));
            }
            case "trackingConfigArn": {
                return Optional.ofNullable(clazz.cast(this.trackingConfigArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMissionProfileRequest, T> g) {
        return obj -> g.apply((UpdateMissionProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private Integer contactPostPassDurationSeconds;
        private Integer contactPrePassDurationSeconds;
        private List<List<String>> dataflowEdges = DefaultSdkAutoConstructList.getInstance();
        private Integer minimumViableContactDurationSeconds;
        private String missionProfileId;
        private String name;
        private KmsKey streamsKmsKey;
        private String streamsKmsRole;
        private String trackingConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMissionProfileRequest model) {
            super(model);
            this.contactPostPassDurationSeconds(model.contactPostPassDurationSeconds);
            this.contactPrePassDurationSeconds(model.contactPrePassDurationSeconds);
            this.dataflowEdges(model.dataflowEdges);
            this.minimumViableContactDurationSeconds(model.minimumViableContactDurationSeconds);
            this.missionProfileId(model.missionProfileId);
            this.name(model.name);
            this.streamsKmsKey(model.streamsKmsKey);
            this.streamsKmsRole(model.streamsKmsRole);
            this.trackingConfigArn(model.trackingConfigArn);
        }

        public final Integer getContactPostPassDurationSeconds() {
            return this.contactPostPassDurationSeconds;
        }

        public final void setContactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
        }

        @Override
        public final Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        public final Integer getContactPrePassDurationSeconds() {
            return this.contactPrePassDurationSeconds;
        }

        public final void setContactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
        }

        @Override
        public final Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        public final Collection<? extends Collection<String>> getDataflowEdges() {
            if (this.dataflowEdges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataflowEdges;
        }

        public final void setDataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
        }

        @Override
        public final Builder dataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowEdges(Collection<String> ... dataflowEdges) {
            this.dataflowEdges((Collection<? extends Collection<String>>)Arrays.asList(dataflowEdges));
            return this;
        }

        public final Integer getMinimumViableContactDurationSeconds() {
            return this.minimumViableContactDurationSeconds;
        }

        public final void setMinimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
        }

        @Override
        public final Builder minimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
            return this;
        }

        public final String getMissionProfileId() {
            return this.missionProfileId;
        }

        public final void setMissionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
        }

        @Override
        public final Builder missionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final KmsKey.Builder getStreamsKmsKey() {
            return this.streamsKmsKey != null ? this.streamsKmsKey.toBuilder() : null;
        }

        public final void setStreamsKmsKey(KmsKey.BuilderImpl streamsKmsKey) {
            this.streamsKmsKey = streamsKmsKey != null ? streamsKmsKey.build() : null;
        }

        @Override
        public final Builder streamsKmsKey(KmsKey streamsKmsKey) {
            this.streamsKmsKey = streamsKmsKey;
            return this;
        }

        public final String getStreamsKmsRole() {
            return this.streamsKmsRole;
        }

        public final void setStreamsKmsRole(String streamsKmsRole) {
            this.streamsKmsRole = streamsKmsRole;
        }

        @Override
        public final Builder streamsKmsRole(String streamsKmsRole) {
            this.streamsKmsRole = streamsKmsRole;
            return this;
        }

        public final String getTrackingConfigArn() {
            return this.trackingConfigArn;
        }

        public final void setTrackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
        }

        @Override
        public final Builder trackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMissionProfileRequest build() {
            return new UpdateMissionProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMissionProfileRequest> {
        public Builder contactPostPassDurationSeconds(Integer var1);

        public Builder contactPrePassDurationSeconds(Integer var1);

        public Builder dataflowEdges(Collection<? extends Collection<String>> var1);

        public Builder dataflowEdges(Collection<String> ... var1);

        public Builder minimumViableContactDurationSeconds(Integer var1);

        public Builder missionProfileId(String var1);

        public Builder name(String var1);

        public Builder streamsKmsKey(KmsKey var1);

        default public Builder streamsKmsKey(Consumer<KmsKey.Builder> streamsKmsKey) {
            return this.streamsKmsKey((KmsKey)((KmsKey.Builder)KmsKey.builder().applyMutation(streamsKmsKey)).build());
        }

        public Builder streamsKmsRole(String var1);

        public Builder trackingConfigArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

